/************************************************************************
* FILE:         fc_dabtuner_trace.h
* PROJECT:      g3g
* SW-COMPONENT: FC_DABTUNER
*----------------------------------------------------------------------
*
* DESCRIPTION: DABTuner main application class
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                      | Modification
* 15.06.07  | CM-DI/PJ-VW36-Liebanas      | initial version
*
*************************************************************************/

#ifndef _DABTUNER_TTFIS_CMD_H_
#define _DABTUNER_TTFIS_CMD_H_

///*******************************************************************************
//| includes of component-internal interfaces, if necessary
//| (scope: component-local)
//|-----------------------------------------------------------------------------*/
//
/*******************************************************************************
| defines and macros (scope: global)
|-----------------------------------------------------------------------------*/

#include "fc_dabtuner_util.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

namespace DAB {
    struct trMsgTtfisEvent;

    struct trMsgDabTcTtfisCmd:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        tU8 u8MsgCode;
        tU8 u8DataLen;
        tU8 const *pu8Data;
        tBool bHandled;
        trMsgDabTcTtfisCmd(tU8 u8MsgCode_=0,tU8 u8DataLen_=0,tU8 const *pu8Data_=OSAL_NULL):
            u8MsgCode(u8MsgCode_),
            u8DataLen(u8DataLen_),
            pu8Data(pu8Data_),
            bHandled(FALSE)
        {}
        virtual tVoid vTrace() const { };
    };

//class fc_dabtuner_tclApp;
// This is the TTFis trace service
class fc_dabtuner_tclTrace:
    public DAB_Singleton <fc_dabtuner_tclTrace>,
    public DAB_MessageHandlerCommon<fc_dabtuner_tclTrace>
{
        friend class DAB_Singleton<fc_dabtuner_tclTrace>;
public:
    DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_TTFIS);
	//Destructor fc_dabtuner_tclTrace(fc_dabtuner_tclApp*  poFCDabTunerMainApp);
	virtual ~fc_dabtuner_tclTrace();

    virtual tVoid vInit();
    virtual tVoid vDeInit();


	// Send and Receive the data   
	tVoid vStoreTraceCmd(tPCU8 const pu8Data);
    tVoid vSendSelfMessage(fi_tclMessageBase const &oOutData) const;
    tVoid vSendSelfMessage(fi_tclVisitorMessage oOutVisitorMsg, tU16 u16SrvId, tU16 u16FnId, tU8 u8OpCode) const;
    virtual char const *pcGetName() const {return "fc_dabtuner_tclTrace";};

    virtual void vProcess(trMsgTtfisEvent* poMsgTtfisEvent);

private:
	// Constructor
    //lint -esym(1704, fc_dabtuner_tclTrace::fc_dabtuner_tclTrace) prio3 constructor has private access specification
	fc_dabtuner_tclTrace();
	tVoid          vRegisterTraceService();
	tVoid          vUnregisterTraceService();
	static tVoid   vChannelMgr(const tUChar* const puchData);
    tBool bGetHexData(tU8 u8AsciiLen, tU8 const *pu8AsciiData, tU16 *pu16MecaLen, tU8 *pu8MecaData) const;
    DAB_tclEvent _oEvt;
	OSAL_tIODescriptor   m_fdTrace;

	// Reference to Main
	//fc_dabtuner_tclApp*        m_poGWMain; not used

    // todo make sem-protected queue
    struct trTtfisCmdBuf{
        tU8 u8Cmd;
        tU8 u8DataLen;
        tU8 au8Data[255];
    };
    deque<trTtfisCmdBuf> _oCmdQ;
    void vHandleTtfisCmd(trTtfisCmdBuf const &oCmd);
    
    dab_sem _oCmdQSem;
};
} // namespace DAB
#endif   // #if defined _DABTUNER_TRACE_H_
