/************************************************************************
* FILE:         fc_dabtuner_ttfisCmd.cpp
* PROJECT:      g3g
* SW-COMPONENT: fc_dabuner
*----------------------------------------------------------------------
*
* DESCRIPTION: FC Dabtuner
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author             | Modification
* 28.09.11  | CM-AI/PJ-CB34      | initial version
*
*************************************************************************/

//-----------------------------------------------------------------------------
// file define
//-----------------------------------------------------------------------------
/*
#ifdef FC_DABTUNER_FILE_NUMBER
	#undef FC_DABTUNER_FILE_NUMBER
#endif
#define FC_DABTUNER_FILE_NUMBER 0x0020
*/

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| set own module id
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| includes: needed interfaces from external components
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| includes: internal and external interfaces from this component
|-----------------------------------------------------------------------------*/

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#define FC_DABTUNER_S_IMPORT_INTERFACE_MSG
#include "fc_dabtuner_config.h"
#include "fc_dabtuner_if.h"
#include "fc_dabtuner_mainProxy.h"


#include "fc_dabtuner_util.h"
#include "fc_dabtuner_trace.h"        // trace stuff

#ifndef VARIANT_S_FTR_ENABLE_DAB_TEST_CLIENT
#include "dabdrv_main.hpp"
#endif
#include "dabdrv_typeEnums.h"
#include "fc_dabtuner_ttfisCmd.h"
//#include "fc_dabtuner_config.hpp"

#ifdef ETG_I_TEST
#include "../drv/etgTest.h"
#endif

using namespace DAB;
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_TTFIS
#ifdef ETG_I_TEST
//#define ETG_I_TRACE_CHANNEL TR_TTFIS_FC_DABTUNER
#endif
#include "trcGenProj/Header/fc_dabtuner_ttfisCmd.cpp.trc.h"
#endif

/**Vnd4kor: Commented out to solve prio2 lint warnings*/
/*
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCSFI_STDVISITORS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCSFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCSFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCSFI_SERVICEINFO

#include "midw_fi_if.h"
*/

#ifdef VARIANT_S_FTR_ENABLE_NEW_SPM_CORE_FI
	#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
	#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_TYPES
	#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
	#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_SERVICEINFO
	#include "spm_fi_if.h"
#else
	#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_STDVISITORS
	#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_FUNCTIONIDS
	#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_SERVICEINFO
	#include "cfc_fi_if.h"
#endif

namespace DAB {


    // a timer-event
    struct trMsgTtfisEvent:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgTtfisEvent"));
        };
    };
} //namespace DAB

///*******************************************************************************
//| defines and macros (scope: module-local)
//|-----------------------------------------------------------------------------*/

//const tU8 FC_DABTUNER_TR_COMPONENT_STATUS                       = 0x01;// not used
//const tU8 FC_DABTUNER_TR_AUDIO_FG_BG                            = 0x02;// not used
//const tU8 FC_DABTUNER_TR_TUNE                                   = 0x03;// not used
//const tU8 FC_DABTUNER_TR_SEEK                                   = 0x04;// not used
//const tU8 FC_DABTUNER_TR_LEARN                                  = 0x05;// not used
//const tU8 FC_DABTUNER_TR_SERVICESEEK                            = 0x06;// not used
//const tU8 FC_DABTUNER_TR_SCAN                                   = 0x07;// not used
//const tU8 FC_DABTUNER_TR_DIAG_CONFIGURATION                     = 0x08;// not used
//const tU8 FC_DABTUNER_TR_CONTROL_OPERATION                      = 0x09;// not used
//const tU8 FC_DABTUNER_TR_SETUP                                  = 0x0A;// not used
//const tU8 FC_DABTUNER_TR_OPEN_LIST                              = 0x0B;// not used
//const tU8 FC_DABTUNER_TR_CLOSE_LIST                             = 0x0C;// not used
//const tU8 FC_DABTUNER_TR_ACTIVATE_LIST_ELEM                     = 0x0D;// not used
//const tU8 FC_DABTUNER_TR_GET_PRESET_LIST                        = 0x0E;// not used
//const tU8 FC_DABTUNER_TR_ACTIVATE_PRESET_LIST_ELEM              = 0x0F;// not used
//const tU8 FC_DABTUNER_TR_SAVE_PRESET_LIST_ELEM                  = 0x10;// not used
//const tU8 FC_DABTUNER_TR_DELETE_PRESET_LIST_ELEMENT             = 0x11;// not used
//const tU8 FC_DABTUNER_TR_TEST_FN                              = 0x12;
const tU8 FC_DABTUNER_TR_MECA_RES                               = 0x13;
const tU8 FC_DABTUNER_TR_SET_ADR_TIMEOUT_MS                     = 0x14;
const tU8 FC_DABTUNER_TR_RESET_ADR                              = 0x15;
const tU8 FC_DABTUNER_TR_SET_PING_TIMEOUT_MS                    = 0x16;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_TUNE_MST                  = 0x17;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_TUNER_STATUS_GET          = 0x18;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_SET_CHN_LIST              = 0x19;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_SET_SOURCE_STATE          = 0x20;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_MASCSFI_SOURCEACTIVITYSTATUS = 0x21;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_CHN_SELECT                = 0x22;

const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_DEFSET_SRV_DAB            = 0x23;
#if 0
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_DEFSET_SRV_DIAGLIB        = 0x24; // todo
#endif
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_LEARN                     = 0x25;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_ANNO_CONFIG               = 0x26;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_STORE_PRESET              = 0x27;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_RECALL_PRESET             = 0x28;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_SETUP                     = 0x29;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_GET_PRESET_LIST           = 0x30;

const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_COMP_SELECT               = 0x31;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_SET_COMP_LIST             = 0x32;

const tU8 FC_DABTUNER_TR_SIMULATE_FM_QUALITY                    = 0x33;

const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_TEST_OPERATION            = 0x34;

const tU8 FC_DABTUNER_TR_GEN_MECA_CMD                           = 0x35;

const tU8 FC_DABTUNER_TR_DABTC_CMD                              = 0x36;

const tU8 FC_DABTUNER_TR_TRACE_CONFIG                           = 0x37;

const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_CHANNEL_INFO_GET          = 0x38;

const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_ANNO_STOP                 = 0x39;

const tU8 FC_DABTUNER_TR_STORE_PERS_DATA                        = 0x3a;

const tU8 FC_DABTUNER_TR_SYS_STORE                              = 0x3b;

const tU8 FC_DABTUNER_TR_CFG_SRV_FOLLOW                         = 0x3c;

const tU8 FC_DABTUNER_TR_SYS_RESTORE                            = 0x3d;

const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_SPM_CV                    = 0x3e;

const tU8 FC_DABTUNER_TR_ENABLE_ADR3_LOGGING               = 0x3f;

// get Testmode Data via UpReg
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_TESTMODE_DATA_UPREG       = 0x40;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_TESTMODE_DATA_RELUPREG    = 0x41;

const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_TMC_DATA_UPREG            = 0x42;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_TMC_DATA_RELUPREG         = 0x43;

const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_SELECT_TMC                = 0x44;

const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_TMC_AVAIL_LIST_GET        = 0x46;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_SET_TESTMODE              = 0x47;

const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_TESTMODE_DATA_GET         = 0x48;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_TESTMODE_DB_QUERY         = 0x49;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_FIELD_STRENGTH            = 0x50;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_DEFAULT_SETTINGS          = 0x51;

const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_BG_LEARN                  = 0x60;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_BG_CHNLIST                = 0x61;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_SET_ADR_WATCHDOG          = 0x62;

const tU8 FC_DABTUNER_TR_SELECT_TPEG_URI                        = 0x65;
const tU8 FC_DABTUNER_TR_DESELECT_TPEG_URI                      = 0x66;
const tU8 FC_DABTUNER_TR_GET_TPEG_URI_LIST                      = 0x67;
const tU8 FC_DABTUNER_TR_TPEG_ACTIVITY                          = 0x68;
const tU8 FC_DABTUNER_TR_TPEG_LOAD_FILE                         = 0x69;

const tU8 FC_DABTUNER_TR_SET_ADR_RESET_HANDLING                 = 0x70;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_SET_ENS_LIST                 = 0x71;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_ENS_SELECT                = 0x72;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_INITIAL_AUTOSTORE         = 0x73;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_ENS_SEEK					= 0x74;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_DEL_PRESET				= 0x75;
const tU8 FC_DABTUNER_TR_CCA_SET_FREQUENCY_TABLE		        = 0x76;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_SETUP_MAIN				= 0x77;
const tU8 FC_DABTUNER_TR_CCA_SELF_MSG_LINKING_SETUP		        = 0x78;
const tU8 FC_DABTUNER_TR_CCA_SCAN_BAND					        = 0x79;
const tU8 FC_DABTUNER_TR_CCA_SELECT_ANNO						= 0x7A;
const tU8 FC_DABTUNER_TR_CCA_DELETE_LEARN_MEMORY				= 0x7B;
const tU8 FC_DABTUNER_TR_CCA_GET_TIILIST						= 0x7C;
const tU8 FC_DABTUNER_TR_CCA_MTC_SETMODE						= 0x7D;
const tU8 FC_DABTUNER_TR_CCA_MTC_REQUEST_SWITCH					= 0x7E;
const tU8 FC_DABTUNER_TR_CCA_MTC_ANNOUNCEMENT					= 0x7F;
const tU8 FC_DABTUNER_TR_CCA_FREQUENCY_LABEL						= 0x80;
const tU8 FC_DABTUNER_TR_CCA_UPDATE_USER_PROFILE					= 0x81;
const tU8 FID_DAB_S_VALIDATE_EPG_LIST							= 0x91;

/*******************************************************************************
| function implementation (scope: global)
|-----------------------------------------------------------------------------*/
// Constructor
fc_dabtuner_tclTrace::fc_dabtuner_tclTrace():
	m_fdTrace(OSAL_ERROR)
{}


/* **************************************************FunctionHeaderBegin** *//**
 *
 *  Destructor.
 *
 *  Destroys a vdmmgr_tclTrace object.
 *
 * @date    2005-02-25
 *
 * @note
 *      
 *
 *//* ***********************************************FunctionHeaderEnd******* */
fc_dabtuner_tclTrace::~fc_dabtuner_tclTrace()
{


}

tVoid fc_dabtuner_tclTrace::vInit() {
    _oCmdQSem.vOpen(DAB_TTFIS_CMD_SEM_NAME);
#ifdef ETG_I_TEST
    ETG_I_CMD_REGISTER_CHN(OSAL_NULL);
#endif

    _oEvt =oRegisterEvent(trMsgTtfisEvent());
    vRegisterTraceService();
}

tVoid fc_dabtuner_tclTrace::vDeInit() {
#ifdef ETG_I_TEST
    ETG_I_CMD_UNREGISTER_CHN()
#endif
    vUnregisterTraceService();
    _oEvt.vDeregister();
    _oCmdQSem.vClose();
    _oCmdQ.clear();
}

/******************************************************************+FUNCHEADER**
 *
 * FUNCTION:     fc_dabtuner_tclApp::vRegisterTraceService
 *
 * DESCRIPTION:  Registers trace channel to send commands from TTFis
 *             
 * PARAMETER:    None
 *
 * RETURNVALUE:  None
 *
 ******************************************************************-FUNCHEADER*/
tVoid fc_dabtuner_tclTrace::vRegisterTraceService( )
{
   tS32                        s32Error;
   OSAL_trIOCtrlLaunchChannel  oTraceChannel;

   if(OSAL_ERROR == m_fdTrace)
   {
      m_fdTrace = OSAL_IOOpen( OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE );

      if( OSAL_ERROR != m_fdTrace )
      {
          ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vRegisterTraceService() OSAL_IOOpen OK"));
		  oTraceChannel.enTraceChannel = (TR_tenTraceChan)DAB_TRACE_CHN ;
		  oTraceChannel.pCallback = (OSAL_tpfCallback)vChannelMgr;

		  s32Error = OSAL_s32IOControl( m_fdTrace, (tS32)OSAL_C_S32_IOCTRL_CALLBACK_REG, (intptr_t)&oTraceChannel );
		  if( OSAL_OK != s32Error)
		  {
              ETG_TRACE_ERR(("fc_dabtuner_tclTrace::vRegisterTraceService() OSAL_s32IOControl ERROR"));
		  }
		  else
		  {
              ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vRegisterTraceService() OSAL_s32IOControl OK"));
		  }
	  }
      else
      {
          ETG_TRACE_ERR(("fc_dabtuner_tclTrace::vRegisterTraceService() OSAL_IOOpen ERROR"));
      }
   }
}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     fc_dabtuner_tclTrace::vUnregisterTraceService
 *
 *DESCRIPTION:  De-registers trace channel used to send commands from TTFis
 *             
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *
 ******************************************************************-FUNCHEADER*/
tVoid fc_dabtuner_tclTrace::vUnregisterTraceService()
{
   tS32 s32Error;
   OSAL_trIOCtrlLaunchChannel oTraceChannel;

    ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vUnregisterTraceService(): Entry function"));

   if(OSAL_ERROR != m_fdTrace)
   {
      oTraceChannel.enTraceChannel = (TR_tenTraceChan)DAB_TRACE_CHN;
      oTraceChannel.pCallback      = (OSAL_tpfCallback)vChannelMgr;

      s32Error = OSAL_s32IOControl(m_fdTrace, (tS32)OSAL_C_S32_IOCTRL_CALLBACK_UNREG, (intptr_t)&oTraceChannel);
	  if( OSAL_OK != s32Error)
	  {
          ETG_TRACE_ERR(("fc_dabtuner_tclTrace::vUnregisterTraceService() OSAL_s32IOControl ERROR"));
      }
      else
      {
          ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vUnregisterTraceService() OSAL_s32IOControl OK"));
      }
      (tVoid)OSAL_s32IOClose(m_fdTrace);
   }
}


tBool fc_dabtuner_tclTrace::bGetHexData(tU8 u8AsciiLen, tU8 const *pu8AsciiData, tU16 *pu16MecaLen, tU8 *pu8MecaData) const {
    pu8MecaData[0]=0; // lint
    tU8 u8NumRead=0;
    *pu16MecaLen=0;
    tBool bDone=FALSE;
	/*lint -e{850} u8Index is modified in the body of the for loop */
    for (tU8 u8Index =0;!bDone && (u8Index< (u8AsciiLen-1) && (*pu16MecaLen < 950));u8Index++) {
        char data[3];
        data[0]=pu8AsciiData[u8Index];
        switch (data[0]) {
            case '_':
                break;
            case 0:
                bDone=TRUE;
                break;
            case '#':
            case ':':
            {
                // parse a label (16 char)
                tU8 numChar=0;
                while (pu8AsciiData[++u8Index] != '_' && pu8AsciiData[u8Index] != 0) {
                    pu8MecaData[(*pu16MecaLen)++]=pu8AsciiData[u8Index];
                    numChar++;
                }
                if (data[0]=='#')
                {
                    // fill missing characters with 0
                    while (numChar++<16) {
                        pu8MecaData[(*pu16MecaLen)++]=0;
                    }
                }
                break;
            }
            default:
            {
                tU32 u8Bin1=0;
                tU32 u8Bin2=0;
                data[1]=0x30;
                data[2]=0;
                u8NumRead=(tU8)sscanf(data, "%x", &u8Bin1);
                if (u8NumRead != 1) {
                    return FALSE;
                }
                
                data[0]=pu8AsciiData[++u8Index];
                data[1]=0x30;
                data[2]=0;
                if (data[0]==0) {
                    return FALSE;
                }
                u8NumRead=(tU8)sscanf(data, "%x", &u8Bin2);
                if (u8NumRead != 1) {
                    return FALSE;
                }
                tU8 u8Bin=(tU8) (u8Bin1+(u8Bin2>>4));
                pu8MecaData[(*pu16MecaLen)++]=u8Bin;
            }
        }
    }
    return TRUE;
}
/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     fc_dabtuner_tclTrace::vChannelMgr
 *
 *DESCRIPTION:  React on TTFis commands
 *             
 *PARAMETER:    tUChar* puchData
 *
 *RETURNVALUE:  None
 *
 *HISTORY:
 *
 ******************************************************************-FUNCHEADER*/
tVoid fc_dabtuner_tclTrace::vChannelMgr(const tUChar* const puchData)
{
    ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vChannelMgr:StoreTraceCmd(): Entry: len=%u data=%*p", 
                    puchData[0],
                    ETG_LIST_LEN(puchData[0]),
                    ETG_LIST_PTR_T8(puchData)));
    fc_dabtuner_tclTrace *poThis = fc_dabtuner_tclTrace::instance();
    DAB_ASSERT_RETURN(OSAL_NULL != poThis);
    // puchData[0]=num of bytes after puchData[0]
    // puchData[1]=cmd
    // puchData[2 ...puchData[0]]=data
    // store the cmd
    if (!puchData[0]) {
        return;
    }
    trTtfisCmdBuf oCmdBuf;
    oCmdBuf.u8Cmd=puchData[1];
    oCmdBuf.u8DataLen=(tU8)(puchData[0]-1);
    OSAL_pvMemorySet(oCmdBuf.au8Data,0,255);
    if (oCmdBuf.u8DataLen) {
        OSAL_pvMemoryCopy(oCmdBuf.au8Data, &puchData[2], oCmdBuf.u8DataLen);
    }
    poThis->_oCmdQSem.vGet();
    poThis->_oCmdQ.push_back(oCmdBuf);
    poThis->_oCmdQSem.vPost();
    // post event
    poThis->_oEvt.vPost();
}

void fc_dabtuner_tclTrace::vProcess(trMsgTtfisEvent*) {
    ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess(trMsgTtfisEvent)()"));

    _oCmdQSem.vGet();
    while (!_oCmdQ.empty()) {
        trTtfisCmdBuf oCmd = _oCmdQ.front();
        _oCmdQ.pop_front();
        vHandleTtfisCmd(oCmd);
    }
    _oCmdQSem.vPost();
}

//lint -esym(1762,DAB::fc_dabtuner_tclTrace::vHandleTtfisCmd) "Member function '...' could be made const"
void fc_dabtuner_tclTrace::vHandleTtfisCmd(trTtfisCmdBuf const &oCmd) {
    tU8   u8MsgCode   = oCmd.u8Cmd;
    tU8 u8DataLen = oCmd.u8DataLen;
    tU8 const *pParams = oCmd.au8Data;
    tU8 u8Param1= pParams[0];
    tU8 u8Param2= pParams[1];
    tU8 u8Param3= pParams[2];
	tU8 u8Param4= pParams[3];

    ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vHandleTtfisCmd: cmd=0x%x dataLen=%d", 
                    u8MsgCode,
                    u8DataLen));

#ifdef ETG_I_TEST
    tU8 u8ttfisBuf[260];
    u8ttfisBuf[0]=u8DataLen+1;
    u8ttfisBuf[1]=u8MsgCode;
    OSAL_pvMemoryCopy(&u8ttfisBuf[2], oCmd.au8Data, u8DataLen);
    ETG_I_bPROCESS(u8ttfisBuf);
#endif

    if (u8DataLen) {
        ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vHandleTtfisCmd: data=%*p", 
                        ETG_LIST_LEN(u8DataLen),
                        ETG_LIST_PTR_T8(pParams)));
    }
    switch( u8MsgCode )
    {
#ifndef VARIANT_S_FTR_ENABLE_DAB_TEST_CLIENT
        case FC_DABTUNER_TR_MECA_RES:
        {
            tU16 u16FktId = DABDRV_GET_U16(&pParams[0]);
            tenOpType enOpType = (tenOpType)pParams[2];
            if (u8DataLen < 3) {
                return;
            }
            tU8 u8AsciiLen = (tU8)(u8DataLen - 3);
            tU16 u16MecaLen = 0;
            tU8 const *pu8AsciiData = &pParams[3];
            tU8 pu8MecaData[1000];
            if (!bGetHexData(u8AsciiLen, pu8AsciiData, &u16MecaLen, pu8MecaData)) {
                return;
            }


            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: Simulate incoming Meca message u16FktId=0x%x  u8OpCode=0x%x"
                            "u16MecaLen %u data=%*p",
                            u16FktId, 
                            ETG_CENUM(tenOpType,enOpType), 
                            u16MecaLen,
                            ETG_LIST_LEN(u16MecaLen), ETG_LIST_PTR_T8(pu8MecaData)));
            dabdrv_mecaIf::instance()->vSimMecaCmdInput(u16FktId, enOpType, u16MecaLen, pu8MecaData);
        }
        break;

        case FC_DABTUNER_TR_SET_ADR_TIMEOUT_MS:
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_SET_ADR_TIMEOUT_MS:%d",
                            u8Param1));
            dabdrv_adrIf::instance()->vSetAdrSupervisionTimerVal(u8Param1);
            break;

        case FC_DABTUNER_TR_RESET_ADR:
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_RESET_ADR:%d",
                            u8Param1));
            dabdrv_mecaIf::instance()->vReset();

            break;
        case FC_DABTUNER_TR_SET_ADR_RESET_HANDLING:
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_SET_ADR_RESET_HANDLING:%d",
                            u8Param1));
            dabdrv_adrIf::instance()->vSetAdrResetHandling((tBool)u8Param1);

            break;

        case FC_DABTUNER_TR_SET_PING_TIMEOUT_MS:
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_SET_PING_TIMEOUT_MS:%d",
                            u8Param1));
            dabdrv_mecaIf::instance()->vSetPingTimerVal(u8Param1);
            break;
#endif

        case FC_DABTUNER_TR_CCA_SELF_MSG_TUNE_MST:
        {
            //ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_SELF_MSG_TUNE:"));
            //midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNEMethodStart oMStart;
            ////oMStart.TuneParam.e8TuneType.enType = midw_ext_fi_tcl_e8_DAB_TuneType::FI_EN_DAB_TUNETYPE_SELECT_FREQ;
            ////oMStart.TuneParam.u32Value = 225648;//180064;
            //oMStart.TuneParam.e8TuneType.enType = midw_ext_fi_tcl_e8_DAB_TuneType::FI_EN_DAB_TUNETYPE_SELECT_PSID;
            //oMStart.TuneParam.u32Value = 0x1e1c221;
            //vSendSelfMessage(oMStart);
        }
        break;

        case FC_DABTUNER_TR_CCA_SELF_MSG_TUNER_STATUS_GET:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_SELF_MSG_TUNER_STATUS_GET:"));
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSGet oPGet;
            vSendSelfMessage(oPGet );
        }
        break;

        case FC_DABTUNER_TR_CCA_SELF_MSG_SET_CHN_LIST:
        {

            midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart oMStart;
            oMStart.enOperation.enType=(midw_ext_fi_tcl_e8_DAB_ListOperation::tenType)u8Param1;
			oMStart.enServiceListType.enType = (midw_ext_fi_tcl_e8_DAB_ServiceListType::tenType)u8Param2;
            oMStart.u16FirstElemId=u8Param3;
            oMStart.u16NumElem=u8Param4;
			oMStart.u32PTYFilter=DABDRV_GET_U32(&pParams[4]);
			oMStart.enSortingType.enType=(midw_ext_fi_tcl_e8_DAB_ServiceListSortingType::tenType)pParams[8];
			oMStart.u16EnsembleIndex=pParams[9];
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_FROZEN_LIST: op=%d  list type =%d firstElem=%d numElem=%d ptyFiltr=%u sorting=%d	u16EnsembleIndex=%d",
                            ETG_CENUM(tenListOperation, oMStart.enOperation.enType),
							ETG_CENUM(tenChnListType, oMStart.enServiceListType.enType),
                            oMStart.u16FirstElemId,
                            oMStart.u16NumElem,
							oMStart.u32PTYFilter,
							oMStart.enSortingType.enType,
							oMStart.u16EnsembleIndex));
            vSendSelfMessage(oMStart );
        }
        break;

        case FC_DABTUNER_TR_CCA_SELF_MSG_SET_SOURCE_STATE:
        {
            midw_ext_fi_tcl_e8_DAB_SourceState::tenType enSourceState = 
                (midw_ext_fi_tcl_e8_DAB_SourceState::tenType)u8Param1;;
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_SET_SOURCE_STATE: enSourceState=%d",
                            ETG_CENUM(DAB_tenSourceState, enSourceState)));
                midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart oMStart;
                oMStart.e8SourceState.enType=enSourceState;
                vSendSelfMessage(oMStart);
        }
        break;

#ifdef KDS_FOR_G3G_VARIANT
        case FC_DABTUNER_TR_CCA_SELF_MSG_MASCSFI_SOURCEACTIVITYSTATUS:
        {
            midw_mascsfi_tclMsgSourceActivityStatusStatus oFiStatus;
            oFiStatus.Channel.enType=midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC;
            char const *strSource="";
            switch(u8Param1) {
                case 1:
                    oFiStatus.Source.enType=midw_fi_tcl_e8_SourceNo::FI_EN_AUDIO_SRC_DAB;
                    strSource="DAB";
                    break;
                case 2:
                    oFiStatus.Source.enType=midw_fi_tcl_e8_SourceNo::FI_EN_AUDIO_SRC_DAB_TA;
                    strSource="DAB_TA";
                    break;
                default:
                    oFiStatus.Source.enType=midw_fi_tcl_e8_SourceNo::FI_EN_AUDIO_SRC_FM;
                    strSource="FM";
                    break;
                    
            }
            char const *strActivity="";
            switch (u8Param2) {
                case 2:
                    oFiStatus.Activity.enType=midw_fi_tcl_e8_SourceActivity::FI_EN_AUDIO_SRC_ON;
                    strActivity="ON";
                    break;
                case 3:
                    oFiStatus.Activity.enType=midw_fi_tcl_e8_SourceActivity::FI_EN_AUDIO_SRC_DEMUTE_RAMP_RUNNING;
                    strActivity="DEMUTING";
                    break;
                default:
                    oFiStatus.Activity.enType=midw_fi_tcl_e8_SourceActivity::FI_EN_AUDIO_SRC_OFF;
                    strActivity="OFF";
                    break;                

            }

            
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_MASCSFI_SOURCEACTIVITYSTATUS: Source=%7s (%d), activity=%8s (%d) ",
                            strSource,
                            oFiStatus.Source.enType,
                            strActivity,
                            oFiStatus.Activity.enType));
                vSendSelfMessage(oFiStatus);
        }
        break;
#endif

        case FC_DABTUNER_TR_CCA_SELF_MSG_CHN_SELECT:
        {
            midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart oMStart;
            oMStart.SelectMode.enType=(midw_ext_fi_tcl_e8_DAB_ChnSelectMode::tenType)u8Param1;
            
            // default values
            oMStart.u32Value = (tS32)DABDRV_GET_U32(&pParams[1]);
            oMStart.bNegative = pParams[5] ? TRUE: FALSE;
            oMStart.u16Scids=0;
            if(u8Param1 == 0){
            	oMStart.u16Scids = (tS16)DABDRV_GET_U16(&pParams[5]);
            }

            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_CHN_SELECT: SelectMode=%d u32Value=0x%x (%u) bNegative=%d",
                            ETG_CENUM(tenChnSelectMode, u8Param1),
                            oMStart.u32Value, 
                            oMStart.u32Value,
                            oMStart.bNegative));
            ETG_TRACE_USR4(("scids %d",oMStart.u16Scids));
            vSendSelfMessage(oMStart);
            break;
        }

        case FC_DABTUNER_TR_CCA_SELF_MSG_DEFSET_SRV_DAB:
        {
            /*midw_ext_dabtunerfi_tclMsgFID_DAB_S_DIAG_CONFIGURATIONMethodStart oFiMStart;
            switch (u8Param1) {
                case 0:
                    oFiMStart.DefSetStateMode.enType=midw_ext_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_SET_TEF;
                    break;
                case 1:
                    oFiMStart.DefSetStateMode.enType=midw_ext_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_SET_USER;
                    break;
                default:
                    oFiMStart.DefSetStateMode.enType=midw_ext_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_GET;
                    break;
            }
            oFiMStart.DefSetStateGroup.enType=midw_ext_fi_tcl_e8_DefSetGroups::FI_EN_DEFSET_GROUP__RADIO;
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_DEFSET_SRV_DAB: Mode=%d",
                            ETG_CENUM(tenDefsetType, u8Param1)));
            vSendSelfMessage(oFiMStart);*/
            break;
        }


        case FID_DAB_S_VALIDATE_EPG_LIST:
        {
            midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodStart oFiMStart;
			ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FID_DAB_S_VALIDATE_EPG_LIST"));
            vSendSelfMessage(oFiMStart);
            break;
        }

		case FC_DABTUNER_TR_CCA_SELF_MSG_LEARN:
        {
            midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart oFiMStart;
            oFiMStart.LearnParam.e8LearnType.enType=(midw_ext_fi_tcl_e8_DAB_LearnType::tenType)u8Param1;
            oFiMStart.LearnParam.bRollback=u8Param2 ? TRUE : FALSE;
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_LEARN: type=%d bRollback=%d",
                            ETG_CENUM(tenLearnType, u8Param1),
                            oFiMStart.LearnParam.bRollback));
            vSendSelfMessage(oFiMStart);
            break;
        }

        case FC_DABTUNER_TR_CCA_SELF_MSG_ANNO_CONFIG:
        {
            midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart oFiMStart;
            oFiMStart.AnnoConfig.AnnoConfigTypes.u16Value = DABDRV_GET_U16(&pParams[0]);
            oFiMStart.AnnoConfig.bEnable = u8Param3 ? TRUE : FALSE;
            oFiMStart.AnnoConfig.AnnoConfigSource.enType= (midw_ext_fi_tcl_e8_DAB_AnnouncementSource::tenType)u8Param4;
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_ANNO_CONFIG: AnnoConfigTypes=0%04x AnnoConfigSource=%d bEnable=%d",
                            oFiMStart.AnnoConfig.AnnoConfigTypes.u16Value,
                            ETG_CENUM(tenAnnoSource, u8Param3),
                            oFiMStart.AnnoConfig.bEnable));
            vSendSelfMessage(oFiMStart);
            break;
        }

        case FC_DABTUNER_TR_CCA_SELF_MSG_STORE_PRESET:
        {
            midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart oFiMStart;
            oFiMStart.u8PresetElemId = u8Param1;
            oFiMStart.bDelete = u8Param2 ? TRUE : FALSE;
            oFiMStart.u32PSID = DABDRV_GET_U32(&pParams[2]);
            oFiMStart.u32EnsFrequency = DABDRV_GET_U32(&pParams[6]);
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_STORE_PRESET: u8PresetElemId=0%04x bDelete=%d u32PSID=0x%04x u32EnsFrequency=0x%04x",
                            oFiMStart.u8PresetElemId,
                            oFiMStart.bDelete,
                            oFiMStart.u32PSID,
                            oFiMStart.u32EnsFrequency
                            ));
            vSendSelfMessage(oFiMStart);
            break;
        }

        case FC_DABTUNER_TR_CCA_SELF_MSG_RECALL_PRESET:
        {
            midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart oFiMStart;
            oFiMStart.u8ActPresetElemID = u8Param1;
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_ACTIVATE_PRESET_LIST_ELEM: u8PresetElemId=0x%04x",
                            oFiMStart.u8ActPresetElemID));
            vSendSelfMessage(oFiMStart);
            break;
        }

        case FC_DABTUNER_TR_CCA_SELF_MSG_SETUP:
		{
			midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart oFiMStart;
			oFiMStart.bUseConcealmentLevel = pParams[0] ? TRUE : FALSE;
			oFiMStart.u8ConcealmentLevel = pParams[1];
			oFiMStart.bUseServiceLinkingMode = pParams[2];
			oFiMStart.e8ServiceLinkingMode.enType = (midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode::tenType)pParams[3];
			oFiMStart.bUseEnsInsertThreshold = pParams[4] ? TRUE : FALSE;
			oFiMStart.u8EnsInsertThreshold = pParams[5];
			oFiMStart.bUseEnsDeleteThreshold = pParams[6] ? TRUE : FALSE;
			oFiMStart.u8EnsDeleteThreshold = pParams[7];



			ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_SETUP: bUseConcealmentLevel=%d u8ConcealmentLevel=0x%x "
							"bUseServiceLinkingMode=%d e8ServiceLinkingMode=0x%x",
										oFiMStart.bUseConcealmentLevel,
										oFiMStart.u8ConcealmentLevel,
										oFiMStart.bUseServiceLinkingMode,
										oFiMStart.e8ServiceLinkingMode.enType));

			ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_SETUP:"
							"bUseEnsInsertThreshold=%d u8EnsInsertThreshold=%d bUseEnsDeleteThreshold=%d u8EnsDeleteThreshold=%d",
							oFiMStart.bUseEnsInsertThreshold,
							oFiMStart.u8EnsInsertThreshold,
							oFiMStart.bUseEnsDeleteThreshold,
							oFiMStart.u8EnsDeleteThreshold));

			vSendSelfMessage(oFiMStart);
			break;
		}

		case FC_DABTUNER_TR_CCA_SELF_MSG_LINKING_SETUP:
		{
			midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart oFiMStart;
			oFiMStart.b8LinkingSetupMask.u8Value = pParams[0];
			oFiMStart.u8DABFMLinkingThreshold = pParams[1];
			oFiMStart.u8DABFMLinkingBackThreshold = pParams[2];
			oFiMStart.u8DABFMLinkingBackValidationTime = pParams[3];
			oFiMStart.u8DABFMLinkBackDelay = pParams[4];

			ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_SETUP:"
								"b8LinkingSetupMask=0x%x u8DABFMLinkingThreshold=%d u8DABFMLinkingBackThreshold=%d u8DABFMLinkingBackValidationTime=%d u8DABFMLinkBackDelay=%d",
								oFiMStart.b8LinkingSetupMask.u8Value,
								oFiMStart.u8DABFMLinkingThreshold,
								oFiMStart.u8DABFMLinkingBackThreshold,
								oFiMStart.u8DABFMLinkingBackValidationTime,
								oFiMStart.u8DABFMLinkBackDelay));

			 vSendSelfMessage(oFiMStart);
			 break;
		}
		case FC_DABTUNER_TR_CCA_SELF_MSG_SETUP_MAIN:
		{
			midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart oFiMStart;
			oFiMStart.bBgLearnUpdateTime = pParams[0] ? TRUE : FALSE;
			oFiMStart.u8BgLearnUpdateTime = pParams[1];
			oFiMStart.bDABScanThreshold =  pParams[2] ? TRUE : FALSE;
			oFiMStart.u8DABScanThreshold =  pParams[3];
			oFiMStart.bSwitchMeasurementMode = pParams[4] ? TRUE : FALSE;

			ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_SETUP:bBgLearnUpdateTime=%d u8BgLearnUpdateTime=%d "
							"bDABScanThreshold=%d u8DABScanThreshold=%d bSwitchMeasurementMode=0x%x ",
							  oFiMStart.bBgLearnUpdateTime,
							  oFiMStart.u8BgLearnUpdateTime,
							  oFiMStart.bDABScanThreshold,
							  oFiMStart.u8DABScanThreshold,
							  oFiMStart.bSwitchMeasurementMode));

			vSendSelfMessage(oFiMStart);
			break;
		}

        case FC_DABTUNER_TR_CCA_SELF_MSG_GET_PRESET_LIST:
        {
            midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart oFiMStart;
            oFiMStart.u8FirstElementID = u8Param1;
            oFiMStart.u8NumberOfElements = u8Param2;

            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_GET_PRESET_LIST: "
                            "u8FirstElementID=0%04x u8NumberOfElements=0%04x",
                            oFiMStart.u8FirstElementID,
                            oFiMStart.u8NumberOfElements));

            vSendSelfMessage(oFiMStart);
			midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTGet oFiMStart1;
			vSendSelfMessage(oFiMStart1);
            break;
        }

        case FC_DABTUNER_TR_CCA_SELF_MSG_COMP_SELECT:
        {
            midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart oMStart;
            oMStart.SelectMode.enType=(midw_ext_fi_tcl_e8_DAB_CompSelectMode::tenType)u8Param1;
            
            // default values
            oMStart.u32Value = (tS32)DABDRV_GET_U32(&pParams[1]);
            oMStart.bNegative = pParams[5] ? TRUE: FALSE;
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_COMP_SELECT: SelectMode=%d u32Value=0x%x (%u) bNegative=%d",
                            ETG_CENUM(tenChnSelectMode, u8Param1),
                            oMStart.u32Value, 
                            oMStart.u32Value,
                            oMStart.bNegative));
            vSendSelfMessage(oMStart);
            break;
        }

        case FC_DABTUNER_TR_CCA_SELF_MSG_SET_COMP_LIST:
        {

            midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart oMStart;
            oMStart.enOperation.enType=(midw_ext_fi_tcl_e8_DAB_ListOperation::tenType)u8Param1;
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_SET_COMP_LIST: op=%d",
                            ETG_CENUM(tenListOperation, oMStart.enOperation.enType)));
            vSendSelfMessage(oMStart );
        }
        break;

#ifndef VARIANT_S_FTR_ENABLE_DAB_TEST_CLIENT

        case FC_DABTUNER_TR_SIMULATE_FM_QUALITY:        
        {
            // while the tuner-fi is missing, we send the internal message directly
            trMsgSrvCmdFmQuality rFmQuality(u8Param1);
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_SIMULATE_FM_QUALITY: quality=%d",
                            u8Param1));
            DAB_vCallMsg(rFmQuality);
            break;
        }
#endif
        case FC_DABTUNER_TR_CCA_SELF_MSG_TEST_OPERATION:
        {
            midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart oMStart;
            oMStart.enOperation.enType=(midw_ext_fi_tcl_e8_DAB_TestOperation::tenType)u8Param1;
            
            // default values
            oMStart.u32Value1 = (tS32)DABDRV_GET_U32(&pParams[1]);
            oMStart.u32Value2 = (tS32)DABDRV_GET_U32(&pParams[5]);
            oMStart.u32Value3 = (tS32)DABDRV_GET_U32(&pParams[9]);
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_TEST_OPERATION: enOperation=%d u32Value1=0x%x (%u) u32Value2=0x%x u32Value2=0x%x",
                            ETG_CENUM(DAB_tenTestOperation, u8Param1),
                            oMStart.u32Value1, 
                            oMStart.u32Value1,
                            oMStart.u32Value2,
                            oMStart.u32Value3));
            vSendSelfMessage(oMStart);
            break;
        }

#ifndef VARIANT_S_FTR_ENABLE_DAB_TEST_CLIENT
        case FC_DABTUNER_TR_GEN_MECA_CMD:
        {
            tU16 u16FBockId = DAB_CLIENT_ID;
            tU16 u16FktId = DABDRV_GET_U16(&pParams[0]);
            tenOpType enOpType = (tenOpType)pParams[2];
            if (u8DataLen < 3) {
                return;
            }
            tU8 u8AsciiLen = (tU8)(u8DataLen - 3);
            tU16 u16MecaLen = 0;
            tU8 const *pu8AsciiData = &pParams[3];
            tU8 pu8MecaData[1000];
            if (!bGetHexData(u8AsciiLen, pu8AsciiData, &u16MecaLen, pu8MecaData)) {
                return;
            }


            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: generate meca command u16FktId=0x%x  u8OpCode=0x%x"
                            "u16MecaLen %u data=%*p",
                            u16FktId, 
                            ETG_CENUM(tenOpType,enOpType), 
                            u16MecaLen,
                            ETG_LIST_LEN(u16MecaLen), ETG_LIST_PTR_T8(pu8MecaData)));
            dabdrv_mecaIf::instance()->vSendAdrMsg(u16FBockId, u16FktId, enOpType, u16MecaLen, pu8MecaData);

            break;
        }
#endif

        /**************************************************************/
        /**                                                           */
        /**************************************************************/

        case FC_DABTUNER_TR_CCA_SELF_MSG_TESTMODE_DATA_UPREG:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_SELF_MSG_TESTMODE_DATA_UPREG:"));
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAUpReg oPUpReg;
            vSendSelfMessage(oPUpReg);
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOUpReg oCompInfoUpReg;
            vSendSelfMessage(oCompInfoUpReg);
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOUpReg oSrvInfoUpReg;
            vSendSelfMessage(oSrvInfoUpReg);
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOUpReg oEnsInfoUpReg;
            vSendSelfMessage(oEnsInfoUpReg);
        }
        break;

        case FC_DABTUNER_TR_CCA_SELF_MSG_TESTMODE_DATA_RELUPREG:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_SELF_MSG_TESTMODE_DATA_RELUPREG:"));
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATARelUpReg oPRelUpReg;
            vSendSelfMessage(oPRelUpReg);
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOUpReg oCompInfoRelUpReg;
            vSendSelfMessage(oCompInfoRelUpReg);
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOUpReg oSrvInfoRelUpReg;
            vSendSelfMessage(oSrvInfoRelUpReg);
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOUpReg oEnsInfoRelUpReg;
            vSendSelfMessage(oEnsInfoRelUpReg);
        }
        break;
        
        case FC_DABTUNER_TR_CCA_SELF_MSG_TMC_DATA_UPREG:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_SELF_MSG_TMC_DATA_UPREG:"));
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAUpReg oPUpReg;
            vSendSelfMessage(oPUpReg);
        }
        break;

        case FC_DABTUNER_TR_CCA_SELF_MSG_TMC_DATA_RELUPREG:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_SELF_MSG_TMC_DATA_RELUPREG:"));
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATARelUpReg oPRelUpReg;
            vSendSelfMessage(oPRelUpReg);
        }
        break;

        case FC_DABTUNER_TR_DABTC_CMD: 
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_DABTC_CMD:"));
            if (u8DataLen) {
                trMsgDabTcTtfisCmd rMsg(pParams[0], (tU8)(u8DataLen-1), &pParams[1]);
                DAB_vCallMsg(rMsg);
            }
        }
        break;

#ifndef VARIANT_S_FTR_ENABLE_DAB_TEST_CLIENT
        case FC_DABTUNER_TR_TRACE_CONFIG: 
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_TRACE_CONFIG:"));
            fc_dabtuner_config::instance()->vTraceAll();
        }
        break;
#endif
        case FC_DABTUNER_TR_CCA_SELF_MSG_CHANNEL_INFO_GET:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_SELF_MSG_CHANNEL_INFO_GET:"));
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOGet oPGet;
            vSendSelfMessage(oPGet);
        }
        break;

        case FC_DABTUNER_TR_CCA_SELF_MSG_ANNO_STOP:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_SELF_MSG_ANNO_STOP:"));
            midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodStart oMStart;
            vSendSelfMessage(oMStart);
        }
        break;

        case FC_DABTUNER_TR_CCA_SELF_MSG_SELECT_TMC:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_SELF_MSG_SELECT_TMC:"));
            midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart oMStart;
            oMStart.u32EnsembleId = DABDRV_GET_U32(&pParams[0]);
            midw_ext_fi_tcl_DAB_RdbId RdbId;
            RdbId.bEncrypted = 0;
            RdbId.u16Bsa = 0;
            RdbId.u8Cc = 0x10;
            RdbId.u8Ltn = 0x06;
            RdbId.u8Sid = 0xfc;

            oMStart.RdbIDList.push_back(RdbId);
            vSendSelfMessage(oMStart);
        }
        break;

        case FC_DABTUNER_TR_CCA_SELF_MSG_SET_TESTMODE:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_SELF_MSG_SET_TESTMODE:"));
            midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart oMStart;
            oMStart.bActive = pParams[0] ? TRUE : FALSE;
            vSendSelfMessage(oMStart);
        }
        break;

        case FC_DABTUNER_TR_CCA_SELF_MSG_TESTMODE_DATA_GET:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_SELF_MSG_TESTMODE_DATA_GET:"));
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAGet oPGet;
            vSendSelfMessage(oPGet);
        }
        break;

        case FC_DABTUNER_TR_CCA_SELF_MSG_TESTMODE_DB_QUERY:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_SELF_MSG_TESTMODE_DB_QUERY:"));
            midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart oMStart;
            oMStart.u8Adr3DbQuery = pParams[0];
            vSendSelfMessage(oMStart);
        }
        break;

        case FC_DABTUNER_TR_CCA_SELF_MSG_BG_LEARN:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_SELF_MSG_BG_LEARN:"));
            // start background tuner with learn
            trMeca_CRdmLearn oCRdmLearn;
            oCRdmLearn.enLearnCommand = (tenMeca_RdmLearnCommand)pParams[0];
            dabdrv_mecaIf::instance()->vSendMecaCommand(oCRdmLearn);
        }
        break;

        case FC_DABTUNER_TR_CCA_SELF_MSG_BG_CHNLIST:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_SELF_MSG_BG_CHNLIST:"));
            // request channelliste from DB-Query interface
            //trMeca_CRdmLearn oCRdmLearn;
            //oCRdmLearn.enLearnCommand = (tenMeca_RdmLearnCommand)pParams[0];
            //dabdrv_mecaIf::instance()->vSendMecaCommand(oCRdmLearn);
        }
        break;

        case FC_DABTUNER_TR_CCA_SELF_MSG_SET_ADR_WATCHDOG:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_SELF_MSG_SET_ADR_WATCHDOG:"));
            // Todo read first parameter and enable/disable adr watchdog
            // request channelliste from DB-Query interface
            //trMeca_CRdmLearn oCRdmLearn;
            //oCRdmLearn.enLearnCommand = (tenMeca_RdmLearnCommand)pParams[0];
            //dabdrv_mecaIf::instance()->vSendMecaCommand(oCRdmLearn);
        }
        break;

        case FC_DABTUNER_TR_SELECT_TPEG_URI:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_SELECT_TPEG_URI:"));

            midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart oMStart;
            
            char acTmp[100];
            OSALUTIL_szSaveStringNCopy( acTmp, 
                                        (char const *)&pParams[0],
                                        100);
            oMStart.sTpegUriChn.sTpegUriChn.bSet((tString)acTmp,midw_ext_fi_tclString::FI_EN_UTF8);
            oMStart.bActive=TRUE;
            
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace sSelectUri=%s",
                            oMStart.sTpegUriChn.sTpegUriChn.szGet(midw_ext_fi_tclString::FI_EN_UTF8)));

            vSendSelfMessage(oMStart);
        }
        break;

        case FC_DABTUNER_TR_DESELECT_TPEG_URI:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_DESELECT_TPEG_URI:"));

            midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart oMStart;
            
            char acTmp[100];
            OSALUTIL_szSaveStringNCopy( acTmp, 
                                        (char const *)&pParams[0],
                                        100);
            oMStart.sTpegUriChn.sTpegUriChn.bSet((tString)acTmp,midw_ext_fi_tclString::FI_EN_UTF8);
            oMStart.bActive=FALSE;
            
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace sSelectUri=%s",
                            oMStart.sTpegUriChn.sTpegUriChn.szGet(midw_ext_fi_tclString::FI_EN_UTF8)));

            vSendSelfMessage(oMStart);
        }
        break;
        
        case FC_DABTUNER_TR_GET_TPEG_URI_LIST:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_GET_TPEG_URI_LIST"));
            midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart oMStart;
            vSendSelfMessage(oMStart);
        }
        break;

        case FC_DABTUNER_TR_TPEG_ACTIVITY:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_TPEG_ACTIVITY"));
            trMsgDrvSetTpegMode rMsg;
            rMsg.bEnable = pParams[0];
            DAB_vCallMsg(rMsg);
        }
        break;
        case FC_DABTUNER_TR_TPEG_LOAD_FILE:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_TPEG_LOAD_FILE"));
            trMsgDrvLoadTpegSimFile rMsg;
            DAB_vCallMsg(rMsg);
        }
        break;
#ifndef VARIANT_S_FTR_ENABLE_DAB_TEST_CLIENT
        case FC_DABTUNER_TR_STORE_PERS_DATA:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_STORE_PERS_DATA:"));
            trMsgSrvCmdStorePersData rCmd;
            DAB_vCallMsg(rCmd);
        }
        break;

        case FC_DABTUNER_TR_SYS_STORE:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_SYS_STORE:"));
            trMsgDrvCmdSysStore rCmd(u8Param1);
            DAB_vCallMsg(rCmd);
        }
        break;

        case FC_DABTUNER_TR_SYS_RESTORE:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_SYS_ReSTORE:"));
            trMsgDrvCmdSysReStore rCmd(u8Param1);
            DAB_vCallMsg(rCmd);
        }
        break;

        case FC_DABTUNER_TR_CFG_SRV_FOLLOW:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CFG_SRV_FOLLOW:"));
            trMsgDrvCmdConfigDabSrvFollow rCmd;
            rCmd.enSrvFollowClass=(tenSrvFollowClass)u8Param1;
            rCmd.u8ServFollowMode=u8Param2;
            DAB_vCallMsg(rCmd);
        }
        break;

        case FC_DABTUNER_TR_ENABLE_ADR3_LOGGING:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_MECA_ENABLE_ADR3_LOGGING:"));
            trMeca_CSysStoragePutFrame rPutFrame;
            rPutFrame.u8UserId=0;
            rPutFrame.enDeviceId=enMeca_SysStorageDeviceId_PARAMETER_MEMORY;
            rPutFrame.u16DataType = 1;

            tChar const *szOutData="38050002010000000438050002020000000444000080005000";

            
            if (!bGetHexData((tU8)strlen(szOutData), (tU8 const*)szOutData, &rPutFrame.u16DataLen, rPutFrame.au8Data)) {
                ETG_TRACE_USR4(("fc_dabtuner_tclTrace::bGetHexData failed:"));
                return;
            }

            dabdrv_mecaIf::instance()->vSendMecaCommand(rPutFrame); 

        }
        break;

#endif

        case FC_DABTUNER_TR_CCA_SELF_MSG_SPM_CV:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_SELF_MSG_SPM_CV:"));
#ifndef DABTUNER_UTEST
#ifndef VARIANT_S_FTR_ENABLE_NEW_SPM_CORE_FI
            cfc_spmfi_tclMsgCvmEventStatus oPStatus;
            // spm-fi does not derive from fi_tclMessageBase
            
            oPStatus.CvmEvent.enType=(cfc_fi_tcl_SPM_e32_CVM_EVENT::tenType)u8Param1;
            vSendSelfMessage(oPStatus, CCA_C_U16_SRV_SPM, CFC_SPMFI_C_U16_CVMEVENT, AMT_C_U8_CCAMSG_OPCODE_STATUS);
#endif
#endif
        }
        break;

        case FC_DABTUNER_TR_CCA_SELF_MSG_TMC_AVAIL_LIST_GET:
        {
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_SELF_MSG_TMC_AVAIL_LIST_GET:"));
            midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTGet oPGet;
            vSendSelfMessage(oPGet);
        }
        break;

		case FC_DABTUNER_TR_CCA_SELF_MSG_SET_ENS_LIST:
        {
            midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart oMStart;
            oMStart.enOperation.enType=(midw_ext_fi_tcl_e8_DAB_ListOperation::tenType)u8Param1;
            oMStart.u16FirstElemId=u8Param2;
            oMStart.u16NumElem=u8Param3;
			oMStart.enSortingType.enType=(midw_ext_fi_tcl_e8_DAB_EnsembleListSortingType::tenType)u8Param4;
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_FROZEN_LIST: op=%d firstElem=%d numElem=%d sorting=%d",
                            ETG_CENUM(tenListOperation, oMStart.enOperation.enType),
                            oMStart.u16FirstElemId,
                            oMStart.u16NumElem,
							oMStart.enSortingType.enType));
            vSendSelfMessage(oMStart );
        }
        break;
		 case FC_DABTUNER_TR_CCA_SELF_MSG_ENS_SELECT:
        {
            midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart oMStart;
            oMStart.SelectMode.enType=(midw_ext_fi_tcl_e8_DAB_EnsSelectMode::tenType)u8Param1;
            oMStart.u32Value = (tS32)DABDRV_GET_U32(&pParams[1]);
            oMStart.bNegative = pParams[5] ? TRUE: FALSE;
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_CHN_SELECT: SelectMode=%d u32Value=0x%x (%u) bNegative=%d",
                            ETG_CENUM(tenChnSelectMode, u8Param1),
                            oMStart.u32Value, 
                            oMStart.u32Value,
                            oMStart.bNegative));
            vSendSelfMessage(oMStart);
            break;
        }
		 case FC_DABTUNER_TR_CCA_SELF_MSG_INITIAL_AUTOSTORE:
			 {
				 midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart oMStart;
				 oMStart.StartAutostore=(tBool)u8Param1;
				  ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_INITIAL_AUTOSTORE: startautostore=%d ",
                              oMStart.StartAutostore));
				 vSendSelfMessage(oMStart);
				 break;
			 }
		 case FC_DABTUNER_TR_CCA_SELF_MSG_ENS_SEEK:
		{
			midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart oMStart;
			oMStart.enTuneCmd.enType = (midw_ext_fi_tcl_e8_DAB_TuneCmd::tenType)u8Param1;
			ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_ENS_SEEK: TuneCmd=%d",
							ETG_CENUM(tenTuneCmd, u8Param1)));

			vSendSelfMessage(oMStart);
			break;
		}
		case FC_DABTUNER_TR_CCA_SELF_MSG_DEL_PRESET:
		{
			midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart oMStart;
			oMStart.e8Action.enType= (midw_ext_fi_tcl_e8_DAB_DeleteAction::tenType)u8Param1;
			oMStart.u8DelPresetElemId=u8Param2;
			ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_SELF_MSG_DEL_PRESET: deleteAction=%d, u8DelPresetElemId=%d",
								ETG_CENUM(DAB_tenPresetListDeleteAction, u8Param1),		
				                oMStart.u8DelPresetElemId));
			vSendSelfMessage(oMStart);
			break;
		}
		case FC_DABTUNER_TR_CCA_SET_FREQUENCY_TABLE:
			{
				ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_SET_FREQUENCY_TABLE: table %d",
				ETG_CENUM(tenMeca_RdmFrequencyTable,u8Param1) ));
				trMsgDrvCmdDabFrequencyTable rCmd;
				rCmd.u8FrequencyTable=u8Param1;
				DAB_vCallMsg(rCmd);
				break;
			}
		case FC_DABTUNER_TR_CCA_SCAN_BAND:
			{
				midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart oMStart;
				oMStart.StartScan= u8Param1;
				ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_SCAN_BAND: Scan mode %d",
					u8Param1));
			    vSendSelfMessage(oMStart);				
				break;
			}
		case FC_DABTUNER_TR_CCA_SELECT_ANNO:
			{
				trMsgDrvCmdSelectAnno rCmd;
				rCmd.bSelect=u8Param1;
				rCmd.u16AnnoMask= DABDRV_GET_U16(&pParams[1]);
				ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_SELECT_ANNO: bSelect %d, u16AnnoMask %x",
				u8Param1,
				rCmd.u16AnnoMask));
				DAB_vCallMsg(rCmd);
				break;
			}
		case FC_DABTUNER_TR_CCA_DELETE_LEARN_MEMORY:
			{			
				trMsgDrvDeleteMemory rCmd;
				rCmd.enDeleteAction	=(tenMeca_DbConfig_ValueId)u8Param1;				
				ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_DELETE_LEARN_MEMORY: deleteAction %x",
					ETG_CENUM(tenMeca_DbConfig_ValueId,rCmd.enDeleteAction)));
				DAB_vCallMsg(rCmd);
				break;
			}
	   case FC_DABTUNER_TR_CCA_GET_TIILIST:
		{
			midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodStart oMStart;		
			ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_GET_TIILIST: "));
			vSendSelfMessage(oMStart);
			break;
		}

	   case FC_DABTUNER_TR_CCA_MTC_SETMODE:
		   {
				midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart oMStart;
				oMStart.b8Mode.u8Value = u8Param1;
				ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_MTC_SETMODE: "));
				vSendSelfMessage(oMStart);
				break;
		   }

		case FC_DABTUNER_TR_CCA_MTC_REQUEST_SWITCH:
		   {
				/*midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_REQUEST_SWITCHMethodStart oMStart;
				oMStart.Request.enType = (midw_ext_fi_tcl_e8_MTC_Request::tenType)u8Param1;
				ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_MTC_REQUEST_SWITCH: "));
				vSendSelfMessage(oMStart);*/
				break;
		   }

		case FC_DABTUNER_TR_CCA_MTC_ANNOUNCEMENT:
		   {
				/*midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_ANNOUNCEMENTMethodStart oMStart;
				oMStart.ActivityRequest.enType = (midw_ext_fi_tcl_e8_MTC_Tuner_ActivityState::tenType)u8Param1;
				ETG_TRACE_USR4(("fc_dabtuner_tclTrace::FC_DABTUNER_TR_CCA_MTC_ANNOUNCEMENT: "));
				vSendSelfMessage(oMStart);*/
				break;
		   }
		case FC_DABTUNER_TR_CCA_SELF_MSG_FIELD_STRENGTH:
		  {
			midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodStart oMStart;
			ETG_TRACE_USR4(("fc_dabtuner_tclTrace::midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodStart: "));
			vSendSelfMessage(oMStart);
			break;
		 }
		case FC_DABTUNER_TR_CCA_SELF_MSG_DEFAULT_SETTINGS:
		 {
			midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart oMStart;
			ETG_TRACE_USR4(("fc_dabtuner_tclTrace::midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart: "));
			vSendSelfMessage(oMStart);
			break;
		 }
		case FC_DABTUNER_TR_CCA_FREQUENCY_LABEL:
		{
			midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart oMStart;
			char acTmp[4]; // Coverity
            OSALUTIL_szSaveStringNCopy( acTmp, 
                                        (char const *)&pParams[0],
                                        4);
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace acTmp=%s",acTmp));
            oMStart.FrequencyLabel.bSet((tString)acTmp,midw_ext_fi_tclString::FI_EN_UTF8);
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace FrequencyLabel=%s",
                            oMStart.FrequencyLabel.szGet(midw_ext_fi_tclString::FI_EN_UTF8)));
			vSendSelfMessage(oMStart);
			break;
		}
		case FC_DABTUNER_TR_CCA_UPDATE_USER_PROFILE:
		{
			midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart oMStart;
			oMStart.Action.enType = (midw_ext_fi_tcl_e8_DAB_UserProfileAction::tenType)u8Param1;
			oMStart.UserID = u8Param2;
			oMStart.DestinationUserID = u8Param3;
			ETG_TRACE_USR4(("fc_dabtuner_tclTrace::vProcess: FC_DABTUNER_TR_CCA_UPDATE_USER_PROFILE: Action %d",
					ETG_CENUM(DAB_tenProfileUpdateType,oMStart.Action.enType)));
            ETG_TRACE_USR4(("fc_dabtuner_tclTrace u8UserId=%d",
                            oMStart.UserID));
			vSendSelfMessage(oMStart);
			break;
		}
		default:
        {
			/**vnd4kor: To solve prio2 lint warning */
			ETG_TRACE_COMP(("To solve prio lint warning printing FC_DABTUNER_TR_CCA_SELF_MSG_MASCSFI_SOURCEACTIVITYSTATUS : (0x%x)",
                            FC_DABTUNER_TR_CCA_SELF_MSG_MASCSFI_SOURCEACTIVITYSTATUS));
			
            ETG_TRACE_COMP(("fc_dabtuner_tclTrace::vProcess(trMsgTtfisEvent): Invalid u8MsgCode (0x%x) ignored",
                            u8MsgCode));
			break;
        }
    }

}


tVoid fc_dabtuner_tclTrace::vSendSelfMessage(fi_tclMessageBase const &oOutData ) const 
{
    ETG_TRACE_USR1(("bSendSelfMessage: u16ServiceId=%d, fid=0x%x, opCode=0x%x",
                    oOutData.u16GetServiceID(),
                    oOutData.u16GetFunctionID(),
                    oOutData.u8GetOpCode())); 

		//construct MethodStart message
    tU8 u8FiVersion = 1;

		fi_tclVisitorMessage oOutVisitorMsg(oOutData.corfoGetTypeBase(), u8FiVersion);
		oOutVisitorMsg.vInitServiceData (
				DAB_SELF_SENDER_APP,              				// AppID of this application
				 CCA_C_U16_APP_FC_DABTUNER,        				// AppID of the Server
				AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,  // StreamType
				0,                    				// StreamCounter
				DAB_mainProxy::u16GetRegId(oOutData.u16GetServiceID()),   // RegId
				0,                                  // command counter
				oOutData.u16GetServiceID(),//u16ServiceId,			                // SID of the service
				oOutData.u16GetFunctionID(), //u16FID, //FID
				oOutData.u8GetOpCode() //u8Opcode  // MethodStart
				);
 

    if (AIL_EN_N_NO_ERROR != DAB_mainProxy::enPostMsg(&oOutVisitorMsg)) {
        ETG_TRACE_USR1(("bSendSelfMessage failed!")); 
        
    }
}

tVoid fc_dabtuner_tclTrace::vSendSelfMessage(fi_tclVisitorMessage oOutVisitorMsg, tU16 u16SrvId, tU16 u16FnId, tU8 u8OpCode) const 
{
    ETG_TRACE_USR1(("bSendSelfMessage: u16ServiceId=%d, fid=0x%x, opCode=0x%x",
                    u16SrvId,
                    u16FnId,
                    u8OpCode)); 


		oOutVisitorMsg.vInitServiceData (
				DAB_SELF_SENDER_APP,              				// AppID of this application
				 CCA_C_U16_APP_FC_DABTUNER,        				// AppID of the Server
				AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,  // StreamType
				0,                    				// StreamCounter
				DAB_mainProxy::u16GetRegId(u16SrvId),   // RegId
				0,                                  // command counter
				u16SrvId,//u16ServiceId,			                // SID of the service
				u16FnId, //u16FID, //FID
				u8OpCode //u8Opcode  // MethodStart
				);
 

    if (AIL_EN_N_NO_ERROR != DAB_mainProxy::enPostMsg(&oOutVisitorMsg)) {
        ETG_TRACE_USR1(("bSendSelfMessage failed!")); 
        
    }
}
