/************************************************************************
* FILE:         fc_dabtuner_trace.h
* PROJECT:      g3g
* SW-COMPONENT: FC_DABTUNER
*----------------------------------------------------------------------
*
* DESCRIPTION: DABTuner main application class
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                      | Modification
* 15.06.07  | CM-DI/PJ-VW36-Liebanas      | initial version
*
*************************************************************************/

#ifndef _DABTUNER_TRACE_H_
#define _DABTUNER_TRACE_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "fc_dabtuner_config.h"
///*******************************************************************************
//| includes of component-internal interfaces, if necessary
//| (scope: component-local)
//|-----------------------------------------------------------------------------*/
//
/*******************************************************************************
| defines and macros (scope: global)
|-----------------------------------------------------------------------------*/
#define FOR_FUTURE_USE(parm) (tVoid)(parm)


// Base identifier for FC_DABTuner (256 * 121)  0x7900 (taken from tri_types.h->TR_COMP_FC_DABTUNER)
//#ifndef TR_COMP_FC_DABTUNER 
//	#define TR_COMP_FC_DABTUNER	 (256 * 121) //0x7900 
#define TR_TTFIS_FC_DABTUNER 121  //12June07, kbm2hi, added for FC_DABTUNER
//#endif // DAB_TR_COMP


#define FC_DABTUNER_TR_MAIN                 (DAB_TR_COMP + 0x00)  // 0x7900
#define FC_DABTUNER_TR_SERVICE              (DAB_TR_COMP + 0x01)
#define FC_DABTUNER_TR_CLIENT               (DAB_TR_COMP + 0x02)
#define FC_DABTUNER_TR_TTFIS                (DAB_TR_COMP + 0x03)
#define FC_DABTUNER_TR_SRV_BASE             (DAB_TR_COMP + 0x04)
#define FC_DABTUNER_TR_CLIENT_BASE          (DAB_TR_COMP + 0x05)
#define FC_DABTUNER_TR_RFU1                 (DAB_TR_COMP + 0x06)
#define FC_DABTUNER_TR_RFU2                 (DAB_TR_COMP + 0x07)

#define FC_DABTUNER_TR_DRV_MAIN             (DAB_TR_COMP + 0x08)
#define FC_DABTUNER_TR_DRV_ADRIF            (DAB_TR_COMP + 0x09)
#define FC_DABTUNER_TR_DRV_MECAIF           (DAB_TR_COMP + 0x0a)
#define FC_DABTUNER_TR_DRV_MECA             (DAB_TR_COMP + 0x0b)
#define FC_DABTUNER_TR_DRV_MUTE             (DAB_TR_COMP + 0x0c)
#define FC_DABTUNER_TR_DRV_LEARN            (DAB_TR_COMP + 0x0d)
#define FC_DABTUNER_TR_DRV_TSU              (DAB_TR_COMP + 0x0e)
#define FC_DABTUNER_TR_DRV_TMC              (DAB_TR_COMP + 0x0f)
#define FC_DABTUNER_TR_DRV_PRESETS          (DAB_TR_COMP + 0x10)
#define FC_DABTUNER_TR_DRV_PERSDAT          (DAB_TR_COMP + 0x11)
#define FC_DABTUNER_TR_DRV_TESTMD           (DAB_TR_COMP + 0x12)
#define FC_DABTUNER_TR_DRV_SRV              (DAB_TR_COMP + 0x13)
#define FC_DABTUNER_TR_DRV_SRVLST           (DAB_TR_COMP + 0x14)
#define FC_DABTUNER_TR_DRV_COMP             (DAB_TR_COMP + 0x15)
#define FC_DABTUNER_TR_DRV_COMPLST          (DAB_TR_COMP + 0x16)
#define FC_DABTUNER_TR_DRV_ANNO             (DAB_TR_COMP + 0x17)
#define FC_DABTUNER_TR_DRV_DATALST          (DAB_TR_COMP + 0x18)
#define FC_DABTUNER_TR_DRV_UTIL             (DAB_TR_COMP + 0x19)
#define FC_DABTUNER_TR_DRV_TPEG             (DAB_TR_COMP + 0x1a)

#define FC_DABTUNER_TR_UTIL_SYNC            (DAB_TR_COMP + 0x1b)
#define FC_DABTUNER_TR_UTIL_DISP            (DAB_TR_COMP + 0x1c)  
#define FC_DABTUNER_TR_UTIL_MSG             (DAB_TR_COMP + 0x1d)  
#define FC_DABTUNER_TR_UTIL_PROF            (DAB_TR_COMP + 0x1e)  
#define FC_DABTUNER_TR_UTIL                 (DAB_TR_COMP + 0x1f)  



#ifdef VARIANT_S_FTR_ENABLE_DAB_TEST_CLIENT
// reuse trace-classes for dab_tc
#define FC_DABTUNER_TR_TC_MAIN              (DAB_TR_COMP + 0x00)
#define FC_DABTUNER_TR_TC_SERVICE           (DAB_TR_COMP + 0x01)
#define FC_DABTUNER_TR_TC_CLIENT            (DAB_TR_COMP + 0x02)
#endif


#endif   // #if defined _DABTUNER_TRACE_H_
