/************************************************************************
* FILE:         fc_dabtuner_service.h
* PROJECT:      g3g
* SW-COMPONENT: FC_DABTUNER
*----------------------------------------------------------------------
*
* DESCRIPTION: DABTuner CCA server. 
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                      | Modification
* 15.06.07  | CM-DI/PJ-VW36-Liebanas      | initial version
*
*************************************************************************/

#ifndef _DABTUNER_CCASERVICE_H_
#define _DABTUNER_CCASERVICE_H_

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#include "fc_dabtuner_messageHandlerCommon.hpp"
#include "dabdrv_main.hpp"
#include "fc_dabtuner_serviceBase.h"


//lint -esym(763, fc_dabtuner_tclApp)  Redundant declaration for symbol
class fc_dabtuner_tclApp;

//-----------------------------------------------------------------------------
// defines
//-----------------------------------------------------------------------------


// handler for fi-messages (properties)
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSGet;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSRelUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSGet;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSGet;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATARelUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAGet;
//class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSGet;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTRelUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTGet;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYGet;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOGet;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTGet;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTGet;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATARelUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOGet;
//class midw_ext_dabtunerfi_tclMsgFID_DAB_G_EXT_SERVICE_FOLLOWING_STATUSGet;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFORelUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFORelUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOGet;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFORelUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTGet;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATARelUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAGet;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATARelUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSRelUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSGet;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATARelUpReg;

#ifdef VARIANT_S_FTR_ENABLE_TPEG
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTRelUpReg;
#endif// VARIANT_S_FTR_ENABLE_TPEG

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGRelUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGGet;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETRelUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETGet;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSRelUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSGet;

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSRelUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSGet;

//class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_REQUEST_SWITCH_STATUSUpReg;
//class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_REQUEST_SWITCH_STATUSRelUpReg;

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSRelUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSGet;

//class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_ANNOUNCEMENTUpReg;
//class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_ANNOUNCEMENTRelUpReg;

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORRelUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORGet;

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATERelUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEGet;

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONUpReg;
class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONRelUpReg;

// handler for fi-messages (methods)
//class midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNEMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart;

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart;

//class midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_REQUEST_SWITCHMethodStart;

//class midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_ANNOUNCEMENTMethodStart;

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart;
//class midw_ext_dabtunerfi_tclMsgFID_DAB_S_DIAG_CONFIGURATIONMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart;
class midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodStart;
class midw_ext_fi_tcl_DAB_Label;
namespace DAB {

//service id
//#define CCA_C_U16_SRV_DAB_TUNER (tU16)0x007c -> defined in di_frameworks/components/cca/ccaservice.h
//lint -esym(763, fc_dabtuner_tclWireMsgCmd)  Redundant declaration for symbol
class fc_dabtuner_tclWireMsgCmd;



//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------
//lint -esym(1704, fc_dabtuner_tclCCAService::fc_dabtuner_tclCCAService) prio3 constructor has private access specification
class fc_dabtuner_tclCCAService : 
public DAB_MessageHandlerCommon<fc_dabtuner_tclCCAService>,
    public DAB_Singleton <fc_dabtuner_tclCCAService>,
    public DAB::DAB_ServiceBase
{
    friend class DAB_Singleton<fc_dabtuner_tclCCAService>;


	fc_dabtuner_tclCCAService(const fc_dabtuner_tclCCAService& rhs);
	fc_dabtuner_tclCCAService& operator=(const fc_dabtuner_tclCCAService& rhs);

	fc_dabtuner_tclCCAService(); // constructor

    virtual tVoid vDispatchMessage_(amt_tclServiceData *pMsg);


    trAdressing _rTestModeGetAdressing;

    struct trCurrentDefset {
        trCurrentDefset():
            bRunning(FALSE),
            u32FiGroup(0),
            u32FiMode(0)
        {}
        tBool bRunning;
        tU32 u32FiGroup;
        tU32 u32FiMode;
    };
    trCurrentDefset _rCurrentDefset;

protected:
    DAB::trServerConfig oDabServiceConfig;
    virtual DAB::trServerConfig &roGetConfig();
private:
    tVoid vHandlePresetRequest(tU8 uPresetNr);
	tVoid vLabelFromFI(trMecaLabel &oMecalabel, midw_ext_fi_tcl_DAB_Label const oFILabel);

public:
    DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_SERVICE);
    virtual tVoid vDeInit();
	
	virtual tVoid vOnNewAppState(tU32 u32AppState);
    virtual char const *pcGetName() const {return "fc_dabtuner_tclCCAService";};

    // handler for fi-messages (properties)
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSGet *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSUpReg *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSRelUpReg *pMsg) const;
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSGet *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSGet *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAUpReg *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATARelUpReg *pMsg) const;
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAGet *pMsg);
    //tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSGet *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTUpReg *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTRelUpReg *pMsg) const;
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTGet *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYGet *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOGet *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTGet *pMsg);
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTGet *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAUpReg *pMsg)const;
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATARelUpReg *pMsg)const;
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOUpReg *pMsg);
   // tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_EXT_SERVICE_FOLLOWING_STATUSGet *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFORelUpReg *pMsg)const;
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOGet *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOUpReg *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFORelUpReg *pMsg)const;
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOGet *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOUpReg *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFORelUpReg *pMsg)const;
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTGet *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAUpReg *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATARelUpReg *pMsg) const;
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAGet *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAUpReg *pMsg) const;
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATARelUpReg *pMsg) const;
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSUpReg *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSRelUpReg *pMsg) const;
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSGet *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAUpReg *pMsg) const;
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATARelUpReg *pMsg) const;
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart *pMsg) const;
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart *pMsg);
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodStart *pMsg);
	#ifdef VARIANT_S_FTR_ENABLE_TPEG
	    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTUpReg *pMsg) const;
        tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTRelUpReg *pMsg) const;
    #endif// VARIANT_S_FTR_ENABLE_TPEG
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart *pMsg);
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart *pMsg);

	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSUpReg *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSRelUpReg *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSGet *pMsg);

	//tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_REQUEST_SWITCH_STATUSUpReg *pMsg);
    //tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_REQUEST_SWITCH_STATUSRelUpReg *pMsg);

	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSUpReg *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSRelUpReg *pMsg);
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSGet *pMsg);

	//tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_ANNOUNCEMENTUpReg *pMsg);
   // tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_ANNOUNCEMENTRelUpReg *pMsg);

	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORUpReg *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORRelUpReg *pMsg);
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORGet *pMsg);

    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEUpReg *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATERelUpReg *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEGet *pMsg);

    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONUpReg *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONRelUpReg *pMsg);

	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGUpReg *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGRelUpReg *pMsg) ;
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGGet *pMsg);
	
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETUpReg *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETRelUpReg *pMsg) ;
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETGet *pMsg);

	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSUpReg *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSRelUpReg *pMsg);
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSGet *pMsg);
    // handler for fi-messages (methods)
    //tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNEMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart *pMsg);

	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart *pMsg); 


	//tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_REQUEST_SWITCHMethodStart *pMsg); 
	

	//tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_ANNOUNCEMENTMethodStart *pMsg); 

	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart *pMsg);
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart *pMsg);
	    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart *pMsg);
    //tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_DIAG_CONFIGURATIONMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart *pMsg);
    tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart *pMsg);
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart *pMsg);
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart *pMsg);
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart *pMsg);
	tVoid vHandleFi(trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodStart *pMsg);
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart *pMsg);
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart *pMsg);
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart *pMsg);
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart *pMsg);
	tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodStart *pMsg);

    // proxy for fc_dabtuner_tclApp
    tVoid vProcess(trMsgSrvRspAppStateReached const *poAppStateReached) const ;

    // handlers for property-updates from dabdrv
    virtual tVoid vProcess(DAB_trTunerStatusProperty* poTunerStatus);
    virtual tVoid vProcess(DAB_trTestModeDataProperty* poTestModeData);
    virtual tVoid vProcess(DAB_trBgTestModeDataProperty* poBgTestModeData);
    virtual tVoid vProcess(trMsgSrvRspGetTestModeData* poRspGetTestModeData);
    virtual tVoid vProcess(DAB_trComponentInfoProperty* poComponentInfo);
    virtual tVoid vProcess(DAB_trServiceInfoProperty* poServiceInfo);
    virtual tVoid vProcess(DAB_trEnsembleInfoProperty* poEnsembleInfo);
    virtual tVoid vProcess(DAB_trTmcAvailListProperty* poTmcAvailList);
    virtual tVoid vProcess(DAB_trTmcTpegInfoProperty* poTmcTpegInfo);
    virtual tVoid vProcess(DAB::trMsgSrvRspUpdateChnList *poUpdateChnList);
    virtual tVoid vProcess(DAB_trChnInfoProperty* poChnInfo);
    virtual tVoid vProcess(DAB_trAnnoStatusProperty* poAnnoStatus);
    virtual tVoid vProcess(DAB_trSetupStatusProperty* poSetupStatus);
    //virtual tVoid vProcess(DAB_trMuteStatusProperty* poMuteStatus);
    virtual tVoid vProcess(DAB_trAvailabilityProperty* poAvailability);
    virtual tVoid vProcess(DAB_trCompListProperty* poCompList);
    virtual tVoid vProcess(DAB_trTmcDataListProperty* poTmcData);
    virtual tVoid vProcess(DAB_trTsuSwitchProperty* poTsuSwitch);
    virtual tVoid vProcess(DAB_trMuteRequestProperty* poMuteStatus);
    virtual tVoid vProcess(DAB_trTpegDataListProperty* poTpegData);
	virtual tVoid vProcess(DAB_trPresetListProperty* poPresetList);
	virtual tVoid vProcess(DAB_trLearnUpdateStatusProperty* poLearnUpdate);
	virtual tVoid vProcess(DAB_trADRMsgProperty* poADRMsg);
	virtual tVoid vProcess(DAB_trLocalOffsetProperty* poLocalInfo);
	
    virtual tVoid vProcess(DAB_trMsgSrvListUpdateProperty* poSrvListUpdate);
    virtual tVoid vProcess(DAB_trMsgSrvListUpdateNotification* poSrvListUpdateNotification);

    // method-results from dabdrv
    virtual tVoid vProcess(DAB::trMsgSrvRspSetChnList *poChnList);
	virtual tVoid vProcess(DAB::trMsgSrvRspSetEnsmbleList *poEnsList);
    virtual tVoid vProcess(DAB::trMsgSrvRspGetPresetList *poPresetList);
    virtual tVoid vProcess(DAB::trMsgSrvRspChnSelect *poSrvRspChnSelect);
	virtual tVoid vProcess(DAB::trMsgSrvRspAnnoSelect *poSrvRspAnnoSelect);
	virtual tVoid vProcess(trMsgSrvRspEnsSelect *poSrvRspEnsSelect);
    virtual tVoid vProcess(DAB::trMsgSrvRspCompSelect *poSrvRspCompSelect);
    virtual tVoid vProcess(DAB::trMsgSrvRspSetPresetStation *poSrvRspSetPresetStation);
	virtual tVoid vProcess(DAB::trMsgSrvRspAutostore *poSrvRspAutostore);
    virtual tVoid vProcess(DAB::trMsgSrvRspTestOperation *poSrvRspTestOperation);
    virtual tVoid vProcess(DAB::trMsgSrvResultRsp *poSrvRspDefSet);
    virtual tVoid vProcess(DAB::trMsgSrvRspRdbidWishlist *poRdbidWishlist);
    virtual tVoid vProcess(DAB::trMsgDrvRspGetExpApi *poGetExpApi);
    virtual tVoid vProcess(DAB::trMsgDrvRspDbQueryTestmode *poDbQueryTestmode);
    virtual tVoid vProcess(DAB::trMsgSrvRspGetTpegUriList *poTpegUriList);
	virtual tVoid vProcess(DAB::trMsgSrvRspScan *poSrvRspScan);
	virtual tVoid vProcess(DAB::trMsgSrvRspGetTIIList *poSrvRspGetTIIList);
	virtual tVoid vProcess(DAB::trMsgSrvRspExpIdValueU32 *poSrvRspExpId);
	virtual tVoid vProcess(DAB::trMsgSrvRspSrcState *poSrvRspSrcState);
	virtual tVoid vProcess(DAB::trMsgSrvCmdRspTuneFreqlabel *poSrvRspTuneFreqLabel);
	virtual tVoid vProcess(DAB::trMsgSrvRspSetUser *poSrvRspSetUser);
	virtual tVoid vProcess(DAB::trMsgSrvCmdRspSavePresetList *poSrvRspSavePresetList);
	virtual tVoid vProcess(DAB::trMsgSrvRspValidateEPGData *poValidateEPGData);


	virtual tVoid vProcess(DAB::DAB_trMTCSetModeProperty* poMTCMode);
	//virtual tVoid vProcess(DAB::DAB_trMTCSwitchStatusProperty* poSwitchMode);
	virtual tVoid vProcess(DAB::DAB_trMTCTunerStatusProperty* poSwitchMode);


	//virtual tVoid vProcess(DAB::DAB_trMTCAnnouncementProperty* poAnnoState);


	virtual tVoid vProcess(DAB::DAB_trMTCSurveillanceMonitorProperty* poSurvMonitor);
	virtual tVoid vProcess(DAB::trMsgSrvRspCmdLearn *poRspCmdLearn);



	tVoid vSetupLinkingMask( trMsgSrvCmdSetup *oCmdSetup,
		tU8 u8DABFMLinkingThreshold,
		tU8 u8DABFMLinkingBackThreshold,
		tU8 u8DABFMLinkingBackValidationTime,
		tU8 u8DABFMLinkBackDelay)const;
#ifndef _LINUXX86MAKE_	
    tVoid vSetDABAvailability(tBool bState)
    {
        vSetAvailability(bState);
    }
#endif
};
}
#endif //_DABTUNER_CCASERVICE_H_
