/************************************************************************
* FILE:         fc_dabtuner_service.cpp
* PROJECT:      g3g
* SW-COMPONENT: FC_DABTUNER
*----------------------------------------------------------------------
*
* DESCRIPTION: DABTuner CCA server
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                      | Modification
* 15.06.07  | CM-DI/PJ-VW36-Liebanas      | initial version
*
*************************************************************************/




//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#include "fc_dabtuner_util.h"
#include "fc_dabtuner_main.h"
#include "fc_dabtuner_service.h"
#include "fc_dabtuner_trace.h"
#include "dabdrv_main.hpp"
#include "dabdrv_learn.hpp"
#include "dabdrv_mute.hpp"
//#include "fc_dabtuner_clienthandler_vdamfmaud.h"
#include "dabdrv_presets.hpp"

#include "dabdrv_testmode.hpp"

#include "fc_dabtuner_fiConvert.h"
#include "fc_dabtuner_util.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_SERVICE 
#include "trcGenProj/Header/fc_dabtuner_service.cpp.trc.h"
#endif


#define FC_DABTUNER_S_IMPORT_INTERFACE_MSG
#include "fc_dabtuner_if.h"


#define FC_DAB_USE_NOT_TESTMODE_UPREG 1

using namespace DAB;
/* +++ MESSAGE MAP:
enter the function IDs (FID) and the corresponding functions here.
the function will be called when a message with the corresponding FID arrives +++ */

DAB_BEGIN_MSG_MAP(fc_dabtuner_tclCCAService)
//HMI messages
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SOURCE_STATE, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SRV_SELECT, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart)
   ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_ENS_SELECT, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_COMP_SELECT, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart)
    //ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_TUNE, 
                 // midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNEMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_LEARN, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SETUP, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_TEST_OPERATION, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_STOP_ANNO, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SELECT_TMC, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_RDBID_WISH_LIST, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_TPEG_URI_LIST, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SET_TPEG_CHN, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart)
    //ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_DIAG_CONFIGURATION, 
        //          midw_ext_dabtunerfi_tclMsgFID_DAB_S_DIAG_CONFIGURATIONMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_ANNO_CONFIG, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_GET_PRESET_LIST, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_ACTIVATE_PRESET_LIST_ELEM, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SAVE_PRESET_LIST_ELEM, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart)
	ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_DELETE_PRESET_LIST_ELEM, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart)
	ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_AUTOSTORE, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SET_SRV_LIST, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SET_ENS_LIST, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart)
	ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SET_COMP_LIST, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SET_TESTMODE, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_GET_EXP_API_INFO, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_DB_QUERY, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SEEK_ENSEMBLE, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SEEK_SERVICE, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart)			  	
	ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SELECT_BANK, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SET_MUTE_STATUS, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart)
	ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_START_SCAN, 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SELECT_ANNO , 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_GET_TIILIST , 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_DSM_MSG , 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart)
    ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_DATASERVICES_DATA , 
                  midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart)
	ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_MTC_SETMODE ,
					midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart)
	//ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_MTC_REQUEST_SWITCH ,
			//		midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_REQUEST_SWITCHMethodStart)
	//ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_MTC_ANNOUNCEMENT ,
				//	midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_ANNOUNCEMENTMethodStart)
   ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_DEFAULT_SETTINGS ,
					midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart) 
	ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_GET_FIELDSTRENGTH,
					midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodStart)
	ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_TARGET_SEEK ,
					midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart) 				
	ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_TUNE_FREQUENCY_LABEL ,
					midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart)
	ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SAVE_PRESET_LIST ,
					midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart)
	ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_VALIDATE_EPG_LIST,
					midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodStart) 

	ON_DAB_MSTART(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_USER_PROFILE_UPDATE ,
					midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart)
    ON_DAB_PUPRGET(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TUNER_STATUS, 
                midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSGet )
    ON_DAB_PUPR_GET_LONG(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_ANNO_STATUS, 
                   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSUpReg, 
                   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSRelUpReg,
                   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSGet )
    ON_DAB_PUPRGET(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_SETUP_STATUS, 
                   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSGet )
    ON_DAB_PUPR_GET_LONG(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TESTMODE_DATA, 
                midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAUpReg, 
                midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATARelUpReg,
                midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAGet)
    ON_DAB_PUPR_GET_LONG(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_BG_TESTMODE_DATA, 
                midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAUpReg, 
                midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATARelUpReg,
				midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAGet)
    ON_DAB_PUPR_LONG(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TMC_TPEG_DATA, 
                midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAUpReg, 
                midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATARelUpReg)
    ON_DAB_PUPR_GET_LONG(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_MUTE_REQUEST, 
                midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTUpReg, 
                midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTRelUpReg,
				midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTGet)
    ON_DAB_PUPR(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_SRV_LIST_UPDATE)
    ON_DAB_PUPRGET(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_AVAILABILITY, 
                   midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYGet )
    ON_DAB_PUPRGET(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_COMP_LIST, 
                   midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTGet )
	ON_DAB_PUPRGET(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_PRESET_LIST, 
                   midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTGet )
    ON_DAB_PUPRGET(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_CHANNEL_INFO, 
                   midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOGet )
    ON_DAB_PUPR_LONG(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TMC_DATA, 
                midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAUpReg, 
                midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATARelUpReg)
    ON_DAB_PUPR_GET_LONG(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_ACTIVE_COMPONENT_INFO,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOUpReg,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFORelUpReg,
					 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOGet)
   // ON_DAB_PUPRGET(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_EXT_SERVICE_FOLLOWING_STATUS,
                   //  midw_ext_dabtunerfi_tclMsgFID_DAB_G_EXT_SERVICE_FOLLOWING_STATUSGet )
     ON_DAB_PUPR_GET_LONG(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_ACTIVE_SERVICE_INFO,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOUpReg,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFORelUpReg,
					 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOGet)
    ON_DAB_PUPR_LONG(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_ACTIVE_ENSEMBLE_INFO,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOUpReg,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFORelUpReg)
    ON_DAB_PGET(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TMC_AVAIL_LIST, 
                midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTGet )
    ON_DAB_PUPR_GET_LONG(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_SERVICE_FOLLOWING_STATUS, 
                   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSUpReg, 
                   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSRelUpReg,
                   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSGet )
    ON_DAB_PUPR_LONG(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TPEG_DATA, 
                   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAUpReg, 
                   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATARelUpReg)
#ifdef VARIANT_S_FTR_ENABLE_TPEG
    ON_DAB_PUPR_LONG(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_TPEG_URI_LIST, 
                   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTUpReg, 
                   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTRelUpReg)
#endif// VARIANT_S_FTR_ENABLE_TPEG

     ON_DAB_PUPR_GET_LONG( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_ADR_MSG,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGUpReg,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGRelUpReg,
					 midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGGet)
	 ON_DAB_PUPR_GET_LONG( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_LOCAL_OFFSET,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETUpReg,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETRelUpReg,
					 midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETGet)

ON_DAB_PUPR_GET_LONG( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_LEARNUPDATE_PROGRESS,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSUpReg,
					 midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSRelUpReg,
					 midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSGet)

	ON_DAB_PUPR_GET_LONG( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_MTC_SETMODE_STATUS,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSUpReg,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSRelUpReg,
					 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSGet)

   

	/*ON_DAB_PUPR_LONG( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_MTC_REQUEST_SWITCH_STATUS,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_REQUEST_SWITCH_STATUSUpReg,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_REQUEST_SWITCH_STATUSRelUpReg)*/

	ON_DAB_PUPR_GET_LONG( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_MTC_TUNER_STATUS,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSUpReg,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSRelUpReg,
					 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSGet)

	//ON_DAB_PUPR_LONG( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_MTC_ANNOUNCEMENT,
 //                    midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_ANNOUNCEMENTUpReg,
 //                    midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_ANNOUNCEMENTRelUpReg)

	ON_DAB_PUPR_GET_LONG( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_MTC_SURVEILLANCE_MONITOR,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORUpReg,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORRelUpReg,
					 midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORGet)

    ON_DAB_PUPR_GET_LONG( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_LIST_UPDATE,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEUpReg,
					 midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATERelUpReg,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEGet)

    ON_DAB_PUPR_LONG( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_SRVLIST_NOTIFICATION,
                     midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONUpReg,
					 midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONRelUpReg)
//no longer supported    ON_DAB_PUPRGET(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_MUTE_STATUS, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSGet)
//no longer supported    ON_MESSAGE(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SERVICESEEK, vHandleServiceSeek)
//no longer supported    ON_MESSAGE(MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SCAN, vHandleScan)

DAB_END_MSG_MAP()

//lint -esym(1762, fc_dabtuner_tclCCAService::vHandle*)
//lint -esym(818, poMessage)
//lint -esym(818, pMsg)
/*************************************************************************
*
* FUNCTION: fc_dabtuner_tclCCAService(fc_dabtuner_tclApp* poMain)
* 
* DESCRIPTION: constructor, creates object ccademo_tclservice - object
*
*
*************************************************************************/
    fc_dabtuner_tclCCAService::fc_dabtuner_tclCCAService():
        oDabServiceConfig(CCA_C_U16_SRV_DAB_TUNER,
                          CCA_C_U16_APP_FC_DABTUNER,
                          "DAB_Service",
                          MIDW_EXT_DABTUNERFI_C_U16_SERVICE_MAJORVERSION,
                          MIDW_EXT_DABTUNERFI_C_U16_SERVICE_MINORVERSION, 0)
{
	/* --- this constructor calls ( implicit ) the constructor of the upper class ( framework )
	so it registers the combinations of FID and message handler with the framework  --- */

    // proxy for fc_dabtuner_tclApp
    vSubscribe<trMsgSrvRspAppStateReached>();

    // property-updates
    vSubscribe<DAB_trTunerStatusProperty>();
    vSubscribe<DAB_trTestModeDataProperty>(); // upreg-only property
    vSubscribe<DAB_trBgTestModeDataProperty>(); // upreg-only property
    vSubscribe<DAB_trChnInfoProperty>();
    vSubscribe<DAB_trAnnoStatusProperty>();
    vSubscribe<DAB_trSetupStatusProperty>();
    //vSubscribe<DAB_trMuteStatusProperty>();
    vSubscribe<DAB_trAvailabilityProperty>();
    vSubscribe<DAB_trCompListProperty>();
    vSubscribe<trMsgSrvRspUpdateChnList>(); // upreg-only property
    vSubscribe<DAB_trTmcDataListProperty>();    // upreg-only property
    vSubscribe<DAB_trTsuSwitchProperty>();
    vSubscribe<DAB_trComponentInfoProperty>();
    vSubscribe<DAB_trServiceInfoProperty>();
    vSubscribe<DAB_trEnsembleInfoProperty>();
    vSubscribe<DAB_trTmcAvailListProperty>();
    vSubscribe<DAB_trTmcTpegInfoProperty>();
    vSubscribe<DAB_trMuteRequestProperty>();
    vSubscribe<DAB_trTpegDataListProperty>();    // upreg-only property
	vSubscribe<DAB_trPresetListProperty>();  
	vSubscribe<DAB_trLearnUpdateStatusProperty>(); 
	vSubscribe<DAB_trADRMsgProperty>(); 
	vSubscribe<DAB_trLocalOffsetProperty>();
	 
	vSubscribe<DAB_trMTCSetModeProperty>();

	//vSubscribe<DAB_trMTCSwitchStatusProperty>();
	
	vSubscribe<DAB_trMTCTunerStatusProperty>();

	//vSubscribe<DAB_trMTCAnnouncementProperty>();

	vSubscribe<DAB_trMTCSurveillanceMonitorProperty>();
    vSubscribe<DAB_trMsgSrvListUpdateProperty>();
    vSubscribe<DAB_trMsgSrvListUpdateNotification>();

    // async method-results
    vSubscribe<trMsgSrvRspSetChnList>();
	vSubscribe<trMsgSrvRspSetEnsmbleList>();
	vSubscribe<trMsgSrvRspAnnoSelect>();
    vSubscribe<trMsgSrvRspGetPresetList>();
    vSubscribe<trMsgSrvRspChnSelect>();
	vSubscribe<trMsgSrvRspEnsSelect>();
    vSubscribe<trMsgSrvRspCompSelect>();
    vSubscribe<trMsgSrvRspSetPresetStation>();
	vSubscribe<trMsgSrvRspAutostore>();
    vSubscribe<trMsgSrvRspTestOperation>();
    vSubscribe<trMsgSrvResultRsp>();
    vSubscribe<trMsgSrvRspRdbidWishlist>();
    vSubscribe<trMsgDrvRspGetExpApi>();
    vSubscribe<trMsgDrvRspDbQueryTestmode>();
    vSubscribe<trMsgSrvRspGetTpegUriList>();
	vSubscribe<trMsgSrvRspScan>();
	vSubscribe<trMsgSrvRspGetTIIList>();
	vSubscribe<trMsgSrvRspCmdLearn>();
	vSubscribe<trMsgSrvRspExpIdValueU32>();
	vSubscribe<trMsgSrvRspSrcState>();
	vSubscribe<trMsgSrvRspSetUser>();
	vSubscribe<trMsgSrvCmdRspSavePresetList>();
	vSubscribe<trMsgSrvRspValidateEPGData>();
	vSubscribe<trMsgSrvCmdRspTuneFreqlabel>();
}

// Called before destruction
tVoid fc_dabtuner_tclCCAService::vDeInit() {
    vDeInitServiceBase();
}

trServerConfig &fc_dabtuner_tclCCAService::roGetConfig() {
    return oDabServiceConfig;
}


/*************************************************************************
*
 * FUNCTION: tVoid vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState)
 * 
 * DESCRIPTION: handles state - change messages form the spm
 *
 *************************************************************************/
//lint -esym(1762, fc_dabtuner_tclCCAService::vOnNewAppState)
tVoid fc_dabtuner_tclCCAService::vOnNewAppState(tU32 u32AppState)
{
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vOnNewAppState(): Should switch to Applikation state: %u",
                    ETG_ENUM(APP_STATE, (tU8)u32AppState)));
	
		switch(u32AppState)
		{
			case AMT_C_U32_STATE_NORMAL:
			case AMT_C_U32_STATE_DIAGNOSIS:
			case AMT_C_U32_STATE_PAUSE:
				{
                    //#ifdef _LINUXX86MAKE_	
						vSetAvailability(TRUE);
					//#endif
					break;
				}
			case AMT_C_U32_STATE_OFF:
				{
                    vSetAvailability(FALSE);
					break;
				}
			default:
				{
					/* +++ unkown power state: enter error handling here ( trace or assert ) +++ */
					break;
				}
		}//switch(u32AppState)
}


//-----------------------------------------------------------------------------
// handler for fi-messages (Methods)
//-----------------------------------------------------------------------------
//tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
//                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNEMethodStart *pMsg) {
//    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_TUNEMethodStart): TuneParam: %u",
//                    pMsg->TuneParam.u32Value));
//
//    midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNEMethodResult oFiResult;
//
//#if 0
//    trMsgSrvCmdTune rMsg(DAB_enTuneMode_Freq,DAB_enDir_UP,pMsg->TuneParam.u32Value);
//    DAB_vCallMsg(rMsg);
//#endif    
//    oFiResult.e8MethodResult.enType=midw_ext_fi_tcl_e8_DAB_Response::FI_EN_DAB_RES_FAILED;
//    enSendFiMessage(&roAdressing, oFiResult);
//}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart *pMsg) {

    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SRV_SELECTMethodStart): Mode: %u  value: %d scids =%d",
                    ETG_ENUM(tenChnSelectMode, pMsg->SelectMode.enType),
                    pMsg->u32Value,
                    pMsg->u16Scids));
	ETG_TRACE_USR4(("CCR.STARTING.SEEK:MethodStart"));
    vStoreNotification(&roAdressing);
    trMeca_CMtcSfRestart rSrvCmdMtcSfRestart;
    dabdrv_mecaIf::instance()->vSendMecaCommand(rSrvCmdMtcSfRestart);

    trMsgSrvCmdMtcTunerstatus rTunerstaus;
    DAB_vCallMsg(rTunerstaus);

#ifdef MUTE_ACTIVE
    tU8 u8chnselectemode = (tU8)pMsg->SelectMode.enType;
    if(((u8chnselectemode == enChnSelectMode_Relative) || (u8chnselectemode == enChnSelectMode_ListId) || (u8chnselectemode == enChnSelectMode_Psid)) && (dabdrv_main::instance()->enGetSourceState() == DAB_enSourceState_FG))
    {

    	trMsgSrvCmdSrvSelect rSrvCmdSrvSelect;
        rSrvCmdSrvSelect.enChnSelectMode= (tenChnSelectMode)u8chnselectemode;
        rSrvCmdSrvSelect.u32Value=pMsg->u32Value;
		rSrvCmdSrvSelect.u16Scids=pMsg->u16Scids;
        rSrvCmdSrvSelect.bNegative=pMsg->bNegative;
        rSrvCmdSrvSelect.enMuteOp=(u8chnselectemode == (tU8)enChnSelectMode_ListId)?enMuteOperation_LoadFromList:enMuteOperation_ServiceSeek;
        DAB_vCallMsg(rSrvCmdSrvSelect);
    }
    else
    {
#endif
        trMsgSrvCmdChnSelect rSrvCmdChnSelect;
        rSrvCmdChnSelect.enChnSelectMode=(tenChnSelectMode)pMsg->SelectMode.enType;
        rSrvCmdChnSelect.u32Value=pMsg->u32Value;
        rSrvCmdChnSelect.u16Scids=pMsg->u16Scids;
        rSrvCmdChnSelect.bNegative=pMsg->bNegative;
        rSrvCmdChnSelect.vTrace();
        DAB_vCallMsg(rSrvCmdChnSelect);
#ifdef MUTE_ACTIVE
    }
#endif
}
tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart *pMsg) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_ENS_SELECTMethodStart): Mode: %u  value: %d",
                    ETG_ENUM(tenChnSelectMode, pMsg->SelectMode.enType),
                    pMsg->u32Value));
    vStoreNotification(&roAdressing);
    trMsgSrvCmdEnsSelect rSrvCmdEnsSelect;
    rSrvCmdEnsSelect.enEnsSelectMode=(tenEnsSelectMode)pMsg->SelectMode.enType;
    rSrvCmdEnsSelect.u32Value=pMsg->u32Value;
    rSrvCmdEnsSelect.bNegative=pMsg->bNegative;
    DAB_vCallMsg(rSrvCmdEnsSelect);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing,
		midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodStart *pMsg) {
	(tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_GET_FIELDSTRENGTHMethodStart)"));
    vStoreNotification(&roAdressing);
    trMsgSrvCmdExpSelect rSrvCmdExpSelect;
    rSrvCmdExpSelect.enValueId = enMeca_ExpValueId_FieldStrength;
    rSrvCmdExpSelect.enAction = enMeca_ExpAction_UPDATE_VALUE;
    DAB_vCallMsg(rSrvCmdExpSelect);
}
tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart *pMsg) {

    vStoreNotification(&roAdressing);
    trMeca_CMtcSfRestart rSrvCmdMtcSfRestart;
    dabdrv_mecaIf::instance()->vSendMecaCommand(rSrvCmdMtcSfRestart);

    trMsgSrvCmdMtcTunerstatus rTunerstaus;
    DAB_vCallMsg(rTunerstaus);

    trMsgSrvCmdCompSelect rSrvCmdCompSelect;
    rSrvCmdCompSelect.enChnSelectMode=(tenChnSelectMode)pMsg->SelectMode.enType;
    rSrvCmdCompSelect.u32Value=pMsg->u32Value;
    rSrvCmdCompSelect.bNegative=pMsg->bNegative;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_COMP_SELECTMethodStart): enChnSelectMode: %u u32Value=%u bNegative=%u",
                    ETG_CENUM(tenChnSelectMode, rSrvCmdCompSelect.enChnSelectMode),
                    pMsg->u32Value,
                    pMsg->bNegative));
    DAB_vCallMsg(rSrvCmdCompSelect);
}


tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart *pMsg) {
   
    // todo: check for dab-enable
    
    switch (pMsg->e8SourceState.enType)
    {
        case midw_ext_fi_tcl_e8_DAB_SourceState::FI_EN_DAB_FOREGROUND:
			case midw_ext_fi_tcl_e8_DAB_SourceState::FI_EN_DAB_BACKGROUND:
				{}
            break;
        //case midw_ext_fi_tcl_e8_DAB_SourceState::FI_EN_DAB_BACKGROUND:
        case midw_ext_fi_tcl_e8_DAB_SourceState::FI_EN_DAB_FOREGROUND_TA:
        case midw_ext_fi_tcl_e8_DAB_SourceState::FI_EN_DAB_SERVICE_FOLLOWING:
        default:
			{
				/*commented as reason for introduction is not known*/
				/*trMsgSrvCmdMtcMode enMtcMode;
				enMtcMode.enMtcMode = DAB_enMtcMode_Off;
				trMsgSrvCmdMtcMode rMsgMtc(enMtcMode);
				DAB_vCallMsg(rMsgMtc);*/
            break;
        }
    }

	trMeca_CMtcSfRestart rSrvCmdMtcSfRestart;
    dabdrv_mecaIf::instance()->vSendMecaCommand(rSrvCmdMtcSfRestart);
    trMsgSrvCmdSourceState rMsg((DAB_tenSourceState)pMsg->e8SourceState.enType);
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SOURCE_STATEMethodStart): enSourceState=%u",
                    ETG_CENUM(DAB_tenSourceState, rMsg.enSourceState)));
	ETG_TRACE_USR4(("CCR.STARTING.SOURCE_ACTIVE:MethodStart"));
    DAB_vCallMsg(rMsg);
    vStoreNotification(&roAdressing);
       
}


tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart *pMsg) 
{
	midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult oFiResult;

	trMsgSrvCmdMtcMode rMtcMode;
	
	rMtcMode.enMtcMode = (DAB_tenMtcMode)pMsg->b8Mode.u8Value;
	DAB_vCallMsg(rMtcMode);

    oFiResult.e8MethodResult.enType=midw_ext_fi_tcl_e8_DAB_Response::FI_EN_DAB_RES_OK;
    enSendFiMessage(&roAdressing, oFiResult);
}


//tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
//                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_REQUEST_SWITCHMethodStart *pMsg) 
//{
//	midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_REQUEST_SWITCHMethodResult oFiResult;
//
//	trMsgSrvCmdMtcRequestSwitch rMtcRequestSwitch;
//
//	rMtcRequestSwitch.enMtcRequestSwitch = (DAB_tenMtcRequestSwitch)pMsg->Request.enType;
//	DAB_vCallMsg(rMtcRequestSwitch);
//
//    oFiResult.e8MethodResult.enType=midw_ext_fi_tcl_e8_DAB_Response::FI_EN_DAB_RES_OK;
//    enSendFiMessage(&roAdressing, oFiResult);
//}


//tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
//                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_ANNOUNCEMENTMethodStart *pMsg) 
//{
//	midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_ANNOUNCEMENTMethodResult oFiResult;
//
//	trMsgSrvCmdMtcTuner_ActivityState rMtcActivityState;
//	rMtcActivityState.enMtcActivityState = (DAB_tenMtcActivityState)pMsg->ActivityRequest.enType;
//	DAB_vCallMsg(rMtcActivityState);
//
//    oFiResult.e8MethodResult.enType=midw_ext_fi_tcl_e8_DAB_Response::FI_EN_DAB_RES_OK;
//    enSendFiMessage(&roAdressing, oFiResult);
//}


tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing,
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart *pMsg) {
    trMsgSrvCmdAnnoConfig rAnnoConfig;
    rAnnoConfig.u16AnnoTypesMask = pMsg->AnnoConfig.AnnoConfigTypes.u16Value;
    rAnnoConfig.enAnnoSource = (tenAnnoSource)pMsg->AnnoConfig.AnnoConfigSource.enType;
    rAnnoConfig.bEnable = pMsg->AnnoConfig.bEnable;
	/* in PSA after switching off TA button during announcment HMI does not send stop_anno, hence it is required */
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_ANNO_CONFIGMethodStart): enAnnoSource: %u u16AnnoTypesMask=0x%04x bEnable=%d",
                    ETG_CENUM(tenAnnoSource, rAnnoConfig.enAnnoSource),
                    rAnnoConfig.u16AnnoTypesMask,
                    rAnnoConfig.bEnable));
    DAB_vCallMsg(rAnnoConfig);

    midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult oFiResult;    
    oFiResult.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(rAnnoConfig.enRes);
    enSendFiMessage(&roAdressing, oFiResult);
			
}


//tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
//                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_DIAG_CONFIGURATIONMethodStart *pMsg) {
//
//    // todo: send reject if bRunning already TRUE
//    _rCurrentDefset.bRunning=TRUE;
//    _rCurrentDefset.u32FiGroup=(tU32)pMsg->DefSetStateGroup.enType;
//    _rCurrentDefset.u32FiMode=(tU32)pMsg->DefSetStateMode.enType;
//    vStoreNotification(&roAdressing);
//
//    trMsgSrvCmdDefSet oSrvCmdDefSet(DAB_tclFiConvert::getFromFi(pMsg->DefSetStateMode));
//    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_DIAG_CONFIGURATIONMethodStart): DefSetStateGroup=%u DefSetStateMode=%u (%u)",
//                    pMsg->DefSetStateGroup.enType,
//                    pMsg->DefSetStateMode.enType,
//                    ETG_CENUM(tenDefsetType, oSrvCmdDefSet.enDefsetType)));
//    DAB_vCallMsg(oSrvCmdDefSet);
//}


tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart *pMsg) {
    vStoreNotification(&roAdressing);
    trMsgSrvCmdSetChnList rMsg((tenListOperation)pMsg->enOperation.enType, 
				               (tenChnListType)pMsg->enServiceListType.enType,
                               pMsg->u16FirstElemId, 
                               pMsg->u16NumElem,
							   pMsg->u32PTYFilter,
							   (tenServiceListSortingType)pMsg->enSortingType.enType,
							   pMsg->u16EnsembleIndex);
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SET_SRV_LISTMethodStart): enOperation=%u enListType=%d u16FirstElemId=%u u16NumElem=%u u32PTYFilter=%u EnsIndex=%d",
                    ETG_CENUM(tenListOperation, rMsg.enOperation),
					ETG_CENUM(tenChnListType, rMsg.enListType),
                    pMsg->u16FirstElemId,
                    pMsg->u16NumElem,
					pMsg->u32PTYFilter,
					pMsg->u16EnsembleIndex));
	ETG_TRACE_USR4(("CCR.STARTING.STATION_LIST:MethodStart)"));
    DAB_vCallMsg(rMsg);
}
tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart *pMsg) {
    vStoreNotification(&roAdressing);
    trMsgSrvCmdSetEnsmbleList rMsg((tenListOperation)pMsg->enOperation.enType, 
                               pMsg->u16FirstElemId, 
                               pMsg->u16NumElem,
							   (tenEnsembleListSortingType)pMsg->enSortingType.enType);
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SET_ENS_LISTMethodStart): enOperation=%u u16FirstElemId=%u u16NumElem=%u",
                    ETG_CENUM(tenListOperation, rMsg.enOperation),
                    pMsg->u16FirstElemId,
                    pMsg->u16NumElem));

    DAB_vCallMsg(rMsg);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart *pMsg) {
    trMsgSrvCmdSetCompList rMsg((tenListOperation)pMsg->enOperation.enType);
    DAB_vCallMsg(rMsg);
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SET_COMP_LISTMethodStart): enOperation=%u enRes=%d",
                    ETG_CENUM(tenListOperation, rMsg.enOperation),
                    ETG_CENUM(DAB_tenResult, rMsg.enRes)));
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult oFiMRes;
    oFiMRes.e8MethodResult = DAB_tclFiConvert::vConvert2Fi(rMsg.enRes);
    enSendFiMessage(&roAdressing, oFiMRes);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart *pMsg) {

    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SET_TESTMODEMethodStart): bActive=%u",
                    pMsg->bActive));
	if(pMsg->bActive == 0){
		ETG_TRACE_USR4(("CCR.ENDING.TESTMODE_DATA:fc_dabtuner_tclCCAService::vHandleFi(trAdressing)"));
	}
	else{
		ETG_TRACE_USR4(("CCR.STARTING.TESTMODE_DATA:MethodStart"));
		trMsgDrvDbQuery rDbQueryAltFreq(Query_AltFreqInformation);
		DAB_vCallMsg(rDbQueryAltFreq);
	}

#ifdef FC_DAB_USE_NOT_TESTMODE_UPREG
    trMsgDrvActivateComponentInfo rMsgComp(pMsg->bActive);
    DAB_vCallMsg(rMsgComp);
    trMsgDrvActivateEnsembleInfo rMsgEns(pMsg->bActive);
    DAB_vCallMsg(rMsgEns);
    trMsgDrvActivateServiceInfo rMsgSvc(pMsg->bActive);
    DAB_vCallMsg(rMsgSvc);
    trMsgDrvSetBgTestMode rMsgBg(pMsg->bActive);
    DAB_vCallMsg(rMsgBg);
    trMsgDrvTmcTpegData rMsgTmc(pMsg->bActive);
    DAB_vCallMsg(rMsgTmc);
#endif

    trMsgDrvSetTestMode rMsg(pMsg->bActive);
    DAB_vCallMsg(rMsg);
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult oFiRes;
    oFiRes.e8MethodResult = DAB_tclFiConvert::vConvert2Fi(rMsg.enRes);
    enSendFiMessage(&roAdressing, oFiRes);

}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart *pMsg) {

    vStoreNotification(&roAdressing);

    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_GET_EXP_API_INFOMethodStart): u16ExpApiId=%x",
                    pMsg->u16ExpApiId));

    trMsgSrvGetExpApi rMsg(pMsg->u16ExpApiId);
    DAB_vCallMsg(rMsg);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart *pMsg) {
    vStoreNotification(&roAdressing);

    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_DB_QUERYMethodStart): u8Adr3DbQuery=%u",
                    pMsg->u8Adr3DbQuery));

    trMsgSrvDbQueryTestmode rMsg;
    rMsg.u8Adr3DbQuery = pMsg->u8Adr3DbQuery;
    DAB_vCallMsg(rMsg);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart *pMsg) {
    (tVoid)roAdressing;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SEEK_ENSEMBLEMethodStart): enTuneCmd=%u",
                    ETG_ENUM(tenTuneCmd, pMsg->enTuneCmd.enType)));

#ifdef DAB_ENABLE_MUTE_HANDLING
    trMsgSrvCmdEnsSeek rMsg;
#else
    trMsgDrvCmdRdmTune rMsg;
#endif
    rMsg.enTuneType=DAB_enTuneType_TUNE_ENSEMBLE;
    if (pMsg->enTuneCmd.enType == midw_ext_fi_tcl_e8_DAB_TuneCmd::FI_EN_DAB_TUNE_NEXT) {
           rMsg.enDirection=DAB_enDir_NEXT;
	   }
	   else {
		   rMsg.enDirection=DAB_enDir_PREV;
	   }

    DAB_vCallMsg(rMsg);

#ifdef DAB_ENABLE_MUTE_HANDLING
    trMsgDrvCmdTunerOpMuteReq rMuteReq;
	rMuteReq.enRequiredMuteState=enRequiredMuteState_Mute;
	DAB_vCallMsg(rMuteReq);
#endif

    midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult oFiRes;
    oFiRes.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(rMsg.enRes);    
    enSendFiMessage(&roAdressing, oFiRes);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart *pMsg) {
    (tVoid)roAdressing;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SEEK_SERVICEMethodStart): enTuneCmd=%u",
    		        ETG_ENUM(tenTuneCmd, pMsg->enTuneCmd.enType)));
	 trMeca_CMtcSfRestart rSrvCmdMtcSfRestart;
    dabdrv_mecaIf::instance()->vSendMecaCommand(rSrvCmdMtcSfRestart);

    trMsgSrvCmdMtcTunerstatus rTunerstaus;
    DAB_vCallMsg(rTunerstaus);


#ifdef MUTE_ACTIVE
    trMsgSrvCmdManualModeOp rMsg;
    rMsg.enTestOperation=DAB_enTestOperation_TUNE_SERVICE;
#else
    trMsgSrvCmdTestOperation rMsg;
    rMsg.enTestOperation=DAB_enTestOperation_TUNE_SERVICE;
#endif


    if (pMsg->enTuneCmd.enType == midw_ext_fi_tcl_e8_DAB_TuneCmd::FI_EN_DAB_TUNE_NEXT) {
        rMsg.u32Value1= (tU32)enMeca_RdmServiceCommand_PLAY_NEXT;
    }
    else {
        rMsg.u32Value1= (tU32)enMeca_RdmServiceCommand_PLAY_PREVIOUS;
    }
    DAB_vCallMsg(rMsg);

    midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult oFiRes;
    oFiRes.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(rMsg.enRes);    
    enSendFiMessage(&roAdressing, oFiRes);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart *pMsg) {
    (tVoid)roAdressing;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SELECT_BANKMethodStart): e8BankId=%u",
    		        ETG_ENUM(tenTuneCmd, pMsg->e8BankId.enType)));

	tU8 u8BankId=0;	
	if((DAB_tenBankList)pMsg->e8BankId.enType == Bank_DAB4) //DAB-AST
		u8BankId=1;	

	trMsgSrvCmdSetPresetBank rMsg(u8BankId);

	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SELECT_BANKMethodStart): u8PresetBank=%u",
    		        rMsg.u8PresetBank));

	DAB_vCallMsg(rMsg);

    midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult oFiRes;
    oFiRes.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(rMsg.enRes);    
    enSendFiMessage(&roAdressing, oFiRes);
}
tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart *pMsg) {

    (tVoid)roAdressing;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SET_MUTE_STATUSMethodStart): e8DabSource=%d e8MuteStatus=%d",
                                            ETG_CENUM(tenDabSource, (tenDabSource)pMsg->e8DabSource.enType),
                                            pMsg->e8MuteStatus.enType ));

#ifdef MUTE_ACTIVE
    trMsgDrvMuteState rMsg;    
	rMsg.enMuteState= (tenRequiredMuteState)pMsg->e8MuteStatus.enType;
#else
    trMsgDrvSetMuteStatus rMsg;
	rMsg.enMuteState= (tenARLMuteState)pMsg->e8MuteStatus.enType;
#endif
	rMsg.enDabSource = (tenDabSource)pMsg->e8DabSource.enType;

	
    /*ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SET_MUTE_STATUSMethodStart): rMsg.enMuteState=%u",
    		ETG_CENUM(tenRequiredMuteState, (tenRequiredMuteState)rMsg.enMuteState)));*/
    DAB_vCallMsg(rMsg);

    midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult oFiResult;
    oFiResult.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(rMsg.enRes);    
    vNotifyOnce(oFiResult);
}


tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart *pMsg) {
    vStoreNotification(&roAdressing);
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_GET_PRESET_LISTMethodStart): u8FirstElementID=%u u8NumberOfElements=%u",
                    pMsg->u8FirstElementID,
                    pMsg->u8NumberOfElements));

    trMsgSrvCmdGetPresetList rMsg(pMsg->u8FirstElementID, pMsg->u8NumberOfElements);
    DAB_vCallMsg(rMsg);

}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart *pMsg) {
	vStoreNotification(&roAdressing);
    tBool bRes = TRUE;
	DAB_tenResult enRes = DAB_enResult_OK;
    tU8 uPresetNr = 0;
    uPresetNr = pMsg->u8ActPresetElemID;
    bRes = dabdrv_presets::instance()->vGetPresetValidity(uPresetNr);
    if(!bRes){
        midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult oFiResult;
		oFiResult.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(DAB_enResult_FAILED);    
		vNotifyOnce(oFiResult);
		return;
	}
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart): u8ActPresetElemID=%u",pMsg->u8ActPresetElemID));
    trMeca_CMtcSfRestart rSrvCmdMtcSfRestart;
    dabdrv_mecaIf::instance()->vSendMecaCommand(rSrvCmdMtcSfRestart);

    trMsgSrvCmdMtcTunerstatus rTunerstaus;
     DAB_vCallMsg(rTunerstaus);


    vHandlePresetRequest(uPresetNr);


    // todo: async result?
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult oFiResult;
    oFiResult.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(enRes);
    vNotifyOnce(oFiResult);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart *pMsg) {

    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart): u8PresetElemId=%u bDelete=%u u32PSID=0x%08x u32EnsFrequency=%u u8Scids=%d",
                    pMsg->u8PresetElemId,
                    pMsg->bDelete,
                    pMsg->u32PSID,
                    pMsg->u32EnsFrequency,
                    pMsg->u8Scids));
    vStoreNotification(&roAdressing);
    trMsgSrvCmdStorePreset rMsg;
    rMsg.u8PresetNumber=pMsg->u8PresetElemId;
    rMsg.bDelete=pMsg->bDelete;
    rMsg.rPSID=trMecaProgrammeService(pMsg->u32PSID,enMeca_ServiceType_AUDIO_SERVICE,(tU16)pMsg->u8Scids);
    rMsg.u32EnsFrequency=pMsg->u32EnsFrequency;
    DAB_vCallMsg(rMsg);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing,
										   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart *pMsg){
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart): u8PresetElemId=%u , delaction=%u",
					pMsg->u8DelPresetElemId,
					 ETG_CENUM(DAB_tenPresetListDeleteAction,pMsg->e8Action.enType)
				   ));
	trMsgSrvCmdClearPresets rMsg;
	rMsg.u8PresetNumber=pMsg->u8DelPresetElemId;
	tU8 u8ActionType = pMsg->e8Action.enType;
	rMsg.enDeleteAction=(DAB_tenPresetListDeleteAction)u8ActionType;
	DAB_vCallMsg(rMsg);
	midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult oFiMRes;
    oFiMRes.e8MethodResult = DAB_tclFiConvert::vConvert2Fi(DAB_enResult_OK);
    enSendFiMessage(&roAdressing, oFiMRes);
}
tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart *pMsg){
	 ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_AUTOSTOREMethodStart): StartAutostore=%u",
                    pMsg->StartAutostore));
    vStoreNotification(&roAdressing);
    trMsgSrvCmdAutoStore rMsg;
	rMsg.bStart=pMsg->StartAutostore;
    DAB_vCallMsg(rMsg);
}
tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart *pMsg) {

	vStoreNotification(&roAdressing);
	dabdrv_learn::instance()->bSetManualLearn(TRUE);

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
	trMeca_CRdmQualityConfig rQualityConfig1;
	rQualityConfig1.enMecaQualityConfigCmd = tenMeca_RdmQualityConfigCmd_SET;
	rQualityConfig1.u8QualityStrategy = *poConfig->pcu8GetRdmQualityStrategy();
	rQualityConfig1.u8DataFieldLen = *poConfig->pcu8GetRdmQualityConfigDataLength();
	OSAL_pvMemoryCopy(rQualityConfig1.au8DataField, (poConfig->pcu8GetRdmQualityConfig()), sizeof(rQualityConfig1.au8DataField));
	rQualityConfig1.au8DataField[3] = 0;
	rQualityConfig1.au8DataField[2] = 3;
	rQualityConfig1.au8DataField[6] = 1;
	ETG_TRACE_USR4(("dabdrv_rdm::vSetRdmQualityConfig(trMeca_CRdmQualityConfig) : %*p" ,ETG_LIST_LEN(rQualityConfig1.u8DataFieldLen),ETG_LIST_PTR_T8(rQualityConfig1.au8DataField)));
	dabdrv_mecaIf::instance()->vSendMecaCommand(rQualityConfig1);
#endif
#ifdef MUTE_ACTIVE
	if((tenLearnType)pMsg->LearnParam.e8LearnType.enType == enLearnType_UPDATE){
		trMsgSrvCmdManualLearnOp oCmdLearn((tenLearnType)pMsg->LearnParam.e8LearnType.enType, pMsg->LearnParam.bRollback);
		ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_LEARNMethodStart): enLearnType=%u",
		                    ETG_CENUM(tenLearnType, oCmdLearn.enLearnType)));
		DAB_vCallMsg(oCmdLearn);
	}
	else{
		trMsgSrvCmdLearn oCmdLearn((tenLearnType)pMsg->LearnParam.e8LearnType.enType, pMsg->LearnParam.bRollback);
		ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_LEARNMethodStart): enLearnType=%u",
		                    ETG_CENUM(tenLearnType, oCmdLearn.enLearnType)));
		DAB_vCallMsg(oCmdLearn);
	}
#else
    trMsgSrvCmdLearn oCmdLearn((tenLearnType)pMsg->LearnParam.e8LearnType.enType, pMsg->LearnParam.bRollback);
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_LEARNMethodStart): enLearnType=%u",
                    ETG_CENUM(tenLearnType, oCmdLearn.enLearnType)));
    DAB_vCallMsg(oCmdLearn);
#endif
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart *pMsg) {
    trMsgSrvCmdSetup oCmdSetup;
    oCmdSetup.u32SetupMask=pMsg->b32SetupMask.u32Value;
    oCmdSetup.u32SetupFlags=pMsg->b32SetupFlags.u32Value;
    oCmdSetup.bIsTestMode=pMsg->bIsTestmode;

    /* Concealment Level */
    oCmdSetup.bUseConcealmentLevel=pMsg->bUseConcealmentLevel;
    if (TRUE == pMsg->bUseConcealmentLevel ) {
        if ( 8 > pMsg->u8ConcealmentLevel ) {
            ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SETUPMethodStart): CONCEALMENT - LEVEL (%d)",pMsg->u8ConcealmentLevel));
            oCmdSetup.u8ConcealmentLevel=pMsg->u8ConcealmentLevel;

            fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
            if (OSAL_NULL ==poConfig) {
                ETG_TRACE_FATAL(("dabdrv_main::vProcess(trMeca_RAudSetConcealmentLevel) config not available !!!"));
            }
            else {
                poConfig->vSetConcealmentLevel(oCmdSetup.u8ConcealmentLevel);
            }
        }
        else{
            ETG_TRACE_ERR(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SETUPMethodStart): CONCEALMENT - LEVEL invalid (%d)",pMsg->u8ConcealmentLevel));
            oCmdSetup.bUseConcealmentLevel = FALSE;
        }
    }

    /* Service Linking Mode */
    oCmdSetup.bUseServiceLinkingMode=pMsg->bUseServiceLinkingMode;
    oCmdSetup.e8ServiceLinkingMode=(DAB_tenServiceLinkingMode)pMsg->e8ServiceLinkingMode.enType;

    /* Measurement mode */
    oCmdSetup.bSwitchMeasurementMode=pMsg->bSwitchMeasurementMode;
    oCmdSetup.u8LinkingSetupMask=(tenLinkingSetupMask)pMsg->b8LinkingSetupMask.u8Value;

    /* Linking Setup */
	vSetupLinkingMask(&oCmdSetup,
		pMsg->u8DABFMLinkingThreshold,
		pMsg->u8DABFMLinkingBackThreshold,

		pMsg->u8DABFMLinkingBackValidationTime,


		pMsg->u8DABFMLinkBackDelay);  

    /* Ensemble Insertion Threshold */
    oCmdSetup.bUseEnsInsertThreshold=pMsg->bUseEnsInsertThreshold;
    if (TRUE == pMsg->bUseEnsInsertThreshold ) {
			ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SETUPMethodStart): INSERTION THRESHOLD  (%d)",pMsg->u8EnsInsertThreshold));
			oCmdSetup.u8EnsInsertThreshold=pMsg->u8EnsInsertThreshold;
    }

    /* Ensemble Deletion Threshold */
	oCmdSetup.bUseEnsDeleteThreshold=pMsg->bUseEnsDeleteThreshold;
	if (TRUE == pMsg->bUseEnsDeleteThreshold ) {
			ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SETUPMethodStart): DELETION THRESHOLD  (%d)",pMsg->u8EnsDeleteThreshold));
			oCmdSetup.u8EnsDeleteThreshold=pMsg->u8EnsDeleteThreshold;
	}

	/* Bg Learn Update Time */
	oCmdSetup.bBgLearnUpdateTime=pMsg->bBgLearnUpdateTime;
	if (TRUE == pMsg->bBgLearnUpdateTime ) {
		ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SETUPMethodStart): BG LEARN UPDATE TIME  (%d)",pMsg->u8BgLearnUpdateTime));
		oCmdSetup.u8BgLearnUpdateTime=pMsg->u8BgLearnUpdateTime;
	}

	/* DAB Scan Threshold */
	oCmdSetup.bDABScanThreshold=pMsg->bDABScanThreshold;
	if (TRUE == pMsg->bDABScanThreshold ) {
		ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SETUPMethodStart): DAB SCAN THRESHOLD  (%d)",pMsg->u8DABScanThreshold));
		oCmdSetup.u8DABScanThreshold=pMsg->u8DABScanThreshold;
	}


    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SETUPMethodStart): u32SetupMask=0x%08x u32SetupFlags=0x%08x"
                    "bUseConcealmentLevel=%u u8ConcealmentLevel=%u bUseServiceLinkingMode=%u e8ServiceLinkingMode=%u bSwitchMeasurementMode=%d u8LinkingSetupMask=%d",
                    oCmdSetup.u32SetupMask,
                    oCmdSetup.u32SetupFlags,
                    oCmdSetup.bUseConcealmentLevel,
                    oCmdSetup.u8ConcealmentLevel,
                    oCmdSetup.bUseServiceLinkingMode,
                    ETG_CENUM(DAB_tenServiceLinkingMode, oCmdSetup.e8ServiceLinkingMode),
                    oCmdSetup.bSwitchMeasurementMode,
                    oCmdSetup.u8LinkingSetupMask));

    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SETUPMethodStart): bUseEnsInsertThreshold=%u u8EnsInsertThreshold=%u"
                       "bUseEnsDeleteThreshold=%u u8EnsDeleteThreshold=%u bBgLearnUpdateTime=%u u8BgLearnUpdateTime=%u bDABScanThreshold=%u u8DABScanThreshold=%u",
                       oCmdSetup.bUseEnsInsertThreshold,
                       oCmdSetup.u8EnsInsertThreshold,
                       oCmdSetup.bUseEnsDeleteThreshold,
                       oCmdSetup.u8EnsDeleteThreshold,
                       oCmdSetup.bBgLearnUpdateTime,
                       oCmdSetup.u8BgLearnUpdateTime,
                       oCmdSetup.bDABScanThreshold,
                       oCmdSetup.u8DABScanThreshold));

    DAB_vCallMsg(oCmdSetup);

    midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult oFiResult;
    oFiResult.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(oCmdSetup.enRes);
    enSendFiMessage(&roAdressing,oFiResult);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart *pMsg) {

	 trMeca_CMtcSfRestart rSrvCmdMtcSfRestart;
    dabdrv_mecaIf::instance()->vSendMecaCommand(rSrvCmdMtcSfRestart);

    trMsgSrvCmdMtcTunerstatus rTunerstaus;
    DAB_vCallMsg(rTunerstaus);
	// if the cmd is accepted the response will be async, so we can call vStoreNotification() later
#ifdef MUTE_ACTIVE
	trMsgSrvCmdManualModeOp rSrvCmd;
	rSrvCmd.enTestOperation=(DAB_tenTestOperation)pMsg->enOperation.enType;
	rSrvCmd.u32Value1=pMsg->u32Value1;
	rSrvCmd.u32Value2=pMsg->u32Value2;
	rSrvCmd.u32Value3=pMsg->u32Value3;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_TEST_OPERATIONMethodStart): enTestOperation=%u"
                    "u32Value1=0x%08x u32Value2=0x%08x u32Value3=0x%08x ",
                    ETG_CENUM(DAB_tenTestOperation, rSrvCmd.enTestOperation),
                    rSrvCmd.u32Value1,
                    rSrvCmd.u32Value2,
                    rSrvCmd.u32Value3));
    DAB_vCallMsg(rSrvCmd);


#else
    trMsgSrvCmdTestOperation rSrvCmd;
		rSrvCmd.enTestOperation=(DAB_tenTestOperation)pMsg->enOperation.enType;
		rSrvCmd.u32Value1=pMsg->u32Value1;
		rSrvCmd.u32Value2=pMsg->u32Value2;
		rSrvCmd.u32Value3=pMsg->u32Value3;
		   ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_TEST_OPERATIONMethodStart): enTestOperation=%u"
						   "u32Value1=0x%08x u32Value2=0x%08x u32Value3=0x%08x ",
						   ETG_CENUM(DAB_tenTestOperation, rSrvCmd.enTestOperation),
						   rSrvCmd.u32Value1,
						   rSrvCmd.u32Value2,
						   rSrvCmd.u32Value3));
       DAB_vCallMsg(rSrvCmd);
#endif
    if (rSrvCmd.bRejected) {
        midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult oFiMRes;
        oFiMRes.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(DAB_enResult_FAILED);
        // todo: add op-code to result
        enSendFiMessage(&roAdressing, oFiMRes);        
    } else {
        vStoreNotification(&roAdressing);
    }
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodStart *pMsg) {
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_STOP_ANNOMethodStart)"));
    vStoreNotification(&roAdressing);
    trMsgSrvCmdStopAnno rSrvCmdStopAnno;
    DAB_vCallMsg(rSrvCmdStopAnno);
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult oFiResult;
    oFiResult.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(rSrvCmdStopAnno.enResult);
    vNotifyOnce(oFiResult);
}
tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing,
				midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodStart *pMsg){
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_GET_TIILISTMethodStart)"));
    vStoreNotification(&roAdressing);
	trMsgSrvGetTIIList rSrvCmdGetTIIList;
    DAB_vCallMsg(rSrvCmdGetTIIList);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, 
				midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart *pMsg){
					  (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_DSM_MSGMethodStart)"));
    vStoreNotification(&roAdressing);
	tU32 u32Length= (tU32)pMsg->DSMMsg.MsgData.size(); 
	tU8 au8Data[DABDRV_MAX_MECA_OUT_LEN] = {0};
	for(tU32 u32Index=0; u32Index<u32Length;u32Index++)
	{
		au8Data[u32Index]=pMsg->DSMMsg.MsgData[u32Index];
	}			
	  ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_DSM_MSGMethodStart) fktID %x length %d",pMsg->DSMMsg.u16FktID,u32Length ));
	  switch(pMsg->DSMMsg.u16FktID){
		  case MECA_DISPATCHER_C_DDM_SELECT_URI:
			  {
			  trMeca_CDdmSelectUri rMsg;
			  rMsg.vUpdate(au8Data);
			  dabdrv_mecaIf::instance()->vSendMecaCommand(rMsg);
			  break;
			  }
		  case MECA_DISPATCHER_C_DB_QUERY:
			  {
				  trMeca_CDbQuery rCDbQuery;
				  rCDbQuery.vUpdate(au8Data);
				  //for (tU32 i=4; i < u32Length; i++) {
				//  ETG_TRACE_USR4(("vHandleFi(FID_DAB_S_DSM_MSGMethodStart) DAta  %x",pMsg->DSMMsg.MsgData[i] ))	;				 
				//  }
				  dabdrv_mecaIf::instance()->vSendMecaCommand(rCDbQuery);
				  break;
			  }
		  default:
			  break;
	  }
}
tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, 
				midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart *pMsg){
					  (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_DATASERVICES_DATAMethodStart)"));
    vStoreNotification(&roAdressing);

	tU16 u16NoOfLogos = (tU16)pMsg->LogoList.size();
	trMsgSrvDataList rDatalist;
	/*rLogolist.vecLogoList.resize(u16NoOfLogos);*/

	 ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_DATASERVICES_DATAMethodStart) LogolistSize %d",u16NoOfLogos));

	 for(tU16 u16Index=0;u16Index<u16NoOfLogos;u16Index++){

		 rDatalist.mapLogoList.insert(pair<tU32,string>(pMsg->LogoList[u16Index].u32ServiceID, pMsg->LogoList[u16Index].sLogoLink.szValue));
		 ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_DATASERVICES_DATAMethodStart) SID %d path %s",pMsg->LogoList[u16Index].u32ServiceID, pMsg->LogoList[u16Index].sLogoLink.szValue));
	 }
	
	tU16 u16NoOfContentIds = (tU16)(pMsg->ContentIDList.size());
	 for(tU16 u16Index1=0;u16Index1<u16NoOfContentIds;u16Index1++){
		ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_DATASERVICES_DATAMethodStart) SID %d supported Ds %d",pMsg->ContentIDList[u16Index1].u32ServiceID,pMsg->ContentIDList[u16Index1].u8Scid));
		rDatalist.mmapContentIdList.insert(pair<tU32,tU8>(pMsg->ContentIDList[u16Index1].u32ServiceID, pMsg->ContentIDList[u16Index1].u8Scid));		 
	 }
	  DAB_vCallMsg(rDatalist);

}
tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart *pMsg) {
    (tVoid)pMsg;

    vStoreNotification(&roAdressing);
    trMsgSrvCmdSelectTmc rSrvCmdSelectTmc;
    DAB_tclFiConvert::vConvertFromFi(pMsg, &rSrvCmdSelectTmc);
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SELECT_TMCMethodStart): rEns=0x%08x rRdbId=0x%08x",
                    rSrvCmdSelectTmc.rEns.u32GetID(),
                    rSrvCmdSelectTmc.rRdbId.u32GetVal()));
    DAB_vCallMsg(rSrvCmdSelectTmc);
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult oFiResult;
    oFiResult.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(rSrvCmdSelectTmc.enRes);
    vNotifyOnce(oFiResult);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart *pMsg) {

    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vHandleFi(FID_DAB_S_RDBID_WISH_LISTMethodStart)"));
    vStoreNotification(&roAdressing);

    trMsgSrvCmdRdbidWishlist rSrvCmdRdbidWishlist;
    DAB_tclFiConvert::vConvertFromFi(pMsg, &rSrvCmdRdbidWishlist);
    DAB_vCallMsg(rSrvCmdRdbidWishlist);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart *pMsg) {

	(tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vHandleFi(FID_DAB_S_TPEG_URI_LISTMethodStart)"));
    vStoreNotification(&roAdressing);

    //trMsgSrvCmdGetTpegUriList rMsg;
    //DAB_vCallMsg(rMsg);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart *pMsg) {

    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vHandleFi(FID_DAB_S_SET_TPEG_CHNMethodStart)"));
    vStoreNotification(&roAdressing);

    trMsgSrvCmdSelectTpegUri rSrvCmdSelectTpegUriMsg;
    DAB_tclFiConvert::vConvertFromFi(pMsg, &rSrvCmdSelectTpegUriMsg);
    DAB_vCallMsg(rSrvCmdSelectTpegUriMsg);

    midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult oFiResult;
    oFiResult.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(DAB_enResult_OK);
    enSendFiMessage(&roAdressing,oFiResult);
}
tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart *pMsg){
	(tVoid)pMsg;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vHandleFi(FID_DAB_S_DEFAULT_SETTINGSMethodStart): pMsg->bSet= %d", pMsg->bSet));
	if (pMsg->bSet) {
		/*Clear presets*/
		trMsgSrvCmdClearPresets rMsg;
		rMsg.enDeleteAction = DAB_enPresetListDelete_AllElems;
		DAB_vCallMsg(rMsg);
		/*switch of SF*/
		trMsgSrvCmdMtcMode rMode;
		rMode.enMtcMode = DAB_enMtcMode_Off;
		DAB_vCallMsg(rMode);
		/*set default anno config*/
		trMsgSrvCmdAnnoConfig rAnnoConfig;
		fc_dabtuner_config *poConfig = fc_dabtuner_config::instance();
		rAnnoConfig.u16AnnoTypesMask = DAB_CONFIG_DEFAULT_ANNOUNCEMENT_CONFIG;
		if (OSAL_NULL != poConfig) {
			rAnnoConfig.u16AnnoTypesMask = poConfig->u8GetAnnoConfig();
		}
		DAB_vCallMsg(rAnnoConfig);
		/*do a def set*/
		trMsgSrvCmdDefSet rSrvCmdDefSet(enDefsetType_USER);
		DAB_vCallMsg(&rSrvCmdDefSet);
	}
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult oFiResult;
    oFiResult.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(DAB_enResult_OK);
    enSendFiMessage(&roAdressing,oFiResult);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart *pMsg){
	(tVoid)pMsg;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vHandleFi(FID_DAB_S_TARGET_SEEKMethodStart)"));

#ifdef MUTE_ACTIVE
	trMsgSrvCmdManualModeOp rMsg;
    rMsg.enTestOperation=DAB_enTestOperation_TUNE_ENSEMBLE;

	 rMsg.u32Value1= enMeca_RdmTuneCmd_SKIM;
	 rMsg.u32Value2=pMsg->u32Frequency;
     if (pMsg->enTuneCmd.enType == midw_ext_fi_tcl_e8_DAB_TuneCmd::FI_EN_DAB_TUNE_NEXT) {
           rMsg.u32Value3=DAB_enDir_NEXT;
	   }
	   else {
		   rMsg.u32Value3=DAB_enDir_PREV;
	   }
	
    DAB_vCallMsg(rMsg);
#endif
	
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult oFiResult;
    oFiResult.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(DAB_enResult_OK);
    enSendFiMessage(&roAdressing,oFiResult);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart *pMsg){
	(tVoid)pMsg;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vHandleFi(FID_DAB_S_TUNE_FREQUENCY_LABELMethodStart)"));
	vStoreNotification(&roAdressing);
    trMeca_CMtcSfRestart rSrvCmdMtcSfRestart;
    dabdrv_mecaIf::instance()->vSendMecaCommand(rSrvCmdMtcSfRestart);
    trMsgSrvCmdMtcTunerstatus rTunerstaus;
    DAB_vCallMsg(rTunerstaus);
	trMsgSrvCmdTuneFreqlabel rMsg;
    //rMsg.sfreqlabel=pMsg->FrequencyLabel;
	rMsg.sfreqlabel=pMsg->FrequencyLabel.szGet(midw_ext_fi_tclString::FI_EN_UTF8);
    DAB_vCallMsg(rMsg);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart *pMsg){
	(tVoid)pMsg;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart)"));
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart): pMsg->u32GetSize() = %d", pMsg->PresetList.size()));
	for (std::vector<midw_ext_fi_tcl_DAB_PresetListElement>::iterator it = pMsg->PresetList.begin(); it != pMsg->PresetList.end() ; it++ )
	{
		ETG_TRACE_USR4(( "vHandleFi save u8PresetElementID  =%d ",it->u8PresetElementID));
		ETG_TRACE_USR4(( "vHandleFi saveServiceLabel  =%s ",it->ServiceLabel.sLabel.szValue));
		ETG_TRACE_USR4(( "vHandleFi save Sid  =%d ",it->u32Frequency));
	}
	vStoreNotification(&roAdressing);
    trMsgSrvSavePresetList rMsg;
	for (tU16 u16Index=0;u16Index < pMsg->PresetList.size();u16Index++) {
		trPresetInfo oPresetInfo;
		trMecaLabel oMecaServiceLabel;
		trMecaLabel oMecaEnsembleLabel;
		trMecaLabel oMecaComponentLabel;
		oPresetInfo.u8StationNumber = pMsg->PresetList[u16Index].u8PresetElementID;
		trMecaProgrammeService oPrgService(pMsg->PresetList[u16Index].u32ServiceID);
		oPresetInfo.rPSID = oPrgService;
		oPresetInfo.u32Frequency = pMsg->PresetList[u16Index].u32Frequency;
		oPresetInfo.u32EnsembleId = pMsg->PresetList[u16Index].u32EnsembleId;
		oPresetInfo.u8Scid = pMsg->PresetList[u16Index].u8Scid;
		vLabelFromFI(oMecaServiceLabel, pMsg->PresetList[u16Index].ServiceLabel);
		vLabelFromFI(oMecaEnsembleLabel, pMsg->PresetList[u16Index].EnsembleLabel);
		vLabelFromFI(oMecaComponentLabel, pMsg->PresetList[u16Index].ComponentLabel);
		oPresetInfo.rLabel = oMecaServiceLabel;
		oPresetInfo.rEnsembleLabel = oMecaEnsembleLabel;
		oPresetInfo.rCompLabel = oMecaComponentLabel;
		oPresetInfo.sLogoLink = pMsg->PresetList[u16Index].sLogoLink.szValue;
		rMsg.vecPresetInfos.push_back(oPresetInfo);
	}
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart): Posting message"));
    DAB_vCallMsg(rMsg);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodStart *pMsg){
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodStart)"));
	vStoreNotification(&roAdressing);
	(tVoid)pMsg;
	trMsgSrvValidateEPGData oMsgSrvValidateEPGData;
	DAB_vCallMsg(oMsgSrvValidateEPGData);
}


tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart *pMsg){
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart)"));
	vStoreNotification(&roAdressing);
//	if (pMsg->Action.enType == (midw_ext_fi_tcl_e8_DAB_UserProfileAction::FI_EN_DAB_PROFILE_CHANGE))
	{
		ETG_TRACE_USR4(("Inside midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart"));
		trMsgSrvCmdSetUser rSetUser;
		rSetUser.enUpdateType = (DAB_tenProfileUpdateType)(pMsg->Action.enType+1);//In MIDW Fi it start from 0 in meca it is from 1.
		rSetUser.u8UserId=pMsg->UserID;
		rSetUser.u8DestUserId=pMsg->DestinationUserID;
		DAB_vCallMsg(rSetUser);
	}
}
//-----------------------------------------------------------------------------
// handler for fi-messages (Properties)
//-----------------------------------------------------------------------------

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSGet *pMsg) {
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_TUNER_STATUSGet)"));
    enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oTunerStatusProperty.oGet()));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSUpReg *pMsg) {
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_ANNO_STATUSUpReg)"));
    enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oAnnoStatusProperty.oGet()));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSRelUpReg *pMsg) const{
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_ANNO_STATUSRelUpReg)"));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSGet *pMsg) {
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_ANNO_STATUSGet)"));
    enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oAnnoStatusProperty.oGet()));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSGet *pMsg) {
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_SETUP_STATUSGet)"));
    enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oSetupStatusProperty.oGet()));
}


/*
tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSGet *pMsg) {
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_MUTE_STATUSGet)"));
    enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oMuteStatusProperty.oGet()));
}
*/

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTUpReg *pMsg){
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_MUTE_REQUESTUpReg)"));
	enSendFiMessage(&roAdressing,
		DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oMuteRequestProperty.oGet()));
    //don't send any status message incase of upreg
  //  trMsgEnableMuteReqProperty rMsg(TRUE);
 //   DAB_vCallMsg(rMsg);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTRelUpReg *pMsg) const{
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_MUTE_REQUESTRelUpReg)"));
    trMsgEnableMuteReqProperty rMsg(FALSE);
    DAB_vCallMsg(rMsg);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTGet *pMsg) {
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_MUTE_REQUESTGet)"));
    enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oMuteRequestProperty.oGet()));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYGet *pMsg) {
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_AVAILABILITYGet)"));
    enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oAvailabilityProperty.oGet()));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTGet *pMsg) {
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_COMP_LISTGet)"));

    midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus oFiRes;
    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oCompListProperty.oGet(), oFiRes);
    enSendFiMessage(&roAdressing, oFiRes);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing,
										   midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTGet *pMsg){
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_PRESET_LISTGet)"));
    enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oPresetListDataProperty.oGet()));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOGet *pMsg) {
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_CHANNEL_INFOGet)"));
    enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oChnInfoProperty.oGet()));
}



tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAUpReg *pMsg){
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_TESTMODE_DATAUpReg)"));
	/*enSendFiMessage(&roAdressing,
		DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oTestModeDataProperty.oGet()));*/
#ifndef FC_DAB_USE_NOT_TESTMODE_UPREG
    trMsgDrvSetTestMode rMsg(TRUE);
    DAB_vCallMsg(rMsg);
#endif
}


tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATARelUpReg *pMsg) const{
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_TESTMODE_DATARelUpReg)"));

#ifndef FC_DAB_USE_NOT_TESTMODE_UPREG
    trMsgDrvSetTestMode rMsg(FALSE);
    DAB_vCallMsg(rMsg);
#endif
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAGet *pMsg) {
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_TESTMODE_DATAGet)"));
	enSendFiMessage(&roAdressing,
		DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oTestModeDataProperty.oGet()));
    _rTestModeGetAdressing=roAdressing;
    trMsgSrvCmdGetTestModeData rMsg;
    DAB_vCallMsg(rMsg);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAUpReg *pMsg){
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_BG_TESTMODE_DATAUpReg)"));
	enSendFiMessage(&roAdressing,
		DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oBgTestModeDataProperty.oGet()));

#ifndef FC_DAB_USE_NOT_TESTMODE_UPREG
    trMsgDrvSetBgTestMode rMsg(TRUE);
    DAB_vCallMsg(rMsg);
#endif
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATARelUpReg *pMsg) const {
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_BG_TESTMODE_DATARelUpReg)"));

#ifndef FC_DAB_USE_NOT_TESTMODE_UPREG
    trMsgDrvSetBgTestMode rMsg(FALSE);
    DAB_vCallMsg(rMsg);
#endif

}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAGet *pMsg) {
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_BG_TESTMODE_DATAGet)"));

    enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oBgTestModeDataProperty.oGet()));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAUpReg *pMsg) const {
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_TMC_TPEG_DATAUpReg)"));

#ifndef FC_DAB_USE_NOT_TESTMODE_UPREG
    trMsgDrvTmcTpegData rMsg(TRUE);
    DAB_vCallMsg(rMsg);
#endif
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATARelUpReg *pMsg) const {
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_TMC_TPEG_DATARelUpReg)"));

#ifndef FC_DAB_USE_NOT_TESTMODE_UPREG
    trMsgDrvTmcTpegData rMsg(FALSE);
    DAB_vCallMsg(rMsg);
#endif
}


tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAUpReg *pMsg) const{
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_TMC_DATAUpReg)"));
    trMsgDrvSetTmcMode rMsg(TRUE);
    DAB_vCallMsg(rMsg);
}

//tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
//                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_EXT_SERVICE_FOLLOWING_STATUSGet *pMsg) {
//    (tVoid)pMsg;
//    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_EXT_SERVICE_FOLLOWING_STATUSGet)"));
//    enSendFiMessage(&roAdressing,
//                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oTsuSwitchProperty.oGet()));
//}



tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATARelUpReg *pMsg) const{
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_TMC_DATARelUpReg)"));
    trMsgDrvSetTmcMode rMsg(FALSE);
    DAB_vCallMsg(rMsg);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOUpReg *pMsg){

    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_ACTIVE_COMPONENT_INFOUpReg)"));
	enSendFiMessage(&roAdressing,
		DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oComponentInfoProperty.oGet()));
    trMsgDrvActivateComponentInfo rMsg(TRUE);
    DAB_vCallMsg(rMsg);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFORelUpReg *pMsg) const{

    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_ACTIVE_COMPONENT_INFORelUpReg)"));

    trMsgDrvActivateComponentInfo rMsg(FALSE);
    DAB_vCallMsg(rMsg);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOGet *pMsg){
	(tVoid)roAdressing;
	(tVoid)pMsg;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOGet)"));
	 enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oComponentInfoProperty.oGet()));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGUpReg *pMsg){
	(tVoid)roAdressing;
	(tVoid)pMsg;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGUpReg)"));
	trMeca_CRdmAudioGetAsid rCRdmAudioGetAsid;
	dabdrv_mecaIf::instance()->vSendMecaCommand(rCRdmAudioGetAsid);
	trMeca_CRdmAudioGetScidi rCRdmAudioGetScidi;
	dabdrv_mecaIf::instance()->vSendMecaCommand(rCRdmAudioGetScidi);
	enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oADRMsgProperty.oGet()));
}
tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGRelUpReg *pMsg) {
	(tVoid)roAdressing;
	(tVoid)pMsg;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGRelUpReg)"));
}
tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGGet *pMsg){
	(tVoid)roAdressing;
	(tVoid)pMsg;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGGet)"));
	 enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oADRMsgProperty.oGet()));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETUpReg *pMsg){
	(tVoid)roAdressing;
	(tVoid)pMsg;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETUpReg)"));
	enSendFiMessage(&roAdressing,
                   DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oLocalOffsetProperty.oGet()));
}
	
tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETRelUpReg *pMsg){
	(tVoid)roAdressing;
	(tVoid)pMsg;
}
tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETGet *pMsg){
	(tVoid)roAdressing;
	(tVoid)pMsg;
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSUpReg *pMsg){
	(tVoid)pMsg;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSUpReg)"));
	enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oLearnUpdateProperty.oGet()));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSRelUpReg *pMsg) {
		(tVoid)roAdressing;
	(tVoid)pMsg;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSRelUpReg)"));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSGet *pMsg) {
	(tVoid)roAdressing;
	(tVoid)pMsg;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSGet)"));
	enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oLearnUpdateProperty.oGet()));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSUpReg *pMsg){
	(tVoid)roAdressing;
	(tVoid)pMsg;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSUpReg)"));
	enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oMTCSetModeProperty.oGet()));
}
tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSRelUpReg *pMsg) {
	(tVoid)roAdressing;
	(tVoid)pMsg;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSRelUpReg)"));
}
tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSGet *pMsg){
	(tVoid)roAdressing;
	(tVoid)pMsg;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSGet)"));
	 enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oMTCSetModeProperty.oGet()));
}

//tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_REQUEST_SWITCH_STATUSUpReg *pMsg){
//	(tVoid)roAdressing;
//	(tVoid)pMsg;
//	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_REQUEST_SWITCH_STATUSUpReg)"));
//	enSendFiMessage(&roAdressing,
//                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oMTCSwitchStatusProperty.oGet()));
//}
//tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_REQUEST_SWITCH_STATUSRelUpReg *pMsg) {
//	(tVoid)roAdressing;
//	(tVoid)pMsg;
//	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_REQUEST_SWITCH_STATUSRelUpReg)"));
//}

tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSUpReg *pMsg){
	(tVoid)roAdressing;
	(tVoid)pMsg;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSUpReg)"));
	enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oMTCTunerStatusProperty.oGet()));
}
tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSRelUpReg *pMsg) {
	(tVoid)roAdressing;
	(tVoid)pMsg;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSRelUpReg)"));
}


tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSGet *pMsg){
	(tVoid)pMsg;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSGet)"));
	 enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oMTCTunerStatusProperty.oGet()));
}


//tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_ANNOUNCEMENTUpReg *pMsg){
//	(tVoid)roAdressing;
//	(tVoid)pMsg;
//	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_ANNOUNCEMENTUpReg)"));
//	enSendFiMessage(&roAdressing,
//                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oMTCAnnouncementProperty.oGet()));
//}
//tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_ANNOUNCEMENTRelUpReg *pMsg) {
//	(tVoid)roAdressing;
//	(tVoid)pMsg;
//	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_ANNOUNCEMENTRelUpReg)"));
//}


tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORUpReg *pMsg){
	(tVoid)roAdressing;
	(tVoid)pMsg;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORUpReg)"));
	enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oMTCSurveillanceMonitorProperty.oGet()));
}
tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORRelUpReg *pMsg) {
	(tVoid)roAdressing;
	(tVoid)pMsg;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORRelUpReg)"));
}


tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORGet *pMsg) {

    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORGet)"));
    enSendFiMessage(&roAdressing,
                        DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oMTCSurveillanceMonitorProperty.oGet()));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOUpReg *pMsg){

    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_ACTIVE_SERVICE_INFOUpReg)"));
	enSendFiMessage(&roAdressing,
		DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oServiceInfoProperty.oGet()));
    trMsgDrvActivateServiceInfo rMsg(TRUE);
    DAB_vCallMsg(rMsg);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFORelUpReg *pMsg) const{

    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_ACTIVE_SERVICE_INFORelUpReg)"));

    trMsgDrvActivateServiceInfo rMsg(FALSE);
    DAB_vCallMsg(rMsg);

}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOGet *pMsg) {

    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOGet)"));
    enSendFiMessage(&roAdressing,
                        DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oServiceInfoProperty.oGet()));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOUpReg *pMsg) {

    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_ACTIVE_ENSEMBLE_INFOUpReg)"));
    trMsgDrvActivateEnsembleInfo rMsg(TRUE);
    enSendFiMessage(&roAdressing,
                        DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oEnsembleInfoProperty.oGet()));
    DAB_vCallMsg(rMsg);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFORelUpReg *pMsg) const{

    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_ACTIVE_ENSEMBLE_INFORelUpReg)"));
    trMsgDrvActivateEnsembleInfo rMsg(FALSE);
    DAB_vCallMsg(rMsg);
}


tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEGet *pMsg) {
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_LIST_UPDATEGet)"));
    enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oSrvListUpdateProperty.oGet()));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEUpReg *pMsg) {

    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_LIST_UPDATEUpReg)"));
    enSendFiMessage(&roAdressing,
                        DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oSrvListUpdateProperty.oGet()));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATERelUpReg *pMsg) {

    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_LIST_UPDATERelUpReg)"));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONUpReg *pMsg) {

    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_SRVLIST_NOTIFICATIONUpReg)"));
    trMsgSrvCmdListUpdateStatus rMsg(TRUE);
    DAB_vCallMsg(rMsg);
    enSendFiMessage(&roAdressing,
                        DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oSrvListUpdateNotification.oGet()));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONRelUpReg *pMsg) {

    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_SRVLIST_NOTIFICATIONRelUpReg)"));
    trMsgSrvCmdListUpdateStatus rMsg(FALSE);
    DAB_vCallMsg(rMsg);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTGet *pMsg) {
    (tVoid)pMsg;

    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_TMC_AVAIL_LISTGet)"));
    vStoreNotification(&roAdressing);
    //trMsgSrvCmdGetTmcLearnData rSrvCmdGetTmcLearnData;
    //DAB_vCallMsg(rSrvCmdGetTmcLearnData);
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult oFiResult;
    oFiResult.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(DAB_enResult_OK);
    enSendFiMessage(&roAdressing,oFiResult);

    //vNotifyOnce(DAB_tclFiConvert::vConvert2Fi(rSrvCmdGetTmcLearnData));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSUpReg *pMsg) {
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_SERVICE_FOLLOWING__STATUSUpReg)"));
    enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oMtcServiceFollowingProperty.oGet()));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSRelUpReg *pMsg) const{
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_SERVICE_FOLLOWING_STATUSRelUpReg)"));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSGet *pMsg) {
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_SERVICE_FOLLOWING_STATUSGet)"));
    enSendFiMessage(&roAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oMtcServiceFollowingProperty.oGet()));
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAUpReg *pMsg) const{
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_TPEG_DATAUpReg)"));
    trMsgDrvSetTpegMode rMsg(TRUE);
    DAB_vCallMsg(rMsg);
}
tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATARelUpReg *pMsg) const{
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_TPEG_DATATelUpReg)"));
    trMsgDrvSetTpegMode rMsg(TRUE);
    DAB_vCallMsg(rMsg);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart *pMsg) const{
	(tVoid)roAdressing;
	trMsgSrvCmdScan rMsg(pMsg->StartScan);
	DAB_vCallMsg(rMsg);
}
tVoid fc_dabtuner_tclCCAService::vHandleFi(DAB::trAdressing const &roAdressing, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart *pMsg){	
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_S_SELECT_ANNOMethodStart): Select=%d AnnoNumber=%u",
                    pMsg->bSelect,
					pMsg->u16AnnoNumber));
	vStoreNotification(&roAdressing);
	trMsgDrvCmdSelectAnno rMsg(pMsg->bSelect,pMsg->u16AnnoNumber);
	DAB_vCallMsg(rMsg);
}
#ifdef VARIANT_S_FTR_ENABLE_TPEG
tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTUpReg *pMsg) const{
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_TPEG_URI_LISTUpReg)"));
    trMsgSrvCmdGetTpegUriList rMsg;
    DAB_vCallMsg(rMsg);
}

tVoid fc_dabtuner_tclCCAService::vHandleFi(trAdressing const &roAdressing, 
                                           midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTRelUpReg *pMsg) const{
   (tVoid)roAdressing;
   (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vHandleFi(FID_DAB_G_TPEG_URI_LISTRelUpReg)"));
}
#endif// VARIANT_S_FTR_ENABLE_TPEG
//-----------------------------------------------------------------------------
// proxy for fc_dabtuner_tclApp
//-----------------------------------------------------------------------------

tVoid fc_dabtuner_tclCCAService::vProcess(trMsgSrvRspAppStateReached const *poAppStateReached) const {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvRspAppStateReached): u32AppState=%u",
                    poAppStateReached->u32AppState));
    fc_dabtuner_tclApp::instance()->vOnAppStateReached(poAppStateReached->u32AppState);
}


//-----------------------------------------------------------------------------
// handler for asyn method-results
//-----------------------------------------------------------------------------
tVoid fc_dabtuner_tclCCAService::vProcess(trMsgSrvRspSetChnList *poChnList) {
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult oFiMRes;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvRspSetChnList)"));
	ETG_TRACE_USR4(("CCR.ENDING.STATION_LIST:fc_dabtuner_tclCCAService::vProcess(trMsgSrvRspSetChnList)"));
    DAB_tclFiConvert::vConvert2Fi(*poChnList, oFiMRes);
    vNotifyOnce(oFiMRes);
}


tVoid fc_dabtuner_tclCCAService::vProcess(trMsgSrvRspValidateEPGData *poValidateEPGData) {
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult oFiMRes;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvRspValidateEPGData)"));
	oFiMRes.bEPGAvailability = poValidateEPGData->bEPGPresent;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvRspValidateEPGData): enRes=%u bEPGPresent=%d",
                    ETG_CENUM(DAB_tenResult, poValidateEPGData->enRes), poValidateEPGData->bEPGPresent));
    DAB_tclFiConvert::vConvert2Fi(*poValidateEPGData, oFiMRes);
    vNotifyOnce(oFiMRes);
}


tVoid fc_dabtuner_tclCCAService::vProcess(trMsgSrvRspSetEnsmbleList *poEnsList) {
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult oFiMRes;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvRspSetEnsmbleList)"));

    DAB_tclFiConvert::vConvert2Fi(*poEnsList, oFiMRes);
    vNotifyOnce(oFiMRes);
}

tVoid fc_dabtuner_tclCCAService::vProcess(trMsgSrvRspGetPresetList *poPresetList) {
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult oFiMRes;
    DAB_tclFiConvert::vConvert2Fi(*poPresetList, oFiMRes);
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvRspGetPresetList)"));
    vNotifyOnce(oFiMRes);
}

tVoid fc_dabtuner_tclCCAService::vProcess(trMsgSrvRspChnSelect *poSrvRspChnSelect) {
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult oFiMRes;
    oFiMRes.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(poSrvRspChnSelect->enRes);
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvRspChnSelect): enRes=%u",
                    ETG_CENUM(DAB_tenResult, poSrvRspChnSelect->enRes)));
	ETG_TRACE_USR4(("CCR.ENDING.SEEK:fc_dabtuner_tclCCAService::vProcess(trMsgSrvRspChnSelect)"));
    vNotifyOnce(oFiMRes);
}

tVoid fc_dabtuner_tclCCAService::vProcess(trMsgSrvRspAnnoSelect *poSrvRspAnnoSelect) {
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult oFiMRes;
    oFiMRes.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(poSrvRspAnnoSelect->enRes);
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvRspAnnoSelect): enRes=%u",
                    ETG_CENUM(DAB_tenResult, poSrvRspAnnoSelect->enRes)));
    vNotifyOnce(oFiMRes);
}



tVoid fc_dabtuner_tclCCAService::vProcess(trMsgSrvRspEnsSelect *poSrvRspEnsSelect) {
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult oFiMRes;
    oFiMRes.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(poSrvRspEnsSelect->enRes);
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvRspEnsSelect): enRes=%u",
                    ETG_CENUM(DAB_tenResult, poSrvRspEnsSelect->enRes)));
    vNotifyOnce(oFiMRes);
}

tVoid fc_dabtuner_tclCCAService::vProcess(trMsgSrvRspCompSelect *poSrvRspCompSelect) {
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult oFiMRes;
    oFiMRes.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(poSrvRspCompSelect->enRes);
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvRspCompSelect): enRes=%u",
                    ETG_CENUM(DAB_tenResult, poSrvRspCompSelect->enRes)));
    vNotifyOnce(oFiMRes);
}

tVoid fc_dabtuner_tclCCAService::vProcess(trMsgSrvRspSetPresetStation *poSrvRspSetPresetStation) {
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult oFiMRes;
    oFiMRes.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(poSrvRspSetPresetStation->enRes);
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvRspSetPresetStation): enRes=%u",
                    ETG_CENUM(DAB_tenResult, poSrvRspSetPresetStation->enRes)));
    vNotifyOnce(oFiMRes);
}

tVoid fc_dabtuner_tclCCAService::vProcess(DAB::trMsgSrvRspAutostore *poSrvRspAutostore){
	 midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult oFiMRes;
    oFiMRes.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(poSrvRspAutostore->enRes);
	oFiMRes.u8NumberOfStationsFound=poSrvRspAutostore->u8NumberOfFoundStations;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvRspAutostore): enRes=%u u8NumberOfStationsFound=%d",
                    ETG_CENUM(DAB_tenResult, poSrvRspAutostore->enRes),
					poSrvRspAutostore->u8NumberOfFoundStations));
    vNotifyOnce(oFiMRes);
}
tVoid fc_dabtuner_tclCCAService::vProcess(DAB::trMsgSrvRspSetUser *poSrvRspSetUser){
	 midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult oFiMRes;
	oFiMRes.Action.enType = (midw_ext_fi_tcl_e8_DAB_UserProfileAction::tenType)(poSrvRspSetUser->enUpdateType-1);
	oFiMRes.ActiveUserID=poSrvRspSetUser->u8UserId;
    oFiMRes.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(poSrvRspSetUser->enRes);
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvRspSetUser):Action=%d ActiveUserID=%d enRes=%u",
					ETG_CENUM(DAB_tenProfileUpdateType, poSrvRspSetUser->enUpdateType),
					poSrvRspSetUser->u8UserId,
                    ETG_CENUM(DAB_tenResult, poSrvRspSetUser->enRes)));
    vNotifyOnce(oFiMRes);
}
tVoid fc_dabtuner_tclCCAService::vProcess(trMsgSrvRspTestOperation *poSrvRspTestOperation) {
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult oFiMRes;
    oFiMRes.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(poSrvRspTestOperation->enResult);
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvRspTestOperation): enRes=%u",
                    ETG_CENUM(DAB_tenTestOperation, poSrvRspTestOperation->enTestOperation)));

    vNotifyOnce(oFiMRes);
}

tVoid fc_dabtuner_tclCCAService::vProcess(trMsgSrvResultRsp */*poSrvRspDefSet*/) {
   /* if (_rCurrentDefset.bRunning) {
        midw_ext_dabtunerfi_tclMsgFID_DAB_S_DIAG_CONFIGURATIONMethodResult oFiMRes;
        oFiMRes.DefSetStateGroup.enType = (midw_ext_fi_tcl_e8_DefSetGroups::tenType)_rCurrentDefset.u32FiGroup;
        oFiMRes.DefSetStateMode.enType = (midw_ext_fi_tcl_e8_DefSetMode::tenType)_rCurrentDefset.u32FiMode;
        oFiMRes.e8MethodResult = DAB_tclFiConvert::vConvert2Fi(poSrvRspDefSet->enRes);
        _rCurrentDefset=trCurrentDefset();
        ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvResultRsp): enRes=%d",
                        ETG_CENUM(DAB_tenResult, poSrvRspDefSet->enRes)));
        vNotifyOnce(oFiMRes);
    }*/
}

tVoid fc_dabtuner_tclCCAService::vProcess(trMsgSrvRspRdbidWishlist *poRdbidWishlist) {
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult oFiMRes;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvRspRdbidWishlist)"));

    DAB_tclFiConvert::vConvert2Fi(*poRdbidWishlist, oFiMRes);
    vNotifyOnce(oFiMRes);
}

tVoid fc_dabtuner_tclCCAService::vProcess(trMsgDrvRspGetExpApi *poGetExpApi) {

    midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult oFiMRes;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgDrvRspGetExpApi)"));
    DAB_tclFiConvert::vConvert2Fi(*poGetExpApi, oFiMRes);
    vNotifyOnce(oFiMRes);
}

tVoid fc_dabtuner_tclCCAService::vProcess(trMsgDrvRspDbQueryTestmode *poDbQueryTestmode) {

    // trMsgDrvRspDbQueryTestmode includes only string from adr3
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult oFiMRes;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgDrvRspDbQueryTestmode)"));
    DAB_tclFiConvert::vConvert2Fi(*poDbQueryTestmode, oFiMRes);
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgDrvRspDbQueryTestmode)  vConvert2Fi"));
    vNotifyOnce(oFiMRes);
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgDrvRspDbQueryTestmode)  vNotify"));
}

tVoid fc_dabtuner_tclCCAService::vProcess(trMsgSrvRspGetTpegUriList *poTpegUriList) {
    midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus oFiMRes;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvRspGetTpegUriList)"));

    DAB_tclFiConvert::vConvert2Fi(*poTpegUriList, oFiMRes);
    vNotify(oFiMRes);
}

//-----------------------------------------------------------------------------
// Handlers for property-updates
//-----------------------------------------------------------------------------

tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trTunerStatusProperty* poTunerStatus) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trTunerStatusProperty) Quality=%u\n",
                    poTunerStatus->u8SignalQuality));
    vNotify(DAB_tclFiConvert::vConvert2Fi(*poTunerStatus));
}

// special property: upreg will only result in messages, when test-mode is activated (trMsgDrvSetTestMode)
tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trTestModeDataProperty* poTestModeData) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trTestModeDataProperty)"));
    vNotify(DAB_tclFiConvert::vConvert2Fi(*poTestModeData));
}

// special property: upreg will only result in messages, when test-mode is activated (trMsgDrvSetTestMode)
tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trBgTestModeDataProperty* poBgTestModeData) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trBgTestModeDataProperty)"));
    vNotify(DAB_tclFiConvert::vConvert2Fi(*poBgTestModeData));
}

// the get is also required: this notification is received when data have been fetched from dab-module after a get-command
tVoid fc_dabtuner_tclCCAService::vProcess(trMsgSrvRspGetTestModeData* poRspGetTestModeData) {
    // indication that data are available now.
    (tVoid)poRspGetTestModeData;
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvRspGetTestModeData)"));
    enSendFiMessage(&_rTestModeGetAdressing,
                    DAB_tclFiConvert::vConvert2Fi(dabdrv_properties::instance()->oTestModeDataProperty.oGet()));

}

tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trComponentInfoProperty* poComponentInfo) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trComponentInfoProperty)"));
    vNotify(DAB_tclFiConvert::vConvert2Fi(*poComponentInfo));
}

tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trServiceInfoProperty* poServiceInfo) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trServiceInfoProperty)"));
    vNotify(DAB_tclFiConvert::vConvert2Fi(*poServiceInfo));
}

tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trEnsembleInfoProperty* poEnsembleInfo) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trEnsembleInfoProperty)"));
    vNotify(DAB_tclFiConvert::vConvert2Fi(*poEnsembleInfo));
}

tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trTmcAvailListProperty* poTmcAvailList) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trTmcAvailListProperty)"));
    vNotify(DAB_tclFiConvert::vConvert2Fi(*poTmcAvailList));
}

tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trTmcTpegInfoProperty* poTmcTpegInfo) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trTmcTpegInfoProperty)"));
    vNotify(DAB_tclFiConvert::vConvert2Fi(*poTmcTpegInfo));
}

tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trChnInfoProperty* poChnInfo) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trChnInfoProperty)"));
    vNotify(DAB_tclFiConvert::vConvert2Fi(*poChnInfo));
}

tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trAnnoStatusProperty* poAnnoStatus) {
    if (!dabdrv_testmode::instance()->bIsTestmodeActive())
	{
		ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trAnnoStatusProperty)"));
		vNotify(DAB_tclFiConvert::vConvert2Fi(*poAnnoStatus));
	}
}

tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trSetupStatusProperty* poSetupStatus) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trSetupStatusProperty)"));
    vNotify(DAB_tclFiConvert::vConvert2Fi(*poSetupStatus));
}

/*tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trMuteStatusProperty* poMuteStatus) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_tMuteStatusProperty)"));
    vNotify(DAB_tclFiConvert::vConvert2Fi(*poMuteStatus));
}
*/
tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trAvailabilityProperty* poAvailability) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_tAvailabilityProperty)"));
    vNotify(DAB_tclFiConvert::vConvert2Fi(*poAvailability));
}

tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trCompListProperty* poCompList) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trCompListProperty)"));
    midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus oFiRes;
    DAB_tclFiConvert::vConvert2Fi(*poCompList, oFiRes);
    vNotify(oFiRes);
}

tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trTmcDataListProperty* poTmcData) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trTmcDataListProperty)"));
    vNotify(DAB_tclFiConvert::vConvert2Fi(*poTmcData));
}

tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trMsgSrvListUpdateProperty* poSrvListUpdate) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trMsgSrvListUpdateProperty)"));
    vNotify(DAB_tclFiConvert::vConvert2Fi(*poSrvListUpdate));
}

tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trMsgSrvListUpdateNotification* poSrvListUpdateNotification) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trMsgSrvListUpdateNotification)"));
    vNotify(DAB_tclFiConvert::vConvert2Fi(*poSrvListUpdateNotification));
}


// upreg-only property
tVoid fc_dabtuner_tclCCAService::vProcess(trMsgSrvRspUpdateChnList *poUpdateChnList) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvRspUpdateChnList)"));
    midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus oFiProp;
    DAB_tclFiConvert::vConvert2Fi(*poUpdateChnList, oFiProp);
    vNotify(oFiProp);
}

tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trTsuSwitchProperty* /*poTsuSwitch*/) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trTsuSwitchProperty)"));
    //vNotify(DAB_tclFiConvert::vConvert2Fi(*poTsuSwitch));
}

tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trMuteRequestProperty* poMuteRequest) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trMuteRequestProperty)"));
    vNotify(DAB_tclFiConvert::vConvert2Fi(*poMuteRequest));
}

tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trLearnUpdateStatusProperty* poLearnUpdate) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trLearnUpdateStatusProperty)"));
    vNotify(DAB_tclFiConvert::vConvert2Fi(*poLearnUpdate));
}
tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trTpegDataListProperty* poTpegData) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trTpegDataListProperty)"));
    vNotify(DAB_tclFiConvert::vConvert2Fi(*poTpegData));
}
tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trPresetListProperty* poPresetList) {
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trPresetListProperty) size =%d",poPresetList->u8NumberOfElements));
	if((poPresetList->u8NumberOfElements ==fc_dabtuner_config::instance()->u8NumberOfPresets())&&
		(dabdrv_presets::instance()->_u8PresetDeleteCounter==0))
	{
    vNotify(DAB_tclFiConvert::vConvert2Fi(*poPresetList));
	}
}
tVoid fc_dabtuner_tclCCAService::vSetupLinkingMask( trMsgSrvCmdSetup *poCmdSetup,
		tU8 u8DABFMLinkingThreshold,
		tU8 u8DABFMLinkingBackThreshold,
		tU8 u8DABFMLinkingBackValidationTime,
		tU8 u8DABFMLinkBackDelay) const{
	 ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vSetupLinkingMask"));
	 if(poCmdSetup->u8LinkingSetupMask != 0)
    {
    	if(poCmdSetup->u8LinkingSetupMask == enLinkingSetupMask_DAB_FM_LINKING_Threshold)
    		poCmdSetup->u8DABFMLinkingThreshold=u8DABFMLinkingThreshold;
    	if(poCmdSetup->u8LinkingSetupMask == enLinkingSetupMask_DAB_FM_LINKING_BACK_Threshold)
    		poCmdSetup->u8DABFMLinkingBackThreshold=u8DABFMLinkingBackThreshold;
    	if(poCmdSetup->u8LinkingSetupMask == enLinkingSetupMask_DAB_FM_LINKING_BACK_Validation_Time)
    		poCmdSetup->u8DABFMLinkingBackValidationTime=u8DABFMLinkingBackValidationTime;
    	if(poCmdSetup->u8LinkingSetupMask == enLinkingSetupMask_DAB_FM_Link_Back_Delay)
    		poCmdSetup->u8DABFMLinkBackDelay=u8DABFMLinkBackDelay;
    }
}
tVoid fc_dabtuner_tclCCAService::vProcess(trMsgSrvRspExpIdValueU32 *poSrvRspExpId) {
	midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult oFiMRes;
	DAB_tclFiConvert::vConvert2Fi(*poSrvRspExpId, oFiMRes);
	vNotifyOnce(oFiMRes);
}
tVoid fc_dabtuner_tclCCAService::vProcess(trMsgSrvRspScan *poSrvRspScan) {
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult oFiMRes;
    oFiMRes.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(poSrvRspScan->enRes);
    ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvRspScan): enRes=%u",
                    ETG_CENUM(DAB_tenResult, poSrvRspScan->enRes)));
    vNotifyOnce(oFiMRes);
}
tVoid fc_dabtuner_tclCCAService::vProcess(DAB::trMsgSrvRspGetTIIList *poSrvRspGetTIIList){
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvRspGetTIIList) size =%d",(tU16)poSrvRspGetTIIList->vecTiiList.size()));
    midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult oFiMRes;  
    DAB_tclFiConvert::vConvert2Fi(*poSrvRspGetTIIList, oFiMRes);
    vNotifyOnce(oFiMRes);
}
tVoid fc_dabtuner_tclCCAService::vProcess(DAB::trMsgSrvRspSrcState *poSrvRspSrcState) {
	ETG_TRACE_USR4(("CCR.ENDING.SOURCE_ACTIVE:fc_dabtuner_tclCCAService::vProcess(trMsgSrvRspSrcState)"));
	midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult oFiResult;
	DAB_tclFiConvert::vConvert2Fi(*poSrvRspSrcState, oFiResult);
	vNotifyOnce(oFiResult);
}
tVoid fc_dabtuner_tclCCAService::vProcess(DAB::trMsgSrvCmdRspTuneFreqlabel *poSrvRspTuneFreqLabel) {
	midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult oFiResult;
	oFiResult.e8MethodResult.enType=(midw_ext_fi_tcl_e8_DAB_Response::tenType)poSrvRspTuneFreqLabel->enRes;
	vNotifyOnce(oFiResult);
}
tVoid fc_dabtuner_tclCCAService::vProcess(DAB::trMsgSrvCmdRspSavePresetList *poSrvRspSavePresetList) {
	midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult oFiResult;
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(trMsgSrvCmdRspSavePresetList): enRes=%u",
                    ETG_CENUM(DAB_tenResult, poSrvRspSavePresetList->enRes)));
	oFiResult.e8MethodResult.enType=(midw_ext_fi_tcl_e8_DAB_Response::tenType)poSrvRspSavePresetList->enRes;
	vNotifyOnce(oFiResult);
}
tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trADRMsgProperty* poADRMsg){
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trADRMsgProperty) size =%d", (tU16)poADRMsg->vectorADRMsg.size()));
     vNotify(DAB_tclFiConvert::vConvert2Fi(*poADRMsg));
}
tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trLocalOffsetProperty* poLocalInfo){
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB_trLocalOffsetProperty) Offset =%u", (tU64)poLocalInfo->s64Offset));
     vNotify(DAB_tclFiConvert::vConvert2Fi(*poLocalInfo));	
	}
	
tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trMTCSetModeProperty* poMTCMode){
	ETG_TRACE_USR4((" fc_dabtuner_tclCCAService::vProcess(DAB_trMTCSetModeProperty): MTCMode = %d )",
                     ETG_CENUM(DAB_tenMtcMode, poMTCMode->enMtcMode)));
     vNotify(DAB_tclFiConvert::vConvert2Fi(*poMTCMode));
}


//tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trMTCSwitchStatusProperty* poSwitchMode){
//	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vProcess(DAB_trMTCSwitchStatusProperty): SwitchMode = %d )",
//                     ETG_CENUM(DAB_tenMtcRequestSwitch, poSwitchMode->enMtcRequestSwitch)));
//    // vNotify(DAB_tclFiConvert::vConvert2Fi(*poSwitchMode));
//}

tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trMTCTunerStatusProperty* poSwitchMode){
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vProcess(DAB_trMTCTunerStatusProperty): SwitchMode = %d )",
                     ETG_CENUM(DAB_tenMtcRequestSwitch, poSwitchMode->e8MtcTunerSwitchStatus)));
     vNotify(DAB_tclFiConvert::vConvert2Fi(*poSwitchMode));
}

//tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trMTCAnnouncementProperty* poAnnoState){
//	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vProcess(DAB_trMTCAnnouncementProperty): poAnnoState = %d )",
//                     ETG_CENUM(DAB_tenMtcRequestSwitch, poAnnoState->enMtcActivityState)));
//     //vNotify(DAB_tclFiConvert::vConvert2Fi(*poAnnoState));
//}

tVoid fc_dabtuner_tclCCAService::vProcess(DAB_trMTCSurveillanceMonitorProperty* poSurvMonitor){
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vProcess(DAB_trMTCSurveillanceMonitorProperty): e8MtcMtcStationType =%d "
			"  e8MtcStationFreq=%d  e8MtcStationId=%d  e8MtcEnsID=%d"
            "  e8MtcTPState=%d  sMtcStationNameFM=%s",
             ETG_CENUM(DAB_tenMtcStationType, poSurvMonitor->enMtcStationType), poSurvMonitor->u32MtcStationFreq,
			 poSurvMonitor->u32MtcStationId, poSurvMonitor->u32MtcEnsID, 
			 ETG_CENUM(DAB_tenMtcTPState, poSurvMonitor->enMtcTPState), poSurvMonitor->sMtcStationNameFM));
	ETG_TRACE_USR4(("sStationNameDAB=%s",  poSurvMonitor->sStationNameDAB));  

     vNotify(DAB_tclFiConvert::vConvert2Fi(*poSurvMonitor));
}

tVoid fc_dabtuner_tclCCAService::vProcess(DAB::trMsgSrvRspCmdLearn *poRspCmdLearn){

	midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult oFiResult;
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
	trMeca_CRdmQualityConfig rQualityConfig1;
	rQualityConfig1.enMecaQualityConfigCmd = tenMeca_RdmQualityConfigCmd_SET;
	rQualityConfig1.u8QualityStrategy = *poConfig->pcu8GetRdmQualityStrategy();
	rQualityConfig1.u8DataFieldLen = *poConfig->pcu8GetRdmQualityConfigDataLength();
	OSAL_pvMemoryCopy(rQualityConfig1.au8DataField, (poConfig->pcu8GetRdmQualityConfig()), sizeof(rQualityConfig1.au8DataField));
	ETG_TRACE_USR4(("dabdrv_rdm::vSetRdmQualityConfig(trMeca_CRdmQualityConfig) : %*p" ,ETG_LIST_LEN(rQualityConfig1.u8DataFieldLen),ETG_LIST_PTR_T8(rQualityConfig1.au8DataField)));
	dabdrv_mecaIf::instance()->vSendMecaCommand(rQualityConfig1);
#endif

	oFiResult.e8MethodResult=DAB_tclFiConvert::vConvert2Fi(poRspCmdLearn->enRes);
	 ETG_TRACE_USR4(("fc_dabtuner_tclCCAService:vProcess(DAB::trMsgSrvRspCmdLearn): enRes=%u",
                    ETG_CENUM(DAB_tenResult, poRspCmdLearn->enRes)));

   
    vNotifyOnce(oFiResult);
}

tVoid fc_dabtuner_tclCCAService::vHandlePresetRequest(tU8 uPresetNr){
#ifdef MUTE_ACTIVE
	trMsgSrvCmdLoadPreset rMsg(uPresetNr);
    DAB_vCallMsg(rMsg);
#else
    trMsgSrvCmdRecallPreset rMsg(uPresetNr);
    DAB_vCallMsg(rMsg);
#endif
}

tVoid fc_dabtuner_tclCCAService::vLabelFromFI(trMecaLabel &oMecalabel,  midw_ext_fi_tcl_DAB_Label oFILabel){
	ETG_TRACE_USR4(("fc_dabtuner_tclCCAService::vLabelFromFI"));
	tString sLabel = oFILabel.sLabel.szGet(midw_ext_fi_tclString::FI_EN_UTF8);
	memcpy(oMecalabel._dabOrigString,sLabel,DAB_LABEL_MAX_NUM_CHAR);
	oMecalabel._u16LabelMask = oFILabel.u16LabelMask;
	oMecalabel.bLabelValid = true;
}
