/************************************************************************
* FILE:         fc_dabtuner_mainProxy.h
* PROJECT:      g3g
* SW-COMPONENT: FC_DABTUNER
*----------------------------------------------------------------------
*
* DESCRIPTION:  Implementation of fc_dabtuner_mainProxy
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                      | Modification

*
*************************************************************************/

#ifndef _DAB_MAIN_PROXY_H_
#define _DAB_MAIN_PROXY_H_

#include "fc_dabtuner_config.h"
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps

#define AHL_S_IMPORT_INTERFACE_NOTIFICTABLE
#include "ahl_if.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

namespace DAB {
    class DAB_mainProxy {
    public:
        static tU16 u16RegisterService(tU16 u16ServiceId,
                                           tU16 u16MajorVersion,
                                       tU16 u16MinorVersion,
                                       tU16 u16ServerAppId = AMT_C_U16_APPID_INVALID);
        static tVoid vUnregisterService(tU16 u16ServiceId,tU16 u16ServerAppId = AMT_C_U16_APPID_INVALID);

        static ail_tenCommunicationError enPostMsg(amt_tclServiceData* poMessage);

        static tVoid vServiceAvailabilityChanged(tU16 u16ServiceId, tU8 u8ServiceState);
        static tU16 u16GetRegId(tU16 u16ServiceId);
        static tBool bRegisterAsync(tU16 u16ServiceId, tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion,
        		tU16 u16ServerAppId = AMT_C_U16_APPID_INVALID);

    };

}

#endif
