/*******************************************************************************
* FILE:          fc_dabtuner_fiConvert.h
* PROJECT:        g3g
* SW-COMPONENT:   DABTUNER
*-------------------------------------------------------------------------------
*
* DESCRIPTION:    Implementation of fc_dabtuner_fiConvert
* 
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date      | Author              | Modification

*
*******************************************************************************/

#ifndef FC_DABTUNER_FI_CONVERT_H
#define FC_DABTUNER_FI_CONVERT_H


#define FC_DABTUNER_S_IMPORT_INTERFACE_MSG
#include "fc_dabtuner_if.h"

#include "dabdrv_main.hpp"

namespace DAB {

class DAB_tclFiConvert {
 public:
    static midw_ext_fi_tcl_e8_DAB_Response vConvert2Fi(DAB::DAB_tenResult enDabRes);
    static midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus vConvert2Fi(DAB_trTunerStatusProperty const &rTunerStatus);
    static midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus vConvert2Fi(DAB_trTestModeDataProperty const &rTestModeData);
    static midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus vConvert2Fi(DAB_trBgTestModeDataProperty const &rBgTestModeData);
    static midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus vConvert2Fi(DAB_trComponentInfoProperty const &rChnInfo);
    static midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus vConvert2Fi(DAB_trServiceInfoProperty const &rChnInfo);
    static midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus vConvert2Fi(DAB_trEnsembleInfoProperty const &rChnInfo);
    static midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus vConvert2Fi(DAB_trChnInfoProperty const &rChnInfo);
    //static midw_ext_dabtunerfi_tclMsgFID_DAB_G_EXT_SERVICE_FOLLOWING_STATUSStatus vConvert2Fi(DAB_trTsuSwitchProperty const &rTsuSwitch);
    static midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus vConvert2Fi(DAB_trAnnoStatusProperty const &rAnnoStatus);
    static midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus vConvert2Fi(DAB_trSetupStatusProperty const &rSetupStatus);
    //static midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus vConvert2Fi(DAB_trMuteRequestProperty const &rMuteStatus);
    static midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus vConvert2Fi(DAB_trAvailabilityProperty const &Availability);
    static midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus vConvert2Fi(DAB_trTmcDataListProperty const &rTmcData);
    static midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus vConvert2Fi(DAB_trTmcAvailListProperty const &rTmcAvailList);
    static midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus vConvert2Fi(DAB_trTmcTpegInfoProperty const &rTmcTpegInfo);
    static midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus vConvert2Fi(DAB_trMuteRequestProperty const &rMuteRequest);
    static midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus vConvert2Fi(DAB_trMtcServiceFollowingProperty const &rServiceFollowing);
    static midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus vConvert2Fi(DAB_trTpegDataListProperty const &rTpegData);
	static midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus vConvert2Fi(DAB_trPresetListProperty const &rPresetList);
	static midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus vConvert2Fi(DAB_trLearnUpdateStatusProperty const &rLearnUpdate);
	static midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus vConvert2Fi(DAB_trADRMsgProperty const &rADRMsg);
	static midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus vConvert2Fi(DAB_trLocalOffsetProperty const &rLocalOffset);
    
	static midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus vConvert2Fi(DAB_trMTCTunerStatusProperty const &rTunerStatus);

	//static midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_ANNOUNCEMENTStatus vConvert2Fi(DAB_trMTCAnnouncementProperty const &rAnnoStatus);
	
	static midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus vConvert2Fi(DAB_trMTCSurveillanceMonitorProperty const &rSurveillanceMonitor);
    static midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus vConvert2Fi(DAB_trMsgSrvListUpdateProperty const &oMsg);
    static midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus vConvert2Fi(DAB_trMsgSrvListUpdateNotification const &oMsg);

    static tVoid vConvert2Fi(trMsgDrvRspDbQueryTestmode const &rDbQueryTestmode, midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult &oFiMsg);
    static tVoid vConvert2Fi(trMsgSrvRspGetTpegUriList const &rTpegUriList, midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus &oFiRes);

    static tVoid vConvert2Fi(DAB_trCompListProperty const &oCompList,  midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus &oFiRes);

    static tVoid vConvert2Fi(DAB::trMsgSrvRspSetChnList const &oChnList, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult &oFiRes);
	 static tVoid vConvert2Fi(DAB::trMsgSrvRspSetEnsmbleList const &oEnsList, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult &oFiRes);
    static tVoid vConvert2Fi(DAB::trMsgSrvRspUpdateChnList const &oMsg, midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus &oFiRes);
    static tVoid vConvert2Fi(DAB::trMsgSrvRspGetPresetList const &oPresetList, midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult &oFiRes);
    static tVoid vConvert2Fi(DAB::trMsgSrvRspRdbidWishlist const &oRdbidWishlist, midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult &oFiMsg);
    static tVoid vConvert2Fi(DAB::trMsgDrvRspGetExpApi const &oGetExpApi, midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult &oFiMsg);
	static tVoid vConvert2Fi(DAB::trMsgSrvRspGetTIIList const &oTIIList, midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult &oFiRes);
	static tVoid vConvert2Fi(DAB::trMsgSrvRspExpIdValueU32 const &oMsg, midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult &oFiRes);
	static tVoid vConvert2Fi(DAB::trMsgSrvRspSrcState const &oMsg, midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult &oFiRes);
	static tVoid vConvert2Fi(DAB::trMsgSrvRspValidateEPGData const &oMsg, midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult &oFiRes);

	static midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus vConvert2Fi(DAB_trMTCSetModeProperty const &rMTCMode);
	//static midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_REQUEST_SWITCH_STATUSStatus vConvert2Fi(DAB_trMTCSwitchStatusProperty const &rSwitchMode);
    static DAB::tenDefsetType getFromFi(midw_ext_fi_tcl_e8_DefSetMode const &oDefsetMode);

    static tVoid vConvert2Fi(tU8 const *pu8InUtf8Buf, midw_ext_fi_tclString &sUTF8FiOutString);
   
    static tVoid vConvertFromFi(midw_ext_fi_tcl_DAB_RdbId const &rFiRdbId, DAB_trTmcRdbId *prRdbId);
    static tVoid vConvertFromFi(midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart const *prFiMsg, trMsgSrvCmdSelectTmc *prMsg);
    static tVoid vConvertFromFi(midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart const *prFiMsg, trMsgSrvCmdRdbidWishlist *prMsg);
    static tVoid vConvertFromFi(midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart const *prFiMsg, trMsgSrvCmdSelectTpegUri *prMsg);

 private:
    static tBool bConvertRTextTotString(tenMeca_CharSet enMeca_CharSet,const tChar* apRText, midw_ext_fi_tclString* sUTF8String, tU8 u8Len);
    static tVoid vLabel2Fi(DAB::trMecaLabel const &rLabel, midw_ext_fi_tcl_DAB_Label &oFiLabel);
    static tVoid vRadioText2Fi(DAB::trRadioText const &rRadioText, midw_ext_fi_tcl_DAB_RadioText &oFiRadioText);
    static tVoid vRdbId2Fi(DAB::DAB_trTmcRdbId const &rTmcRdbId, midw_ext_fi_tcl_DAB_RdbId &oFiRdbId);
    static tVoid vFi2RdbId(midw_ext_fi_tcl_DAB_RdbId const &oFiTmcRdbId, DAB_trTmcRdbId &rTmcRdbId);
    static tVoid vTmcData2Fi(DAB_trTmcDataListElement const &rTmcDataListElement, midw_ext_fi_tcl_DAB_TmcInfo &oFiTmcInfo);
    static tVoid vTpegData2Fi(DAB_trTpegDataListElement const &rTpegDataListElement, midw_ext_fi_tcl_DAB_TpegInfo &oFiTpegInfo);
};
}

#endif
