/************************************************************************
* FILE:         fc_dabtuner_config.h
* PROJECT:      g3g
* SW-COMPONENT: DAB Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION:  Implementation of fc_dabtuner_config
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author             | Modification

*
*************************************************************************/

#ifndef FC_DABTUNER_CONFIG_H
#define FC_DABTUNER_CONFIG_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

//lint -e1551 "Function may throw exception '...' in destructor"
//lint -e1712 "default constructor not defined for class"
//lint -e1704 "Constructor ... has private access specification"
//lint -e1705 "static class members may be accessed by the scoping operator"
//lint -e762 "Redundantly declared symbol"
//lint -esym(1702,operator==)  "operator 'operator==' is both an ordinary function and a member function
//lint -esym(1702,operator<)  "operator 'operator<' is both an ordinary function and a member function
//lint -esym(1702,operator!=)  "operator 'operator!=' is both an ordinary function and a member function


#if (OSAL_CONF == OSAL_WINNT)
#define DAB_TIME_FACTOR 10
#else 
#define DAB_TIME_FACTOR 1
#endif

#ifdef LSIM
#  define DAB_USE_OSAL_THREAD_INFO
#endif

#ifdef VARIANT_S_FTR_ENABLE_DAB_GEN2
#  define DAB_ADR_USE_LLD 1
//#  define VARIANT_S_FTR_ENABLE_TPEG 1    // dont enable for LCN2kai
/* DAB Data lun*/
#  define DAB_ADR_LUN 0x12
#  define DAB_ADR_SSI_MAX_RX_LEN 20000
#  define DAB_ADR_SSI_MAX_TX_LEN 20000
#  define DAB_ADR_SUPERVISION_TIMER_MS 20000
/* DAB Tsu lun*/
#  define DAB_TSU_LUN 0x18
#  define DAB_TSU_SSI_MAX_RX_LEN 256
#  define DAB_TSU_SSI_MAX_TX_LEN 256
#else
#  define DAB_ADR_SUPERVISION_TIMER_MS (10000*DAB_TIME_FACTOR) //5000
#endif

//#define ETG_I_TEST
#define DAB_ADR_GPIO_RESET_NAME DTT_XM_CPU_RST
#define DAB_ADR_GPIO_ENABLE_NAME DTT_XM_ENABLE
#define DAB_ADR_PING_TIMER_MS (2000*DAB_TIME_FACTOR) //0
#define DAB_TEST_MODE_UPDATE_TIMER_MS (500*DAB_TIME_FACTOR)//500
#define DAB_TEST_MODE_GET_TIMER_MS (2500*DAB_TIME_FACTOR)//500
#define DAB_CHN_LIST_UPDATE_TIMER_MS (10000*DAB_TIME_FACTOR)
#define DAB_COMP_LIST_UPDATE_TIMER_MS (10000*DAB_TIME_FACTOR)
#define DAB_STOP_LEARN_TIMER_MS (150000*DAB_TIME_FACTOR)
#define DAB_START_LEARN_TIMER_MS (200*DAB_TIME_FACTOR)//(120000*DAB_TIME_FACTOR)
#define DAB_STOP_TMC_LEARN_TIMER_MS (120000*DAB_TIME_FACTOR)// todo: change to ca. 30000
#define DAB_STOP_TMC_LEARN_SUPERVISION_TIMER_MS (2000*DAB_TIME_FACTOR)
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
	#define DAB_RADIO_TEXT_WAIT_TIMER_MS (120000*DAB_TIME_FACTOR)
	#define DAB_MUTE_SUPERVISION_TIMER_MS (300)
#else
	#define DAB_RADIO_TEXT_WAIT_TIMER_MS (14000*DAB_TIME_FACTOR)
	#define DAB_MUTE_SUPERVISION_TIMER_MS (1000)
#endif
#define DAB_PLAY_ASID_SUPERVISION_TIMER_MS (2000)
#define DAB_COMP_LIST_COLLECT_TIMER_MS (2000*DAB_TIME_FACTOR)
#define DAB_DATA_LIST_UPDATE_TIMER_MS (5000*DAB_TIME_FACTOR)
#define DAB_SRC_STATE_BG_DELAY_TIMER_MS (10*DAB_TIME_FACTOR)// changed from 1 min 
#define DAB_TPEG_URI_ACTIVATED_TIMER_MS (20000*DAB_TIME_FACTOR)
#define DAB_TPEG_SUPERVISION_TIMER_MS (300000*DAB_TIME_FACTOR)
#define DAB_CHNINFO_UPDATE_SUPERVISION_TIMER_MS (2000*DAB_TIME_FACTOR)


#define DAB_MAX_NUM_SRV 0xFF
#define DAB_MAX_NUM_ENS 20


//#define DAB_NUM_PRESET_BANKS 2
//#define DAB_PRESET_SEVEN 7
//#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
//#define DAB_NUM_PRESETS_PER_BANK 24
//#define DAB_NUM_PRESETS 24
//#else
//#define DAB_NUM_PRESETS_PER_BANK 6
//#define DAB_NUM_PRESETS ((DAB_NUM_PRESETS_PER_BANK)*(DAB_NUM_PRESET_BANKS))
//#endif
//#define DAB_REPLACE_INVALID_LABEL_BY_SID

#define DAB_SRV_LIST_ELEM_RECEPTION_ALWAYS_OK

#define DAB_DEFAULT_CCA_PRIO 133
#define DAB_DEFAULT_DISPATCHER_PRIO 134
#define DAB_DEFAULT_DISPATCHER_STACK_SIZE 10000
#define DAB_IPN_PRIO 101
#define DAB_IPN_STACK_SIZE 10000

#define DAB_CHN_SELECT_WAIT_TIMER_MS (4000*DAB_TIME_FACTOR)
// after this time we reselect a channel when rdm-info shows wrong channel
#define DAB_CHN_SELECT_RDM_SV_WAIT_TIMER_MS (6000*DAB_TIME_FACTOR)
#define DAB_RDM_WAIT_SRV_FOLLOW_TIMER_MS (4000*DAB_TIME_FACTOR)
#define DAB_CHN_SELECT_FAILED_TIMER_MS (10000*DAB_TIME_FACTOR)
#define DAB_CHN_SELECT_RETRY_TIMER_MS (4000*DAB_TIME_FACTOR)
//#define DAB_CHN_SELCET_ENABLE_AUTO_SKIP
//todo: remove patch to try immediatelly again if chnSelect Failed:
#define DAB_CHN_SELCET_ENABLE_DIRECT_RETRY

// sometimes we don't get the new rdm-info by auto-notification, so we poll it here
#define DAB_CHN_SELECT_POST_POLL_RDM_INFO

#define DAB_COMP_SELECT_WAIT_TIMER_MS (1000*DAB_TIME_FACTOR)

// config after how many ms of muted dab-module chnInfo shall switch to unavail
#define DAB_CHN_INFO_UNAVAIL_TIMER_MS (30000*DAB_TIME_FACTOR)
#define DAB_CHN_INFO_LOADING_TIMER_MS (2000*DAB_TIME_FACTOR)
// config after how many ms of muted dab-module compInfo shall switch to unavail
#define DAB_COMP_INFO_UNAVAIL_TIMER_MS (30000*DAB_TIME_FACTOR)
#define DAB_COMP_INFO_LOADING_TIMER_MS (2000*DAB_TIME_FACTOR)

#define DAB_ANNO_STOP_SUPERVISION_TIMER_MS (1000*DAB_TIME_FACTOR)
#define DAB_MUTE_BLOCK_ANNO_MUTE_TIMER_MS (3000*DAB_TIME_FACTOR)
// after 5s the TA-flag shall be deleted for a new selected channel if quality is bad
#define DAB_ANNO_FLAG_NEW_TIMER_MS 5000
// after 5s the TA-flag shall be deleted for a channel if quality is bad
#define DAB_ANNO_FLAG_LOST_TIMER_MS 120000

#define DAB_CHN_LIST_AFTER_LEARN_TIMER_MS (2000*DAB_TIME_FACTOR)

//#define DAB_ENABLE_POLL_CHN_LIST
#define DAB_ENABLE_CHN_SELECT_ADJUST_FREQ
#define DAB_ENABLE_CHN_RESELECT_AFTER_LEARN
#define DAB_ENABLE_IGNORE_ASID_CCODE
//#define DAB_ENABLE_COMP_MODE_PERSISTANT
#define DAB_PRESET_STORE_SUPERVISION_TIMER_MS (60000*DAB_TIME_FACTOR)

#define DAB_RDM_NOTIFY_INFO_DURING_LEARN

#define DAB_DRV_ENABLE_PRESET_0
//#define DAB_MECA_NO_SCIDS
//#define DAB_ENABLE_TIMER_DEBUG

#define DAB_ENABLE_DEMUTE_ALLWAYS

//#define DAB_THREAD_WAIT_MS(u32MS) OSAL_s32ThreadWait(u32MS)
#define DAB_THREAD_WAIT_MS(u32MS)

#ifdef WIN32
#define DAB_USE_TEST_CLIENT
#endif
#ifdef DAB_USE_TEST_CLIENT
#define DAB_APP_ID_AUDIO CCA_C_U16_APP_FC_XM_TUNER
#define DAB_APP_ID_TUNER CCA_C_U16_APP_FC_XM_TUNER
#else
#define DAB_APP_ID_AUDIO CCA_C_U16_APP_AUDIO
#define DAB_APP_ID_TUNER CCA_C_U16_APP_TUNER
#endif


const tU16 DABTUN_INVALID_UTF8_CHAR = 0xffff;
const tU16 DABTUN_INVALID_UNICODE_CHARACTER =  0xffff;
const tU8  DABTUN_INVALID_EBUCODE_CHARACTER = 0xff;
const tU16 SPACE = 0x0020;
const tU8  DABTUN_RDS2UNICODE_ARRAY_OFFSET = 0x80;
const tU16 DABTUN_RADIOTEXT_BUFFER = 512+1; //( 4 * 128 = 512, 4bytes per character an NULL Termination)

const tU16 DABTUN_FREQLABEL_BUFFER = 3+1;
const tU16 DABTUN_EXP_ID_DESCRIPTION_BUFFER = 20;

//#define DABDRV_IPN_DEV_NAME OSAL_C_STRING_DEVICE_ADR3_DAB_TUNER
#define DAB_REGISTRY_VERSIONS          "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/VERSIONS"

#ifndef VARIANT_S_FTR_ENABLE_DAB_TEST_CLIENT
#  ifdef VARIANT_S_FTR_ENABLE_DAB_GEN2
// ai_projects/components/adit_gen_2_tools/bosch_includes/trace/mc_trace.h
#    define DAB_TR_COMP TR_COMP_FC_DABTUNER // (256 * 121) (0x7900)
#    define DAB_TRACE_CHN TR_TTFIS_DABTUNER // (TR_tenTraceChan)115 (0x73)
#  else
#define DAB_TR_COMP TR_COMP_FC_DABTUNER
#    define DAB_TRACE_CHN TR_TTFIS_FC_DABTUNER
#  endif
#define DAB_DISPATCHER_THREAD_NAME (tCString) "DAB_D"
#define DAB_DISPATCHER_EVENT_NAME (tCString) "DAB_DispatcherEvent"
#define DAB_DISPATCHER_TERMINATE_SEM_NAME "DAB_DispTermSem"
#define DAB_DISPATCHER_MSG_Q_SEM_NAME "DAB_DispMsgQSem"
#define DAB_DISPATCHER_SUBSCR_Q_SEM_NAME "DAB_DispSubscrQSem"
#define DAB_SELF_SENDER_APP CCA_C_U16_APP_FC_DABTUNER
#define DAB_TTFIS_CMD_SEM_NAME "DAB_TTIFS_CMD_SEM"
#else
#define DAB_TR_COMP TR_COMP_XMTUNER
#  define DAB_TRACE_CHN TR_TTFIS_XMTUNER
#define DAB NS_DAB_TESTCLIENT
#define DAB_DISPATCHER_THREAD_NAME (tString) "DABTC_DI"
#define DAB_DISPATCHER_EVENT_NAME (tString) "DABTC_DispatcherEvent"
#define DAB_DISPATCHER_TERMINATE_SEM_NAME "DABTC_DispTermSem"
#define DAB_DISPATCHER_MSG_Q_SEM_NAME "DABTC_DispMsgQSem"
#define DAB_DISPATCHER_SUBSCR_Q_SEM_NAME "DABTC_DispSubscrQSem"
#define DAB_SELF_SENDER_APP CCA_C_U16_APP_FC_XM_TUNER
#define DAB_TTFIS_CMD_SEM_NAME "DABTC_TTIFS_CMD_SEM"
#endif



typedef enum
{
  enPrestListType_Individual,
  enPrestListType_Mixed_AllBands, 
  enPrestListType_AMFMBand
} tenPresetListType;

/*============================================================================
 * Default values for missing KDS
 *--------------------------------------------------------------------------*/
const tU8  DAB_CONFIG_DEFAULT_FEATURE_CONTROL1       =   0x07; 
const tU8  DAB_CONFIG_DEFAULT_FEATURE_CONTROL2       =   0x02;
const tU8  DAB_CONFIG_SERVICEFOLLOWING_CONFIG        =   0x0F;
const tU8  DAB_CONFIG_DEFAULT_CONCEALMENT_LEVEL      =   0x02;
const tU8  DAB_CONFIG_DEFAULT_TSU_MATRIX_DAB_FM[32]   = { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, \
                                                          0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0d, 0x0e, \
                                                          0x10, 0x12, 0x14, 0x16, 0x18, 0x1a, 0x1c, 0x1e, \
                                                          0x1f,  0x1f,0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f };
const tU8  DAB_CONFIG_DEFAULT_TSU_MATRIX_FM_DAB[32]   = { 0x12, 0x12, 0x12, 0x12, 0x13, 0x13, 0x13, 0x14, \
                                                          0x14, 0x14, 0x15, 0x15, 0x15, 0x15, 0x16, 0x16, \
                                                          0x17, 0x17, 0x17, 0x18, 0x18, 0x19, 0x19, 0x19, \
                                                          0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a };

const tU8  DAB_FM_SWITCHBACKDELAY					  =   0x07;        /* DAB/FM Switch back delay   */   \
const tU8  DAB_FM_SMOOTHINGT_UP 					  =   0x10;        /* DAB Smoothing T_up         */   \
const tU8  DAB_FM_SMOOTHINGT_DOWN					  =   0x17;        /* DAB Smoothing T_down       */   \
const tU8  DAB_FM_COMPARISIONDELAY					  =   0x0a;        /* DAB Comparsion delay       */   \
const tU8  DAB_FM_SMOOTHINGT_LONG					  =   0x01;        /* DAB Smoothing T_long       */   \
const tU8  FM_QUALITYTHRESHOLD					      =   0x0b;        /* FM Threshold quality       */   

const tU8  FM_DAB_SWITCHBACKDELAY					  =   0x2d;        /* FM/DAB Switch back delay   */   \
const tU8  FM_DAB_SMOOTHINGT_UP 					  =   0x14;        /* FM Smoothing T_up         */   \
const tU8  FM_DAB_SMOOTHINGT_DOWN					  =   0x14;        /* FM Smoothing T_down       */   \
const tU8  FM_DAB_PSID_CHANGEDELAY					  =	  0x05;        /* PSID changed delay         */   \
const tU8  FM_DAB_SMOOTHINGT_LONG					  =   0x01;        /* FM Smoothing T_long       */   \
const tU8  DAB_QUALITYTHRESHOLD						  =   0x12;        /* DAB Threshold quality       */   

const tU8  DAB_CONFIG_DEFAULT_TSU_TIME_CONSTANTS_DAB_FM[6]  = { 0x07,        /* DAB/FM Switch back delay   */   \
                                                                0x10,        /* DAB Smoothing T_up         */   \
                                                                0x17,        /* DAB Smoothing T_down       */   \
                                                                0x0a,        /* DAB Comparsion delay       */   \
                                                                0x01,        /* DAB Smoothing T_long       */   \
                                                                0x0b,        /* FM Threshold quality       */   };
const tU8  DAB_CONFIG_DEFAULT_TSU_TIME_CONSTANTS_FM_DAB[6]  = { 0x2d,        /* FM/DAB Switch back delay   */   \
                                                                0x14,        /* FM Smoothing T_up          */   \
                                                                0x14,        /* FM Smoothing T_down        */   \
                                                                0x05,        /* PSID changed delay         */   \
                                                                0x01,        /* FM Smoothing T_long        */   \
                                                                0x12         /* DAB Threshold quality      */   };

const tU8  DAB_CONFIG_DEFAULT_RDM_QUALITY_CONFIG_MODE =   0x01;
const tU8  DAB_CONFIG_DEFAULT_RDM_QUALITY_CONFIG_COUNT=   16;
const tU8  DAB_CONFIG_DEFAULT_QUALITY_DECREASE_SPEED_FACTOR_COUNT=   2;

const tU8   DAB_CONFIG_ENSEMBLE_RECINDICATOR			= 0x02;		
const tU8   DAB_CONFIG_ENSEMBLE_RECINDICATORSYNCDELAY	= 0x03;
const tU8   DAB_CONFIG_ENSEMBLEVERALG_TIMETICKDIVIDER   = 0x3c;
const tU8   DAB_CONFIG_ENSEMBLEVERALG_TIMEPERIOD		= 0x03;
const tU8   DAB_CONFIG_ENSEMBLEVERALG_MINFICBERTIME		= 0x05;
const tU8	DAB_CONFIG_ENSEMBLEVERALG_MINFICBERLEVEL	= 0x04;
const tU8	DAB_CONFIG_ENSEMBLEVERALG_TARGETCNTRVALUE   = 0x05;
const tU8   DAB_CONFIG_ENSEMBLEQUALALG_MINFICBERTIM		= 0x05;
const tU8	DAB_CONFIG_ENSEMBLEQUALALG_MINFICBERLEVEL	= 0x04 ;
const tU8	DAB_CONFIG_BGSNOOPING1						= 0x04;	                 
const tU8   DAB_CONFIG_BGSNOOPING_LEARNFIELDSTRENGTH	= 0x81;
const tU8   DAB_CONFIG_BGSNOOPING_UNLEARNFIELDSTRENGTH	= 0x81;
const tU8	DAB_CONFIG_BGSNOOPING_LEARNCNTRMAXVALUE		= 0x02;
const tU8   DAB_CONFIG_BGSNOOPING_LEARNCNTRVALUE		= 0x01;
const tU8   DAB_CONFIG_BGSNOOPING_UNLEARNCNTRVALUE		= 0xff;
const tU8   DAB_CONFIG_BGSNOOPING_UNLEARNCNTRMINVALUE	= 0xfe;

const tU8  DAB_CONFIG_DEFAULT_RDM_QUALITY_CONFIG[16]  = { 0x02,     /* "Ensemble Receiveable Indicator"     0=disable,1=enable_normal,2=enable_stickyrxindicator    */   \
                                                          0x03,     /* "Ensemble Receiveable Indicator"     no sync delay                                           */   \
                                                          0x3c,     /* "Ensemble Verification Allgorithm"   Timetick (1s) divider                                   */   \
                                                          0x03,     /* "Ensemble Verification Allgorithm"   Timeperiod (3=180s)                                     */   \
                                                          0x05,     /* "Ensemble Verification Allgorithm"   min good FICBER time                                    */   \
                                                          0x04,     /* "Ensemble Verification Allgorithm"   min FICBER level                                        */   \
                                                          0x05,     /* "Ensemble Verification Allgorithm"   Target Counter Value                                    */   \
                                                          0x05,     /* "Ensemble Quality Allgorithm"        min good FICBER time                                    */   \
                                                          0x04,     /* "Ensemble Quality Allgorithm"        min FICBER level                                        */   \
                                                          0x04,     /* "Background Snooping Enable"         0=disable,b0=quickhide,b1=realunlearn,b2=rxindicator    */   \
                                                          0x81,     /* "Background Snooping, -127 learn fieldstrengh"                                               */   \
                                                          0x81,     /* "Background Snooping, -127 unlearn fieldstrengh"                                             */   \
                                                          0x02,     /* "Background Snooping, +2 learn counter max value                                             */   \
                                                          0x01,     /* "Background Snooping, +1 learn counter value                                                 */   \
                                                          0xff,     /* "Background Snooping, -1 unlearn counter value                                               */   \
                                                          0xfe      /* "Background Snooping, -2 unlearn counter min value                                           */   };

const tU8  DAB_CONFIG_DEFAULT_ANNOUNCEMENT_CONFIG		=   0x00;
const tU8  DAB_CONFIG_DEFAULT_SCAN_CONFIG				=   0x10;
const tU8  DAB_CONFIG_DEFAULT_SCAN_MIN_SIGNAL_QUALITY	=   0x06;
const tU8  DAB_CONFIG_DEFAULT_SCAN_MIN_AUDIO_THRESHOLD	=   0x05;
const tU8  DAB_CONFIG_DEFAULT_SCAN_PLAY_DURATION		=   0x05;


const tU8  DAB_CONFIG_DEFAULT_ENSEMBLE_LIST_SORTING		=   0x0;
const tU8  DAB_CONFIG_DEFAULT_SERVICE_LIST_SORTING		=   0x0;
const tU8  DAB_CONFIG_DEFAULT_COMPONENT_LIST_SORTING	=   0x0;
const tU8  DAB_CONFIG_DEFAULT_MAX_STATIONS				=   0xFF;
const tU8  DAB_CONFIG_DEFAULT_STATIONLIST_CONFIG    	=   0x0;

/*tbc with Soeren*/
const tU8  DAB_CONFIG_DEFAULT_T_FMDABSWITCHMUTEDAB		= 1;
const tU8  DAB_CONFIG_DEFAULT_T_FMDABSWITCHMUTEDABPLUS	= 1;
const tU8  DAB_CONFIG_DEFAULT_T_FMDABSWITCHMUTEDMBA		= 1;
const tU8  DAB_CONFIG_DEFAULT_T_BG_LEARNSTART			= 1;
const tU8  DAB_CONFIG_DEFAULT_T_LEARN_START_SF_OFF		= 1;
const tU8  DAB_CONFIG_DEFAULT_T_MAN_MODE_SF_OFF			= 1;
const tU8  DAB_CONFIG_DEFAULT_T_STATION_SELECT_SF_OFF	= 1;
const tU8  DAB_CONFIG_DEFAULT_T_SLS_SIGNAL_LOST			= 1;
const tU8  DAB_CONFIG_DEFAULT_T_CLEAR_RT_DELAY			= 1;
const tU8  DAB_CONFIG_DEFAULT_T_CLEAR_RT_AFTER_SYNC_LOST = 1;

const tU8  DAB_CONFIG_DEFAULT_DAB_BAND                =   0x11;

const tU32 DAB_CONFIG_DEFAULT_LSM_ASID                =   0x7f7f;
const tU32 DAB_CONFIG_DEFAULT_SERVICE_LABEL_INFO      =   0x00fe;
const tU8  DAB_CONFIG_DEFAULT_SERVICE_LABEL[16]       = { 0x4e, 0x6f, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, \
                                                          0x63, 0x65, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 };
const tU32 DAB_CONFIG_DEFAULT_ENSEMBLE_LABEL_INFO     =   0x00ff;
const tU8  DAB_CONFIG_DEFAULT_ENSEMBLE_LABEL[16]      = { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, \
                                                          0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20 };
const tU16 DAB_CONFIG_DEFAULT_ENSEMBLE_ID             =   0x0000;
const tU16 DAB_CONFIG_DEFAULT_COMP_ID             =   0x0000;

const tU16 DAB_CONFIG_DEFAULT_CHANNEL[3]            =   {0x35,0x41,0x20};

/*Currently required for Suzuki based on road test-	Quality decrease speed factor, which determines the DAB-DAB following wait time:

Below is for second byte
Factor                   2,0     1,5     1,0     0,5
Config Value			0x32  0x43  0x64  0xc8
duration/ms appr.		5600  4200  2800  1400
*/
const tU8  DAB_CONFIG_DEFAULT_QUALITY_DECREASE_SPEED_FACTOR[2]  = { 0x32,
																	0x64
																  };		

const tU8 DAB_CONFIG_DEFAULT_CONCEALMENT_LEVEL_SUZUKI = 0xc8;

const tU16 DAB_CONFIG_DEFAULT_EXPERT_ID_VALUES[3]     = { 0x0200,      /* "Expert ID value 1 */  \
                                                          0x0204,      /* "Expert ID value 2 */  \
                                                          0x0207       /* "Expert ID value 3 */  };

//lint -e1551 "Function may throw exception '...' in destructor"
//lint -e1712 "default constructor not defined for class"
//lint -e1704 "Constructor ... has private access specification"
//lint -e1705 "static class members may be accessed by the scoping operator"
//lint -e762 "Redundantly declared symbol"
//lint -esym(1702,operator==)  "operator 'operator==' is both an ordinary function and a member function
//lint -esym(1702,operator<)  "operator 'operator<' is both an ordinary function and a member function
//lint -esym(1702,operator!=)  "operator 'operator!=' is both an ordinary function and a member function

#endif

