/************************************************************************
* FILE:         fc_dabtuner_clientTuner.h
* PROJECT:      g3g
* SW-COMPONENT: DAB Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION:  Implementation of fc_dabtuner_clientTuner
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author             | Modification

*
*************************************************************************/

#ifndef FC_DABTUNER_CLIENT_TUNER_H
#define FC_DABTUNER_CLIENT_TUNER_H

#include "fc_dabtuner_clientBase.h"

class midw_tunerfi_tclMsgFID_TUN_G_MONITOR_STATIONStatus;
class midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus;
class midw_tunerfi_tclMsgFID_TUN_S_MONITOR_STATIONMethodResult;
namespace DAB {
    struct trMsgDrvCmdTsuSelectFmPsid;


class fc_dabtuner_clientTuner : 
    public DAB_Singleton <fc_dabtuner_clientTuner>,
    public DAB_MessageHandlerCommon<fc_dabtuner_clientTuner>,
    public DAB::DAB_ClientBase
{
        friend class DAB_Singleton<fc_dabtuner_clientTuner>;


 public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_CLIENT);

        virtual char const *pcGetName() const {return "fc_dabtuner_clientTuner";};
        virtual tVoid vTraceState() const;
        virtual tVoid vDispatchMessage_(amt_tclServiceData *pMsg);

        tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_tunerfi_tclMsgFID_TUN_G_MONITOR_STATIONStatus *pMsg);
        tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus const *pMsg) const;
        tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_tunerfi_tclMsgFID_TUN_S_MONITOR_STATIONMethodResult const *pMsg) const;

        tVoid vProcess(DAB::trMsgDrvCmdTsuSelectFmPsid *poDrvCmdTsuSelectFmPsid);
        tVoid vProcess(DAB::trMsgDrvCmdRegisterFmRT const *poDrvCmdRegisterFmRT);


 protected:
        virtual tVoid vOnSrvUp();
        virtual tVoid vOnSrvDown();

        virtual DAB::trClientConfig &roGetConfig();
        DAB::trClientConfig oClientConfig;
        static tU16 _cau16FIDs[];
 private:
        fc_dabtuner_clientTuner();
        tU32 _u32MonitoredPi;
        tBool _bMonitorOn;
        tBool _bGetFmRT;
};
}
#endif
