/************************************************************************
* FILE:         fc_dabtuner_clientTuner.cpp
* PROJECT:      g3g
* SW-COMPONENT: DAB Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION:  Implementation of fc_dabtuner_clientTuner
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author             | Modification

*
*************************************************************************/

#include "fc_dabtuner_util.h"
#include "dabdrv_types.hpp"
#include "fc_dabtuner_clientTuner.h"


#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_STDVISITORS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_SERVICEINFO

#include "midw_fi_if.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_CLIENT
#include "trcGenProj/Header/fc_dabtuner_clientTuner.cpp.trc.h"
#endif

using namespace DAB;

//lint -esym(1762, fc_dabtuner_clientTuner::vHandle*)
tU16 fc_dabtuner_clientTuner::_cau16FIDs[] = 
{
   // MIDW_TUNERFI_C_U16_FID_TUN_G_MONITOR_STATION,
    MIDW_TUNERFI_C_U16_FID_TUN_G_RADIO_TEXT
};

//BEGIN_MSG_MAP(fc_dabtuner_clientTuner, ahl_tclBaseWork)
DAB_BEGIN_MSG_MAP(fc_dabtuner_clientTuner)
    //ON_DAB_PSTATUS( MIDW_TUNERFI_C_U16_FID_TUN_G_MONITOR_STATION, midw_tunerfi_tclMsgFID_TUN_G_MONITOR_STATIONStatus)
    ON_DAB_PSTATUS( MIDW_TUNERFI_C_U16_FID_TUN_G_RADIO_TEXT, midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus)
    //ON_DAB_MRESULT( MIDW_TUNERFI_C_U16_FID_TUN_S_MONITOR_STATION, midw_tunerfi_tclMsgFID_TUN_S_MONITOR_STATIONMethodResult)
DAB_END_MSG_MAP()

fc_dabtuner_clientTuner::fc_dabtuner_clientTuner():
    oClientConfig(CCA_C_U16_SRV_TUNERCONTROL,
                  DAB_APP_ID_TUNER,
                  CCA_C_U16_APP_FC_DABTUNER,
                  "DAB_TunerClient",
                  sizeof(_cau16FIDs)/sizeof(_cau16FIDs[0]),
                  _cau16FIDs,
                  MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION,
                  MIDW_TUNERFI_C_U16_SERVICE_MINORVERSION){
    _u32MonitoredPi=0;
    _bMonitorOn=FALSE;
    _bGetFmRT=FALSE;

    vSubscribe<trMsgDrvCmdTsuSelectFmPsid>();
    vSubscribe<trMsgDrvCmdRegisterFmRT>();

};

tVoid fc_dabtuner_clientTuner::vTraceState() const {
    ETG_TRACE_USR1(("  fc_dabtuner_clientTuner STATE: _u32MonitoredPi=0x%08x _bMonitorOn=%d _bGetFmRT=%d",
                    _u32MonitoredPi,
                    _bMonitorOn,
                    _bGetFmRT));
}


tVoid fc_dabtuner_clientTuner::vOnSrvUp() {
    // set Monitor
    ETG_TRACE_USR4(("  fc_dabtuner_clientTuner::vOnSrvUp:  restore: u32Pi=0x%08x bOn=%d",
                    _u32MonitoredPi, _bMonitorOn ));
    trMsgDrvCmdTsuSelectFmPsid rCmd;
    // retore Monitor
    rCmd.rProgrammeService=trMecaProgrammeService(_u32MonitoredPi);
    rCmd.bMonitor=_bMonitorOn;
    vProcess(&rCmd);

    if (_bGetFmRT) {
        // register to RT again
        trMsgDrvCmdRegisterFmRT oRegisterFmRt(TRUE);
        vProcess(&oRegisterFmRt);
    }
}

tVoid fc_dabtuner_clientTuner::vOnSrvDown() {
    // set Monitor
    ETG_TRACE_USR4(("  fc_dabtuner_clientTuner::vOnSrvDown:  u32Pi=0x%08x bOn=%d",
                    _u32MonitoredPi, _bMonitorOn ));
    if (_bMonitorOn) {
        // set quality to 0
        trMsgSrvCmdFmQuality rSelfCmd;
        DAB_vCallMsg(rSelfCmd);
    }
    _bGetFmRT=FALSE;
}

trClientConfig &fc_dabtuner_clientTuner::roGetConfig() {
    return oClientConfig;
}

#if 0
tVoid fc_dabtuner_clientTuner::vHandleFi(trAdressing const &roAdressing, midw_tunerfi_tclMsgFID_TUN_G_MONITOR_STATIONStatus *pMsg) {
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4((" fc_dabtuner_clientTuner::vHandleFi(FID_TUN_G_MONITOR_STATIONStatus):  u32Pi=0x%08x u8Quality=%d bOn=%d",
                    pMsg->u32PI, pMsg->u8Quality, pMsg->bMode));
    if (pMsg->u32PI != _u32MonitoredPi) {
        ETG_TRACE_USR4((" fc_dabtuner_clientTuner::vHandleFi(FID_TUN_G_MONITOR_STATIONStatus):  ignore wrong rcvPi=0x%08x monitoredPi=0x%08x",
                        pMsg->u32PI, _u32MonitoredPi));
        return;
    }
    trMsgSrvCmdFmQuality rFmQuality;
    rFmQuality.u8Quality=pMsg->u8Quality;
    DAB_vCallMsg(rFmQuality);
}
#endif

tVoid fc_dabtuner_clientTuner::vHandleFi(trAdressing const &roAdressing, midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus const *pMsg) const{
    (tVoid)roAdressing;
    midw_fi_tcl_TunerRadioText const &oFiRT =pMsg->TunerRadioText;
    tBool bFg= (oFiRT.u8TunerHeader.enType == midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_FOREGROUND);
    ETG_TRACE_USR4((" fc_dabtuner_clientTuner::vHandleFi(FID_TUN_G_RADIO_TEXTStatus):  bFg=%d GetFmRT=%d u8TextType=%d text=%17s",
                    bFg,_bGetFmRT, oFiRT.u8TextType, oFiRT.sRadioTextData.szValue));
    if (!bFg || !_bGetFmRT) {
        return;
    }
    trMsgSrvRspFmRT rFmRT(oFiRT.sRadioTextData.szValue);
    DAB_vCallMsg(rFmRT);
}

#if 0
tVoid fc_dabtuner_clientTuner::vHandleFi(trAdressing const &roAdressing, midw_tunerfi_tclMsgFID_TUN_S_MONITOR_STATIONMethodResult const *pMsg) const{
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4((" fc_dabtuner_clientTuner::vHandleFi(FID_TUN_S_MONITOR_STATIONMethodResult)"));
    if (pMsg->TunerServer_StatusResponse.u8TunerStatus.enType != midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED) {
        // monitor station was not accepted, report quality as 0
        // todo: clarify if we have to try again later, I would like to avoid this
        trMsgSrvCmdFmQuality rFmQuality;
        rFmQuality.u8Quality=0;
        DAB_vCallMsg(rFmQuality);        
    }
}
#endif

tVoid fc_dabtuner_clientTuner::vProcess(trMsgDrvCmdTsuSelectFmPsid *poDrvCmdTsuSelectFmPsid) {
    (tVoid)poDrvCmdTsuSelectFmPsid;
#if 0
    midw_tunerfi_tclMsgFID_TUN_S_MONITOR_STATIONMethodStart oFiMStart;
    oFiMStart.u8Client.enType=midw_fi_tcl_e8_Tun_Client::FI_EN_DAB;
    oFiMStart.u32PI=poDrvCmdTsuSelectFmPsid->rProgrammeService.u32GetSID();
    oFiMStart.bMode=poDrvCmdTsuSelectFmPsid->bMonitor;
    oFiMStart.u8Seconds=1;
    ETG_TRACE_USR4(("fc_dabtuner_clientTuner::vProcess(trMsgDrvCmdTsuSelectFmPsid): u32Pi=0x%08x bOn=%d u8Seconds=%d",
                    oFiMStart.u32PI, oFiMStart.bMode, oFiMStart.u8Seconds));
    _u32MonitoredPi=oFiMStart.u32PI & 0xffff;
    vSendFiMessage(oFiMStart);
#endif
}

tVoid fc_dabtuner_clientTuner::vProcess(trMsgDrvCmdRegisterFmRT const *poDrvCmdRegisterFmRT) {
    _bGetFmRT = poDrvCmdRegisterFmRT->bRegister;
    if (_bGetFmRT) {
        vRegisterFid(MIDW_TUNERFI_C_U16_FID_TUN_G_RADIO_TEXT);    
    } else {
        vUnregisterFid(MIDW_TUNERFI_C_U16_FID_TUN_G_RADIO_TEXT);    
    }
}
