/************************************************************************
* FILE:         fc_dabtuner_clienthandler_diaglog.cpp
* PROJECT:      g3g
* SW-COMPONENT: DAB Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION: Client Handler for DiagLog
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author             | Modification
* 20.04.06  | CM-DI/ESA2 Fiebing | initial version
* 15.06.07  | CM-DI/PJ-VW36-Liebanas | adapted for fc_dabtuner
*
*************************************************************************/


//lint -esym(818, pMsg)
//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#include "fc_dabtuner_util.h"
#include "dabdrv_types.hpp"
#include "fc_dabtuner_clientDiagLog.h"
#include "dabdrv_properties.hpp"

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_STDVISITORS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_SERVICEINFO
#include "midw_fi_if.h"

/* import declaration of version struct */
#define FI_S_IMPORT_INTERFACE_FI_VERSION
#include "fi_if.h"

// DiagLog header (trouble codes)
#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_CLIENT 
#include "trcGenProj/Header/fc_dabtuner_clientDiagLog.cpp.trc.h"
#endif

    using namespace DAB;

//lint -esym(1762, fc_dabtuner_clientDiagLog::vHandle*)
tU16 fc_dabtuner_clientDiagLog::_cau16FIDs[] = 
    {
        //MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT
    };

/* +++ MESSAGE MAP: enter the function IDs (FID) and the corresponding functions here.
the function will be called when a message with the corresponding FID arrives +++ */
//BEGIN_MSG_MAP(fc_dabtuner_clientDiagLog, ahl_tclBaseWork)
DAB_BEGIN_MSG_MAP(fc_dabtuner_clientDiagLog)
    ON_DAB_PSTATUS( MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT, midw_diaglogfi_tclMsgSendNextTestResultStatus)
    //ON_DAB_MRESULT( MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT,     midw_diaglogfi_tclMsgSaveTestResultMethodResult)
DAB_END_MSG_MAP()

/*************************************************************************
*
* FUNCTION: fc_dabtuner_clientDiagLog(fc_dabtuner_tclApp* poMain)
* 
* DESCRIPTION: constructor, creates object fc_dabtuner_clientDiagLog - object
*
* PARAMETER: void
*
* RETURNVALUE: none
*
*************************************************************************/
fc_dabtuner_clientDiagLog::fc_dabtuner_clientDiagLog() :
    oClientConfig(CCA_C_U16_SRV_DIAGLOG,
                  CCA_C_U16_APP_DIAGLOG,
                  CCA_C_U16_APP_FC_DABTUNER,
                  "DAB_DiagLogClient",
                  sizeof(_cau16FIDs)/sizeof(_cau16FIDs[0]),
                  _cau16FIDs,
                  MIDW_DIAGLOGFI_C_U16_SERVICE_MAJORVERSION,
				  MIDW_DIAGLOGFI_C_U16_SERVICE_MINORVERSION)
{
	ETG_TRACE_USR4(("fc_dabtuner_clientDiagLog:: Register for DIAGLOG Service"));
	vSubscribe<DAB_trErrLogProperty>();

	/* --- this constructor calls ( impicit ) the constructor of the upper class ( framework )
	so it registers the combinations of FID and message handler with the framework --- */

}

trClientConfig &fc_dabtuner_clientDiagLog::roGetConfig() {
    return oClientConfig;
}


tVoid fc_dabtuner_clientDiagLog::vHandleFi(trAdressing const &roAdressing, midw_diaglogfi_tclMsgSendNextTestResultStatus *pMsg) {
    (tVoid)roAdressing;
    if(pMsg->Status)
    {
        DAB_tenTestResult enAdrState=dabdrv_properties::instance()->oErrLogProperty.oGet().enAdrDiag;
        ETG_TRACE_USR4(("fc_dabtuner_clientDiagLog::vHandleFi: SendNextTestResultStatus: adrState=%d",
                        ETG_CENUM(DAB_tenTestResult, enAdrState)));
    }

}
tVoid fc_dabtuner_clientDiagLog::vSendMethodStartSaveTestResult(DAB_tenTestResult enAdrDiagState)
{  

    if(AMT_C_U16_REGID_INVALID != oClientConfig._u16RegID) {
        return;
    }
    midw_diaglogfi_tclMsgSaveTestResultMethodStart oTestData;
    midw_fi_tcl_TestResult oTestResultModuleUp;
    
    // set default values
    oTestResultModuleUp.TroubleCode  = ITC_DAB_TUNER_SYSTEM_FAILURE;
    oTestResultModuleUp.Result.enType =  (midw_fi_tcl_e8_TestResult::tenType)enAdrDiagState;

    ETG_TRACE_USR1(("fc_dabtuner_clientDiagLog::vSendMethodStartSaveTestResult: Send ITC=: 0x%04x result=%d",
                    oTestResultModuleUp.TroubleCode, 
                    ETG_CENUM(DAB_tenTestResult, enAdrDiagState)));    
    //fill this oTestResult with ITC from data
    oTestData.TestResultList.TestResultList.push_back(oTestResultModuleUp);
    
    vSendFiMessage(oTestData);
}


tVoid fc_dabtuner_clientDiagLog::vHandleFi(trAdressing const &roAdressing, midw_diaglogfi_tclMsgSaveTestResultMethodResult *pMsg) const {
    (tVoid)roAdressing;
    // Trace to output the outcome of save request
    ETG_TRACE_USR4(("fc_dabtuner_clientDiagLog::vHandleSaveTestResult: METHODRESULT Status value: %u",
                            (tU8)pMsg->Status.enType));
}


 tVoid fc_dabtuner_clientDiagLog::vProcess(DAB_trErrLogProperty const *poPropertyErrLog) {
     DAB_tenTestResult enAdrResult=poPropertyErrLog->enAdrDiag;
         ETG_TRACE_USR4(("fc_dabtuner_clientDiagLog::DAB_trErrLogProperty: Status value: %u",
                         ETG_CENUM(DAB_tenTestResult, enAdrResult)));

     vSendMethodStartSaveTestResult(enAdrResult);
 }
