/************************************************************************
* FILE:         fc_dabtuner_ServiceBase.h
* PROJECT:      g3g
* SW-COMPONENT: FC_DABTUNER
*----------------------------------------------------------------------
*
* DESCRIPTION: Declare the handlers for generic handlers to send method result,
 *         service handlers, update clients, send status message to clients.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                      | Modification
* 06.11.2009  Ruchi Mishra(RBEI/ECG3) 	   Original version
*************************************************************************/




#ifndef DAB_CLIENT_BASE_H_
#define DAB_CLIENT_BASE_H_

#include "fc_dabtuner_util.h"
#include "fc_dabtuner_cca.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"  // empty message U8-message etc.

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"



#define ON_DAB_PSTATUS(fid, fiPStatus) \
    case fid:\
    DAB_ClientStatusFn<className, fiPStatus>(pMsg); \
    break;

#define ON_DAB_MRESULT(fid, fiMResult) \
    case fid:                                               \
    DAB_ClientMResFn<className, fiMResult>(pMsg);   \
    break;                                                  \


/*
for methods the will send a result later, the requestDetails have to be stored.
You may 

*/
namespace DAB {
    typedef enum {
        enClientError_UnsupportedOpCode
    }tenClientErrorCode;




    struct trClientConfig {
        trClientConfig(tU16 u16ServiceId, 
                       tU16 u16SrvAppId, 
                       tU16 u16MyAppId, 
                       char const *pcName,
                       tU8 u8NumUpRegs,
                       tU16 *pu16UpregFids,
                       tU16 u16MajorVersion, 
                       tU16 u16MinorVersion=0):
            _u16ServiceId(u16ServiceId),
            _u16SrvAppId(u16SrvAppId),
            _u16MyAppId(u16MyAppId),
            _pcName(pcName),
            _u8NumUpRegs(u8NumUpRegs),
            _pu16UpregFids(pu16UpregFids),
            _u16MajorVersion(u16MajorVersion),
            _u16MinorVersion(u16MinorVersion),
            _u16FIDUpregsOpen(0),
            _u16RegID(AMT_C_U16_REGID_INVALID){};

        tU16 _u16ServiceId;
        tU16 _u16SrvAppId;
        tU16 _u16MyAppId;
        char const *_pcName;
        tU8 _u8NumUpRegs;
        tU16 *_pu16UpregFids;
        tU16 _u16MajorVersion;
        tU16 _u16MinorVersion;
        tU16 _u16FIDUpregsOpen;
        tU16 _u16RegID;
        void vSetRegID(tU16 u16RegID)
        {
        	_u16RegID = u16RegID;
        };
        

    };


    class DAB_ClientBase: public ahl_tclBaseWork {
public:
   DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_CLIENT_BASE);

   DAB_ClientBase();
   virtual ~DAB_ClientBase();
   tU16 u16RegisterService(tVoid);
   tVoid vUnregisterService(tVoid);

   tVoid vOnNewAppState(tU32 u32AppState);
   tVoid vOnServiceState(tU16 u16ServiceId,
                         tU16 /*u16ServerId*/,
                         tU16 u16RegisterId,
                         tU8  u8ServiceState,
                         tU16 /*u16SubId*/);

   tU16 u16GetServiceId();
   tU16 u16GetRegId();

   virtual tVoid vDispatchMessage_(amt_tclServiceData *pMsg) = 0;

private:
   virtual tVoid vTraceError(trAdressing const *prAdressing, tenClientErrorCode enClientErrorCode);
protected:
   virtual trClientConfig &roGetConfig()=0;
   virtual tVoid vOnUnknownMessage(amt_tclBaseMessage* poMessage);
   virtual tVoid vHandleError(trAdressing const &roAdressing, tU8 u8ErrorCode){(tVoid)roAdressing; (tVoid)u8ErrorCode;};
   virtual tVoid vOnSrvUp(){};
   virtual tVoid vOnSrvDown(){};

   tVoid vRegisterFid(tU16 u16Fid);
   tVoid vUnregisterFid(tU16 u16Fid);


   tVoid vSendFiMessage(fi_tclMessageBase const & roSendFiObj, tU16 u16CmdCount=0);
   //   virtual tVoid vUpregConfirmed(tU16 u16Fid) {};
   //   virtual tVoid vUpregReady() {};


    template<typename S, typename MSTATUS>
        tVoid DAB_ClientStatusFn(amt_tclServiceData* poMessage) {
        trAdressing rAdressing(poMessage);
        switch(poMessage->u8GetOpCode()) {
            case AMT_C_U8_CCAMSG_OPCODE_STATUS: {
                MSTATUS oRxFIObj;
                fi_tclVisitorMessage oMsg( poMessage );
                oMsg.s32GetData( oRxFIObj );
                S::instance()->vHandleFi(rAdressing,&oRxFIObj);
                break;
            }
        default:
            vTraceError(&rAdressing,enClientError_UnsupportedOpCode);
            break;
        }
    }



    template<class S, class MRES>
        tVoid DAB_ClientMResFn(amt_tclServiceData* poMessage) {
        trAdressing rAdressing(poMessage);
        switch(poMessage->u8GetOpCode()) {
            case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT: {
                MRES oRxFIObj;
                fi_tclVisitorMessage oMsg( poMessage );
                oMsg.s32GetData( oRxFIObj );
                S::instance()->vHandleFi(rAdressing,&oRxFIObj);
                break;
            }
        default:
            vTraceError(&rAdressing, enClientError_UnsupportedOpCode);
            break;
        }
    }


 private:
   tVoid vPostMsg(amt_tclServiceData* poMessage) const;
   tVoid  vTraceRequest(tPCChar name, trAdressing const *prAdressing);


   tVoid vRegisterAllFIDs(tVoid);
   tVoid vUnregisterAllFIDs(tVoid);

};

} // namespace DAB

#endif
