/************************************************************************
* FILE:         fc_dabtuner_cca.h
* PROJECT:      g3g
* SW-COMPONENT: FC_DABTUNER
*----------------------------------------------------------------------
*
* DESCRIPTION:  header contents of fc_dabtuner_cca
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                      | Modification
*
*************************************************************************/

#ifndef FC_DABTUNER_CCA_H
#define FC_DABTUNER_CCA_H

//        extern tVoid xxx_vTracefnId(tU16 fnId);

#define DAB_BEGIN_MSG_MAP(className_) \
    tVoid className_::vDispatchMessage_(amt_tclServiceData *pMsg) { \
        className_ *pClass =instance();                       \
        typedef className_ className; \
        if ((pMsg->u8GetType()) != (AMT_C_U8_CCAMSGTYPE_SVCDATA)) { \
           pClass->vOnUnknownMessage(pMsg); \
        } else { \
        switch (pMsg->u16GetFunctionID()) {

#define DAB_END_MSG_MAP() \
    default:\
    pClass->vOnUnknownMessage(pMsg);\
    break; \
    }}};
//        xxx_vTracefnId(0xffff);

namespace DAB {
    struct trAdressing {
        trAdressing(amt_tclServiceData const *poMessage) {
            _u16Fid      = poMessage->u16GetFunctionID();
            _u16AppId    = poMessage->u16GetSourceAppID();
            _u16RegId    = poMessage->u16GetRegisterID();
            _u16CmdCount = poMessage->u16GetCmdCounter();
            _u8OpCode    = poMessage->u8GetOpCode();
        };
        trAdressing(){_u16Fid=0; _u16AppId=0; _u16RegId=0; _u16CmdCount=0; _u8OpCode=0;};

        tU16 _u16Fid;
        tU16 _u16AppId;
        tU16 _u16RegId;
        tU16 _u16CmdCount;
        tU8 _u8OpCode;
    };

} // namespace DAB


#endif
