/*******************************************************************************
* FILE:           fc_dabtuner_DiagLibSysSetListener.h
* PROJECT:        g3g
* SW-COMPONENT:   DABTUNER
*-------------------------------------------------------------------------------
*
* DESCRIPTION:    definition of diagnosis system set default listener
* 
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date      | Author              | Modification
* 05.06.09  | PJ-VW33 Hassmann     | initial version
*
*******************************************************************************/

#ifndef DAB_DIAGLIBSYSSETLISTENER_H
#define DAB_DIAGLIBSYSSETLISTENER_H

#include "fc_dabtuner_DiagLibHandler.h"

// +++ Specify what part of diaglib you need in this file +++
//#define DIAGLIB_INCLUDE_ROUTINE_CONTROL


// forward definition of own application class
//lint -esym(763, fc_dabtuner_tclApp)  Redundant declaration for symbol
class fc_dabtuner_tclApp;

namespace DAB {

// class definition
class fc_dabtuner_DiagLibSysSetListener : public diaglib::tclSystemSetListenerIF
{
public:
    // +++ Depending on the type of listener you need the associated interface to send responses +++
    fc_dabtuner_DiagLibSysSetListener( diaglib::tclSystemSetIF* poSystemSetIF,
                                                 fc_dabtuner_tclApp* poMain );

    // default destructor
    virtual ~fc_dabtuner_DiagLibSysSetListener();

private:
    // default constructor
    fc_dabtuner_DiagLibSysSetListener(); //lint !e1704 prio3 reviewed: constructor has private access specification: its use is forbidden
    // copy constructor
    fc_dabtuner_DiagLibSysSetListener(const fc_dabtuner_DiagLibSysSetListener& rhs); //lint !e1704 prio3 reviewed: constructor has private access specification: its use is forbidden
    // assignment operator
    fc_dabtuner_DiagLibSysSetListener& operator=(const fc_dabtuner_DiagLibSysSetListener& rhs);

	
    // attribute: reference to system set interface
    diaglib::tclSystemSetIF* m_poSystemSetIF;

    diaglib::tContext _MsgContext;

	 // attribute: reference of own application object
    fc_dabtuner_tclApp* m_poGWMain;
    typedef enum{
    	DAB_SYSET_None,
    	DAB_SYSSET_DEFSET_RUNNING,
    	DAB_SYSSET_CODING_RUNNIG
    }SysSetListenerStatus;


    SysSetListenerStatus _enSySetsetStatus;

    tVoid vSendResult(DAB_tenResult enRes);
    tU32 u32HandleSysSetPrepare(diaglib::tenSystemSetType u32SystemSetType,diaglib::tenSystemSetResult& systemSetResult);
    tU32 u32HandleSysSet(diaglib::tenSystemSetType u32SystemSetType,diaglib::tContext MsgContext);
    tU32 u32HandleSwitchUser();
    tU32 u32HandleDefaultSettings(diaglib::tenSystemSetType u32SystemSetType,diaglib::tContext MsgContext);
    tVoid vHandleDefaultSettingsExt();

public:
    // handler method for system setting
    virtual tU32 vOnSystemSet (
                              tU32 u32SystemSetID, 
                              diaglib::tenSystemSetType u32SystemSetType,
                              diaglib::tContext MsgContext
                              );

    // handler method for finaling of system setting
    virtual tU32 vOnSystemSetFinished (
                                      tU32 u32SystemSetID, 
                                      diaglib::tenSystemSetType u32SystemSetType,
                                      diaglib::tContext MsgContext
                                      );

    // handler method for preparing of system setting
    virtual tU32 vOnSystemSetPrepare (
                                     tU32 u32SystemSetID, 
                                     diaglib::tenSystemSetType u32SystemSetType,
                                     diaglib::tContext MsgContext
                                     );

    tVoid vOnSysSetResult(trMsgSrvResultRsp const *poSrvRspDefSet);
};
}
#endif

