/************************************************************************
* FILE:         fc_dabtuner_DiagLibHandler.h
* PROJECT:      g3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION: Demo Server diagnosis handler using the new diagnosis
* library.
* In order to use diaglib to provide diagnostic services, include a
* diaghandler object like this one in your component. Adjust it to your
* needs and create an instance of it in your main application. This class
* does not use traces by purpose in order not to pollute the important
* information for the diaglib-use. Look at the other parts of this
* demoserver to get an idea of the general concept of application, CCA-
* communication and trace functionality. This part concentrates on the
* diaglib.
* Parts that need modification by you are marked by special comments.
* depending on the file.
* - ccademo_diaghandler.x              => // +++ Comment +++
* - ccademo_IncreaseDecreaseHandler.x  => // +++ Comment +++
* - ccademo_main.x                     => // +++diaglib+++ comment
* - ccademo_msgtypes.h                 => // +++diaglib+++ comment
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                 | Modification
* 15.07.08  | CM-AI/PJ-FO45 Evers    | Inital version
* 21.08.08  | CM-AI/PJ-FO45 Evers    | Finalize and comment
* 18.02.11  | CM-DI/PJ-VW33 Hassmann  | Adaption for fc_fc_dabtuner
*************************************************************************/
#ifndef DAB_DIAGLIBHANDLER_H
#define DAB_DIAGLIBHANDLER_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


// +++ Specify what kind of diagnostic services you provide. Consult documentation for details +++
#define DIAGLIB_INCLUDE_SYSTEM_SET
#define DIAGLIB_INCLUDE_IO_CONTROL




#include "diaglib_if.h"
#ifndef SYSSETID_TUNE_DAB
#define SYSSETID_TUNE_DAB 1003
#endif



#include "fc_dabtuner_messageHandlerCommon.hpp"
#include "dabdrv_main.hpp"
#include "fc_dabtuner_serviceBase.h"

// +++ Application forward declaration +++
class fc_dabtuner_tclApp;

namespace DAB {


// +++ Listener forward declarations +++
class fc_dabtuner_DiagLibSysSetListener;
class fc_dabtuner_DiagLibIoControlListener;

/**
 * Message are received by implementing ListenerInterfaces and registering 
 * them with diagnosis library. This demo shows two ways to achieve this.
 * SystemSets are handled in this class. For RoutineControl we create an
 * extra classe that handles requests for two different routines.
 */
// +++ Adjust class prefix according to your component +++
class fc_dabtuner_DiagLibHandler:
    public DAB::DAB_ServiceBase,
    public DAB_MessageHandlerCommon<fc_dabtuner_DiagLibHandler>,
    public DAB_Singleton <fc_dabtuner_DiagLibHandler>
{
public:
    DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_SERVICE);
    virtual tVoid vInit();
    virtual char const *pcGetName() const {return "fc_dabtuner_DiagLibHandler";};

    fc_dabtuner_DiagLibHandler();

    virtual tVoid vProcess(DAB::trMsgSrvResultRsp *poSrvRspDefSet);
    virtual tVoid vProcess(DAB::trMsgSrvRspTestOperation *poSrvRspTestOperation);

    virtual ~fc_dabtuner_DiagLibHandler();

 protected:
    DAB::trServerConfig oDabServiceConfig;
    virtual DAB::trServerConfig &roGetConfig();
private:
    //forbidden
    fc_dabtuner_DiagLibHandler(const fc_dabtuner_DiagLibHandler& rhs); //lint !e1704 prio3 reviewed: constructor has private access specification: its use is forbidden
    fc_dabtuner_DiagLibHandler& operator=(const fc_dabtuner_DiagLibHandler& rhs);

    // +++ Pointer to application +++
    fc_dabtuner_tclApp* m_poGWMain;
    diaglib::tclDiagnosisInterfaceFactory* m_poFactory;


    diaglib::tclDiagnosisIF* m_poDiagIF;
    diaglib::tclCCAServiceIF* m_poCcaIF;

    // +++ Interfaces you need +++
    diaglib::tclSystemSetIF* m_poSystemSetIF;
    diaglib::tclIoControlIF* m_poIoControlIF;


    // +++ Listeners you create +++
    fc_dabtuner_DiagLibSysSetListener*  m_poSystemSetListener;
    fc_dabtuner_DiagLibIoControlListener*  m_poIoControlListener;

public:

    virtual tVoid vOnNewAppState (tU32 u32AppState);
    virtual tU16 u16GetServiceId();
    virtual tBool bGetServiceVersion (tU16& rfu16MajorVersion, 
                              tU16& rfu16MinorVersion, 
                              tU16& rfu16PatchVersion);
    virtual tVoid vDispatchMessage_(amt_tclServiceData *poMessage);

};
}
#endif

