/************************************************************************
 * FILE:        dabmeca_exp.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabmeca_exp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      	| Author                       | Modification
				  
				
 *************************************************************************/

#ifndef DABMECA_EXP_HPP
#define DABMECA_EXP_HPP

#include "fc_dabtuner_util.h"
#include "dabdrv_meca.h"
//#include "dabmeca_db.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_UTIL_MSG
#include "trcGenProj/Header/dabmeca_exp.hpp.trc.h"
#endif

namespace DAB {

    typedef enum {
        enMeca_ExpValueId_BBE = 0x0200,
        enMeca_ExpValueId_EnsId =  0x0201,              // EXPAPI_ID_DAB__DIAG_EID
        enMeca_ExpValueId_Frequency = 0x0202,           // EXPAPI_ID_DAB__DIAG_FREQUENCY
        enMeca_ExpValueId_Retune = 0x0203,              // EXPAPI_ID_DAB__DIAG_RETUNE_VAL
        enMeca_ExpValueId_MSCBER = 0x0204,
        enMeca_ExpValueId_FICBER = 0x0207,
        enMeca_ExpValueId_SYNC = 0x0208,                // EXPAPI_ID_DAB__DIAG_SYNC
        enMeca_ExpValueId_ISOCRC = 0x020b,
        enMeca_ExpValueId_RSFEC = 0x020c,               // EXPAPI_ID_DAB__DIAG_RSFEC
        enMeca_ExpValueId_DabMode = 0x020f,
        enMeca_ExpValueId_AudioSid =  0x0210,           // EXPAPI_ID_DAB__DIAG_AUDIO_SID
		enMeca_ExpValueId_NETBER = 0x0211,
        enMeca_ExpValueId_FieldStrength = 0x0261,
        enMeca_ExpValueId_Bg_BBE =  0x02B0,             // EXPAPI_ID_DAB__DIAG_BBE_2
        enMeca_ExpValueId_Bg_EnsId =  0x02B1,           // EXPAPI_ID_DAB__DIAG_EID_2
        enMeca_ExpValueId_Bg_Frequency = 0x02B2,        // EXPAPI_ID_DAB__DIAG_FREQUENCY_2
        enMeca_ExpValueId_Bg_Retune = 0x02B3,           // EXPAPI_ID_DAB__DIAG_RETUNE_VAL_2
        enMeca_ExpValueId_Bg_FIC = 0x02B7,              // EXPAPI_ID_DAB__DIAG_FIC_BER_2
        enMeca_ExpValueId_Bg_SYNC = 0x02B8,             // EXPAPI_ID_DAB__DIAG_SYNC_2
        enMeca_ExpValueId_Bg_DabMode = 0x02BF,          // EXPAPI_ID_DAB__DAB_TRANSM_MODE_2
        enMeca_ExpValueId_Bg_FieldStrength = 0x02C1,    // EXPAPI_ID_DAB__FIELDSTRENGH_2
        //enMeca_ExpValueId_Version = 0x0400,           // not supported from adr
        //enMeca_ExpValueId_CompileData = 0x0401,       // not supported from adr
        enMeca_ExpValueId_Modul_Info = 0x0511,          // EXPAPI_RDM_SHARE_INFO_PATH_1
        enMeca_ExpValueId_Modul_Info_Bg = 0x0512,       // EXPAPI_RDM_SHARE_INFO_PATH_2
        enMeca_ExpValueId_Num_Sls_Svcs = 0x0732,        // EXPAPI_ID_DB__NUM_SLS_SERVICES
        enMeca_ExpValueId_Num_Bws_Svcs = 0x0733,        // EXPAPI_ID_DB__NUM_BWS_SERVICES
        enMeca_ExpValueId_Num_Tpeg_Svcs = 0x0734,       // EXPAPI_ID_DB__NUM_TPEG_SERVICES
        enMeca_ExpValueId_Num_Tmc_Svcs = 0x0736,        // EXPAPI_ID_DB__NUM_TMC_SERVICES
        enMeca_ExpValueId_Num_Epg_Svcs = 0x0737,        // EXPAPI_ID_DB__NUM_EPG_SERVICES
        enMeca_ExpValueId_Num_Journaline_Svcs = 0x073A, // EXPAPI_ID_DB__NUM_JORNALINE_SERVICES
        enMeca_ExpValueId_FlashId = 0x1001,
        enMeca_ExpValueId_Crc = 0x1002,
        enMeca_ExpValueId_Mtd_0 = 0x2000,
        enMeca_ExpValueId_Mtd_1 = 0x2001,
        enMeca_ExpValueId_Mtd_2 = 0x2002,
        enMeca_ExpValueId_Mtd_3 = 0x2003,
        enMeca_ExpValueId_Mtd_4 = 0x2004,
        enMeca_ExpValueId_Mtd_5 = 0x2005
    } tenMeca_ExpValueId;

    typedef enum {
        enMeca_ExpAction_DISABLE = 0x01,
        enMeca_ExpAction_ENABLE_MANUAL = 0x02,
        enMeca_ExpAction_ENABLE_AUTO_UPDATE = 0x03,
        enMeca_ExpAction_UPDATE_VALUE = 0x04,
        enMeca_ExpAction_UPDATE_DESCRIPTION = 0x05,
        enMeca_ExpAction_SET_POSTMSGID = 0x06,
        enMeca_ExpAction_SCANIDS = 0x07
    } tenMeca_ExpAction;

    // _DAB_C_EXP_SELECT
    struct trMeca_CExpSelect:
        public  trMsgMecaOut {
        DAB_DISPATCH_IMPL

        virtual tVoid vSerialize(trMsgMecaRawOutput *pRawOutput) const {
            pRawOutput->u16FBlockId = DAB_FBLOCK_ID;
            pRawOutput->u16MsgType = MECA_DISPATCHER_C_EXP_SELECT;
            pRawOutput->enOpType = enOpType_SET;
            pRawOutput->u16DataLen = 3;
            DABDRV_SET_U16(&pRawOutput->au8Data[0],(tU16)enValueId);
            pRawOutput->au8Data[2]= (tU8)enAction;
        }

        virtual tVoid vTrace() const {
            ETG_TRACE_USR1(("  trMeca_CExpSelect:enValueId=%x enAction=%x",
                            ETG_CENUM(tenMeca_ExpValueId, enValueId),
                            ETG_CENUM(tenMeca_ExpAction, enAction)));
        };
    
        tenMeca_ExpValueId enValueId;
        tenMeca_ExpAction enAction;
    };



    typedef enum {
        enMeca_ExpActionRes_ID_UNKNOWN = 0x01,
        enMeca_ExpActionRes_ID_ENABLED = 0x02,
        enMeca_ExpActionRes_ID_DISABLED = 0x03
    } tenMeca_ExpActionRes;

    typedef enum {
        enMeca_ExpValueType_UNDEFINED = 0x00,
        enMeca_ExpValueType_LABEL = 0x01,
        enMeca_ExpValueType_UINT32 = 0x02,
        enMeca_ExpValueType_UINT32_RW = 0x03,
        enMeca_ExpValueType_BYTEARRAY = 0x04
    } tenMeca_ExpValueType;

    // _DAB_R_EXP_SELECT
    struct trMeca_RExpSelect:
        public trMsgMecaInput {
        DAB_DISPATCH_IMPL
    
        virtual tBool bParse(trMostHdr const &rMostHdr, tU8 const *pu8Data) {
            if (rMostHdr._u16MecaLen != 4) {
                return FALSE;
            }
            _rMostHdr=rMostHdr;
            enValueId=(tenMeca_ExpValueId )DABDRV_GET_U16(&pu8Data[0]);
            enActionRes = (tenMeca_ExpActionRes)pu8Data[2];
            enValueType = (tenMeca_ExpValueType)pu8Data[3];
            return TRUE;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1(("  trMeca_RExpSelect:enValueId=%x enActionRes=%x enValueType=%x",
                             ETG_CENUM(tenMeca_ExpValueId, enValueId),
                            ETG_CENUM(tenMeca_ExpActionRes, enActionRes),
                            ETG_CENUM(tenMeca_ExpValueType, enValueType)));
        };
    
        tenMeca_ExpValueId enValueId;
        tenMeca_ExpActionRes enActionRes;
        tenMeca_ExpValueType enValueType;

    };


    // R_EXP_ID_VALUE_LABEL
    struct trMeca_RExpIdValueLabel:
        public trMsgMecaInput {
        DAB_DISPATCH_IMPL
    
        virtual tBool bParse(trMostHdr const &rMostHdr, tU8 const *pu8Data) {
            if (rMostHdr._u16MecaLen != 22) {
                return FALSE;
            }
            _rMostHdr=rMostHdr;
            enValueId=(tenMeca_ExpValueId )DABDRV_GET_U16(&pu8Data[0]);
            rLabel.vParse(&pu8Data[2]);

            return TRUE;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1(("  trMeca_RExpIdValueLabel:enValueId=%x Label follows",
                            ETG_CENUM(tenMeca_ExpValueId, enValueId)));
            rLabel.vTrace();

        };
    
        tenMeca_ExpValueId enValueId;
        trMecaLabel rLabel;

    };

    // R_EXP_ID_VALUE_UINT32
    struct trMeca_RExpIdValueU32:
        public trMsgMecaInput {
        DAB_DISPATCH_IMPL
    
        virtual tBool bParse(trMostHdr const &rMostHdr, tU8 const *pu8Data) {
            if (rMostHdr._u16MecaLen != 6) {
                return FALSE;
            }
            _rMostHdr=rMostHdr;
            enValueId=(tenMeca_ExpValueId )DABDRV_GET_U16(&pu8Data[0]);
            u32Value=DABDRV_GET_U32(&pu8Data[2]);
            return TRUE;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1(("  trMeca_RExpIdValueU32:enValueId=%x u32Value=0x%x",
                            ETG_CENUM(tenMeca_ExpValueId, enValueId),
                            u32Value));
        };
    
        tenMeca_ExpValueId enValueId;
        tU32 u32Value;
    };

    // R_EXP_ID_DESCRIPTION
    struct trMeca_RExpIdDescription:
        public trMsgMecaInput {
        DAB_DISPATCH_IMPL

        virtual tBool bParse(trMostHdr const &rMostHdr, tU8 const *pu8Data) {
            _rMostHdr=rMostHdr;
            enValueId=(tenMeca_ExpValueId )DABDRV_GET_U16(&pu8Data[0]);
            rExpLabel.vParse(&pu8Data[2]);
            return TRUE;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1(("  trMeca_RExpIdDescription:enValueId=%x",
                            ETG_CENUM(tenMeca_ExpValueId, enValueId)));
        };

        tenMeca_ExpValueId enValueId;
        trMecaLabel rExpLabel;
    };

    // missing
    //C_EXP_ID_SET_VALUE_UINT32

} // namespace DAB

#endif
