/************************************************************************
 * FILE:        dabmeca_aud.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabmeca_aud
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      	| Author                       | Modification
				  
				
 *************************************************************************/

#ifndef DABMECA_AUD_HPP
#define DABMECA_AUD_HPP

#include "fc_dabtuner_util.h"
#include "dabdrv_meca.h"
//#include "dabmeca_db.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_UTIL_MSG
#include "trcGenProj/Header/dabmeca_aud.hpp.trc.h"
#endif

namespace DAB {


    // _DAB_C_AUD_SET_CONCEALMENT_LEVEL
    struct trMeca_CAudSetConcealmentLevel:
        public  trMsgMecaOut {
        DAB_DISPATCH_IMPL

        trMeca_CAudSetConcealmentLevel(tU8 u8ConcealmentLevel_=0) {
            u8ConcealmentLevel=u8ConcealmentLevel_;
        }

        virtual tVoid vSerialize(trMsgMecaRawOutput *pRawOutput) const {
            pRawOutput->u16FBlockId = DAB_FBLOCK_ID;
            pRawOutput->u16MsgType = MECA_DISPATCHER_C_AUD_SET_CONCEALMENT_LEVEL;
            pRawOutput->enOpType = enOpType_SETGET;
            pRawOutput->u16DataLen = 1;
            pRawOutput->au8Data[0]= u8ConcealmentLevel;
        }

        virtual tVoid vTrace() const {
            ETG_TRACE_USR1(("  trMeca_CAudSetConcealmentLevel:u8ConcealmentLevel=0x%x",
                            u8ConcealmentLevel));
        };
    
        tU8 u8ConcealmentLevel;

    };


    // DAB_*_R_AUD_SET_CONCEALMENT_LEVEL
    struct trMeca_RAudSetConcealmentLevel:
        public trMsgMecaInput {
        DAB_DISPATCH_IMPL
    
        virtual tBool bParse(trMostHdr const &rMostHdr, tU8 const *pu8Data) {
            if (rMostHdr._u16MecaLen != 1) {
                ETG_TRACE_USR1((" ******* trMeca_RAudSetConcealmentLevel  rMostHdr._u16MecaLen =%d",
                            rMostHdr._u16MecaLen));
                return FALSE;
            }
            _rMostHdr=rMostHdr;
            u8ConcealmentLevel=pu8Data[0];
            ETG_TRACE_USR1(("  trMeca_RAudSetConcealmentLevel:u8ConcealmentLevel=0x%x",
                                        u8ConcealmentLevel));
            return TRUE;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1(("  trMeca_RAudSetConcealmentLevel:u8ConcealmentLevel=0x%x",
                            u8ConcealmentLevel));
        };
    
        tU8 u8ConcealmentLevel;
    };



} // namespace DAB

#endif
