/************************************************************************
 * FILE:         dabdrv_tmcRead.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_tmcRead
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      	| Author                       | Modification
				  
				
 *************************************************************************/

#ifndef DABDRV_TMC_READ_HPP
#define DABDRV_TMC_READ_HPP

#include "fc_dabtuner_util.h"
#include "dabdrv_main.hpp"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_TMC 
#include "trcGenProj/Header/dabdrv_tmcRead.hpp.trc.h"
#endif

namespace DAB {
    struct trMsgTmcStatusTimeOut;

    class dabdrv_tmcRead:
        public DAB_Singleton <dabdrv_tmcRead>,
        public DAB_MessageHandlerCommon<dabdrv_tmcRead>
    {
        friend class DAB_Singleton<dabdrv_tmcRead>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_TMC);
        virtual char const *pcGetName() const {return "dabdrv_tmcRead";};

        virtual tVoid vInit();
        virtual tVoid vDeInit();

        virtual tVoid vProcess(trMsgDrvStartComponent *poStartComponent);
        virtual tVoid vProcess(trMsgDrvStopComponent *poStopComponent);

        virtual tVoid vProcess(trMsgDrvCmdSourceState* poDrvCmdSourceState);
        virtual tVoid vProcess(trMsgSrvCmdSelectTmc* poSrvCmdSelectTmc);

        virtual tVoid vProcess(trMeca_RDdmTmcSc* poTmcSc);
        virtual tVoid vProcess(trMeca_RDdmTmcEvent* poTmcEvent);
        
        virtual tVoid vProcess(trMsgSrvCmdRdbidWishlist* poRdbidWishlist);
        virtual tVoid vProcess(trMsgDrvSetTmcMode* poMsgDrvSetTmcMode);
        virtual tVoid vProcess(trMsgTmcStatusTimeOut *poTmcStatusTimeOut);

        tVoid vTraceRdbidWishList(DAB_trTmcRdbId const &rTmcRdbId) const;

        trMeca_CDdmTmcSc const &rGetLastTmcSc() const {
            return _rLastTmcScStart;
        }

    private:
        typedef enum {
            enTmcState_Idle,
            enTmcState_CollectingTmcData,
            enTmcState_SendTmcData
        } tenTmcState;

        dabdrv_tmcRead();   

        tVoid vStopLearn();
        tVoid vStartLearn();

        tVoid vRequestEnsemble();
        tVoid vRequestTmcSc();
        tVoid vCancelTmcSc();
        tBool bEnsembleTuned() const;

        DAB_tclTimer _oTmcTmr;

        trMeca_CDdmTmcSc _rLastTmcScStart;
        trMeca_RDdmTmcSc _rLastTmcScResponse;
        tenTmcState _enTmcState;
        DAB_trTmcDataListProperty oTmcDataList;

    };
} //namespace DAB 

#endif
