/************************************************************************
 * FILE:         dabdrv_tmcRead.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_tmcRead
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      	| Author                       | Modification
				  
				
 *************************************************************************/
#include "dabdrv_main.hpp"
#include "dabdrv_chnList.hpp"
#include "dabdrv_tmcLearn.hpp"
#include "dabdrv_tmcParse.hpp"
#include "dabdrv_tmcRead.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_TMC 
#include "trcGenProj/Header/dabdrv_tmcRead.cpp.trc.h"
#endif


namespace DAB {
#define DAB_TMC_STATUS_TIMER_MS (1000 * DAB_TIME_FACTOR)
//#define DAB_WAIT_TMC_READ_ENSEMBLE_TIMER_MS (5000 * DAB_TIME_FACTOR)
//#define DAB_WAIT_RETRY_TMC_SC_TIMER_MS (5000 * DAB_TIME_FACTOR)
//#define DAB_WAIT_TMC_DATA_TIMER_MS (30000 * DAB_TIME_FACTOR)

    struct trMsgTmcStatusTimeOut:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgTmcStatusTimeOut"));
        };
    };
}


using namespace DAB;
dabdrv_tmcRead::dabdrv_tmcRead() {
    _enTmcState = enTmcState_Idle;

    _rLastTmcScStart.enCommand = enMeca_DdmCommand_STOP;
    _rLastTmcScStart.enServiceType = enMeca_ServiceType_INVALID;
    _rLastTmcScStart.rMecaProgrammeService._u32Id = 0;
    _rLastTmcScStart.u16SCIDI = 0;
    _rLastTmcScStart.u8Flags = 0;

    vSubscribe<trMsgDrvStartComponent>();
    vSubscribe<trMsgDrvStopComponent>();
    vSubscribe<trMsgDrvCmdSourceState>();
    vSubscribe<trMsgSrvCmdSelectTmc>();

    vSubscribe<trMeca_RDdmTmcSc>();
    vSubscribe<trMeca_RDdmTmcEvent>();
    
    vSubscribe<trMsgSrvCmdRdbidWishlist>();
    vSubscribe<trMsgDrvSetTmcMode>();

}

tVoid dabdrv_tmcRead::vInit() {
    ETG_TRACE_USR1(("dabdrv_tmcRead::vInit"));
    _oTmcTmr.vInit(instance(),trMsgTmcStatusTimeOut());

}

tVoid dabdrv_tmcRead::vDeInit() {
    ETG_TRACE_USR1(("dabdrv_tmcRead::vDeInit"));

    _oTmcTmr.vDeInit();
    _oTmcTmr.vStop();
}

/*
  request tmcData for next compoent in _rCurrentCompList
  If all compoents in component-list are done, request compoent list for next
  audio-service (vRequestNextCompList()).
*/

tVoid dabdrv_tmcRead::vCancelTmcSc() {
    ETG_TRACE_USR4(("dabdrv_tmcRead::vCancelTmcSc"));
    _rLastTmcScStart.enCommand=enMeca_DdmCommand_STOP;
    dabdrv_mecaIf::instance()->vSendMecaCommand(_rLastTmcScStart);
}

tVoid dabdrv_tmcRead::vRequestTmcSc() {
    ETG_TRACE_USR4(("dabdrv_tmcRead::vRequestTmcSc()"));
    if (_rLastTmcScStart.enCommand==enMeca_DdmCommand_START) {
        //vCancelTmcSc();
    } else {
        _rLastTmcScStart.enCommand=enMeca_DdmCommand_START;
        _rLastTmcScStart.u8Flags= 1; // send once
        dabdrv_mecaIf::instance()->vSendMecaCommand(_rLastTmcScStart);
    }
}


tVoid dabdrv_tmcRead::vProcess(trMsgDrvStartComponent *poStartComponent) {
    (tVoid)poStartComponent;
}

tVoid dabdrv_tmcRead::vProcess(trMsgDrvStopComponent *poStopComponent) {
    (tVoid)poStopComponent;
}

tVoid dabdrv_tmcRead::vProcess(trMsgDrvCmdSourceState* poDrvCmdSourceState) {
    if (poDrvCmdSourceState->enSourceState == DAB_enSourceState_BG) {

    }
}

tVoid dabdrv_tmcRead::vProcess(trMsgSrvCmdSelectTmc* poSrvCmdSelectTmc) {

     ETG_TRACE_USR4(("dabdrv_tmcRead::vProcess(trMsgSrvCmdSelectTmc) Ensemble:0x%08x RDBID= 0x00%02x%02x%02x",
                            poSrvCmdSelectTmc->rEns._u32Id,poSrvCmdSelectTmc->rRdbId.u8Cc,
                            poSrvCmdSelectTmc->rRdbId.u8Ltn,poSrvCmdSelectTmc->rRdbId.u8Sid));

     // search in below property if ensemble matches ??
     DAB_trTmcAvailListProperty rProperty= dabdrv_properties::instance()->oTmcAvailListProperty.oGet();

     trTmcAvailListElem test;
     test.rEnsembleId._u32Id = poSrvCmdSelectTmc->rEns._u32Id;

     std::vector<trTmcAvailListElem>::iterator it;
     for( it = rProperty.vectorTmcAvailEntries.begin() ; it < rProperty.vectorTmcAvailEntries.end() ; it ++ ) 
     {
         if( (it)->rEnsembleId._u32Id == poSrvCmdSelectTmc->rEns._u32Id) 
         {
             // fill 
             _rLastTmcScStart.u16SCIDI = (tU16)(it)->u32Scidi;
             _rLastTmcScStart.rMecaProgrammeService._u32Id = (it)->rProgrammeService._u32Id;
             _rLastTmcScStart.rMecaProgrammeService._enServiceType = (it)->rProgrammeService._enServiceType;
             _rLastTmcScStart.enServiceType = (it)->rProgrammeService._enServiceType;
             break;
         }
     }

     vRequestTmcSc();
}

tVoid dabdrv_tmcRead::vProcess(trMeca_RDdmTmcSc* poTmcSc) {
    ETG_TRACE_USR1(("dabdrv_tmcRead::vProcess(trMeca_RDdmTmcSc) enCommand=%d",
                    ETG_CENUM(tenMeca_DdmCommand, poTmcSc->enCommand)));
    vRequestTmcSc();
}

tVoid dabdrv_tmcRead::vProcess(trMeca_RDdmTmcEvent* poTmcEvent) {
    ETG_TRACE_USR1(("dabdrv_tmcRead::vProcess(trMeca_RDdmTmcEvent)"));
    //(tVoid)poTmcEvent;

    tBool bDoCancel = FALSE;

    if (poTmcEvent->u16SCIDI != _rLastTmcScStart.u16SCIDI /*&& !dabdrv_tmcLearn::instance()->bTmcLearnActive()*/) {
        // neither tmcLearn nor tmcRead are waiting for tmc-data of this scidi, so stop them
        bDoCancel=TRUE;
    }
        
    if (bDoCancel) {
        // todo: if we receive tmc-data from unexpected scidi or in wrong state, send TmcSc->Stop
        trMeca_CDdmTmcSc rTmcScStop;
        rTmcScStop.enCommand=enMeca_DdmCommand_STOP;
        rTmcScStop.enServiceType=poTmcEvent->enServiceType;
        rTmcScStop.u8Flags=0;
        rTmcScStop.rMecaProgrammeService= poTmcEvent->rMecaProgrammeService;
        rTmcScStop.u16SCIDI=poTmcEvent->u16SCIDI;
        return;
    }

    // todo: process tmc-data
    // todo: check handling of ECC
    DAB_trTmcDataListElement _rTmcData;
    tBool bRetVal = dabdrv_tmcParse::instance()->bParseTmcMsg( (tU8)poTmcEvent->enTmcGroup, 
                                                                &(poTmcEvent->u8TmcData[0]), 
                                                                poTmcEvent->rMecaProgrammeService.u32GetSID(), 
                                                                poTmcEvent->u16SCIDI,
                                                                poTmcEvent->s16Ecc,
                                                                &_rTmcData);

    if ( bRetVal == TRUE ) {
        // add to vector 
        oTmcDataList.vectorTmcDataListElements.push_back(_rTmcData);
    }

    // check if vector is full
    if ( (oTmcDataList.vectorTmcDataListElements.size() == 50) || 
         (_enTmcState == enTmcState_SendTmcData) ) 
    {
        dabdrv_properties::instance()->oTmcDataListProperty.vSet(oTmcDataList);

        oTmcDataList.vectorTmcDataListElements.clear();
        _enTmcState = enTmcState_CollectingTmcData;
    }

}

/*  Store RDBID-Wishlist in local member */
tVoid dabdrv_tmcRead::vProcess(trMsgSrvCmdRdbidWishlist* poRdbidWishlist) {
    ETG_TRACE_USR1(("dabdrv_tmcRead::vProcess(trMsgSrvCmdRdbidWishlist)"));
    
    trMsgSrvRspRdbidWishlist rRdbidWishlist;
    //tU32 u32size = poRdbidWishlist->vecRdbIdList.size(); // Coverity

    dabdrv_tmcParse::instance()->vCleanRdbidWishlist();

    for (tU32 i=0;i<poRdbidWishlist->vecRdbIdList.size();++i) {
        vTraceRdbidWishList(poRdbidWishlist->vecRdbIdList[i]);
        
        dabdrv_tmcParse::instance()->vAddRdbid2Wishlist(&poRdbidWishlist->vecRdbIdList[i]);

        rRdbidWishlist.vecRdbIdList.push_back(poRdbidWishlist->vecRdbIdList[i]);
    }

    // todo: send rdbid-wishlist to ADR3
    DAB_vCallMsg(rRdbidWishlist);
}


tVoid dabdrv_tmcRead::vTraceRdbidWishList(DAB_trTmcRdbId const &rTmcRdbId) const{
    ETG_TRACE_USR4(("RDBID  encrypted %d, u16Bsa 0x%x, u8Cc 0x%x, u8Ltn 0x%x, u8Sid 0x%x,", 
                    rTmcRdbId.bEncrypted, 
                    rTmcRdbId.u16Bsa,
                    rTmcRdbId.u8Cc,
                    rTmcRdbId.u8Ltn,
                    rTmcRdbId.u8Sid));
}

/* enable TMC (UpReg)*/
tVoid dabdrv_tmcRead::vProcess(trMsgDrvSetTmcMode* poMsgDrvSetTmcMode) {
    
    ETG_TRACE_USR1(("dabdrv_tmcRead::vProcess(trMsgDrvSetTmcMode) TMC activ = %d", poMsgDrvSetTmcMode->bEnable));
    _enTmcState = enTmcState_CollectingTmcData;
    _oTmcTmr.vStart(DAB_TMC_STATUS_TIMER_MS, TRUE);
}

tVoid dabdrv_tmcRead::vProcess(trMsgTmcStatusTimeOut *poTmcStatusTimeOut) {
    (tVoid)poTmcStatusTimeOut;
    //ETG_TRACE_USR4(("dabdrv_tmcRead::vProcess(trMsgTmcStatusTimeOut)"));

    if (_enTmcState==enTmcState_CollectingTmcData) {
        _enTmcState = enTmcState_SendTmcData;
    }
}



