/************************************************************************
 * FILE:          dabdrv_tmcParse.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_tmcParse
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      	| Author                       | Modification
				  
				
 *************************************************************************/

#ifndef DABDRV_TMC_PARSE_HPP
#define DABDRV_TMC_PARSE_HPP

#include "fc_dabtuner_util.h"
#include "dabdrv_main.hpp"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_TMC 
#include "trcGenProj/Header/dabdrv_tmcParse.hpp.trc.h"
#endif

namespace DAB {

    const tU8 TMC_C_U8_VALID_ECC                       =    0x01;
    const tU8 TMC_C_U8_VALID_LTN                       =    0x02;
    /**vnd4kor: supressing prio2 lint warning*/
	//lint -esym(793,*identifiers in one block*)
    const tU8 TMC_C_U8_VALID_SID                       =    0x04;
    const tU8 TMC_C_U8_VALID_AID                       =    0x08;

    const tU8  TMC_C_U8_MASK_VALID_TMC_ELEM            =    TMC_C_U8_VALID_ECC | TMC_C_U8_VALID_LTN | TMC_C_U8_VALID_SID | TMC_C_U8_VALID_AID;

    const tU16 TMC_C_U16_MASK_VARIANT_SID              =    0x4000;

    /*
    struct trTmcLearnRdbIdInfo {
        DAB_trTmcRdbId rRdbId;
        tenMeca_ServiceType enServiceType;
        trMecaProgrammeService rSid;
        tU16 u16Scidi;
        tVoid vClear() {
            rRdbId=DAB_trTmcRdbId();
            enServiceType=enMeca_ServiceType_AUDIO_SERVICE;
            rSid.vInvalidate();
            u16Scidi=0;
        }
        tBool bValid() const {
            return rRdbId.u8Ltn !=0 && rSid.bIsValid() && u16Scidi!=0;
        }
    };
*/

    class dabdrv_tmcParse:
        public DAB_Singleton <dabdrv_tmcParse>,
        public DAB_MessageHandlerCommon<dabdrv_tmcParse>
    {
        friend class DAB_Singleton<dabdrv_tmcParse>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_TMC);
        virtual char const *pcGetName() const {return "dabdrv_tmcParse";};
        virtual tVoid vTraceState() const;

        virtual tVoid vInit();
        virtual tVoid vDeInit();

        struct trTmcDataElement 
        {
            trTmcDataElement() {
                _u32EnsId = 0;
                _u16Scidi = 0;
                _u32Psid  = 0;
                _u16Ecc   = 0;
                _u8Ltn    = 0;
                _u8Sid    = 0;
                _u16Aid   = 0;
                _u8Valid  = 0;
            }

            tU32 _u32EnsId;
            tU16 _u16Scidi;
            tU32 _u32Psid;
            tU16 _u16Ecc;
            tU8  _u8Ltn;
            tU8  _u8Sid;
            tU16 _u16Aid;
            tU8  _u8Valid;
        };

        struct trTmcList 
        {
            trTmcList() {
                for(tU8 i=0;i<5;i++) {
                    _u8TmcData[i] = 0;
                }
            }
            tU8 _u8TmcData[5];
        };

        vector<trTmcDataElement*>oTMCList;
        vector<trTmcList>_vectorTmcList;
        vector<DAB_trTmcRdbId*>_vecRdbIdWishList;
        
        tVoid vSetTmcActivity(tBool bTmcActive );
        tVoid vHandle3aGroup(vector<trTmcDataElement*>::const_iterator it, tU8 const *pTmcData) const;
        tBool bParseTmcMsg(tU8 u8TmcGroup, tU8* pTmc, tU32 u32Psid, tU16 u16SCIDI, tS16 s16Ecc, DAB_trTmcDataListElement *_rTmcData);
        tVoid vParse3aMsg(tU8* pTmc, tU32 u32Psid, tU16 u16SCIDI, tS16 s16Ecc);
        tVoid vAddRdbid2Wishlist(DAB_trTmcRdbId const *poTmcRdbid);
        tVoid vCleanRdbidWishlist();
        tBool bCheckTmcScidiSidEcc(tU32 u32Psid, tU16 u16SCIDI, tS16 s16Ecc, DAB_trTmcDataListElement *_rTmcData);
        tBool bParseTmcMsg(DAB_trTmcDataListElement *_rTmcData, tU8 const *pTmc) const;
        dabdrv_tmcParse();   

        tBool _bTmcActive;
    };
} //namespace DAB 

#endif
