/************************************************************************
 * FILE:           dabdrv_tmcLearn.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_tmcLearn
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      	| Author                       | Modification
				  
				
 *************************************************************************/

#ifndef DABDRV_TMC_LEARN_HPP
#define DABDRV_TMC_LEARN_HPP

#include "fc_dabtuner_util.h"
#include "dabdrv_main.hpp"
#include "dabdrv_activity.hpp"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_TMC 
#include "trcGenProj/Header/dabdrv_tmcLearn.hpp.trc.h"
#endif

namespace DAB {

    #define DAB_MAX_RDBID_PER_ENSEMBLE 8
    
    struct trTmcLearnRdbIdInfo {
        DAB_trTmcRdbId rRdbId;
        tenMeca_ServiceType enServiceType;
        trMecaProgrammeService rSid;
        tU16 u16Scidi;
        tVoid vClear() {
            rRdbId=DAB_trTmcRdbId();
            enServiceType=enMeca_ServiceType_AUDIO_SERVICE;
            rSid.vInvalidate();
            u16Scidi=0;
        }
        tBool bValid() const {
            return rRdbId.u8Ltn !=0 && rSid.bIsValid() && u16Scidi!=0;
        }
    };




    class dabdrv_tmcLearn:
        public DAB_Singleton <dabdrv_tmcLearn>,
        public DAB_MessageHandlerCommon<dabdrv_tmcLearn>
    {
        friend class DAB_Singleton<dabdrv_tmcLearn>;
    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_TMC);
        virtual char const *pcGetName() const {return "dabdrv_tmcLearn";};
        virtual tVoid vTraceState() const;

        virtual tVoid vInit();
        virtual tVoid vDeInit();

        virtual tVoid vProcess(trMsgDrvStartComponent *poStartComponent);
        virtual tVoid vProcess(trMsgDrvStopComponent *poStopComponent);

        virtual tVoid vProcess(trMsgDrvCmdSourceState* poDrvCmdSourceState);

        virtual tVoid vProcess(trMsgSrvCmdNewAppState *poNewAppState);
        virtual tVoid vProcess(trMsgSrvCmdGetTmcLearnData *poGetTmcLearnData);

        virtual tVoid vProcess(trMsgDrvSetTmcMode* poMsgDrvSetTmcMode);
        virtual tVoid vProcess(trMeca_RDdmTmcSc* poTmcSc);
        virtual tVoid vProcess(trMeca_RDdmTmcEvent* poTmcEvent);

        virtual tVoid vProcess(trMeca_RDbQuery* poQuery);

    private:

        struct trTmcLearnEnsembleInfo {
            trMecaEnsemble rEnsembleId;
            map<DAB_trTmcRdbId, trTmcLearnRdbIdInfo> mapRdbIdInfos;
            trTmcLearnEnsembleInfo() {};



        };

        dabdrv_tmcLearn();   

        tVoid vSendTmcSc(tBool bStart=TRUE);

        DAB_tclTimer _oStopLearnTmr;
        DAB_tclTimer _oWaitTmr;
        trMecaEnsemble _rRdmEnsemble;
        trMecaProgrammeService _rCurrentService;
        tBool _bTmcActive;
        tU16 _u16ActivatedScidi;
        tU16 _u16CurrentComponent;
    };
} //namespace DAB 

#endif
