/************************************************************************
 * FILE:           dabdrv_tmcLearn.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_tmcLearn
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      	| Author                       | Modification
				  
				
 *************************************************************************/
 
#include "dabdrv_main.hpp"
#include "dabdrv_chnList.hpp"
#include "dabdrv_dataSrvList.hpp"
#include "dabdrv_tmcParse.hpp"
#include "dabdrv_tmcRead.hpp"
#include "dabdrv_tmcLearn.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_TMC 
#include "trcGenProj/Header/dabdrv_tmcLearn.cpp.trc.h"
#endif

//#define DAB_TMC_LEARN_USE_CHN_LIST

//#define DAB_TNC_LEARN_MAX_NUM_ENS_TO_SCAN 1


#ifndef __RFC3072_HELPER_H__
#include "rfc3072_helper.h"
#endif


using namespace DAB;
dabdrv_tmcLearn::dabdrv_tmcLearn() {

    _bTmcActive = FALSE;
    _u16ActivatedScidi = 0;
    _u16CurrentComponent = 0;

    vSubscribe<trMsgDrvStartComponent>();
    vSubscribe<trMsgDrvStopComponent>();
    vSubscribe<trMsgDrvCmdSourceState>();
    vSubscribe<trMsgSrvCmdNewAppState>();
    vSubscribe<trMsgSrvCmdGetTmcLearnData>();

    vSubscribe<trMsgDrvSetTmcMode>();
    vSubscribe<trMeca_RDdmTmcSc>();
    vSubscribe<trMeca_RDdmTmcEvent>();

    vSubscribe<trMeca_RDbQuery>();

}

tVoid dabdrv_tmcLearn::vInit() {
    ETG_TRACE_USR1(("dabdrv_tmcLearn::vInit"));
}

tVoid dabdrv_tmcLearn::vDeInit() {
    ETG_TRACE_USR1(("dabdrv_tmcLearn::vDeInit"));
    dabdrv_tmcParse::instance()->vDeInit();
}

tVoid dabdrv_tmcLearn::vTraceState() const {

    ETG_TRACE_USR1(("  dabdrv_tmcLearn STATE: "
                    "_rCurrentService=0x%08x _u16CurrentComponent=0x%04x",
                    _rCurrentService.u32GetSID(),
                    _u16CurrentComponent));
}


tVoid dabdrv_tmcLearn::vProcess(trMsgSrvCmdNewAppState *poNewAppState) {
    (tVoid)poNewAppState;
#if 0
    if (poNewAppState->u32NewAppState!=AMT_C_U32_STATE_NORMAL) {
    }
#endif
}

tVoid dabdrv_tmcLearn::vProcess(trMsgSrvCmdGetTmcLearnData* /*poGetTmcLearnData*/) {

    // get DB_QUERY TMC-Component
    trMeca_CDbQuery rCDbQuery;
    rCDbQuery.u8QueryTag = (tU8)enMeca_QUERY_TAG_AVAIL_LIST;
    rCDbQuery.u8QueryStateId = 0;
    rCDbQuery.enDbQueryCmd = enMeca_DbQueryCmd_EVALUATE;

    const tChar line[] = "SELECT MAKE_API_SERVICE(stype,servecc,sid),MAKE_SCIDI(tmid,id,ps,scids,scty),eid,ltn,ca_flag FROM v1f0_dab_tmc_service_component";

    tU32 u32Len=(tU32)(OSAL_u32StringLength(line));
    rCDbQuery.lu8SqlStatement.reserve(u32Len+2);

    for (tU32 i=0; i < u32Len; i++) {
        rCDbQuery.lu8SqlStatement.push_back(line[i]);
    }
    rCDbQuery.lu8SqlParameter.push_back(0);
    rCDbQuery.lu8SqlParameter.push_back(0);
    
    dabdrv_mecaIf::instance()->vSendMecaCommand(rCDbQuery);
}


tVoid dabdrv_tmcLearn::vProcess(trMsgDrvStartComponent *poStartComponent) {
    (tVoid)poStartComponent;
}

tVoid dabdrv_tmcLearn::vProcess(trMsgDrvStopComponent *poStopComponent) {
    (tVoid)poStopComponent;
}

tVoid dabdrv_tmcLearn::vProcess(trMsgDrvCmdSourceState* poDrvCmdSourceState) {
    
    ETG_TRACE_USR4(("dabdrv_tmcLearn::trMsgDrvCmdSourceState enSourceState=%d",
                 ETG_CENUM(DAB_tenSourceState, poDrvCmdSourceState->enSourceState)));
    if (poDrvCmdSourceState->enSourceState != DAB_enSourceState_BG) {
    }
}

tVoid dabdrv_tmcLearn::vSendTmcSc(tBool bStart) {
    //_u16ActivatedScidi=0;
    trMeca_CDdmTmcSc const &rTmcReadTmcSc=dabdrv_tmcRead::instance()->rGetLastTmcSc();
    if (rTmcReadTmcSc.enCommand==enMeca_DdmCommand_START && _u16CurrentComponent==rTmcReadTmcSc.u16SCIDI) {
        ETG_TRACE_USR4(("dabdrv_tmcLearn::vSendTmcSc() _u16CurrentComponent=0x%04x already activated by tmcRead",
                        _u16CurrentComponent));
    } else {
        trMeca_CDdmTmcSc rCDdmTmcSc;
        if (bStart) {
            rCDdmTmcSc.enCommand=enMeca_DdmCommand_START;
            _u16ActivatedScidi=_u16CurrentComponent;
        } else {
            rCDdmTmcSc.enCommand=enMeca_DdmCommand_STOP;
        }
        rCDdmTmcSc.enCommand=bStart ? enMeca_DdmCommand_START : enMeca_DdmCommand_STOP;
        //rCDdmTmcSc.enServiceType=enGetServiceType();
        rCDdmTmcSc.u8Flags=  0x80 | 1; // send once 
        rCDdmTmcSc.rMecaProgrammeService= _rCurrentService;
        rCDdmTmcSc.u16SCIDI=_u16CurrentComponent;

        dabdrv_mecaIf::instance()->vSendMecaCommand(rCDdmTmcSc);
    }
}

/* receive all data-compoents of an audio-service
   next step: request component-info (uaids) for first received component
*/

tVoid dabdrv_tmcLearn::vProcess(trMeca_RDdmTmcSc* poTmcSc) {
    ETG_TRACE_USR1(("dabdrv_tmcLearn::vProcess(trMeca_RDdmTmcSc)"));
    (tVoid)poTmcSc;

    if (poTmcSc->enResponse != enMeca_DdmResponse_OK) {
        ETG_TRACE_USR1(("dabdrv_tmcLearn::vProcess(trMeca_RDdmTmcSc): FAILED (%d) SCIDI=0x%04x)",
                    ETG_CENUM(tenMeca_DdmResponse, poTmcSc->enResponse), 
                    poTmcSc->u16SCIDI));
    }
    // todo
}

// enable or disable tmc-mode
tVoid dabdrv_tmcLearn::vProcess(trMsgDrvSetTmcMode* poMsgDrvSetTmcMode) {
    
    ETG_TRACE_USR1(("dabdrv_tmcLearn::vProcess(trMsgDrvSetTmcMode) TMC activ = %d", poMsgDrvSetTmcMode->bEnable));

    if (poMsgDrvSetTmcMode->bEnable) {
        // enable TMC
        _bTmcActive = TRUE;
    } else {
        // disable TMC
        _bTmcActive = FALSE;
    }

    dabdrv_tmcParse::instance()->vSetTmcActivity(_bTmcActive);
}

tVoid dabdrv_tmcLearn::vProcess(trMeca_RDdmTmcEvent* poTmcEvent) {
    ETG_TRACE_USR1(("dabdrv_tmcLearn::vProcess(trMeca_RDdmTmcEvent)"));
    (tVoid)poTmcEvent;
}

tVoid dabdrv_tmcLearn::vProcess(trMeca_RDbQuery* poQuery) {
    
    ETG_TRACE_USR1(("dabdrv_tmcLearn::vProcess(trMeca_RDbQuery)"));

    tU32 u32Columns = 0;
    tU32 u32Rows    = 0;

    // midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus 
    if ( poQuery->u8QueryTag == (tU8)enMeca_QUERY_TAG_AVAIL_LIST ) 
    {
        tU32 l_result_length = (tU32)(poQuery->lu8UserData.size());
        if ( l_result_length == 0 )
            return;

        tU8* r_result = OSAL_NEW tU8[l_result_length]; 
        if (r_result == NULL)
            return;

        for(tU32 k=0; k<l_result_length; k++)
            r_result[k] = poQuery->lu8UserData[k];

        // get count of columns
        u32Columns = sdxf_table_get_num_columns(r_result, l_result_length);
        // get count of rows
        u32Rows = sdxf_table_get_num_rows(r_result, l_result_length);
        
        ETG_TRACE_USR1(("dabdrv_tmcLearn::vProcess(trMeca_RDbQuery) Columns: %d  Rows: %d",u32Columns, u32Rows));

        DAB_trTmcAvailListProperty rProperty= dabdrv_properties::instance()->oTmcAvailListProperty.oGet();

        if( u32Columns == 5) {

            vector<trTmcAvailListElem> vectorTmcAvailEntries;

            // get table with all tmc-servcies
            for (tU32 i=1; i<= u32Rows ;i++) {

                APIService api_service;
                tU8  api_service_type,u8Ltn,u8CaFlag;
                tU32 u32Scidi,u32Eid;

                
                sdxf_apiserviceblob_2_apiservicetype(&api_service_type, sdxf_chunk_get_blob(sdxf_table_get_chunk(r_result, l_result_length, i, 1)));
                ETG_TRACE_USR1(("dabdrv_tmcLearn::vProcess(trMeca_RDbQuery) Rows: %d Columns:1 api_service_type: %x",
                                                                               i,
                                                                               api_service_type));                

                sdxf_apiserviceblob_2_apiservice(&api_service, sdxf_chunk_get_blob(sdxf_table_get_chunk(r_result, l_result_length, i, 1)));
                ETG_TRACE_USR1(("dabdrv_tmcLearn::vProcess(trMeca_RDbQuery) Rows: %d Columns:2 l_data_service_id: %x ecc:%x ps:%x sid:%x",
                                                                               i,
                                                                               api_service.l_data_service_id, 
                                                                               api_service.r_programme_service.b_ecc,
                                                                               api_service.r_programme_service.b_programme_service_type,
                                                                               api_service.r_programme_service.w_service_id));

                //"SELECT MAKE_API_SERVICE(stype,servecc,sid),MAKE_SCIDI(tmid,id,ps,scids,scty),eid,ltn,ca_flag FROM v1f0_dab_tmc_service_component";

                u32Scidi  = sdxf_chunk_get_numeric_uint32(sdxf_table_get_chunk(r_result, l_result_length, i, 2));
                u32Eid    = sdxf_chunk_get_numeric_uint32(sdxf_table_get_chunk(r_result, l_result_length, i, 3));
                u8Ltn     = (tU8)sdxf_chunk_get_numeric_uint32(sdxf_table_get_chunk(r_result, l_result_length, i, 4));
				//lint -sem(sdxf_table_get_chunk,custodial(1))
                u8CaFlag  = (tU8)sdxf_chunk_get_numeric_uint32(sdxf_table_get_chunk(r_result, l_result_length, i, 5));
                ETG_TRACE_USR1(("dabdrv_tmcLearn::vProcess(trMeca_RDbQuery) Rows: %d u32Scidi:%x u32Eid:%x u8Ltn:%x u8CaFlag:%d",i,u32Scidi,u32Eid,u8Ltn,u8CaFlag));

                // fill structure
                trTmcAvailListElem rAvailListInfo;
                rAvailListInfo.rEnsembleId._u32Id = u32Eid;
                rAvailListInfo.u8NumberOfRdbIds = 1;    // each ensemble can handle one rdbid
                
                trMecaEnsemble rRefEnsemble;
                rRefEnsemble._u32Id = u32Eid;
                
                rAvailListInfo.u8Quality = dabdrv_chnList::instance()->u8GetReceptionQualityOfEnsemble(rRefEnsemble);
                rAvailListInfo.u32Scidi = u32Scidi;
                rAvailListInfo.rProgrammeService._enServiceType = (tenMeca_ServiceType)api_service.r_programme_service.b_programme_service_type;
                rAvailListInfo.rProgrammeService._u32Id = api_service.r_programme_service.w_service_id;
                rAvailListInfo.u8Ecc = api_service.r_programme_service.b_ecc;

                DAB_trTmcRdbId rTmcRdbId;
                rTmcRdbId.bEncrypted = u8CaFlag;
                rTmcRdbId.u16Bsa = 0;                   // only for XM radio
                rTmcRdbId.u8Cc = api_service.r_programme_service.b_ecc;
                rTmcRdbId.u8Ltn = u8Ltn;
                rTmcRdbId.u8Sid = (tU8)api_service.l_data_service_id;

                rAvailListInfo.vectorRdbIdEntries.push_back(rTmcRdbId);
                rProperty.vectorTmcAvailEntries.push_back(rAvailListInfo);
            }
        }

        if (rProperty.vectorTmcAvailEntries.size() != 0) {
            dabdrv_properties::instance()->oTmcAvailListProperty.vSet(rProperty);
        }

    }
}

// enMeca_DbRejectCode_DSID_INVALID
