/************************************************************************
 * FILE:    dabdrv_testmode.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  header of dabdrv_testmode
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DABDRV_TESTMODE_HPP
#define DABDRV_TESTMODE_HPP

#include "fc_dabtuner_util.h"
//#include "dabdrv_types.hpp"
#include "dabdrv_main.hpp"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_TESTMD 
#include "trcGenProj/Header/dabdrv_testmode.hpp.trc.h"
#endif

namespace DAB {



    struct trMsgTestModeTimer;
    struct trMsgDbQueryTimer;



    class dabdrv_testmode:
        public DAB_Singleton <dabdrv_testmode>,
        public DAB_MessageHandlerCommon<dabdrv_testmode>
    {
        friend class DAB_Singleton<dabdrv_testmode>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_TESTMD);
        virtual ~dabdrv_testmode();
        virtual char const *pcGetName() const {return "dabdrv_testmode";};
        virtual tVoid vTraceState() const;
        virtual tVoid vInit();
        virtual tVoid vDeInit();

        virtual tVoid vProcess(trMsgDrvStartComponentFirst* poMsgDrvStartComponentFirst);
        virtual tVoid vProcess(trMsgDrvSetTestMode* poMsgDrvSetTestMode);
        virtual tVoid vProcess(trMsgDrvSetBgTestMode* poMsgDrvSetBgTestMode);
        virtual tVoid vProcess(trMsgDrvTmcTpegData* poMsgDrvTmcTpegData);
        virtual tVoid vProcess(trMsgSrvGetExpApi* poMsgSrvGetExpApi);
        virtual tVoid vProcess(trMsgSrvCmdGetTestModeData* poMsgDrvSetTestMode);
		virtual tVoid vProcess(trMsgDrvUpdateLink* poMsgDrvUpdateLink);
		virtual tVoid vProcess(trMsgDrvAltFreqInfo* poMsgDrvAltFreqInfo);

        //virtual tVoid vProcess(trMeca_RSysVersionInfo *poRVersionInfo);
        virtual tVoid vProcess(trMeca_RExpIdValueLabel* poMsgRExpIdValueLabel);
        virtual tVoid vProcess(trMeca_RExpIdValueU32* poMsgRExpIdValueU32);
        virtual tVoid vProcess(trMeca_RExpIdDescription* poMsgRExpIdDescription);
        virtual tVoid vProcess(trMeca_RRdmGetAudioStatus *poRRdmGetAudioStatus);
        //virtual tVoid vProcess(trMeca_RRdmGetDabFrequencyTable *poRRdmGetDabFrequencyTable);
        virtual tVoid vProcess(trMeca_RRdmAudioGetAsid *poRRdmAudioGetAsid);
        virtual tVoid vProcess(trMeca_RDbServiceGetLinkInfo *poRDbServiceGetLinkInfo);

        virtual tVoid vProcess(trMsgDrvActivateComponentInfo* poMsgDrvActivateComponentInfo);
        virtual tVoid vProcess(trMsgDrvActivateServiceInfo* poMsgDrvActivateServiceInfo);
        virtual tVoid vProcess(trMsgDrvActivateEnsembleInfo* poMsgDrvActivateEnsembleInfo);

        virtual tVoid vProcess(trMeca_RDbSubchannelGetInfo *poRDbSubchannelGetInfo);
		/*virtual tVoid vProcess(trMeca_RDbServiceComponentGetInfo *poRDbServiceComponentGetInfo);
        virtual tVoid vProcess(trMeca_RDbEnsembleGetInfo *poRDbEnsembleGetInfo);
        virtual tVoid vProcess(trMeca_RDbServiceGetInfo *poRDbServiceGetInfo);
        virtual tVoid vProcess(trMeca_RDbServiceGetComponentList* poComponentList);*/
        virtual tVoid vProcess(trMeca_RRdmGetRdmInfo* poGetRdmInfo);
        virtual tVoid vProcess(trMeca_RRdmAudioGetScidi* poAudioGetScidi);
        virtual tVoid vProcess(trMsgSrvDbQueryTestmode* poDbQueryTestmode);

        virtual tVoid vProcess(trMeca_RDbQuery *poDbQuery);
        virtual tVoid vProcess(trMeca_RMtcTestmode* poMtcTestmode);
		virtual tVoid vProcess(trMeca_RRdmGetRdmStatus* poRdmStatus);
		virtual tVoid vProcess(trMeca_RExpSelect* poMsgRExpSelect);

        // pseudo-private
        virtual tVoid vProcess(trMsgTestModeTimer* poTestModeTimer);
        virtual tVoid vProcess(trMsgDbQueryTimer* poDbQueryTimer);
        virtual tVoid vProcess(trMsgSrvCmdExpSelect *porMsgSrvCmdExpSelect);
		
		tBool bIsTestmodeActive() const
		{
			return _bIsTestmodeActive;
		}

    private:
        dabdrv_testmode();   
        DAB_tclTimer _oTestModeTmr;
        DAB_tclTimer _oDbQueryTmr;
        trMecaProgrammeService _rRdmAsid;
        tU16 _u16RdmAscidi;
        typedef enum {
            enTestModeState_Off,
            enTestModeState_Collect,
            enTestModeState_Ready
        }tenTestModeState;
        tenTestModeState _enTestModeState;
        tVoid vStartCollect();
        tVoid vCollectServiceInfo();
        tVoid vDbQuery()const;
        tVoid vConfigure();
        tVoid vEmit();

        tBool bAddExpApiResult(tenExpApiRequest enRequest, tU16 u16ExpApiId, const tChar* pcValueText);

        tBool _bIsTestmodeActive;
        tBool _bIsBgTestmodeActive;
        tBool _bIsTmcTpegDataActive;
        tBool _bIsComponentInfoActive;
        tBool _bIsServiceInfoActive;
        tBool _bIsEnsembleInfoActive;
		tBool _bNewService;
		
        tBool _bTestModeDataGetPending;
	
        tU8 _u8RequestedDbQuery;
        tBool _bRequestDbQueryDone;
		tBool _bIsFSUpdatePending;
        DAB_trTestModeDataProperty _rTestModeData;
        DAB_trBgTestModeDataProperty _rBgTestModeData;
        DAB_trComponentInfoProperty _rComponentInfo;
        DAB_trServiceInfoProperty _rServiceInfo;
        
        vector<DAB::trMsgDrvRspGetExpApi>vecExpApiList;
        
        
        struct DAB_tclRegUtil {
            DAB_tclRegUtil(const char *pcPath):
                _pcPath(pcPath),
                _bOpen(FALSE)
            {};

            ~DAB_tclRegUtil() {
                vClose();
                _pcPath=OSAL_NULL;
            }

            tBool bOpen() {
                if (!_bOpen && _pcPath !=OSAL_NULL) {
                    _bOpen=_oReg.bOpen(_pcPath);
                    if (!_bOpen) {
                        ETG_TRACE_ERR(("dabdrv_testmode Open REG-path failed !!!"));
                    }
                }
                return _bOpen;
            };

            tVoid vClose() {
                if (_bOpen) {
                    _oReg.vClose();
                    _bOpen=FALSE;
                }
            };
            tBool bIsOpen() const {
                return _bOpen;
            };

            tBool bWrite(char const *pKey, char *pValue, tU32 u32Len) {
                tBool bSuccess=FALSE;
                if (bOpen()) {
                    ETG_TRACE_USR3(("dabdrv_testmode Write: key=%30s, value=%30s len=%d",
                                   pKey, pValue, u32Len));

                    bSuccess =_oReg.bSetString(pKey,pValue,u32Len);
                    if (!bSuccess) {
                        ETG_TRACE_ERR(("dabdrv_testmode Write REG failed !!!"));
                    }
                }
                return bSuccess;
            }
        private:
            char const *_pcPath;
            tBool _bOpen;
            reg_tclRegKey _oReg;
        };
    };


} //namespace DAB 

#endif
