/************************************************************************
 * FILE:  dabdrv_testmode.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  header of dabdrv_testmode
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "dabdrv_testmode.hpp"
#include "dabdrv_chnList.hpp"
#include "dabdrv_compList.hpp"
#include "dabdrv_chnInfo.hpp"
#include "dabdrv_presets.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_TESTMD
#include "trcGenProj/Header/dabdrv_testmode.cpp.trc.h"
#endif

/*#define DAB_REGISTRY_DABMODULE_DATE_KEY_NAME     "DABMODULE_DATE"
#define DAB_REGISTRY_DABMODULE_SW_VER_KEY_NAME   "DABMODULE_SW_VERSION"
#define DAB_REGISTRY_DABMODULE_HW_VER_KEY_NAME   "DABMODULE_HW_VERSION"
//#define DAB_REGISTRY_DABMODULE_CRC_KEY_NAME      "DABMODULE_CRC"
#define DAB_MODUL_VERSION_STRING_LEN 10
#define DAB_MODUL_VERSION_SW_OFFSET 3
#define DAB_MODUL_VERSION_HW_OFFSET 17*/


#ifndef __RFC3072_HELPER_H__
#include "rfc3072_helper.h"
#endif


using namespace DAB;

namespace DAB {

    // Timer
    // a timer-event
    struct trMsgTestModeTimer:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "dabdrv_trMsgTestModeTimer"));
        };
    };
    struct trMsgDbQueryTimer:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG,
                                "trMsgDbQueryTimer"));
        };
    };

}


dabdrv_testmode::dabdrv_testmode(tVoid)
{
    _u16RdmAscidi=0;
    _enTestModeState = enTestModeState_Off; 
    _bIsTestmodeActive = FALSE;
    _bIsBgTestmodeActive = FALSE;
    _bIsTmcTpegDataActive = FALSE;
    _bIsComponentInfoActive = FALSE;
    _bIsServiceInfoActive = FALSE;
    _bIsEnsembleInfoActive = FALSE;
	_bNewService = FALSE;
    _bTestModeDataGetPending = FALSE;
	_bIsFSUpdatePending = TRUE;
    _u8RequestedDbQuery = 1;
    _bRequestDbQueryDone = TRUE;

    // subsribe
    vSubscribe<trMsgDrvStartComponentFirst>();
    vSubscribe<trMsgDrvSetTestMode>();
    vSubscribe<trMsgDrvSetBgTestMode>();
    vSubscribe<trMsgDrvTmcTpegData>();
    vSubscribe<trMsgSrvCmdGetTestModeData>();
    vSubscribe<trMsgSrvGetExpApi>();
	vSubscribe<trMsgDrvUpdateLink>();

    //vSubscribe<trMeca_RSysVersionInfo>();
    vSubscribe<trMeca_RExpIdValueLabel>();
    vSubscribe<trMeca_RExpIdValueU32>();
    vSubscribe<trMeca_RExpIdDescription>();

    vSubscribe<trMeca_RRdmGetAudioStatus>();

    vSubscribe<trMeca_RRdmAudioGetAsid>();
    //Response for Service Link Info -- KVA4KOR
    vSubscribe<trMeca_RDbServiceGetLinkInfo>();

    
    vSubscribe<trMsgDrvActivateComponentInfo>();
    vSubscribe<trMsgDrvActivateServiceInfo>();
    vSubscribe<trMsgDrvActivateEnsembleInfo>();

    vSubscribe<trMeca_RDbSubchannelGetInfo>();
  /* removed due to high load caused NCG3D-130978 
     vSubscribe<trMeca_RDbServiceComponentGetInfo>();
	vSubscribe<trMeca_RDbEnsembleGetInfo>();
    vSubscribe<trMeca_RDbServiceGetInfo>();
    vSubscribe<trMeca_RDbServiceGetComponentList>();*/
    vSubscribe<trMeca_RRdmGetRdmInfo>();
    vSubscribe<trMeca_RRdmAudioGetScidi>();
    vSubscribe<trMsgSrvDbQueryTestmode>();
    
    vSubscribe<trMeca_RDbQuery>();
    vSubscribe<trMeca_RMtcTestmode>();
	vSubscribe<trMeca_RRdmGetRdmStatus>();
	vSubscribe<trMsgDrvAltFreqInfo>();
	vSubscribe<trMsgSrvCmdExpSelect>();
	vSubscribe<trMeca_RExpSelect>();
}


dabdrv_testmode::~dabdrv_testmode(tVoid) {
	_oDbQueryTmr.vStop();
}

tVoid dabdrv_testmode::vTraceState() const {
    ETG_TRACE_USR1(("  dabdrv_testmode STATE: _enTestModeState=%d",
                    ETG_CENUM(tenTestModeState, _enTestModeState) ));    
}

tVoid dabdrv_testmode::vInit() {
    // timer can not be created in constructor
    _oTestModeTmr.vInit(instance(),trMsgTestModeTimer());
    _oDbQueryTmr.vInit(instance(),trMsgDbQueryTimer());

    //_rTestModeData.bDataValid=FALSE;
    dabdrv_properties::instance()->oTestModeDataProperty.vInit(_rTestModeData);
    // make sure that on next property.set at least bDataValid has changed:
    _rTestModeData.bDataValid=TRUE;
}

tVoid dabdrv_testmode::vDeInit() {
    _oTestModeTmr.vDeInit();
    _oDbQueryTmr.vDeInit();
}
// receive label-values for selected value-ids from meca-exp
tVoid dabdrv_testmode::vProcess(trMeca_RExpIdValueLabel* poMsgRExpIdValueLabel) {
    (tVoid)poMsgRExpIdValueLabel;
    return;
}

// receive u32-values for selected value-ids from meca-exp
tVoid dabdrv_testmode::vProcess(trMeca_RExpIdValueU32* poMsgRExpIdValueU32) {

	ETG_TRACE_USR1((" trMeca_RExpIdValueU32: _bIsTestmodeActive: %d", _bIsTestmodeActive));
    if( _bIsTestmodeActive == FALSE ){

    	if(poMsgRExpIdValueU32->enValueId == enMeca_ExpValueId_FieldStrength){

    		trMsgSrvRspExpIdValueU32 idValueU32(enMeca_ExpValueId_FieldStrength,poMsgRExpIdValueU32->u32Value);
    		DAB_vCallMsg(idValueU32	);
    	}

        return;
    }

    // convert hex to ascii
    tChar sExpIdValueText[7];
    OSAL_s32PrintFormat(sExpIdValueText, "0x%x", (tU16)(poMsgRExpIdValueU32->u32Value));
    bAddExpApiResult( DAB_enExpApiRequest_Value, (tU16)(poMsgRExpIdValueU32->enValueId), sExpIdValueText );

    //lint -e{788} enum constant '...' not used within defaulted switch
    switch (poMsgRExpIdValueU32->enValueId) {
        case enMeca_ExpValueId_BBE:
            _rTestModeData.u32BBE=poMsgRExpIdValueU32->u32Value;
            ETG_TRACE_USR1(("  dabdrv_testmode: BBE: %d", poMsgRExpIdValueU32->u32Value));
            break;
        case enMeca_ExpValueId_DabMode:
            _rTestModeData.u8DabMode=(tU8)poMsgRExpIdValueU32->u32Value;
            ETG_TRACE_USR1(("  dabdrv_testmode: Mode: %d", poMsgRExpIdValueU32->u32Value));
            break;
        case enMeca_ExpValueId_MSCBER:
			if(poMsgRExpIdValueU32->u32Value != 0xffffffff) //NCG3D-79576
			{
				_rTestModeData.u32MSCBER=poMsgRExpIdValueU32->u32Value;
			}
            ETG_TRACE_USR1(("  dabdrv_testmode: MSCBER: %d", poMsgRExpIdValueU32->u32Value));
            break;
        case enMeca_ExpValueId_FICBER:
			if(poMsgRExpIdValueU32->u32Value != 0xffffffff) //NCG3D-79576
			{
				_rTestModeData.u32FICBER=poMsgRExpIdValueU32->u32Value;
			}
            ETG_TRACE_USR1(("  dabdrv_testmode: FICBER: %d", poMsgRExpIdValueU32->u32Value));
            break;
	    case enMeca_ExpValueId_NETBER:
			if(poMsgRExpIdValueU32->u32Value != 0xffffffff) //NCG3D-79576
			{
			 _rTestModeData.u32NETBER=poMsgRExpIdValueU32->u32Value;
			}
            ETG_TRACE_USR1(("  dabdrv_testmode: NETBER: %d", poMsgRExpIdValueU32->u32Value));
            break;
        case enMeca_ExpValueId_FieldStrength:
            _rTestModeData.u32FieldStrength=poMsgRExpIdValueU32->u32Value;
			_bIsFSUpdatePending = FALSE;
            ETG_TRACE_USR1(("  dabdrv_testmode: FieldStrength: %d", poMsgRExpIdValueU32->u32Value));
            break;
        case enMeca_ExpValueId_RSFEC:
            _rTestModeData.u8RSFEC = (tU8)poMsgRExpIdValueU32->u32Value;
            ETG_TRACE_USR1(("  dabdrv_testmode: RS-FEC: %d", poMsgRExpIdValueU32->u32Value));
            break;
		//Not required in gen3 as we do not update any registry with crc
        /*case enMeca_ExpValueId_Crc:
        {
            DAB_tclRegUtil oReg(DAB_REGISTRY_VERSIONS);
            ETG_TRACE_USR1(("  dabdrv_testmode: DAB MODUL DabModuleCrc: 0x%08x", poMsgRExpIdValueU32->u32Value));
            char cCrc[DAB_MODUL_VERSION_STRING_LEN + 1];
            sprintf(cCrc, "%08x", poMsgRExpIdValueU32->u32Value);
            oReg.bWrite(DAB_REGISTRY_DABMODULE_CRC_KEY_NAME,cCrc,8);
            break;
        }*/
        /*** Background dab tuner information ***/
        case enMeca_ExpValueId_Bg_Frequency:
        {
            _rBgTestModeData.u32BgFrequency=poMsgRExpIdValueU32->u32Value;
            ETG_TRACE_USR1(("  Bg dabdrv_testmode: u32BgFrequency: %d", poMsgRExpIdValueU32->u32Value));
            break;
        }
        case enMeca_ExpValueId_Bg_EnsId:
        {
            _rBgTestModeData.u32BgCurrentEnsID=poMsgRExpIdValueU32->u32Value;
            ETG_TRACE_USR1(("  Bg dabdrv_testmode: u32BgEnsId: %x", poMsgRExpIdValueU32->u32Value));
            break;
        }
        case enMeca_ExpValueId_Bg_FIC:
        {
            _rBgTestModeData.u32BgFICBER=poMsgRExpIdValueU32->u32Value;
            ETG_TRACE_USR1(("  Bg dabdrv_testmode: u32BgFICBER: %d", poMsgRExpIdValueU32->u32Value));
            break;
        }
        case enMeca_ExpValueId_Bg_SYNC:
        {
            _rBgTestModeData.u16BgFlags=(tU16)poMsgRExpIdValueU32->u32Value;
            ETG_TRACE_USR1(("  Bg dabdrv_testmode: u16BgFlags: %x", poMsgRExpIdValueU32->u32Value));
            break;
        }
#if 0
        case enMeca_ExpValueId_Modul_Info_Bg:
        {
            //poMsgRExpIdValueU32->u32Value;
            //OSALUTIL_szSaveStringNCopy(_rBgTestModeData.sBgDabMode,poMsgRExpIdDescription->sIdDescription, DABTUN_EXP_ID_DESCRIPTION_BUFFER);
            (tVoid)OSAL_szStringCopy(_rBgTestModeData.sBgDabMode, "TEST");

            ETG_TRACE_USR1(("  Bg dabdrv_testmode: BgMode: %d", poMsgRExpIdValueU32->u32Value));
            break;
        }
#endif
        case enMeca_ExpValueId_Num_Tpeg_Svcs:
        {
            DAB_trTmcTpegInfoProperty rProperty= dabdrv_properties::instance()->oTmcTpegInfoProperty.oGet();
            rProperty.u8NumOfTpegServices = (tU8)(poMsgRExpIdValueU32->u32Value);
            dabdrv_properties::instance()->oTmcTpegInfoProperty.vSet(rProperty);
            ETG_TRACE_USR1(("  dabdrv_testmode: NUM_TPEG_SVCS: %d", poMsgRExpIdValueU32->u32Value));
            break;
        }
        case enMeca_ExpValueId_Num_Tmc_Svcs:
        {
            DAB_trTmcTpegInfoProperty rProperty= dabdrv_properties::instance()->oTmcTpegInfoProperty.oGet();
            rProperty.u8NumOfTmcServices = (tU8)(poMsgRExpIdValueU32->u32Value);
            dabdrv_properties::instance()->oTmcTpegInfoProperty.vSet(rProperty);
            ETG_TRACE_USR1(("  dabdrv_testmode: NUM_TMC_SVCS: %d", poMsgRExpIdValueU32->u32Value));
            break;
        }
        /*** Background dab tuner information ***/
        default:
            break;
    }
}

tVoid dabdrv_testmode::vProcess(trMeca_RExpIdDescription* poMsgRExpIdDescription) {

    if( _bIsTestmodeActive == FALSE )
        return;

    //lint -e{788} enum constant '...' not used within defaulted switch
    ETG_TRACE_USR1(("  dabdrv_testmode:vProcess(trMeca_RExpIdDescription) %s", poMsgRExpIdDescription->rExpLabel.oUtf8Label.pcGetCString()));

    bAddExpApiResult( DAB_enExpApiRequest_Description, (tU16)poMsgRExpIdDescription->enValueId, poMsgRExpIdDescription->rExpLabel.oUtf8Label.pcGetCString());

    switch (poMsgRExpIdDescription->enValueId) {
        case enMeca_ExpValueId_Modul_Info_Bg:
        {
            OSALUTIL_szSaveStringNCopy(_rBgTestModeData.sBgDabMode,poMsgRExpIdDescription->rExpLabel.oUtf8Label.pcGetCString(), DABTUN_EXP_ID_DESCRIPTION_BUFFER);
            ETG_TRACE_USR1(("  Bg dabdrv_testmode: enMeca_ExpValueId_Modul_Info_Bg rExpLabel: %s", poMsgRExpIdDescription->rExpLabel.oUtf8Label.pcGetCString()));
            break;
        }
        default:
            ETG_TRACE_USR1(("  dabdrv_testmode:vProcess(trMeca_RExpIdDescription) !!!!  NOT HANDLED: %d  %s", poMsgRExpIdDescription->enValueId, poMsgRExpIdDescription->rExpLabel.oUtf8Label.pcGetCString()));
    }
}


tBool dabdrv_testmode::bAddExpApiResult(tenExpApiRequest enRequest, tU16 u16ExpApiId, const tChar* pcValueText) {

    tBool bRetVal = FALSE;
    // search in list if this id was requested

    ETG_TRACE_USR1(("  dabdrv_testmode::bAddExpApiResult ExpApi=%x enRequest=%d sValueText: %s",
                                                    u16ExpApiId,
                                                    ETG_CENUM(tenExpApiRequest,enRequest),
                                                    pcValueText));

    std::vector<trMsgDrvRspGetExpApi>::iterator it;
    for( it = vecExpApiList.begin() ; it < vecExpApiList.end() ; it ++ ) 
    {
        if( (it)->u16ExpApiId == u16ExpApiId ) 
        {
            trMsgDrvRspGetExpApi rExpApiElem;
            rExpApiElem.u16ExpApiId = (it)->u16ExpApiId;

            if( enRequest == DAB_enExpApiRequest_Description ) {
                //(tVoid)OSAL_szStringCopy((it)->pcDescription, pcValueText);
            	(tVoid)OSAL_szStringNCopy((it)->pcDescription, pcValueText, sizeof(it->pcDescription)-1);
                (it)->bDescriptionValid = TRUE;
                ETG_TRACE_USR1(("  dabdrv_testmode: ExpApi=%x sTextLabel:%s",
                                            (it)->u16ExpApiId,
                                            rExpApiElem.pcDescription));
                if ((it)->bValueValid == FALSE) {
                	trMeca_CExpSelect oCExpSelect;
                	oCExpSelect.enAction=enMeca_ExpAction_ENABLE_AUTO_UPDATE;
              	    oCExpSelect.enValueId=(tenMeca_ExpValueId)u16ExpApiId;
              	    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect);
                }

            }
            else {
                bRetVal = TRUE;
                //(tVoid)OSAL_szStringCopy((it)->pcValueLabel, pcValueText);
                (tVoid)OSAL_szStringNCopy((it)->pcValueLabel, pcValueText, sizeof(it->pcValueLabel)-1);
                (it)->bValueValid = TRUE;
                ETG_TRACE_USR1(("  dabdrv_testmode: ExpApi=%x sValueLabel: %s",
                                            (it)->u16ExpApiId, 
                                            rExpApiElem.pcValueLabel));
            }

            (tVoid)OSAL_szStringCopy(rExpApiElem.pcDescription, (it)->pcDescription);
            (tVoid)OSAL_szStringCopy(rExpApiElem.pcValueLabel,(it)->pcValueLabel);

            if (((it)->bDescriptionValid==TRUE)&&((it)->bValueValid==TRUE)) {
                DAB_vCallMsg(rExpApiElem);
                vecExpApiList.erase (it);
            }
            break;
        }
    }
    return bRetVal;
}

void dabdrv_testmode::vProcess(trMsgSrvCmdExpSelect *porMsgSrvCmdExpSelect) {

	trMeca_CExpSelect oCExpSelect;
	oCExpSelect.enAction = porMsgSrvCmdExpSelect->enAction;
	oCExpSelect.enValueId = porMsgSrvCmdExpSelect->enValueId;
	dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect);
}

void dabdrv_testmode::vProcess(trMeca_RRdmGetAudioStatus *poRRdmGetAudioStatus) {

   /* if(_bIsTestmodeActive == FALSE && _bTestModeDataGetPending==FALSE)
        return;*/

	if(poRRdmGetAudioStatus->enRdmMode == enMeca_RdmMode_DAB_FG_AUDIO){
    ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMeca_RRdmGetAudioStatus):u16BitRateKbps=%d", poRRdmGetAudioStatus->rAudioStatus.u16BitRateKbps));

    _rServiceInfo.u16BitRateKbps = poRRdmGetAudioStatus->rAudioStatus.u16BitRateKbps;
    _rServiceInfo.enSampleRate = (DAB_tenSampleRate)(poRRdmGetAudioStatus->rAudioStatus.enAlgorithm);
    _rServiceInfo.enAudioMode = poRRdmGetAudioStatus->rAudioStatus.enAudioMode;
    _rServiceInfo.enAudioCodec = poRRdmGetAudioStatus->enRdmMode;  
    ETG_TRACE_USR1(("  dabdrv_testmode: bSBRFlag=%d bPSFlag=%d",   _rServiceInfo.bSBRFlag , _rServiceInfo.bPSFlag));
}
	else if(poRRdmGetAudioStatus->enRdmMode == enMeca_RdmMode_DAB_DMB){
		ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMeca_RRdmGetAudioStatus):u16BitRateKbps=%d", poRRdmGetAudioStatus->rDMBAudioStatus.u16AudioBitrate));

		_rServiceInfo.u16BitRateKbps = poRRdmGetAudioStatus->rDMBAudioStatus.u16AudioBitrate;
		tU8 u8SampleRate = (tU8)poRRdmGetAudioStatus->rDMBAudioStatus.enCoreAudioConfig;
		_rServiceInfo.enSampleRate = (DAB_tenSampleRate)u8SampleRate;
		_rServiceInfo.enAudioMode = (tenMeca_RdmAudioMode)poRRdmGetAudioStatus->rDMBAudioStatus.enDMBAudioMode;
		tU8 u8ChannelType = (tU8)poRRdmGetAudioStatus->rDMBAudioStatus.enChannelType;
		_rServiceInfo.enAudioCodec = (tenMeca_RdmMode)u8ChannelType;
		trMeca_CDbSubchannelGetInfo oCDbSubchannelGetInfo;
		oCDbSubchannelGetInfo.u8SubchId=poRRdmGetAudioStatus->rDMBAudioStatus.u8SubChId;
		_rServiceInfo.enAudioCoding=poRRdmGetAudioStatus->rDMBAudioStatus.enCoreAudioConfig;
		dabdrv_mecaIf::instance()->vSendMecaCommand(oCDbSubchannelGetInfo);
		_rServiceInfo.bSBRFlag = poRRdmGetAudioStatus->rDMBAudioStatus.enSBRFlag;
		_rServiceInfo.bPSFlag = poRRdmGetAudioStatus->rDMBAudioStatus.enPSFlag;
		ETG_TRACE_USR1(("  dabdrv_testmode: bSBRFlag=%d bPSFlag=%d",   _rServiceInfo.bSBRFlag , _rServiceInfo.bPSFlag));
	}
	if(_bNewService)
	{
		dabdrv_properties::instance()->oServiceInfoProperty.vSet(_rServiceInfo);
		_bNewService = FALSE;
	}
}
/*void dabdrv_testmode::vProcess(trMeca_RRdmGetDabFrequencyTable *poRRdmGetDabFrequencyTable) {
    
    ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMeca_RRdmGetDabFrequencyTable):enFrequencyTable=0x%x", poRRdmGetDabFrequencyTable->enFrequencyTable ));
    // todo
}*/


void dabdrv_testmode::vProcess(trMeca_RRdmAudioGetAsid *poRRdmAudioGetAsid) {

    tU8 u8NumberLinkedServices = 0;
    // get LINK_INFO
    trMeca_CDbServiceGetLinkInfo oCDbServiceGetLinkInfo;
    _rRdmAsid = poRRdmAudioGetAsid->rMecaProgrammeService;
    if (_rRdmAsid.bIsValid()) {

        ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMeca_RRdmAudioGetAsid):rMecaProgrammeService._u32Id=%08x", poRRdmAudioGetAsid->rMecaProgrammeService._u32Id));
	//trMsgDrvDbQuery rDbQuery(Query_SelfLearnedLinkInfo);
	//DAB_vCallMsg(rDbQuery);

	//Query for alternate DAB/DMB frequencies
	// rDbQueryAltFreq(Query_AltFreqInformation);
	//DAB_vCallMsg(rDbQueryAltFreq);
        
        _rTestModeData.vecLinkList.clear();
        _rTestModeData.vecAltFreqInfo.clear();

        //Subscribing for Service Link Info -- KVA4KOR
       oCDbServiceGetLinkInfo.rProgrammeService = _rRdmAsid;
       dabdrv_mecaIf::instance()->vSendMecaCommand(oCDbServiceGetLinkInfo);
        // peha test: trace ensembles of this service from db
        // get Ensemble ID
        set<trMecaEnsemble>lEnsembles;
        tU32 u32SID=poRRdmAudioGetAsid->rMecaProgrammeService.u32GetSID();
        dabdrv_chnList::instance()->vGetEnsemblesOfProgSrv(poRRdmAudioGetAsid->rMecaProgrammeService.u32GetSID(), lEnsembles);
        DAB_FOREACH(set<trMecaEnsemble>, ensIter, lEnsembles) {
            u8NumberLinkedServices++;
            // create LinkListElem and add data
            trLinkListElem rLinkListElem;

            ETG_TRACE_USR4(("dabdrv_testmode::RRdmAudioGetAsid:: ensemble:0x04%x",
                ensIter->u32GetID()));
            rLinkListElem.u32EnsembleId = (*ensIter).u32GetID();
            rLinkListElem.u8Quality = dabdrv_chnList::instance()->u8GetReceptionQualityOfEnsemble((*ensIter));
            // get SID/PI
            //todo: peha:which SID/PI???, I think using EID is not OK, changed to SID of poRRdmAudioGetAsid
            //            rLinkListElem.u32Id = (*ensIter).u32GetID(); 
            rLinkListElem.u32Id=u32SID;
            // add link type (allways DB)
            rLinkListElem.enLinkType = enLinkType_DAB_NOLINK; 

            // add link list elem to member-list
            _rTestModeData.vecLinkList.push_back(rLinkListElem);
        }

        _rTestModeData.u16TotalNumberLinks = u8NumberLinkedServices;
		if((_bIsTestmodeActive)&&(!_bIsFSUpdatePending))
		{
		dabdrv_properties::instance()->oTestModeDataProperty.vSet(_rTestModeData);
		}
    }
    
}

void dabdrv_testmode::vProcess(trMeca_RDbServiceGetLinkInfo *poRDbServiceGetLinkInfo) {

    // get LINK_INFO
    ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMeca_RDbServiceGetLinkInfo):u8NumberLinkedServices=%d", poRDbServiceGetLinkInfo->u8NumberLinkedServices));

    // check if required PSID is same to reference PSID
    if ( _rRdmAsid == poRDbServiceGetLinkInfo->rRefProgrammeService) {

        ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMeca_RDbServiceGetLinkInfo): _rRdmAsid == rRefProgrammeService =%d", _rRdmAsid.u32GetSID()));

        // get number of linked services
        tU8 u8NumberLinkedServices = poRDbServiceGetLinkInfo->u8NumberLinkedServices;
        // response_status (one and only, first, intermediate, last)
        if( poRDbServiceGetLinkInfo->enResponseStatus == enMeca_DbLinkResponseStatus_ONEANDONLY_LINK || 
            poRDbServiceGetLinkInfo->enResponseStatus == enMeca_DbLinkResponseStatus_FIRST_LINK  )   {
             _rTestModeData.vecLinkList.clear();
        }
        
        // b_flags -> b0 (link is active)
        //poRDbServiceGetLinkInfo->u16Lsn;

        // add number of linked services
        _rTestModeData.u16TotalNumberLinks = u8NumberLinkedServices;

        // handle vector only when linked services are available
        if ( u8NumberLinkedServices > 0 ){

            vector<trLinkListElem> rLinkList;

            //get linked_programme_services -> list of all PSID?s
            vector<trMecaProgrammeService> lLinkedServices;
            lLinkedServices = poRDbServiceGetLinkInfo->lLinkedServices;

            DAB_FOREACH(vector<trMecaProgrammeService>, iter, poRDbServiceGetLinkInfo->lLinkedServices) {

                // create LinkListElem and add data
                trLinkListElem rLinkListElem;
                // w_lsn -> link type -> b13 (hard, softlink)
                rLinkListElem.enLinkType = (tenLinkType)DAB_BOOL_FROM_BIT(poRDbServiceGetLinkInfo->u16Lsn, DAB_b13);

                // get Ensemble ID
                set<trMecaEnsemble>lEnsembles;
                dabdrv_chnList::instance()->vGetEnsemblesOfProgSrv(poRDbServiceGetLinkInfo->rRefProgrammeService.u32GetSID(), lEnsembles);

                // todo : ist das gleich dem oberen ?
                DAB_FOREACH(set<trMecaEnsemble>, iter2, lEnsembles) {
                    rLinkListElem.u32EnsembleId = (*iter2).u32GetID();
                    rLinkListElem.u8Quality = dabdrv_chnList::instance()->u8GetReceptionQualityOfEnsemble((*iter2));
                }

                // get SID/PI
                rLinkListElem.u32Id = (*iter).u16GetSID(); 

                // add link list elem to member-list
                _rTestModeData.vecLinkList.push_back(rLinkListElem);
            }
        }
		if((_bIsTestmodeActive)&&(!_bIsFSUpdatePending))
		{
		dabdrv_properties::instance()->oTestModeDataProperty.vSet(_rTestModeData);
		}
    }
}

// request basic diag-info from dab-module
tVoid dabdrv_testmode::vProcess(trMsgDrvStartComponentFirst* poMsgDrvStartComponentFirst) {
    (tVoid)poMsgDrvStartComponentFirst;
    //dabdrv_mecaIf::instance()->vSendMecaCommandCtor(trMeca_CSysVersionInfo());
	//Not required in gen3 as we do not update any registry with crc
    /*trMeca_CExpSelect oCExpSelect;
    oCExpSelect.enAction=enMeca_ExpAction_UPDATE_VALUE;
    oCExpSelect.enValueId=enMeca_ExpValueId_Crc;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect);*/
}



/*tVoid dabdrv_testmode::vProcess(trMeca_RSysVersionInfo *poRVersionInfo) {

char acDabProductName[DAB_MECA_SYS_VER_MAX_STR_LEN + 1];   //     helper object to construct Version String
    (tVoid)OSAL_szStringCopy(acDabProductName, poRVersionInfo->sProductName);

    ETG_TRACE_USR4(("  dabdrv_testmode::vProcess(trMeca_RSysVersionInfo): sProductName=%32s sVersionTag=%32s sVersionDate=%32s",
                    poRVersionInfo->sProductName,
                    poRVersionInfo->sVersionTag,
                    poRVersionInfo->sVersionDate));
    
    
    DAB_tclRegUtil oReg(DAB_REGISTRY_VERSIONS);
    // SW-version
    acDabProductName[DAB_MODUL_VERSION_SW_OFFSET + DAB_MODUL_VERSION_STRING_LEN]=0;
    oReg.bWrite(DAB_REGISTRY_DABMODULE_SW_VER_KEY_NAME,acDabProductName+DAB_MODUL_VERSION_SW_OFFSET,DAB_MODUL_VERSION_STRING_LEN);
    // HW-version
    acDabProductName[DAB_MODUL_VERSION_HW_OFFSET + DAB_MODUL_VERSION_STRING_LEN]=0;
    oReg.bWrite(DAB_REGISTRY_DABMODULE_HW_VER_KEY_NAME,acDabProductName+DAB_MODUL_VERSION_HW_OFFSET,DAB_MODUL_VERSION_STRING_LEN);
    // Date
    oReg.bWrite(DAB_REGISTRY_DABMODULE_DATE_KEY_NAME,poRVersionInfo->sVersionDate,DAB_MECA_SYS_VER_MAX_STR_LEN);
}*/

// enable or disable test-mode
tVoid dabdrv_testmode::vProcess(trMsgDrvSetTestMode* poMsgDrvSetTestMode) {

    ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMsgDrvSetTestMode):bEnable=%d", poMsgDrvSetTestMode->bEnable));
    if (poMsgDrvSetTestMode->bEnable) {
        _bIsTestmodeActive = TRUE;
        _bIsFSUpdatePending = TRUE;
        if (_enTestModeState == enTestModeState_Off) {
            _enTestModeState = enTestModeState_Ready;
            vStartCollect();            
        }

        // enable remote access for tune ensemble and tune service in testmode
        trMsgSrvCmdTestOperation rTestOp;
        
        //rTestOp.enTestOperation=DAB_enTestOperation_REMOTE_CTRL_ENTER;
        //DAB_vCallMsg(&rTestOp);

        rTestOp.enTestOperation=DAB_enTestOperation_TESTMODE_ACTIVE;
        DAB_vCallMsg(&rTestOp);

    } else {
        if (_enTestModeState != enTestModeState_Off) {
            _bIsTestmodeActive = FALSE;
            trMsgDrvCmdSetRdmNotifyMode rRdmNotifyMode;
            DAB_vCallMsg(rRdmNotifyMode);
            _oTestModeTmr.vStop();
            _enTestModeState = enTestModeState_Off;
            vConfigure();
        }

        // disable remote access for tune ensemble and tune service in testmode
        /*trMsgSrvCmdTestOperation rTestOp;
        rTestOp.enTestOperation=DAB_enTestOperation_REMOTE_CTRL_LEAVE;
        DAB_vCallMsg(&rTestOp);*/
    }
}

// enable or disable test-mode data for background dab tuner
tVoid dabdrv_testmode::vProcess(trMsgDrvSetBgTestMode* poMsgDrvSetBgTestMode) {

    ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMsgDrvSetBgTestMode):bEnable=%d", poMsgDrvSetBgTestMode->bEnable));
    _bIsBgTestmodeActive = poMsgDrvSetBgTestMode->bEnable;
}

// enable or disable test-mode data of Tmc and Tpeg data
tVoid dabdrv_testmode::vProcess(trMsgDrvTmcTpegData* poMsgDrvTmcTpegData) {

    ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMsgDrvTmcTpegData):bEnable=%d", poMsgDrvTmcTpegData->bEnable));
    _bIsTmcTpegDataActive = poMsgDrvTmcTpegData->bEnable;
}

// request of expert api values
tVoid dabdrv_testmode::vProcess(trMsgSrvGetExpApi* poMsgSrvGetExpApi) {

    ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMsgSrvGetExpApi):bu16ExpApiId=%x", poMsgSrvGetExpApi->u16ExpApi));
    
    // special method to handle received id
    // vector list with push/pop to handle all elements.

    //expapi-id(tU16), labeltext(tChar[16]), label-value(tChar[16]), element complete(tU8)
    trMeca_CExpSelect oCExpSelect;
    oCExpSelect.enAction= enMeca_ExpAction_UPDATE_DESCRIPTION;
    oCExpSelect.enValueId=(tenMeca_ExpValueId)(poMsgSrvGetExpApi->u16ExpApi);
    // enter data to vector-list 
    trMsgDrvRspGetExpApi rExpApiElem;
    rExpApiElem.u16ExpApiId = poMsgSrvGetExpApi->u16ExpApi;
    vecExpApiList.push_back(rExpApiElem);

    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect);
}

tVoid dabdrv_testmode::vProcess(trMsgSrvCmdGetTestModeData* poMsgDrvSetTestMode) {
    (tVoid)poMsgDrvSetTestMode;
    if (_bTestModeDataGetPending) {
        return;
    }
    _bTestModeDataGetPending=TRUE;
    if (_enTestModeState != enTestModeState_Collect) {
        // we enter test-mode or adr was down
        _enTestModeState = enTestModeState_Ready;

        vStartCollect();
    }
}



// enable or disable test-mode
tVoid dabdrv_testmode::vProcess(trMsgDrvActivateComponentInfo* poMsgDrvActivateComponentInfo) {
    ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMsgDrvActivateComponentInfo):bEnable=%d", poMsgDrvActivateComponentInfo->bEnable));
    if (poMsgDrvActivateComponentInfo->bEnable) {
        _bIsComponentInfoActive = TRUE;
    }else {
        _bIsComponentInfoActive = FALSE;
    }
}

tVoid dabdrv_testmode::vProcess(trMsgDrvActivateServiceInfo* poMsgDrvActivateServiceInfo) {
    ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMsgDrvActivateServiceInfo):bEnable=%d", poMsgDrvActivateServiceInfo->bEnable));
    if (poMsgDrvActivateServiceInfo->bEnable) {
        _bIsServiceInfoActive = TRUE;
    }else {
        _bIsServiceInfoActive = FALSE;
    }
}

tVoid dabdrv_testmode::vProcess(trMsgDrvActivateEnsembleInfo* poMsgDrvActivateEnsembleInfo) {
    ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMsgDrvActivateEnsembleInfo):bEnable=%d", poMsgDrvActivateEnsembleInfo->bEnable));
    if (poMsgDrvActivateEnsembleInfo->bEnable) {
        _bIsEnsembleInfoActive = TRUE;
    }else {
        _bIsEnsembleInfoActive = FALSE;
    }
}
  /* removed due to high load caused NCG3D-130978 
tVoid dabdrv_testmode::vProcess(trMeca_RDbServiceComponentGetInfo *poRDbServiceComponentGetInfo)
{
    //if (_bIsTestmodeActive == FALSE)
    //    return;

    ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMeca_RDbServiceComponentGetInfo):enServiceType=%d", poRDbServiceComponentGetInfo->enServiceType));

    _rRdmAsid.vTrace();
    poRDbServiceComponentGetInfo->rService.vTrace();

    ETG_TRACE_USR4(("_u16RdmAscidi=%d u16SCIDI = %d", _u16RdmAscidi, poRDbServiceComponentGetInfo->u16SCIDI));
    if (_rRdmAsid !=poRDbServiceComponentGetInfo->rService ||
        _u16RdmAscidi!=poRDbServiceComponentGetInfo->u16SCIDI) {
        return;
    }

    _rTestModeData.u8Flags = poRDbServiceComponentGetInfo->u8Flags;
    _rServiceInfo.u8NumberOfAudioComponents = dabdrv_compList::instance()->u8GetNumComponents(poRDbServiceComponentGetInfo->rService);
    _rServiceInfo.u8ServiceInfoFlags = (tU8)(!DAB_BOOL_FROM_BIT(poRDbServiceComponentGetInfo->u8Flags, DAB_b0));

    _rComponentInfo.u8ComponentId = poRDbServiceComponentGetInfo->u8SCIDS;
    _rComponentInfo.rComponentLabel = poRDbServiceComponentGetInfo->rLabel;
    _rComponentInfo.enServiceType = (DAB_tenServiceType)(poRDbServiceComponentGetInfo->enServiceType);

    // -> P/S
    _rComponentInfo.enComponentType = (DAB::DAB_tenComponentType)DAB_BOOL_FROM_BIT(poRDbServiceComponentGetInfo->u8Flags, DAB_b0);
    // -> TMId
      _rComponentInfo.enTMIIdType = (DAB_tenTMIdType)(((poRDbServiceComponentGetInfo->u8Flags) >> 4) & 0x3); //(bit 4 and 5)
    // -> ASCTY
    _rComponentInfo.u16Scidi = poRDbServiceComponentGetInfo->u16SCIDI;
    _rComponentInfo.u8AudioDataServiceComponentType = poRDbServiceComponentGetInfo->u8Scty;
	//Get Component Index -- KVA4KOR
    _rComponentInfo.u16ComponentIndex = dabdrv_compList::instance()->u16GetFrozenListId(trMecaId(_rRdmAsid));
	_rComponentInfo.u8Scids =poRDbServiceComponentGetInfo->u8SCIDS;
	_rComponentInfo.u8Subchannel=poRDbServiceComponentGetInfo->u8Id;

     dabdrv_properties::instance()->oComponentInfoProperty.vSet(_rComponentInfo);
}*/

tVoid dabdrv_testmode::vProcess(trMeca_RDbSubchannelGetInfo *poRDbSubchannelGetInfo)
{
    ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMeca_RDbSubchannelGetInfo):u16BitRate=%d", poRDbSubchannelGetInfo->u16BitRate));
    // -> Prot-Level    bitrate
    _rTestModeData.u8ProtectionLevel = poRDbSubchannelGetInfo->u8ProtectionLevel;
    // will be get by AUDIO_STATUS
    _rServiceInfo.u16BitRateKbps = poRDbSubchannelGetInfo->u16BitRate;
}

  /* removed due to high load caused NCG3D-130978*/ 
 // tVoid dabdrv_testmode::vProcess(trMeca_RDbEnsembleGetInfo *poRDbEnsembleGetInfo)
// {
    // /*if( _bIsEnsembleInfoActive == FALSE)
        // return;*/

    // ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMeca_RDbEnsembleGetInfo):rEnsemble._u32Id=%08x", 
                        // poRDbEnsembleGetInfo->rEnsemble._u32Id));
    // // -> ensemble label
    // DAB_trEnsembleInfoProperty rProperty=dabdrv_properties::instance()->oEnsembleInfoProperty.oGet();
	
	// /*DAB_trChnInfoProperty rChnInfoProperty=dabdrv_properties::instance()->oChnInfoProperty.oGet();*/
	// if(enAutostore_Normal != dabdrv_presets::instance()->u8GetAutoStoreType()){
		// //Label is not getting changed though the all information is changed. w.t.r PSARCCB-9706
		// //Previous code in MIDW_46, It doesn't cause any problem but the intention is fir copy the label then make the label invalid based on condition
		// rProperty.rEnsembleLabel = poRDbEnsembleGetInfo->rLabel/*dabdrv_chnList::instance()->vGetEnsembleinfofromid(rChnInfoProperty.rMecaId)*/;
		// if(enChnState_Stable != dabdrv_properties::instance()->oChnInfoProperty.oGet().enChnState)
			// rProperty.rEnsembleLabel.bLabelValid = FALSE;
	// }
	// poRDbEnsembleGetInfo->rLabel.vTrace();
	// rProperty.rEnsembleLabel.vTrace();

	// rProperty.u32EnsembleId = poRDbEnsembleGetInfo->rEnsemble._u32Id;
    // rProperty.u8NumberOfDataServices = poRDbEnsembleGetInfo->u8NumDataServices;
    // rProperty.u8NumberOfAudioServices = poRDbEnsembleGetInfo->u8NumProgServices;
    // rProperty.u8ReceptionQuality = poRDbEnsembleGetInfo->u8ReceptionQuality;
	// rProperty.bReception=bIsReceptionOk( poRDbEnsembleGetInfo->u8ReceptionQuality);
    // dabdrv_properties::instance()->oEnsembleInfoProperty.vSet(rProperty);

    // trMsgDrvCmdSetEnsembleId rSetEnsembleId;
    // rSetEnsembleId.rEnsemble = poRDbEnsembleGetInfo->rEnsemble;
	// DAB_vCallMsg(rSetEnsembleId);
// }

 /* removed due to high load caused NCG3D-130978*/ 
// tVoid dabdrv_testmode::vProcess(trMeca_RDbServiceGetInfo *poRDbServiceGetInfo)
// {
    // if (_rServiceInfo.rProgService == poRDbServiceGetInfo->rProgrammeService) {
        // _rServiceInfo.u8NumberOfComponents=poRDbServiceGetInfo->u8NumberOfComponents;
        // _rServiceInfo.u8ServiceInfoFlags=0;
    // }

	// DAB_trChnInfoProperty rChnInfoProperty=dabdrv_properties::instance()->oChnInfoProperty.oGet();
	// if(rChnInfoProperty.rMecaId == poRDbServiceGetInfo->rProgrammeService._u32Id){
	// ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMeca_RDbServiceGetInfo):bComponentMode=%d",rChnInfoProperty.bComponentMode));
	// if(!rChnInfoProperty.bComponentMode)
		// rChnInfoProperty.rLabel = poRDbServiceGetInfo->rLabel;
    // dabdrv_properties::instance()->oChnInfoProperty.vSet(rChnInfoProperty);
	// }
// }

 /* removed due to high load caused NCG3D-130978*/ 
// tVoid dabdrv_testmode::vProcess(trMeca_RDbServiceGetComponentList* poComponentList) {
    
    // if ( poComponentList->u8FilterId == (tU8)enDabDbFilterId_Default && poComponentList->rRefProgrammeService==_rServiceInfo.rProgService) {
        // ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMeca_RDbServiceGetComponentList):u8FilterId=%d", poComponentList->u8FilterId));
        // _rServiceInfo.u8NumberOfAudioComponents = poComponentList->u8NumComponents;
    // }
// }

tVoid dabdrv_testmode::vProcess(trMeca_RRdmGetRdmInfo* poGetRdmInfo) {

    ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMeca_RRdmGetRdmInfo):rProgrammeService.sid=%08x", poGetRdmInfo->rProgrammeService.u32GetSID()));
	ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMeca_RRdmGetRdmInfo):rProgService._u32Id=%08x rProgService._u16Scids=%d", _rServiceInfo.rProgService._u32Id,_rServiceInfo.rProgService._u16Scids));
	ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMeca_RRdmGetRdmInfo):rEnsemble=%d ensembleId=%d", poGetRdmInfo->rEnsemble.bIsValid(),poGetRdmInfo->rEnsemble._u32Id));

    if (poGetRdmInfo->rEnsemble.bIsValid()&&
		_rServiceInfo.rProgService._u32Id !=poGetRdmInfo->rProgrammeService._u32Id) {
		_bNewService = TRUE;
    	DAB_trEnsembleInfoProperty rProperty=dabdrv_properties::instance()->oEnsembleInfoProperty.oGet();
    	rProperty.u32EnsembleId = poGetRdmInfo->rEnsemble.u32GetID();
    	rProperty.u32Frequency = poGetRdmInfo->u32Frequency;
    	dabdrv_properties::instance()->oEnsembleInfoProperty.vSet(rProperty);

        _rServiceInfo.rProgService = poGetRdmInfo->rProgrammeService;
		trChnListChnInfo oChnInfo = dabdrv_chnList::instance()->rGetChnInfo(poGetRdmInfo->rProgrammeService);
		_rServiceInfo.u8PtyCode = oChnInfo.u8PTY;
		_rServiceInfo.u16ServiceIndex = dabdrv_chnList::instance()->u16GetFrozenListId(oChnInfo.rMecaId);
		_rServiceInfo.bLabelPresent = oChnInfo.bLabelPresent;
		_rServiceInfo.rLabel = oChnInfo.rLabel;
		_rServiceInfo.u16AvailableAnnoTypesMask = oChnInfo.u16AvailableAnnoTypesMask;
		_rServiceInfo.u8PresetNumber = oChnInfo.u8PresetNumber;	
		trMeca_CRdmGetAudioStatus oCRdmGetAudioStatus;
		oCRdmGetAudioStatus.enRdmMode = enMeca_RdmMode_DAB_DMB;
		dabdrv_mecaIf::instance()->vSendMecaCommand(oCRdmGetAudioStatus);

        //Added by jab4kor - update ECC
        _rTestModeData.u8ECC = poGetRdmInfo->rProgrammeService.u8GetECC();
        ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMeca_RRdmGetRdmInfo):rProgrammeService.ECC=%8x", _rTestModeData.u8ECC));
        //Fix for PSARCCB-9706 some times ADR is sending wrong ensemble info and proper channel info
        //Actual fix has to be done from ADR side, however middleware is validating the condition whether service belongs to the given ensemble or not.
        if(dabdrv_chnList::instance()->bIsEnsembleContainsService(poGetRdmInfo->rEnsemble,poGetRdmInfo->rProgrammeService)){
			ETG_TRACE_USR4(("dabdrv_testmode::bIsEnsembleContainsService TRUE"));
			// Get Ensemble label over auto-notifications
			/* removed due to high load caused NCG3D-130978
			trMeca_CDbEnsembleGetInfo oCDbEnsembleGetInfo;
			oCDbEnsembleGetInfo.rRefEnsemble = poGetRdmInfo->rEnsemble;
			dabdrv_mecaIf::instance()->vSendMecaCommand(oCDbEnsembleGetInfo);*/
			
			trMecaEnsemble rEnsemble(poGetRdmInfo->rEnsemble);
			trEnsembleListElem EnsElem = dabdrv_chnList::instance()->rGetEnsembleInfo(rEnsemble);
			
			if(enAutostore_Normal != dabdrv_presets::instance()->u8GetAutoStoreType()){
				//Label is not getting changed though the all information is changed. w.t.r PSARCCB-9706
				//Previous code in MIDW_46, It doesn't cause any problem but the intention is fir copy the label then make the label invalid based on condition
				rProperty.rEnsembleLabel = EnsElem.rEnsembleLabel/*dabdrv_chnList::instance()->vGetEnsembleinfofromid(rChnInfoProperty.rMecaId)*/;
				if(enChnState_Stable != dabdrv_properties::instance()->oChnInfoProperty.oGet().enChnState)
					rProperty.rEnsembleLabel.bLabelValid = FALSE;
			}
			EnsElem.rEnsembleLabel.vTrace();
			rProperty.rEnsembleLabel.vTrace();

			rProperty.u32EnsembleId = EnsElem.rEnsemble._u32Id;
			rProperty.u8NumberOfDataServices = EnsElem.u8NumberOfDataServices;
			rProperty.u8NumberOfAudioServices = EnsElem.u8NumberOfAudioServices;
			rProperty.u8ReceptionQuality = EnsElem.u8ReceptionQuality;
			rProperty.bReception=bIsReceptionOk( EnsElem.u8ReceptionQuality);
			dabdrv_properties::instance()->oEnsembleInfoProperty.vSet(rProperty);

			trMsgDrvCmdSetEnsembleId rSetEnsembleId;
			rSetEnsembleId.rEnsemble = EnsElem.rEnsemble;
			DAB_vCallMsg(rSetEnsembleId);
        }
		/* removed due to high load caused NCG3D-130978
        if ( poGetRdmInfo->rProgrammeService.bIsValid()) {
           
			trMeca_CDbServiceGetComponentList oCDbServiceGetComponentList;
            oCDbServiceGetComponentList.enServiceType = enMeca_ServiceType_AUDIO_SERVICE;
            oCDbServiceGetComponentList.rRefProgrammeService = poGetRdmInfo->rProgrammeService;
            dabdrv_mecaIf::instance()->vSendMecaCommand(oCDbServiceGetComponentList);
        }*/
		/*send active service info on every service change*/
		_rServiceInfo.vTrace();
        dabdrv_properties::instance()->oServiceInfoProperty.vSet(_rServiceInfo);
    }
}

tVoid dabdrv_testmode::vProcess(trMeca_RRdmAudioGetScidi* poAudioGetScidi) {

    
    // request for -> P/S   TMId   ASCTY   SubChId
    _u16RdmAscidi=poAudioGetScidi->u16SCIDI;

#if 0
    if (poAudioGetScidi->u16SCIDI == 0xffff) {
        _rComponentInfo=DAB_trComponentInfoProperty();
    } 
    else {

        ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMeca_RRdmAudioGetScidi):u16SCIDI=%04x", poAudioGetScidi->u16SCIDI));


        trMeca_CDbServiceComponentGetInfo oCDbServiceComponentGetInfo;
        oCDbServiceComponentGetInfo.enServiceType = enMeca_ServiceType_AUDIO_SERVICE;
        oCDbServiceComponentGetInfo.u16SCIDI = poAudioGetScidi->u16SCIDI;
        oCDbServiceComponentGetInfo.rService = _rServiceInfo.rProgService;

        if (_rServiceInfo.rProgService.bIsValid()) {
            // todo: get over auto-notifications
            if (_bIsTestmodeActive) {
                dabdrv_mecaIf::instance()->vSendMecaCommand(oCDbServiceComponentGetInfo);
            }
        } 
        else {
            ETG_TRACE_USR4(("dabdrv_testmode::vProcess SID:0x04%x",
                _rServiceInfo.rProgService.u32GetSID()));
       }
    }
#endif
}

tVoid dabdrv_testmode::vProcess(trMsgSrvDbQueryTestmode* poDbQueryTestmode) {

    ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMsgSrvDbQueryTestmode):u8Adr3DbQuery=%d", poDbQueryTestmode->u8Adr3DbQuery));

    if( _bIsTestmodeActive == FALSE )
        return;

    trMeca_CDbQuery rCDbQuery;
    rCDbQuery.u8QueryTag = (tU8)enMeca_QUERY_TAG_TESTMODE_DB_REQUEST;
    rCDbQuery.u8QueryStateId = 0;
	rCDbQuery.enDbQueryCmd = enMeca_DbQueryCmd_EVALUATE;
    tChar line[256];

    switch (poDbQueryTestmode->u8Adr3DbQuery) {
    case  1: (tVoid)OSAL_szStringCopy(line, "select * from dab_testmode_0"); break;
    case  2: (tVoid)OSAL_szStringCopy(line, "select * from dab_testmode_1"); break;
    case  3: (tVoid)OSAL_szStringCopy(line, "select * from dab_testmode_2"); break;
    case  4: (tVoid)OSAL_szStringCopy(line, "select * from dab_testmode_3"); break;
    case  5: (tVoid)OSAL_szStringCopy(line, "select * from dab_testmode_4"); break;
    case  6: (tVoid)OSAL_szStringCopy(line, "select * from dab_testmode_5"); break;
    case  7: (tVoid)OSAL_szStringCopy(line, "select * from dab_testmode_6"); break;
    case  8: (tVoid)OSAL_szStringCopy(line, "select * from dab_testmode_7"); break;
    case  9: (tVoid)OSAL_szStringCopy(line, "select * from dab_testmode_8"); break;
    case 10: (tVoid)OSAL_szStringCopy(line, "select * from dab_testmode_9"); break;
    default: 
        (tVoid)OSAL_szStringCopy(line, "SELECT * FROM dab_testmode_0");
        ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMsgSrvDbQueryTestmode): not handled"));
    }

    tU32 u32Len=(tU32)(OSAL_u32StringLength(line));
    rCDbQuery.lu8SqlStatement.reserve(u32Len+2);
    
    for (tU32 i=0; i < u32Len; i++) {
        rCDbQuery.lu8SqlStatement.push_back(line[i]);
    }

    
    DAB_ASSERT_RETURN(_bRequestDbQueryDone == TRUE); // if this assert happens we need additional states

    _u8RequestedDbQuery = poDbQueryTestmode->u8Adr3DbQuery;
    _bRequestDbQueryDone = FALSE;
    dabdrv_mecaIf::instance()->vSendMecaCommand(rCDbQuery);
}
//lint -sem(sdxf_table_get_num_rows,custodial(1))
tVoid dabdrv_testmode::vProcess(trMeca_RDbQuery* poQuery) {
    
    ETG_TRACE_USR1(("dabdrv_testmode::vProcess(trMeca_RDbQuery)"));

    //tU32 u32Columns = 0;
    tU32 u32Rows    = 0;


    if ( poQuery->u8QueryTag == (tU8)enMeca_QUERY_TAG_COUNT_OF_TMC_SERVICES ) {
        ETG_TRACE_USR1(("dabdrv_testmode::vProcess(trMeca_RDbQuery) QUERY_TAG_COUNT_OF_TMC_SERVICES"));
        tU32 l_result_length = (tU32)(poQuery->lu8UserData.size());
        if ( l_result_length == 0 )
            return;
        tU8* r_result = OSAL_NEW tU8[l_result_length]; 
        if (r_result == NULL)
            return;
        for(tU32 k=0; k<l_result_length; k++)
            r_result[k] = poQuery->lu8UserData[k];

        u32Rows = sdxf_table_get_num_rows(r_result, l_result_length);
        
        DAB_trTmcTpegInfoProperty rProperty= dabdrv_properties::instance()->oTmcTpegInfoProperty.oGet();
        rProperty.u8NumOfTmcServices = (tU8)u32Rows;
        dabdrv_properties::instance()->oTmcTpegInfoProperty.vSet(rProperty);
    }// ( poQuery->u8QueryTag == QUERY_TAG_COUNT_OF_TMC_SERVICES )


    // TODO need news handler files to decode testmode queries
    if ( poQuery->u8QueryTag == (tU8)enMeca_QUERY_TAG_TESTMODE_DB_REQUEST ) {
        
        ETG_TRACE_USR1(("dabdrv_testmode::vProcess(trMeca_RDbQuery) enMeca_QUERY_TAG_TESTMODE_DB_REQUEST"));


	 tU32 l_result_length = (tU32)(poQuery->lu8UserData.size());
        if ( l_result_length == 0 )
            return;
        tU8* r_result = OSAL_NEW tU8[l_result_length]; 
        if (r_result == NULL)
            return;
        for(tU32 k=0; k<l_result_length; k++)
            r_result[k] = poQuery->lu8UserData[k];

        // get count of columns
        //u32Columns = sdxf_table_get_num_columns(r_result, l_result_length);
        // get count of rows
        u32Rows = sdxf_table_get_num_rows(r_result, l_result_length);
        
		tSDXFPrintColumnFormatConfig column_format_hint[] = { SDXF_WELL_KNOWN_COLUMN_FORMAT_HINTS
                                                              { NULL, COLUMN_FORMAT_MODE_UNDEF } };

        char* line = NULL;
        char tmp_buffer[128];	/* temporary cell buffer */
        char line_buffer[1024]; /* line buffer */
        tSDXFPrintChunkConfig print_config;
        memset(&print_config,0,sizeof(tSDXFPrintChunkConfig));
        print_config.state = 0;
        print_config.print_header = TRUE;
        print_config.tmp_buffer = tmp_buffer;
        print_config.tmp_buffer_size = sizeof(tmp_buffer);
        print_config.line_buffer = line_buffer;
        print_config.line_buffer_size = sizeof(line_buffer);
        print_config.column_format_hint = column_format_hint;					
        print_config.headline_splitter = '=';
        print_config.column_splitter = '|';
        print_config.max_num_columns = SDXF_CONFIG_MAX_NUM_COLUMNS;
		print_config.table_num_columns = 0;

        std::string sQueryResult;
        tU8 u8MaxCount = 0;
        while( (line=sdxf_print_chunk(&print_config,l_result_length,r_result)) != NULL )
        {   
            if (u8MaxCount < 24){ // (24 * 80) + (24 * "/n") <= 2KB max buffer in HMI for LCN2Kai
                u8MaxCount++;
            }
            else {
                sQueryResult +="...";
                break;
            }

            std::string sQueryOrg(line);
            std::string sQuery = sQueryOrg.substr(0,80);
            //std::string sQuery(line);
            ETG_TRACE_USR1(("LINE %s\n", sQuery.c_str()));
            sQuery +="\n";
            sQueryResult += sQuery;
        }
            
        ETG_TRACE_USR1(("LINE result_len=%d  QUERY-TEXT %s\n",l_result_length, sQueryResult.c_str()));

        trMsgDrvRspDbQueryTestmode rDbQueryTestmode;
        rDbQueryTestmode.sQuery = sQueryResult.c_str();
        _bRequestDbQueryDone = TRUE;
        rDbQueryTestmode.u8Query = _u8RequestedDbQuery;
        DAB_vCallMsg(rDbQueryTestmode);
    } // ( poQuery->u8QueryTag == QUERY_TAG_TESTMODE_DB_REQUEST )
}

// timeout, collect data, update property, request new data and restart timer
tVoid dabdrv_testmode::vProcess(trMsgTestModeTimer* poMsgTestModeTimer) {
    (tVoid)poMsgTestModeTimer;
    vEmit();
    if( _bIsTestmodeActive == TRUE || _bTestModeDataGetPending==TRUE) {
        vStartCollect();
    }
}

// timeout, collect data, update property, request new data and restart timer
tVoid dabdrv_testmode::vProcess(trMsgDbQueryTimer* poMsgDbQueryTimer) {
    (tVoid)poMsgDbQueryTimer;

    if( _bIsTestmodeActive == TRUE || _bTestModeDataGetPending==TRUE) {
    	vDbQuery();
    }
    _oTestModeTmr.vStart(DAB_TEST_MODE_GET_TIMER_MS);
}

// register for exp-values
tVoid dabdrv_testmode::vConfigure() {

    ETG_TRACE_USR4(("dabdrv_testmode::vConfigure() _bIsTestmodeActive=%d _bTestModeDataGetPending=%d", 
                    _bIsTestmodeActive, _bTestModeDataGetPending));
    tBool bEnable=_bIsTestmodeActive | _bTestModeDataGetPending;
    trMsgDrvCmdSetRdmNotifyMode rRdmNotifyMode(bEnable ? enRdmNotifyMode_TestMode:enRdmNotifyMode_Invalid );
    DAB_vCallMsg(rRdmNotifyMode);

    trMeca_CExpSelect oCExpSelect;
    oCExpSelect.enAction=bEnable ? enMeca_ExpAction_ENABLE_AUTO_UPDATE : enMeca_ExpAction_DISABLE;

    //oCExpSelect.enValueId=enMeca_ExpValueId_BBE;
    //dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect);

    oCExpSelect.enValueId=enMeca_ExpValueId_DabMode;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect);

    oCExpSelect.enValueId=enMeca_ExpValueId_MSCBER;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect);

    oCExpSelect.enValueId=enMeca_ExpValueId_FICBER;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect);
	oCExpSelect.enValueId=enMeca_ExpValueId_NETBER;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect);

    oCExpSelect.enValueId=enMeca_ExpValueId_RSFEC;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect);

    oCExpSelect.enValueId=enMeca_ExpValueId_FieldStrength;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect);

    if (_bIsBgTestmodeActive == TRUE ) {
        // request BG dabtuner information from expert api
        oCExpSelect.enValueId=enMeca_ExpValueId_Bg_Frequency;
        dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect);

        oCExpSelect.enValueId=enMeca_ExpValueId_Bg_EnsId;
        dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect);

        oCExpSelect.enValueId=enMeca_ExpValueId_Bg_FIC;
        dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect);

        oCExpSelect.enValueId=enMeca_ExpValueId_Bg_SYNC;
        dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect);

        oCExpSelect.enValueId=enMeca_ExpValueId_Modul_Info_Bg;
        dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect);
    }

    if ( _bIsTmcTpegDataActive == TRUE ) {
        
        oCExpSelect.enValueId=enMeca_ExpValueId_Num_Tpeg_Svcs;
        dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect);

        //oCExpSelect.enValueId=enMeca_ExpValueId_Num_Tmc_Svcs;
        //dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect);
    }
}

tVoid dabdrv_testmode::vStartCollect() {
    // todo: send all request
    // property-update if all exp-requests have been answered
    // all non-exp data will be fetched from other message-handlers or properties.
    // race-condition if testmode is stoped and restarted in less then 500ms is ignored
    if (!dabdrv_main::instance()->bIsAdrUp()) {
        _enTestModeState = enTestModeState_Ready;
        
    }
    else {
        // adr is up
        if (_enTestModeState == enTestModeState_Ready) {
            // we enter test-mode or adr was down
            _enTestModeState = enTestModeState_Collect;
            vConfigure();
        }
    }
    

    vCollectServiceInfo();

    _oTestModeTmr.vStart(_bTestModeDataGetPending ? DAB_TEST_MODE_GET_TIMER_MS:DAB_TEST_MODE_UPDATE_TIMER_MS);

}

tVoid dabdrv_testmode::vCollectServiceInfo() {

    if(_bIsServiceInfoActive == FALSE && !_bTestModeDataGetPending)
        return;

    trChnListChnInfo oChnInfo = dabdrv_chnList::instance()->rGetChnInfo(_rServiceInfo.rProgService);

    _rServiceInfo.bLabelPresent = oChnInfo.bLabelPresent;
    _rServiceInfo.rLabel = oChnInfo.rLabel;
    _rServiceInfo.u16AvailableAnnoTypesMask = oChnInfo.u16AvailableAnnoTypesMask;
    _rServiceInfo.u8PresetNumber = oChnInfo.u8PresetNumber;	

    trMeca_CRdmGetAudioStatus oCRdmGetAudioStatus;
    oCRdmGetAudioStatus.enRdmMode = enMeca_RdmMode_DAB_DMB;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCRdmGetAudioStatus);
}


tVoid dabdrv_testmode::vDbQuery() const {

    trMeca_CDbQuery rCDbQuery;
    rCDbQuery.u8QueryTag = (tU8)enMeca_QUERY_TAG_COUNT_OF_TMC_SERVICES;
    rCDbQuery.u8QueryStateId = 0;

    const tChar line[] = "SELECT id FROM v1f0_dab_tmc_service_component";

    tU32 u32Len=(tU32)(OSAL_u32StringLength(line));
    rCDbQuery.lu8SqlStatement.reserve(u32Len+2);

    for (tU32 i=0; i < u32Len; i++) {
        rCDbQuery.lu8SqlStatement.push_back(line[i]);
    }
    rCDbQuery.lu8SqlParameter.push_back(0);
    rCDbQuery.lu8SqlParameter.push_back(0);

    dabdrv_mecaIf::instance()->vSendMecaCommand(rCDbQuery);

}


// updata the testmode-property
tVoid dabdrv_testmode::vEmit() {
    if((_bIsTestmodeActive || _bTestModeDataGetPending) &&(!_bIsFSUpdatePending)){

        ETG_TRACE_USR4(("dabdrv_testmode::vEmit()"));

        _rTestModeData.e8ServiceLinkingMode = dabdrv_main::instance()->enGetServiceLinkingMode();
        _rTestModeData.u8ConcealmentLevel = dabdrv_properties::instance()->oSetupStatusProperty.oGet().u8ConcealmentLevel;

        _rTestModeData.vTrace();
        dabdrv_properties::instance()->oTestModeDataProperty.vSet(_rTestModeData);
		DAB_vCallMsg(_rTestModeData);

        // TODO !!!!!!!!!!!!
        _rBgTestModeData.vTrace();
        dabdrv_properties::instance()->oBgTestModeDataProperty.vSet(_rBgTestModeData);
		DAB_vCallMsg(_rBgTestModeData);

    } else {
        return;
    }


    if(_bIsComponentInfoActive) {
        _rComponentInfo.vTrace();
        dabdrv_properties::instance()->oComponentInfoProperty.vSet(_rComponentInfo);
    }
    if(_bIsServiceInfoActive) {
        _rServiceInfo.vTrace();
        dabdrv_properties::instance()->oServiceInfoProperty.vSet(_rServiceInfo);
    }

    if (_bTestModeDataGetPending) {
        _bTestModeDataGetPending=FALSE;
        DAB_vCallMsgCtor(trMsgSrvRspGetTestModeData());
    }

}
tVoid dabdrv_testmode::vProcess(trMeca_RMtcTestmode* poMtcTestmode) {
    if( _bIsTestmodeActive == FALSE )
        return;
    ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMeca_RMtcTestmode):u32FmFrequency=%d", poMtcTestmode->u32FmFrequency));
    _rTestModeData.u32AltFMFrequency = poMtcTestmode->u32FmFrequency;
    _rTestModeData.u16AltFMPI = poMtcTestmode->u16Pi;
    _rTestModeData.u8AltFMQuality = poMtcTestmode->u8FmQuality;
}
tVoid dabdrv_testmode::vProcess(trMsgDrvUpdateLink* poMsgDrvUpdateLink){
	 ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMsgDrvUpdateLink*)"));
	 poMsgDrvUpdateLink->vTrace();
	 _rTestModeData.vecLinkList.push_back(poMsgDrvUpdateLink->rLinkListElem);
	 _rTestModeData.u16TotalNumberLinks++;
	 if((_bIsTestmodeActive)&&(!_bIsFSUpdatePending))
	 {
	dabdrv_properties::instance()->oTestModeDataProperty.vSet(_rTestModeData);
	 }
}
tVoid dabdrv_testmode::vProcess(trMsgDrvAltFreqInfo* poMsgDrvAltFreqInfo){
	 ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMsgDrvAltFreqInfo*)"));
	 poMsgDrvAltFreqInfo->vTrace();
	 _rTestModeData.vecAltFreqInfo.push_back(poMsgDrvAltFreqInfo->rAltFreqInfo);
	if((_bIsTestmodeActive)&&(!_bIsFSUpdatePending))
	 {
	 dabdrv_properties::instance()->oTestModeDataProperty.vSet(_rTestModeData);
	 }
	 DAB_trChnInfoProperty rProperty=dabdrv_properties::instance()->oChnInfoProperty.oGet();
	 rProperty.bAFPresent=(_rTestModeData.vecAltFreqInfo.size())?TRUE:FALSE;
	 dabdrv_properties::instance()->oChnInfoProperty.vSet(rProperty);
}

tVoid dabdrv_testmode::vProcess(trMeca_RRdmGetRdmStatus* poRdmStatus){
	 ETG_TRACE_USR4(("dabdrv_testmode::vProcess(trMeca_RRdmGetRdmStatus*)"));	
	 _rTestModeData.bSync=DAB_BOOL_FROM_BIT(poRdmStatus->rRdmStatus.u8Status, (tU8)enRdmStatusBits_SYNC)?1:0;
	if((_bIsTestmodeActive)&&(!_bIsFSUpdatePending))
	{
	dabdrv_properties::instance()->oTestModeDataProperty.vSet(_rTestModeData);
	}
}
tVoid dabdrv_testmode::vProcess(trMeca_RExpSelect* poMsgRExpSelect) {
    if( _bIsTestmodeActive == FALSE )
        return;
    //lint -e{788} enum constant '...' not used within defaulted switch
    ETG_TRACE_USR1(("  dabdrv_testmode:vProcess(trMeca_RExpSelect) enValueId=%x enActionRes=%x enValueType=%x",
                             ETG_CENUM(tenMeca_ExpValueId, poMsgRExpSelect->enValueId),
                            ETG_CENUM(tenMeca_ExpActionRes, poMsgRExpSelect->enActionRes),
                            ETG_CENUM(tenMeca_ExpValueType, poMsgRExpSelect->enValueType)));
}
