/************************************************************************
 * FILE:  dabdrv_sysStore.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  header of dabdrv_sysStore
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DABDRV_SYS_STORE_HPP
#define DABDRV_SYS_STORE_HPP

#include "fc_dabtuner_util.h"
#include "dabdrv_main.hpp"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_MAIN 
#include "trcGenProj/Header/dabdrv_sysStore.hpp.trc.h"
#endif

namespace DAB {

    class dabdrv_sysStore:
        public DAB_Singleton <dabdrv_sysStore>,
        public DAB_MessageHandlerCommon<dabdrv_sysStore>
    {
        friend class DAB_Singleton<dabdrv_sysStore>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_MAIN);
        virtual char const *pcGetName() const {return "dabdrv_sysStore";};
        virtual tVoid vTraceState() const;

        virtual tVoid vInit();
        virtual tVoid vDeInit();

        virtual tVoid vProcess(trMsgSrvCmdDefSet* poSrvCmdDefSet);
        virtual tVoid vProcess(trMsgSrvCmdNewAppState* poSrvCmdNewAppState);

        virtual tVoid vProcess(trMsgDrvStartComponent *poStartComponent);
        virtual tVoid vProcess(trMsgDrvStopComponent *poStopComponent);



        virtual tVoid vProcess(trMsgDrvCmdSysStore* poDrvCmdSysStore); // ttfis
        virtual tVoid vProcess(trMsgDrvCmdSysReStore *poRestore);


        virtual tVoid vProcess(trMeca_RSysStore *poRSysStore);
        virtual tVoid vProcess(trMeca_RSysReStore *poRSysReStore);
        virtual tVoid vProcess(trMeca_RSysStorageFormat *poRSysStorageFormat);
        virtual tVoid vProcess(trMsgSrvCmdCriticalVoltage* poCriticalVoltage);

		typedef enum {
            enSysStoreAction_Nothing,
            enSysStoreAction_DefSet,
            enSysStoreAction_SysStore
        } tenSysStoreAction;
        tenSysStoreAction _enSysStoreAction;
		tenSysStoreAction enGetSysStoreAction(){
			return _enSysStoreAction;
		}
		tVoid vClear();
        // activity handling

    private:

        typedef enum {
            enSysStoreState_Off,
            enSysStoreState_WaitNotifyOff,
            enSysStoreState_WaitRSysStore,
            enSysStoreState_WaitRSysStorageFormat
        } tenSysStoreState;
        tenSysStoreState _enSysStoreState;


        dabdrv_sysStore();   


        
        tVoid vApplyDefSet() const;
        tVoid vSendSysStoreCmd(tU8 u8UsrId, tU8 u8Tag=0) const;
        tVoid vSendSysStorageFormat(tenMeca_SysStorageMemory enDeviceId=enMeca_SysStorageMemory_PARAMETER) const;
        tVoid vSendSysReStoreCmd(tU8 u8UsrId) const;
        tVoid vHandleSysStore();

       
        tBool _bQuick;
        tU8 _u8UsrId;
        tBool _bCritLowVoltageDetected;
        tBool _bStartSysRestoreAfterLowVoltage;


    };
} //namespace DAB 

#endif
