/************************************************************************
 * FILE:  dabdrv_sysStore.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  header of dabdrv_sysStore
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/
 
#include "dabdrv_main.hpp"
#include "dabdrv_sysStore.hpp"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_MAIN 
#include "trcGenProj/Header/dabdrv_sysStore.cpp.trc.h"
#endif

namespace DAB {


}


using namespace DAB;

tVoid dabdrv_sysStore::vClear() {
    _enSysStoreState=enSysStoreState_Off;
    _enSysStoreAction=enSysStoreAction_Nothing;
}
dabdrv_sysStore::dabdrv_sysStore() {
    _enSysStoreState=enSysStoreState_Off;
    _enSysStoreAction=enSysStoreAction_Nothing;

    vSubscribe<trMsgSrvCmdDefSet>();
    vSubscribe<trMsgSrvCmdNewAppState>();

    vSubscribe<trMsgDrvStartComponent>();
    vSubscribe<trMsgDrvStopComponent>();

    vSubscribe<trMsgDrvCmdSysStore>();


    vSubscribe<trMsgDrvCmdSysReStore>();


    vSubscribe<trMeca_RSysStore>();
    vSubscribe<trMeca_RSysReStore>();
    vSubscribe<trMeca_RSysStorageFormat>();
    vSubscribe<trMsgSrvCmdCriticalVoltage>();


    _bQuick=FALSE;
    _u8UsrId=0;
    _bCritLowVoltageDetected=FALSE;
    _bStartSysRestoreAfterLowVoltage = FALSE;
}

tVoid dabdrv_sysStore::vInit() {
    ETG_TRACE_USR1(("dabdrv_sysStore::vInit"));

    vClear();

     
}

tVoid dabdrv_sysStore::vDeInit() {
    ETG_TRACE_USR1(("dabdrv_sysStore::vDeInit"));
    vClear();
}

tVoid dabdrv_sysStore::vTraceState() const {

    ETG_TRACE_USR1(("  dabdrv_sysStore STATE: _enSysStoreState=%d _enSysStoreAction=%d",
                    ETG_CENUM(tenSysStoreState, _enSysStoreState),
                    ETG_CENUM(tenSysStoreAction, _enSysStoreAction)));
}



tVoid dabdrv_sysStore::vProcess(trMsgSrvCmdNewAppState* poSrvCmdNewAppState) {
    (tVoid)poSrvCmdNewAppState;
}





tVoid dabdrv_sysStore::vProcess(trMsgDrvStartComponent *poStartComponent) {
    (tVoid)poStartComponent;
    if (_bStartSysRestoreAfterLowVoltage) {
        vSendSysReStoreCmd(1);
        _bStartSysRestoreAfterLowVoltage = FALSE;
    }
    vClear();
}

tVoid dabdrv_sysStore::vProcess(trMsgDrvStopComponent *poStopComponent) {
    (tVoid)poStopComponent;
}

tVoid dabdrv_sysStore::vHandleSysStore() {
            if (_enSysStoreAction==enSysStoreAction_DefSet) {
                vApplyDefSet();
                //_enSysStoreState=enSysStoreState_WaitRSysStorageFormat;
            } else if (_enSysStoreAction==enSysStoreAction_SysStore) {
                trMsgSrvCmdStorePersData rCmd;
                DAB_vCallMsg(rCmd);

                vSendSysStoreCmd(_u8UsrId);
                _enSysStoreState=enSysStoreState_WaitRSysStore;
            }
        }







tVoid dabdrv_sysStore::vProcess(trMsgSrvCmdDefSet* poSrvCmdDefSet) {
    // todo: async response
    (tVoid)poSrvCmdDefSet;
    if (!_bCritLowVoltageDetected) {
        _enSysStoreAction=enSysStoreAction_DefSet;
        vHandleSysStore(); 
    } else {
        ETG_TRACE_ERR(("dabdrv_sysStore::Defset not possible now"));
        DAB_vCallMsgCtor(trMsgSrvResultRsp(DAB_enResult_FAILED));

    }
}

tVoid dabdrv_sysStore::vProcess(trMsgDrvCmdSysStore* poDrvCmdSysStore) {
    // todo: async responde
    (tVoid)poDrvCmdSysStore;

    if (!_bCritLowVoltageDetected) {
        _enSysStoreAction=enSysStoreAction_SysStore;
        _bQuick=poDrvCmdSysStore->bQuick;
        _u8UsrId = poDrvCmdSysStore->u8UsrId;
        vHandleSysStore(); 
    } else {
        ETG_TRACE_ERR(("dabdrv_sysStore::SysStore not possible now"));
    }
}

tVoid dabdrv_sysStore::vProcess(trMsgDrvCmdSysReStore* poDrvCmdSysReStore) {
    vSendSysReStoreCmd(poDrvCmdSysReStore->u8UsrId);
}




tVoid dabdrv_sysStore::vSendSysReStoreCmd(tU8 u8UsrId) const {
    ETG_TRACE_USR1(("  dabdrv_sysStore::vSendSysReStoreCmd()"));
     trMeca_CSysReStore rSysReStore;
    rSysReStore.u8UserId=u8UsrId;

   
    dabdrv_mecaIf::instance()->vSendMecaCommand(rSysReStore);
}


tVoid dabdrv_sysStore::vSendSysStoreCmd(tU8 u8UsrId, tU8 u8Tag) const {
    ETG_TRACE_USR1(("  dabdrv_sysStore::vSendSysStoreCmd()"));
     trMeca_CSysStore rSysStore;
    rSysStore.u8UserId=u8UsrId;
    rSysStore.u8Tag=u8Tag;
    

    dabdrv_mecaIf::instance()->vSendMecaCommand(rSysStore);
}

tVoid dabdrv_sysStore::vSendSysStorageFormat(tenMeca_SysStorageMemory enDeviceId) const {
    ETG_TRACE_USR1(("  dabdrv_sysStore::vSendSysStorageFormat()"));
     trMeca_CSysStorageFormat rCSysStorageFormat;
    rCSysStorageFormat.enDeviceId=enDeviceId;

    dabdrv_mecaIf::instance()->vSendMecaCommand(rCSysStorageFormat);
}

tVoid dabdrv_sysStore::vApplyDefSet() const {
    //vSendSysStorageFormat();
dabdrv_main::instance()->vClearDatabase(enMeca_DbConfig_ValueId_delete_All);

}

tVoid dabdrv_sysStore::vProcess(trMeca_RSysStore *poRSysStore) {
    ETG_TRACE_USR1(("dabdrv_sysStore::vProcess(trMeca_RSysStore) enStatus=%d u8UserId=%d u8Tag=%d",
                    ETG_CENUM(tenMeca_SysStoreStatus, poRSysStore->enStatus),
                    poRSysStore->u8UserId, 
                    poRSysStore->u8Tag));
    if (poRSysStore->enStatus==enMeca_SysStoreStatus_STORE_DONE ||
        poRSysStore->enStatus==enMeca_SysStoreStatus_STORE_ERROR ) {
        trMsgDrvCmdProcessed rProcessed(enSysStore);
        // the anser has been received, deblock meca-if
        DAB_vCallMsg(rProcessed);
        }
     vClear();


}

tVoid dabdrv_sysStore::vProcess(trMeca_RSysReStore *poRSysReStore) {
    ETG_TRACE_USR1(("dabdrv_sysStore::vProcess(trMeca_poRSysReStore) enStatus=%d u8UserId=%d",
                    ETG_CENUM(tenMeca_SysReStoreStatus, poRSysReStore->enStatus),
                    poRSysReStore->u8UserId));
    if (poRSysReStore->enStatus==enMeca_SysStoreStatus_RESTORE_DONE ||
        poRSysReStore->enStatus==enMeca_SysStoreStatus_RESTORE_ERROR) {
       
        vClear();
    }

}

tVoid dabdrv_sysStore::vProcess(trMeca_RSysStorageFormat *poRSysStorageFormat) {
    ETG_TRACE_USR1(("dabdrv_sysStore::vProcess(trMeca_RSysStorageFormat) enDeviceId=%d",
                    ETG_CENUM(tenMeca_SysStorageMemory, poRSysStorageFormat->enDeviceId)));
    
    
        _enSysStoreAction=enSysStoreAction_Nothing;
		// todo: check what data shall be reset for which defset (machineData?, currentUser?, allUsers?)
        dabdrv_persData::instance()->vSetDefaultSettings(TRUE);
        trMsgDrvCmdApplyUsrData rApplyUsrData;
        DAB_vCallMsg(rApplyUsrData);
	
    vClear();
}

tVoid dabdrv_sysStore::vProcess(trMsgSrvCmdCriticalVoltage* poCriticalVoltage) {
     ETG_TRACE_USR1(("dabdrv_sysStore::vProcess(trMsgSrvCmdCriticalVoltage) bIsCritical=%d",
                    poCriticalVoltage->bIsCritical));
    _bCritLowVoltageDetected = poCriticalVoltage->bIsCritical;
	if(_bCritLowVoltageDetected){
		_bStartSysRestoreAfterLowVoltage= TRUE;
	}

}
