/************************************************************************
 * FILE:  dabdrv_rdm.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  header of dabdrv_rdm
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/


#ifndef DABDRV_RDM_HPP
#define DABDRV_RDM_HPP

#include "fc_dabtuner_util.h"
#include "dabdrv_types.hpp"
#include "dabdrv_main.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_MECA 
#include "trcGenProj/Header/dabdrv_rdm.hpp.trc.h"
#endif

namespace DAB {


    struct trMsgRdmSetNotifyWaitTimeOut;
    struct trMsgRdmSetSrvFollowClassWaitTimeOut;
    class dabdrv_rdm:
        public DAB_Singleton <dabdrv_rdm>,
        public DAB_MessageHandlerCommon<dabdrv_rdm>
    {
        friend class DAB_Singleton<dabdrv_rdm>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_MECA);
        virtual char const *pcGetName() const {return "dabdrv_rdm";};
        virtual tVoid vTraceState() const;
        virtual tVoid vInit();
        virtual tVoid vDeInit();
        

        virtual tVoid vProcess(trMsgDrvStartComponent* poStart);
        virtual tVoid vProcess(trMsgDrvStopComponent* poStop);
        virtual tVoid vProcess(trMsgRdmSetNotifyWaitTimeOut*);
        virtual tVoid vProcess(trMsgRdmSetSrvFollowClassWaitTimeOut*);
        virtual tVoid vProcess(trMsgDrvCmdSetRdmNotifyMode* poNotifyMode);
        virtual tVoid vProcess(trMeca_RRdmGetSignalQuality* poRRdmGetSignalQuality);
        virtual tVoid vProcess(trMeca_RRdmGetFrequency *poRRdmGetFrequency);
        virtual tVoid vProcess(trMeca_RRdmTuneEid *poRRdmTuneEid);
        virtual tVoid vProcess(trMeca_RRdmAudioGetScidi *poRRdmAudioGetScidi);
        virtual tVoid vProcess(trMeca_RRdmAudioGetAsid *poRRdmAudioGetAsid);
        virtual tVoid vProcess(trMeca_RRdmGetAudioStatus *poRRdmGetAudioStatus);
        virtual tVoid vProcess(trMeca_RRdmGetEid *poRRdmGetEid);
        virtual tVoid vProcess(trMeca_RRdmQualityConfig *poRRdmQualityConfig);
        virtual tVoid vProcess(trMeca_RRdmGetRdmInfo *poRRdmGetRdmInfo);
        virtual tVoid vProcess(trMeca_RRdmGetDabFrequencyTable *poRRdmGetDabFrequencyTable);
        virtual tVoid vProcess(trMeca_RRdmSetDabFrequencyTable *poRRdmSetDabFrequencyTable);
        virtual tVoid vProcess(trMeca_RRdmSetAutoNotification *poRRdmSetAutoNotification);
        virtual tVoid vProcess(trMeca_RRdmServFollowSetMode *poRRdmServFollowSetMode);
        virtual tVoid vProcess(trMeca_RRdmLearn* poRRdmLearn);
        virtual tVoid vProcess(trMeca_RRdmScan *poSrvCmndScan);
		virtual tVoid vProcess(trMeca_RRdmGetCurrTiiList *poRRdmCurrTiiList);

        virtual tVoid vProcess(trMsgDrvCmdSetDabSrvFollowClass *prMsgSetDabSrvFollowClass);
        virtual tVoid vProcess(trMsgDrvCmdConfigDabSrvFollow *prMsgConfigDabSrvFollow);
        virtual tVoid vProcess(trMsgDrvCmdEnableDabSrvFollow *poDrvCmdEnableDabSrvFollow);
		virtual tVoid vProcess(trMsgDrvCmdDabFrequencyTable *poDrvCmdDabFrequencyTable);
		virtual tVoid vProcess(trMsgSrvGetTIIList *poSrvCmdGetTIIList);

		tVoid bSetServiceChangedInfo(tBool bServiceChanged_){ _bServiceChanged=bServiceChanged_;};

		tVoid vSetDABFMLinking(DAB_tenServiceLinkingMode e8ServLinkingMode,tBool bitValue=TRUE);
		tBool bGetServiceChangedInfo(){ return _bServiceChanged;};
		tVoid vSendOneShotServFollowMode();

        trMeca_RRdmGetRdmInfo const &rGetLastRdmInfo() const {
            return _oLastRdmInfo;
        }
		tU8 u8GetLastECC(){
			return _u8ECC;
		}
    private:
        dabdrv_rdm();
        tVoid vNotifyEid(trMecaEnsemble const &rEnsemble);
        trMecaEnsemble _rRdmEnsemble;

        DAB_trAudioStatusProperty _rAudioStatus;
        tVoid vSetNotifications(tenRdmNotifyMode enNotifyMode=enRdmNotifyMode_Invalid);
        tVoid vSetRdmQualityConfig() const;
        tBool bConfigRdmSrvFollowing();
        tU16 u16GetTunerStatusFlags() const;        
        tenRdmNotifyMode _enNotifyMode;
        tBool _bTestMode;
        tBool _bEnableSrvFollow;
        trMeca_RRdmGetRdmInfo _oLastRdmInfo;
        tU8 _aenSrvFollowModes[(tU32)enSrvFollowClass_Last];
        tenSrvFollowClass _enSrvFollowClass;
        tU8 _u8LastSendSrvFollowMode;
        DAB_tclTimer _oNotifyWaitTimer;
        DAB_tclTimer _oSrvFollowWaitTimer;
        tBool _bCorrectSrvFollowModeReceived;
        tBool _bTunerStatusLearn;
        tBool _bRdmScan;
		tBool _bServiceChanged;
		tBool _bNewServiceReceived;
		tU8 _u8ECC;

        
    };
} //namespace DAB 

#endif
