/************************************************************************
 * FILE:   dabdrv_radioText.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  header of dabdrv_radioText
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DABDRV_RADIO_TEXT_HPP
#define DABDRV_RADIO_TEXT_HPP

#include "fc_dabtuner_util.h"
//#include "dabdrv_types.hpp"
#include "dabdrv_main.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_SRV 
#include "trcGenProj/Header/dabdrv_radioText.hpp.trc.h"
#endif

namespace DAB {

    struct dabdrv_msgRadioTextWaitTimeOut;

    typedef enum {
        enRadioTextCfgState_Off,
        enRadioTextCfgState_OnRequested,
        enRadioTextCfgState_On,
        enRadioTextCfgState_OffRequested
    } tenRadioTextCfgState;

#if 0
        struct trRadioTextRcvBuffer {
            tU8 u8NextSegmentNr;
            tU8 u8StartPos;
            tU8 u8Length;
            tU8 u8Text[129];
            tBool bExtractControlChars;
            tenMeca_CharSet enCharSet;
            tVoid vReset() {
                u8NextSegmentNr=0; 
                u8StartPos=0;
                u8Length=0;
                u8Text[0]=0;
                bExtractControlChars=FALSE;
                enCharSet=enMeca_CharSet_EBU_LATIN;
            }
            trRadioTextRcvBuffer()
            {
                vReset();
            }
            operator+=(trMeca_RDdmRadioTextCurrent const &oDdmRT) {
                tBool bAllOk=TRUE;
                if (!oDdmRT.bSegment) {
                    vReset();
                    bExtractControlChars=oDdmRT.bExtractControlChars;
                    _enCharSet= oDdmRT.enCharSet;
                }

                if (u8NextSegmentNr!=oDdmRT.bSegment) {
                    vReset();
                    return;
                }

                if (u8NextSegmentNr!=oDdmRT.bSegment) {
                    vReset();
                    return;
                }

            }
        };
#endif

    class dabdrv_radioText:
        public DAB_Singleton <dabdrv_radioText>,
        public DAB_MessageHandlerCommon<dabdrv_radioText>
    {
        friend class DAB_Singleton<dabdrv_radioText>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_SRV);
        virtual char const *pcGetName() const {return "dabdrv_radioText";};
        virtual tVoid vTraceState() const;
        virtual tVoid vInit();
        virtual tVoid vDeInit();
        virtual ~dabdrv_radioText();

        virtual tVoid vProcess(dabdrv_msgRadioTextWaitTimeOut *poWaitTimeOut);

        virtual tVoid vProcess(trMsgDrvStartComponent* StartComponent);
        virtual tVoid vProcess(trMsgDrvStopComponent* StopComponent);
        virtual tVoid vProcess(trMsgDrvFmServiceFollow* poFmServiceFollow);

        virtual tVoid vProcess(trMsgDrvCmdChnSelectState* poChnSelectState);
        virtual tVoid vProcess(trMsgDrvIndPreChnSelect* poIndPreChnSelect);
        virtual tVoid vProcess(trMsgSrvRspFmRT* poFmRT);


        virtual tVoid vProcess(trMeca_RDdmRadioTextCurrent* poRadioText);
        virtual tVoid vProcess(trMsgSrvCmdSourceState *poSourceState);
        virtual tVoid vProcess(trMeca_RRdmGetRdmInfo *poRRdmGetRdmInfo);
        virtual tVoid vProcess(trMeca_RDdmRadioTextCurrentCmd* poRadioTextPlus);

        void vUpdate(tBool bInvalidate=FALSE);


    private:
        dabdrv_radioText();

        tVoid vSubsribeRtCurrent() const;
        tVoid vUnSubsribeRtCurrent() const;
        /* indicates a stable channel. If the channel is no longer stable,
           the radio-text is deleted
        */
        tBool _bChnStable;
        /* The currently stored radio-text */
        trRadioText _rActiveRadioText;
        /* Wait timer, on time-out the radio-text is deleted */
        DAB_tclTimer _oRadioTextWaitTmr;
        /* Store, if we have registered for radio-text from FM. 
         Registration will be done on receipt of the correct PI-code from FM-tuner*/
        tBool _bFmRTRegistered;
        tBool _bSyncStatus;
        
        
    };
} //namespace DAB 

#endif
