/************************************************************************
 * FILE:    dabdrv_presets.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  header of dabdrv_presets
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "fc_dabtuner_util.h"
#include "dabdrv_main.hpp"
#include "dabdrv_mecaIf.h"
#include "dabdrv_chnInfo.hpp"
#include "dabdrv_presets.hpp"
#include "dabdrv_chnList.hpp"
#include "dabdrv_chnSelect.hpp"
#include "dabdrv_rdm.hpp"
#include "dabdrv_sysStore.hpp"
#include "dabdrv_mute.hpp"
#include "dabdrv_types.hpp"
#include "dabdrv_learn.hpp"
#include "dabdrv_db.hpp"
#include "fc_dabtuner_config.hpp"
#include "dabdrv_compInfo.hpp"

#ifndef DABTUNER_UTEST
	#define DP_S_IMPORT_INTERFACE_FI
	#include "dp_fc_dabtuner_if.h"
	#include "dp_generic_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_PRESETS 
#include "trcGenProj/Header/dabdrv_presets.cpp.trc.h"
#endif

#define DAB_ENABLE_USE_MECA_PRESET
using namespace DAB;
const tU8 u8InvalidScIds = 255;
namespace DAB {
    struct trMsgPresetStoreSupervisionTimer:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgPresetStoreSupervisionTimer"));
        };
    };
}
/*
mirror preset-list of adr3
provide auto-compare by psid

todo: can preset be changed in frozenChnList: no!
todo: check negative results from meca_rdm
*/
dabdrv_presets::dabdrv_presets(): 
	_u8PresetDeleteCounter(0),
    _vPresetInfos((fc_dabtuner_config::instance()->u8NumberOfPresets())+1),
    _mapPresetsByPSID(),
	_mapASTListByQuality(),
    _u8PresetBank(0),
    _u8ActiveRecallPreset(0),
    _u8ActiveStorePreset(0),
    _enChnSelectSource(enChnSelectSource_ChnSelect),
	_enAutoStoreType(enAutostore_InValid),
	_enBankType(Bank_DAB1),
	_enDeleteAction(DAB_enPresetListDelete_None),
	_enDiagAction(enDiagAction_FINISH),
	_enPresetListToHMIStatus(enPresetListToHMI_None),
    u8NumberofPresets(fc_dabtuner_config::instance()->u8NumberOfPresets()),
    u8NumberofPresetsPerBank(fc_dabtuner_config::instance()->u8NumberOfPresetsPerBank()),
	_u8PresetRecalledFromBG(0),
	_bStartup(FALSE),
	u8UserId(0),
	u8DestUserId(0),
	u8UserUpdate(0),
	u8Index(0),
	vecPresetInfo()

{
    vSubscribe<trMsgDrvStartComponent>();
    vSubscribe<trMsgSrvCmdStorePreset>();
    vSubscribe<trMsgSrvCmdRecallPreset>();
    vSubscribe<trMsgSrvCmdSetPresetBank>();
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI //multi-user preset
    vSubscribe<trMsgSrvCmdSetUser>();
    vSubscribe<trMeca_RRdmStationSetUser>();
	vSubscribe<trMeca_RRdmStationTravelStore>();
    vSubscribe<trMsgSrvCmdDiagStatus>();
#endif
	vSubscribe<trMsgSrvCmdGetPresetList>();
    vSubscribe<trMeca_RRdmStationSetPresetStation>();
    vSubscribe<trMeca_RRdmStationStore>();
    vSubscribe<trMeca_RRdmStationPlay>();
    vSubscribe<trMsgDrvIndPreChnSelect>();
    vSubscribe<trMsgSrvCmdClearPresets>();
	vSubscribe<trMsgSrvCmdAutoStore>();
	vSubscribe<trMeca_RDbQuery>();
	vSubscribe<trMsgSrvSavePresetList>();
}

tVoid dabdrv_presets::vInit() {
    _oPresetStoreSuperVisionTimer.vInit(instance(),trMsgPresetStoreSupervisionTimer());
}

tVoid dabdrv_presets::vDeInit() {
    _oPresetStoreSuperVisionTimer.vDeInit();
}

tVoid dabdrv_presets::vTraceState() const {

    ETG_TRACE_USR1(("  dabdrv_presets STATE: _u8ActiveStorePreset%d  " 
                    "rActivePreset: u8PresetNr=%d rPsid=0x%08x u32Frequency=%u" ,
                    _u8ActiveStorePreset,
                    _rPersUsrData.rActivePreset.u8PresetNr,
                    _rPersUsrData.rActivePreset.rPsid.u32GetSID(),
                    _rPersUsrData.rActivePreset.u32Frequency ));

}

tVoid dabdrv_presets::vProcess(trMsgPresetStoreSupervisionTimer *poStoreSupervisionTimer) {
    (tVoid)poStoreSupervisionTimer;
    DAB_tenResult enRes = DAB_enResult_FAILED;
    _u8ActiveStorePreset=0;
    trMsgSrvRspSetPresetStation rSrvRsp(enRes);
    DAB_vCallMsg(rSrvRsp);
}

tVoid dabdrv_presets::vProcess(trMsgDrvStartComponent* poStart) {
    (tVoid)poStart;
    // request all presets from adr3
    ETG_TRACE_USR4(("dabdrv_presets::vProcess(trMsgDrvStartComponent)"));

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
    tBool bClearPreset = DAB::fc_dabtuner_config::instance()->bGetClearPreset();

    ETG_TRACE_USR1(("bClearPreset : %d",bClearPreset));

    if(bClearPreset)
    {
        trMsgDrvDeleteMemory deleteAllPresets(enMeca_DbConfig_ValueId_delete_presets);
		DAB_vCallMsg(&deleteAllPresets);
    }
#endif

#ifndef VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI //multi-user preset
		tU8 currentUserId=0;
	#ifndef DABTUNER_UTEST
		dp_tclSrvIf objUserInfo;

		tS32 s32Status = objUserInfo.s32GetEndUser(currentUserId);
		ETG_TRACE_USR1(("dabdrv_presets::trMsgDrvStartComponent retvalue %d currentUserId=%d",s32Status,currentUserId));
		if( s32Status == DP_S32_NO_ERR && currentUserId<NUMBER_OF_USERS){
			_bStartup =TRUE;
	#else
		if(currentUserId<NUMBER_OF_USERS){
			_bStartup =TRUE;
	#endif
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC //For IVI
		if(currentUserId==0)
		{
			trMeca_CRdmStationTravelStore rDeletePresets = vSendMeaCommandDeleteProfile(currentUserId);
		}
#endif

		trMeca_CRdmStationSetUser rCRdmStationSetUser = vSendMecaCmdSetUser(currentUserId);
    		return;
		}else{
    		ETG_TRACE_USR4(("dabdrv_presets::trMsgDrvStartComponent Data pool read error"));
		}
#endif

   trMsgDrvDbQuery rDbQuery(Query_PresetInfo_All);
    DAB_vCallMsg(rDbQuery);

}


tVoid dabdrv_presets::vProcess(trMeca_RDbQuery* poRDbQuery) {
	poRDbQuery->vTrace();

    ETG_TRACE_USR4(("dabdrv_presets(trMeca_RDbQuery)vOnPresetListQueryResponse u8NumberofPresets=%u", u8NumberofPresets));
		if(poRDbQuery->u8QueryTag >= enMeca_TagID_All_Preset_Info
				&& poRDbQuery->u8QueryTag <= enMeca_TagID_Preset_Info_Start + u8NumberofPresets){

			ETG_TRACE_USR1(("dabdrv_presets(trMeca_RDbQuery)vOnPresetListQueryResponse"));

			_rProperty=dabdrv_properties::instance()->oPresetListDataProperty.oGet();
			vOnPresetListQueryResponse(poRDbQuery,_rProperty);
			ETG_TRACE_USR1(("dabdrv_presets(trMeca_RDbQuery)vOnPresetListQueryResponse _u8PresetDeleteCounter %d",_u8PresetDeleteCounter));
			if(_u8PresetDeleteCounter == 1){
				ETG_TRACE_USR1(("dabdrv_presets(trMeca_RDbQuery)vOnPresetListQueryResponse systore"));
				DAB_vCallMsgCtor(trMsgDrvCmdSysStore(1, TRUE)); // u8UsrId=1, quick;
			}

			_enPresetListToHMIStatus=enPresetListToHMI_NOTUPDATED;
			if(_enDiagAction == enDiagAction_FINISH){
				_u8PresetDeleteCounter=0;
				_enPresetListToHMIStatus=enPresetListHMI_UPDATEDONE;
				dabdrv_properties::instance()->oPresetListDataProperty.vSet(_rProperty);
			}
		}
}

tVoid dabdrv_presets::vOnPresetListQueryResponse(trMeca_RDbQuery* poRDbQuery,DAB_trPresetListProperty& rProperty){
	ETG_TRACE_USR4(("dabdrv_presets::vOnPresetListQueryResponse:"));

	if(poRDbQuery->enQueryResponse != enMeca_DbQueryResponse_OK ){
		ETG_TRACE_USR4(("dabdrv_presets::vOnPresetListQueryResponse error"));
		return;
	}

	vector<trPresetInfo> vecPresetListInfo;
	if(poRDbQuery->u16QueryNumRows == 0 ||
					poRDbQuery->u16QueryNumColumns == 0){

		//If no data is coming with preset number (u8QueryTag) means preset is deleted
		if (poRDbQuery->u8QueryTag >= enMeca_TagID_Preset_Info_Start){
			ETG_TRACE_USR4(("dabdrv_presets::vOnPresetListQueryResponse u8QueryTag %d ",poRDbQuery->u8QueryTag));
			trPresetInfo presetInfo;
			presetInfo.u8StationNumber = (tU8)(poRDbQuery->u8QueryTag - enMeca_TagID_Preset_Info_Start);
			vUpdatePresetInfo(presetInfo,rProperty);
		}else{
			//Incase of delete preset all sysstorewill be triggered from defset.
			vUpdateAllPresetList(vecPresetListInfo,rProperty);
		}
		return;
	}


	vExtractPresetInfo(poRDbQuery,vecPresetListInfo);

	//if single preset info just update the preset info and return
	if(poRDbQuery->u8QueryTag >= enMeca_TagID_Preset_Info_Start &&
			vecPresetListInfo.size()!= 0){
		vUpdatePresetInfo(vecPresetListInfo[0],rProperty,TRUE);
		return;
	}

	vUpdateAllPresetList(vecPresetListInfo,rProperty);
}


tVoid dabdrv_presets::vUpdateAllPresetList(vector<trPresetInfo>& vecPresetListInfo,DAB_trPresetListProperty& rProperty){
	//Update All presets info _vPresetInfos
	for (tU8 u8PresetNr=1;u8PresetNr<=u8NumberofPresets;++u8PresetNr) {

		trPresetInfo rPresetInfo;
		rPresetInfo.u8StationNumber = u8PresetNr;
		DAB_FOREACH(vector<trPresetInfo>, iterPreset, vecPresetListInfo){

				if((*iterPreset).u8StationNumber == u8PresetNr){

					rPresetInfo=(*iterPreset);
					break;
				}
		}
		vUpdatePresetInfo(rPresetInfo,rProperty);
	}
}

tVoid dabdrv_presets::vExtractPresetInfo(trMeca_RDbQuery* poRDbQuery,vector<trPresetInfo>& vecPresetListInfo){

	tU32 u32DataLength = (tU32)(poRDbQuery->lu8UserData.size());
	tU8* pu8Data = OSAL_NEW tU8[u32DataLength];
	if (pu8Data == NULL){
		ETG_TRACE_USR4(("dabdrv_presets::vExtractPresetInfo result length %d",u32DataLength));
		return;
	}

	for(tU32 u32Index=0; u32Index<u32DataLength; u32Index++){
		pu8Data[u32Index] = poRDbQuery->lu8UserData[u32Index];
	}

	vPrepareVectorPresetList((tU8)(poRDbQuery->u16QueryNumRows),vecPresetListInfo,pu8Data,u32DataLength);

	OSAL_DELETE[] pu8Data;
}

tVoid dabdrv_presets::vPrepareVectorPresetList(tU8 rowCount,vector<trPresetInfo>& vecPresetListInfo,tU8* pu8Data,tU32 u32DataLength){
	
	tBool _bIsLabelReplaced = FALSE;
	for (tU16 u16Row=1;u16Row<=rowCount;u16Row++){

		tS16 s16StationNumber=(tS16)(sdxf_chunk_get_numeric_sint32(sdxf_table_get_chunk(pu8Data,u32DataLength,u16Row,ONE)));

		if(s16StationNumber<0){ //if rdm_sttnum returns -1
				continue;
		}
		tU32 u32Freq =  sdxf_chunk_get_numeric_uint32(sdxf_table_get_chunk(pu8Data,u32DataLength,u16Row,TWO));
		tU8 u8Secc = (tU8)(sdxf_chunk_get_numeric_uint32(sdxf_table_get_chunk(pu8Data,u32DataLength,u16Row,THREE)));
		tU8 u8Stype=(tU8)(sdxf_chunk_get_numeric_uint32(sdxf_table_get_chunk(pu8Data,u32DataLength,u16Row,FOUR))+1);
		tU16 u16Sid=(tU16)(sdxf_chunk_get_numeric_uint32(sdxf_table_get_chunk(pu8Data,u32DataLength,u16Row,FIVE)));
		tU32 u32Rservice = (u8Stype<<24) | (u8Secc<<16) | (u16Sid);
		APILabel label;
		sdxf_labelblob_2_apilabel(&label, sdxf_chunk_get_blob(sdxf_table_get_chunk(pu8Data,u32DataLength,u16Row,SIX)));
		tU16 u16Scids=(tU16)(sdxf_chunk_get_numeric_uint32(sdxf_table_get_chunk(pu8Data,u32DataLength,u16Row,SEVEN)));
		
		if(u16Scids >= u8InvalidScIds)
		{
			u16Scids = 0;
		}
		ETG_TRACE_USR4(("dabdrv_presets::row %d stationNumber %d u32Freq %u secc %d sType %d u32Rservice %x scids %d",u16Row,s16StationNumber,u32Freq,u8Secc,u8Stype,u32Rservice,u16Scids));
		//CRQ 431566 preset label replace
		if (((DAB_CHNINFO_UPDATE_SUPERVISION_TIMER_MS)>0) && (label.b_label[0]=='\0'))
		{
			sprintf((char *)label.b_label, "%x", u32Rservice);
			ETG_TRACE_USR4(("dabdrv_presets::vPrepareVectorPresetList rServiceInfo.ServiceLabel.b_label %s", label.b_label));
			_bIsLabelReplaced = TRUE;
		}

		trPresetInfo presetInfo;
		presetInfo.u8StationNumber = (tU8)s16StationNumber;
		presetInfo.rPSID = trMecaProgrammeService(u32Rservice,enMeca_ServiceType_AUDIO_SERVICE,u16Scids);
		presetInfo.u32Frequency = (u32Freq != 0) ? u32Freq : 0;
		//CRQ 431566 for preset label short
		if (_bIsLabelReplaced) {
			presetInfo.rLabel.vParse(label, TRUE);
			_bIsLabelReplaced = FALSE;
		}
		else {
			presetInfo.rLabel.vParse(label);
		}
		presetInfo.vTrace();

		vecPresetListInfo.push_back(presetInfo);
	}
}

tVoid dabdrv_presets::vFinalizeStorePreset(tU8 u8StationNumber, tenMeca_RdmStationState enStationState) {

	if (dabdrv_chnInfo::instance()->rGetChnInfo().rMecaId==
				 dabdrv_rdm::instance()->rGetLastRdmInfo().rProgrammeService){
		/*update active service info preset number*/
		DAB_trServiceInfoProperty rServiceInfoProperty=dabdrv_properties::instance()->oServiceInfoProperty.oGet();
		rServiceInfoProperty.u8PresetNumber = u8StationNumber;
		dabdrv_properties::instance()->oServiceInfoProperty.vSet(rServiceInfoProperty);
	}
	if(_u8PresetDeleteCounter > 0)
		_u8PresetDeleteCounter--;
	ETG_TRACE_USR4(("dabdrv_presets::vFinalizeStorePreset %d",_u8PresetDeleteCounter));
	if (_enDeleteAction == DAB_enPresetListDelete_AllElems && _u8PresetDeleteCounter == 1){
			trMsgDrvDbQuery rDbQuery(Query_PresetInfo_All);
			DAB_vCallMsg(rDbQuery);
			_enDeleteAction = DAB_enPresetListDelete_None;
	}
	else if(_enDeleteAction == DAB_enPresetListDelete_None
						|| _enDeleteAction == DAB_enPresetListDelete_OneElem)//incase of store preset or delete a single preset.
	{
		trMsgDrvDbQuery rDbQuery(Query_PresetInfo);
		rDbQuery.u8Param1 = u8StationNumber;
		DAB_vCallMsg(rDbQuery);
		_enDeleteAction = DAB_enPresetListDelete_None;
	}

    _oPresetStoreSuperVisionTimer.vStop();

    DAB_tenResult enRes = DAB_enResult_OK;
    if ( (enStationState == enMeca_RdmStationState_STATION_SET_OK) || (enStationState == enMeca_RdmStationState_STATION_STORE_OK) ) {
		enRes = DAB_enResult_OK;
		//If request comes from Store preset then make select source as recall preset otherwise make it as none.
		_enChnSelectSource = _u8PresetDeleteCounter == 1? enChnSelectSource_None: enChnSelectSource_RecallPreset;
    }
	else
	{
		 enRes = DAB_enResult_FAILED;
        _u8ActiveStorePreset=0;
	}

    trMsgSrvRspSetPresetStation rSrvRsp(enRes);
    DAB_vCallMsg(rSrvRsp);


}
tVoid dabdrv_presets::vProcess(trMeca_RRdmStationSetPresetStation* poRRdmSetPresetStation) {
    ETG_TRACE_USR4(("dabdrv_presets(trMeca_RRdmStationSetPresetStation) enStationState=%d",
                                ETG_CENUM(tenMeca_RdmStationState, poRRdmSetPresetStation->enStationState)));
    //From Test operation when PLAY_ASID with SID anf frequency is sent, after moving the chninfo to LSM play the LSM
	if(u8UserUpdate > 0)
	{
		if(poRRdmSetPresetStation->enStationState == enMeca_RdmStationState_STATION_SET_OK)
		{
			if(u8Index < u8UserUpdate)
			{
				trMeca_CRdmStationSetPresetStation rCRdmSetPresetStation = vSendSetPresetStationList(u8Index);
				u8Index++;
			}
			else
			{
				trMsgDrvDbQuery rDbQuery(Query_PresetInfo_All);
				DAB_vCallMsg(rDbQuery);
				ETG_TRACE_USR1(("dabdrv_presets(trMeca_RRdmStationSetPresetStation) systore"));
				DAB_vCallMsgCtor(trMsgDrvCmdSysStore(1, TRUE));
				u8Index = 0;
				u8UserUpdate = 0;
				trMsgSrvCmdRspSavePresetList oRspSavePresetList;
				oRspSavePresetList.enRes = DAB_enResult_OK;
				DAB_vCallMsg(oRspSavePresetList);
			}
		}
		else
		{
			ETG_TRACE_USR1(("  dabdrv_presets(trMeca_RRdmStationSetPresetStation) SysReStore"));
			trMeca_CSysReStore rSysReStore;
			rSysReStore.u8UserId=u8UserId;
			u8Index = 0;
			u8UserUpdate = 0;
			ETG_TRACE_USR1(("  dabdrv_presets(trMeca_RRdmStationSetPresetStation) u8Index = %d", u8Index));
			dabdrv_mecaIf::instance()->vSendMecaCommand(rSysReStore);
			trMsgSrvCmdRspSavePresetList oRspSavePresetList;
			oRspSavePresetList.enRes = DAB_enResult_FAILED;
			DAB_vCallMsg(oRspSavePresetList);
			return;
		}
	}
	else
	{
    if(poRRdmSetPresetStation->u8StationNumber ==0 && dabdrv_main::instance()->enGetSourceState() == DAB_enSourceState_FG
    		&& _enChnSelectSource != enChnSelectSource_RecallPreset){

    	vPLayLSM(0);
    	return;
    }

    vFinalizeStorePreset(poRRdmSetPresetStation->u8StationNumber, poRRdmSetPresetStation->enStationState);
	}
}


tBool dabdrv_presets::bPresetNumberValid(tU16 u16PresetNumber) const {
    return (u16PresetNumber >0 && u16PresetNumber<=u8NumberofPresets);
   
}

tVoid dabdrv_presets::vAutoStoreResponse()
{
	if(dabdrv_db::instance()->bGetAutoStorePendingStatus()){
			static tU8 u8rRes_counter = 0;
			tU8 u8FoundStations = dabdrv_db::instance()->vGetFoundStations();			
			u8rRes_counter++;
			
			ETG_TRACE_USR4(("u8rRes_counter = %d", u8rRes_counter));
			if(u8rRes_counter == u8FoundStations || u8FoundStations==0)
			{
				trMsgSrvRspAutostore rResAutostore;
				if(u8FoundStations==0)
					rResAutostore.enRes=DAB_enResult_FAILED;
				else
					rResAutostore.enRes=DAB_enResult_OK;

                rResAutostore.u8NumberOfFoundStations = u8FoundStations;
				u8rRes_counter=0;
				dabdrv_db::instance()->vSetAutoStorePendingStatus(FALSE);
				
				DAB_vCallMsg(rResAutostore);
				dabdrv_presets::instance()->vSetAutoStoreType(enAutostore_InValid);
				dabdrv_learn::instance()->vSetAutostoreAction(enAutostoreAction_InValid);		
			}
		}
}

tVoid dabdrv_presets::vUpdatePresetInfo(trPresetInfo& rRcvPreset,DAB_trPresetListProperty& rProperty,tBool bDoSysStore){


    tU8 u8StationNumber=rRcvPreset.u8StationNumber;
    tBool bUpdate=FALSE;

    ETG_TRACE_USR4(("dabdrv_presets::vUpdatePresetInfo u8StationNumber=%d, _u8ActiveStorePreset = %d ServiceId=%u scids=%d label=%17s labelok = %d",
                        u8StationNumber, _u8ActiveStorePreset,rRcvPreset.rPSID._u32Id,rRcvPreset.rPSID._u16Scids, rRcvPreset.rLabel.pcGetCString(),rRcvPreset.rLabel.bIsLabelOk()));

    if (bPresetNumberValid(u8StationNumber)) {

        rRcvPreset.vTrace();
		if((rRcvPreset.rPSID.bIsValid() && bDoSysStore)){
			DAB_vCallMsgCtor(trMsgDrvCmdSysStore(1, TRUE)); // u8UsrId=1, quick;
		}
        _vPresetInfos[u8StationNumber].vTrace();
        if (_u8ActiveStorePreset==u8StationNumber) {
            bUpdate=TRUE;
            _u8ActiveStorePreset=0;
            if(rRcvPreset.rLabel.bIsLabelOk()){
				//Make the current selected preset as the recall preset
				_u8ActiveRecallPreset = u8StationNumber;
            }
            _rPersUsrData.rActivePreset.u8PresetNr=u8StationNumber;
            _rPersUsrData.rActivePreset.rPsid=rRcvPreset.rPSID;
            _rPersUsrData.rActivePreset.u32Frequency=rRcvPreset.u32Frequency;
        }


        vUpdatePresetProperty(rRcvPreset,u8StationNumber,bUpdate,rProperty);
        vAutoStoreResponse();

     }
}

tVoid dabdrv_presets::vUpdatePresetProperty(trPresetInfo& rRcvPreset,tU8 u8StationNumber, tBool bUpdate,DAB_trPresetListProperty& rProperty){


	 if (bUpdate || (_vPresetInfos[u8StationNumber] != rRcvPreset)) {


		ETG_TRACE_USR4(("  sdabdrv_presets(vUpdatePresetProperty) bUpdate"));
		// removed old preset
		trMecaProgrammeService rOldPsid=_vPresetInfos[u8StationNumber].rPSID;
		if (rOldPsid.bIsValid()) {
			_mapPresetsByPSID[rOldPsid].erase(u8StationNumber);
			if (_mapPresetsByPSID[rOldPsid].empty()) {
				_mapPresetsByPSID.erase(rOldPsid);
			}
		}

		rRcvPreset.sLogoLink= dabdrv_chnList::instance()->sGetLogoLink(rRcvPreset.rPSID._u32Id , TRUE);

		// add new preset
		_vPresetInfos[u8StationNumber]=rRcvPreset;
		rProperty.u8FirstElementID =0;
		rProperty.u8NumberOfElements=0;
		trPresetInfo &rPresetInfo =_vPresetInfos[u8StationNumber];
		if(u8StationNumber <=rProperty.vecPresetListInfo.size())
		{
			rProperty.vecPresetListInfo[u8StationNumber-1]=rPresetInfo;
		}
		else
		{
			rProperty.vecPresetListInfo.push_back(rPresetInfo);
		}
		rProperty.u8NumberOfElements=(tU8)(rProperty.vecPresetListInfo.size());


		if(rPresetInfo.rLabel.bIsLabelOk()){
			_mapPresetsByPSID[rPresetInfo.rPSID].insert(u8StationNumber) ;
		}
		//if the selected Preset channel  is updated or cleared
		//refresh the presetinfo
		trMecaProgrammeService rCurrentPsid(dabdrv_chnInfo::instance()->rGetCurrentSid()._u32Id,
				enMeca_ServiceType_AUDIO_SERVICE,dabdrv_chnInfo::instance()->rGetChnInfo().u16Scids);
		if (rRcvPreset.rPSID == rCurrentPsid ||
				rOldPsid == rCurrentPsid) {
			DAB_vCallMsgCtor(trMsgDrvRspChnListCurrentSrvChanged(rCurrentPsid));
		}
	}
}

tU8 dabdrv_presets::bIsPresetInBank(tU8 u8PresetNr) const {

	    ETG_TRACE_USR4(("  dabdrv_presets::bIsPresetInBank _u8PresetBank=%d",
                   _u8PresetBank));

    tU8 u8FirstPreset=(tU8)((_u8PresetBank * u8NumberofPresetsPerBank) +1);
    return ((u8PresetNr >= u8FirstPreset) && (u8PresetNr <= u8FirstPreset+u8NumberofPresetsPerBank));
}

tU8 dabdrv_presets::u8GetPresetNumber(trMecaId const &rPSID,tU8 u8Scids) {

    ETG_TRACE_USR4(("  dabdrv_presets::u8GetPresetNumbern rPSID=%x  activePresetPid=%x  _enChnSelectSource=%d scids=%d",
                        rPSID._u32Id,
                        _rPersUsrData.rActivePreset.rPsid._u32Id,
                        _enChnSelectSource,
                        u8Scids));
    ETG_TRACE_USR4(("  dabdrv_presets::u8GetPresetNumbern inside _u8ActiveRecallPreset %d",_u8ActiveRecallPreset));
    tU8 u8ResPresetNumber=0;
    // search for ProgrammeService in our map
    //if (rPSID.bIsValid() && _rPersUsrData.rActivePreset.rPsid==rPSID) {
      //  return _rPersUsrData.rActivePreset.u8PresetNr;
    //}
    trMecaProgrammeService srvid(rPSID._u32Id,enMeca_ServiceType_AUDIO_SERVICE,u8Scids);
    DAB_IF_FIND_MAP(trMecaProgrammeService,tPresetNrSet, iterPsid, _mapPresetsByPSID, srvid) {
    	ETG_TRACE_USR4(("  dabdrv_presets::u8GetPresetNumbern inside FINDMAP _u32Id %d scids %d preset count %d",rPSID._u32Id,u8Scids,(tU16)(iterPsid->second.size())));
    	DAB_FOREACH(tPresetNrSet, iterPresets, iterPsid->second) {
    		 tU8 PresetNumber=(*iterPresets);
    		ETG_TRACE_USR1(("dabdrv_presets(u8GetPresetNumber) loop PresetNumber (%d)",
    		                    PresetNumber));
    	}
        // iterate over all preset-numbers belonging to rPSID
        DAB_FOREACH(tPresetNrSet, iterPresets, iterPsid->second) {
            tU8 PresetNumber=(*iterPresets);
            /*
             * Fix for 22702 START
             */
            if(PresetNumber != _u8ActiveRecallPreset && _enChnSelectSource == enChnSelectSource_RecallPreset){
            	continue;

            }
            /*
			 * Fix for 22702 END
			 */
			ETG_TRACE_USR1(("dabdrv_presets(u8GetPresetNumber) PresetNumber (%d)",
                    PresetNumber));
            if (!u8ResPresetNumber) {
                // store the first preset-number in set
                // we have to continue the search to make sure we return a preset-number inside the current bank in case
                u8ResPresetNumber=PresetNumber;
            }
            if (bIsPresetInBank(PresetNumber)) {
                // if we found a preset in the current bank, we are done
                u8ResPresetNumber=PresetNumber;
                break;
            }
        }
    }
    ETG_TRACE_USR4(("  dabdrv_presets::u8GetPresetNumbern rPSID=0x%08x --> %d, state:",
                    rPSID.u32GetSID(), u8ResPresetNumber));
    return u8ResPresetNumber;
}

tVoid dabdrv_presets::vProcess(trMsgSrvCmdStorePreset* poStorePreset) {

    ETG_TRACE_USR4(("dabdrv_presets(trMsgSrvCmdStorePreset) u8PresetNumber=%d PSID=%u scids=%d",
                                poStorePreset->u8PresetNumber,poStorePreset->rPSID._u32Id,poStorePreset->rPSID._u16Scids));

    tU8 u8PresetNr = poStorePreset->u8PresetNumber;
    trMecaProgrammeService rPSID = poStorePreset->rPSID;

    if (!bPresetNumberValid(u8PresetNr)) {
        trMsgSrvRspSetPresetStation rSrvRsp(DAB_enResult_FAILED);
        DAB_vCallMsg(rSrvRsp);
        return;
    }
    /*Presets were not allowed to be stored in comp mode*/
    /*if (dabdrv_main::instance()->bIsCompMode()) {
        trMsgSrvRspSetPresetStation rSrvRsp(DAB_enResult_FAILED);
        DAB_vCallMsg(rSrvRsp);
        return;
    }*/

        ETG_TRACE_USR4(("dabdrv_presets(trMsgSrvCmdStorePreset) u16scids =%d ",dabdrv_chnInfo::instance()->rGetChnInfo().u16Scids));                       
    _u8ActiveStorePreset=u8PresetNr;

    if(poStorePreset->bDelete) {
        _u8ActiveStorePreset=0;
        
        // check if parameters for delete work
        // (copy from rlib/dab_preset.c)
        trMeca_CRdmStationSetPresetStation rCRdmSetPresetStation;
        rCRdmSetPresetStation.enServiceType=enMeca_ServiceType_INVALID;
        trChnListChnInfo rChnInfo = dabdrv_chnInfo::instance()->rGetChnInfo();
        rCRdmSetPresetStation.u8StationNumber=u8PresetNr;
        rCRdmSetPresetStation.rProgrammeService=rChnInfo.rMecaId.rGetProgService();
        rCRdmSetPresetStation.u32Frequency=0;
        rCRdmSetPresetStation.rLabel = rChnInfo.rLabel;
        dabdrv_mecaIf::instance()->vSendMecaCommand(rCRdmSetPresetStation);
    }
    else if (rPSID.bIsValid()) {

    	vSendSpecialPresetSave(poStorePreset);
    }

	// Current state is being checked as preset store should only go if channel is availble. Else in case of no signals, on pressing star button on main PSA screen current channel is stored in preset.
    else if (dabdrv_chnInfo::instance()->rGetChnInfo().rMecaId==
             dabdrv_rdm::instance()->rGetLastRdmInfo().rProgrammeService &&
             dabdrv_chnInfo::instance()->rGetChnInfo().u16Scids == 0 && (!dabdrv_chnList::instance()->bIsMapServiceInfoEmpty())){ //If the current service is not a secondary service 
																																// !dabdrv_chnList::instance()->bIsMapServiceInfoEmpty() -> Fix for NCG3D-117213
        trMeca_CRdmStationStore rStationStore;
        rStationStore.u8StationNumber= u8PresetNr;
        ETG_TRACE_USR4(("dabdrv_presets(trMsgSrvCmdStorePreset) trMeca_CRdmStationStore u16Scids %d",dabdrv_chnInfo::instance()->rGetChnInfo().u16Scids));
        dabdrv_mecaIf::instance()->vSendMecaCommand(rStationStore);
    } else {

    	vSendSetPresetStation(poStorePreset);
    }

    _oPresetStoreSuperVisionTimer.vStart(DAB_PRESET_STORE_SUPERVISION_TIMER_MS);

}

tVoid dabdrv_presets::vProcess(trMsgSrvSavePresetList* poSavePresetList){
	u8UserUpdate = (tU8)(poSavePresetList->vecPresetInfos.size());
	ETG_TRACE_USR4(("dabdrv_presets(trMsgSrvSavePresetList): u8UserUpdate = %d", u8UserUpdate));
	vecPresetInfo = poSavePresetList->vecPresetInfos;
	ETG_TRACE_USR4(("dabdrv_presets(trMsgSrvSavePresetList)"));
	trMeca_CRdmStationSetPresetStation rCRdmSetPresetStation = vSendSetPresetStationList(u8Index);
	u8Index++;
}
trMeca_CRdmStationSetPresetStation dabdrv_presets::vSendSetPresetStationList(tU8 u8vecPresetInfosIndex){
	ETG_TRACE_USR4(("dabdrv_presets(vSendSetPresetStationList) u8vecPresetInfosIndex = %d", u8vecPresetInfosIndex));
	trMeca_CRdmStationSetPresetStation rCRdmSetPresetStation;
	rCRdmSetPresetStation.u8StationNumber = vecPresetInfo[u8vecPresetInfosIndex].u8StationNumber;
	if (vecPresetInfo[u8vecPresetInfosIndex].rPSID == 0 && vecPresetInfo[u8vecPresetInfosIndex].u32EnsembleId == 0 && vecPresetInfo[u8vecPresetInfosIndex].u32Frequency ==0)
	{
		rCRdmSetPresetStation.enServiceType = enMeca_ServiceType_INVALID;
	}
	else{
		rCRdmSetPresetStation.enServiceType = enMeca_ServiceType_AUDIO_SERVICE;
	}
    rCRdmSetPresetStation.rProgrammeService = vecPresetInfo[u8vecPresetInfosIndex].rPSID;
    rCRdmSetPresetStation.u32Frequency = vecPresetInfo[u8vecPresetInfosIndex].u32Frequency;
    rCRdmSetPresetStation.rLabel = vecPresetInfo[u8vecPresetInfosIndex].rLabel;
	//trChnListChnInfo rChnInfo = dabdrv_chnInfo::instance()->rGetChnInfo();
	//rCRdmSetPresetStation.rLabel = rChnInfo.rLabel;
    rCRdmSetPresetStation.rEnsemble._u32Id = vecPresetInfo[u8vecPresetInfosIndex].u32EnsembleId;
    rCRdmSetPresetStation.rEnsLabel = vecPresetInfo[u8vecPresetInfosIndex].rEnsembleLabel;
    rCRdmSetPresetStation.scids = vecPresetInfo[u8vecPresetInfosIndex].u8Scid;
    rCRdmSetPresetStation.rCompLabel = vecPresetInfo[u8vecPresetInfosIndex].rCompLabel;
	rCRdmSetPresetStation.dataLength = 76;
	rCRdmSetPresetStation.vTrace();
	 dabdrv_mecaIf::instance()->vSendMecaCommand(rCRdmSetPresetStation);
	 return rCRdmSetPresetStation;
}
//Currently supports only primary channel, Getting called from Testoperation when PLAY_ASID is called
tVoid dabdrv_presets::vMovePresetToLSM(trMsgSrvCmdStorePreset* poStorePreset){

	ETG_TRACE_USR4(("vMovePresetToLSM(trMsgSrvCmdStorePreset"));
	 trMeca_CRdmStationSetPresetStation rCRdmSetPresetStation;
	 rCRdmSetPresetStation.enServiceType=enMeca_ServiceType_AUDIO_SERVICE;
	 rCRdmSetPresetStation.u8StationNumber =  _vPresetInfos[0].u8StationNumber = poStorePreset->u8PresetNumber;
	 rCRdmSetPresetStation.rProgrammeService = _vPresetInfos[0].rPSID = poStorePreset->rPSID;
	 rCRdmSetPresetStation.u32Frequency = _vPresetInfos[0].u32Frequency = poStorePreset->u32EnsFrequency;

	 rCRdmSetPresetStation.vTrace();
	 dabdrv_mecaIf::instance()->vSendMecaCommand(rCRdmSetPresetStation);
}

tVoid dabdrv_presets::vSendSpecialPresetSave(trMsgSrvCmdStorePreset* poStorePreset){

    trMeca_CRdmStationSetPresetStation rCRdmSetPresetStation;
    trMecaProgrammeService rMecaPrgSrv = poStorePreset->rPSID;
    trChnListChnInfo chninfo = dabdrv_chnList::instance()->rGetChnInfo(trMecaId(rMecaPrgSrv._u32Id),rMecaPrgSrv._u16Scids);
    if (!chninfo.rMecaId.rGetProgService().bIsValid()) {
    	ETG_TRACE_USR4(("dabdrv_presets(vSendSpecialPresetSave) Failed"));
            return;
        }

    rCRdmSetPresetStation.enServiceType=enMeca_ServiceType_AUDIO_SERVICE;
    rCRdmSetPresetStation.u8StationNumber = poStorePreset->u8PresetNumber;
    rCRdmSetPresetStation.rProgrammeService=rMecaPrgSrv;
    rCRdmSetPresetStation.u32Frequency=poStorePreset->u32EnsFrequency;
    rCRdmSetPresetStation.rLabel = chninfo.rLabel;
    rCRdmSetPresetStation.dataLength = 30;
    if(chninfo.u16Scids !=0 ){ //Check if it is a secondary channel.

           	 rCRdmSetPresetStation.dataLength = 76;
           	 rCRdmSetPresetStation.rEnsemble = dabdrv_chnList::instance()->rGetEnsembleElemFromFrozenList(chninfo.u16FrozenListId).rEnsemble;
           	 rCRdmSetPresetStation.rEnsLabel = dabdrv_chnList::instance()->rGetEnsembleElemFromFrozenList(chninfo.u16FrozenListId).rEnsembleLabel;
           	 rCRdmSetPresetStation.scids = (tU8)(chninfo.u16Scids);
           	 rCRdmSetPresetStation.rCompLabel = chninfo.rLabel;
           }
    ETG_TRACE_USR4(("dabdrv_presets(vSendSpecialPresetSave) "));
    rCRdmSetPresetStation.vTrace();
    chninfo.vTrace();

    dabdrv_mecaIf::instance()->vSendMecaCommand(rCRdmSetPresetStation);

}

tVoid dabdrv_presets::vSendSetPresetStation(trMsgSrvCmdStorePreset* poStorePreset){

    // use data from chn-list

    trMeca_CRdmStationSetPresetStation rCRdmSetPresetStation;
    rCRdmSetPresetStation.enServiceType=enMeca_ServiceType_AUDIO_SERVICE;
    trChnListChnInfo rChnInfo = dabdrv_chnInfo::instance()->rGetChnInfo();
    trMecaProgrammeService rProgSrv=rChnInfo.rMecaId.rGetProgService();
    if (!rProgSrv.bIsValid()) {
        trMsgSrvRspSetPresetStation rSrvRsp(DAB_enResult_FAILED);
        DAB_vCallMsg(rSrvRsp);
        return;
    }
    rCRdmSetPresetStation.u8StationNumber= poStorePreset->u8PresetNumber;
    rCRdmSetPresetStation.rProgrammeService=rProgSrv;
    rCRdmSetPresetStation.u32Frequency=dabdrv_chnList::instance()->u32GetFrequencyOfService(rProgSrv);
    rCRdmSetPresetStation.rLabel = rChnInfo.rLabel;
    rCRdmSetPresetStation.dataLength = 30;
    ETG_TRACE_USR4(("dabdrv_presets(trMsgSrvCmdStorePreset) SCIDS %d",rChnInfo.u16Scids));
    if(rChnInfo.u16Scids !=0 ){ //Check if it is a secondary channel.

    	 rCRdmSetPresetStation.dataLength = 76;
    	 rCRdmSetPresetStation.rEnsemble = dabdrv_chnInfo::instance()->rGetCurrEnsemble();
    	 rCRdmSetPresetStation.rEnsLabel = dabdrv_chnInfo::instance()->rGetCurrEnsembleInfo().rEnsembleElem.rEnsembleLabel;
    	 rCRdmSetPresetStation.scids = (tU8)rChnInfo.u16Scids;
    	 rCRdmSetPresetStation.rCompLabel = rChnInfo.rLabel;
    }
    dabdrv_mecaIf::instance()->vSendMecaCommand(rCRdmSetPresetStation);


}

tVoid dabdrv_presets::vProcess(trMsgSrvCmdClearPresets* poClearPreset) {

    ETG_TRACE_USR4(("dabdrv_presets(trMsgSrvCmdClearPresets Action %d)",poClearPreset->enDeleteAction));

    // check if parameters for delete work
    // (copy from rlib/dab_preset.c)
        trMeca_CRdmStationSetPresetStation rCRdmSetPresetStation;
        rCRdmSetPresetStation.enServiceType=enMeca_ServiceType_INVALID;
        rCRdmSetPresetStation.rProgrammeService=0;
        rCRdmSetPresetStation.u32Frequency=0;
        rCRdmSetPresetStation.rLabel = 0;
	_u8PresetDeleteCounter =1;
	if(poClearPreset->enDeleteAction==DAB_enPresetListDelete_AllElems){
		_enDeleteAction = DAB_enPresetListDelete_AllElems;
		_enPresetListToHMIStatus=enPresetListToHMI_INPROGRESS;
		for (tU8 u8PresetNr=1; u8PresetNr<=u8NumberofPresets; u8PresetNr++) {			
			if(_vPresetInfos[u8PresetNr].rPSID.bIsValid())
			{
				_u8PresetDeleteCounter++;
			rCRdmSetPresetStation.u8StationNumber=u8PresetNr;			
        ETG_TRACE_USR4(("dabdrv_presets(trMsgSrvCmdClearPresets) delete Preset %d",u8PresetNr));
			dabdrv_mecaIf::instance()->vSendMecaCommand(rCRdmSetPresetStation);
		}
		}	
	}
	else
	{
		tU8 u8PresetNo=poClearPreset->u8PresetNumber;
		if(_vPresetInfos[u8PresetNo].rPSID.bIsValid())
		{
			_u8PresetDeleteCounter++;
			_enDeleteAction = DAB_enPresetListDelete_OneElem;
		rCRdmSetPresetStation.u8StationNumber=poClearPreset->u8PresetNumber;
		ETG_TRACE_USR4(("dabdrv_presets(trMsgSrvCmdClearPresets) delete Preset %d",poClearPreset->u8PresetNumber));
        dabdrv_mecaIf::instance()->vSendMecaCommand(rCRdmSetPresetStation);
		}
    }
	if(_u8PresetDeleteCounter==1)
	{		
		_u8PresetDeleteCounter=0;
		_enDeleteAction = DAB_enPresetListDelete_None;
		_enPresetListToHMIStatus=enPresetListHMI_UPDATEDONE;
		DAB_trPresetListProperty rProperty=dabdrv_properties::instance()->oPresetListDataProperty.oGet();
		DAB_vCallMsg(rProperty);	
    }
}


tVoid dabdrv_presets::vProcess(trMsgSrvCmdAutoStore* poAutostore){
	 ETG_TRACE_USR4(("dabdrv_presets(trMsgSrvCmdAutoStore)"));

	 _enAutoStoreType = poAutostore->enAutostoreType;
	 dabdrv_learn::instance()->vSetAutostoreAction((tenAutostoreAction)poAutostore->bStart);

	 if(poAutostore->bStart) {

		dabdrv_main::instance()->vSetStartupLearn(TRUE);
		trMsgSrvCmdLearn oCmdLearn(enLearnType_VIRGIN);
		DAB_vCallMsg(oCmdLearn);

#if 0
		/*delete ensemble+services+components memory*/
		dabdrv_main::instance()->vClearDatabase(enMeca_DbConfig_ValueId_delete_All);
#endif
		/*delete preset memory*/
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_VW_MIBE
		dabdrv_main::instance()->vClearDatabase(enMeca_DbConfig_ValueId_delete_presets);
#endif

	}
	 else
	 {		
		trMsgSrvCmdLearn oCmdLearn(enLearnType_OFF);
		DAB_vCallMsg(oCmdLearn);

	 }
}
	
tVoid dabdrv_presets::vSetPreset(tU8 u8PresetNr,trPresetInfo &rPrstInfo)const
{
	ETG_TRACE_USR4(("dabdrv_presets(vSetPreset) prest no=%d SID=%08x",
		u8PresetNr,
		rPrstInfo.rPSID.u32GetSID()));
	trMeca_CRdmStationSetPresetStation rCRdmSetPresetStation;
	rCRdmSetPresetStation.enServiceType=enMeca_ServiceType_AUDIO_SERVICE;
	rCRdmSetPresetStation.u8StationNumber = u8PresetNr;
	rCRdmSetPresetStation.rProgrammeService=rPrstInfo.rPSID;
	rCRdmSetPresetStation.u32Frequency=dabdrv_chnList::instance()->u32GetFrequencyOfService(rPrstInfo.rPSID);
	dabdrv_mecaIf::instance()->vSendMecaCommand(rCRdmSetPresetStation);
}
tVoid dabdrv_presets::vProcess(trMeca_RRdmStationStore* poRRdmStationStore) {
    ETG_TRACE_USR4(("dabdrv_presets(trMeca_RRdmStationStore) enStationState=%d stationnumber=%d",
                                ETG_CENUM(tenMeca_RdmStationState, poRRdmStationStore->enStationState),poRRdmStationStore->u8StationNumber));
    if ( poRRdmStationStore->enStationState == enMeca_RdmStationState_STATION_INVALID ) {
        // use data from chn-list and store hard NIKAI-2610
        trMeca_CRdmStationSetPresetStation rCRdmSetPresetStation;
        rCRdmSetPresetStation.enServiceType=enMeca_ServiceType_AUDIO_SERVICE;
        trChnListChnInfo rChnInfo = dabdrv_chnInfo::instance()->rGetChnInfo();

        ETG_TRACE_USR4(("dabdrv_presets(trMeca_RRdmStationSetPresetStation) enMeca_RdmStationState_STATION_INVALID ChnInfo"));
        rChnInfo.vTrace();

        trMecaProgrammeService rProgSrv=rChnInfo.rMecaId.rGetProgService();
        if (!rProgSrv.bIsValid()) {
            trMsgSrvRspSetPresetStation rSrvRsp(DAB_enResult_FAILED);
            DAB_vCallMsg(rSrvRsp);
            return;
        }
        rCRdmSetPresetStation.u8StationNumber=poRRdmStationStore->u8StationNumber;
        rCRdmSetPresetStation.rProgrammeService=rProgSrv;
        rCRdmSetPresetStation.u32Frequency=dabdrv_chnList::instance()->u32GetFrequencyOfService(rProgSrv);
        rCRdmSetPresetStation.rLabel = rChnInfo.rLabel;

        ETG_TRACE_USR4(("dabdrv_presets(trMeca_RRdmStationSetPresetStation) enMeca_RdmStationState_STATION_INVALID PresetStation:"));
        rCRdmSetPresetStation.vTrace();

        dabdrv_mecaIf::instance()->vSendMecaCommand(rCRdmSetPresetStation);
    }
    else {
        vFinalizeStorePreset(poRRdmStationStore->u8StationNumber, poRRdmStationStore->enStationState);
    }
}

tVoid dabdrv_presets::vProcess(trMeca_RRdmStationPlay* poRRdmStationPlay) {

	 ETG_TRACE_USR4(("dabdrv_presets(trMeca_RRdmStationPlay) START"));
    (tVoid)poRRdmStationPlay;
    switch (poRRdmStationPlay->enStationState) {
        case enMeca_RdmStationState_STATION_PLAY_OK:
        case enMeca_RdmStationState_STATION_STORE_OK:
        case enMeca_RdmStationState_WAITING_FOR_STATION_PLAY:
		case enMeca_RdmStationState_STATION_FREE:
        case enMeca_RdmStationState_STATION_SET_OK:
            break;
        case enMeca_RdmStationState_STATION_NUMBER_INVALID:
        case enMeca_RdmStationState_STATION_INVALID:
        case enMeca_RdmStationState_STATION_PLAY_ERROR:
        case enMeca_RdmStationState_STATION_SERVICE_INVALID:
        case enMeca_RdmStationState_STATION_ENS_FREQ_INVALID:
        default:
        {
        	//In some scenarios Waiting for station play response is not coming
        	//hence source state response is not sent to clients.
        	if(dabdrv_main::instance()->bGetSourceChangingToFG()){
        		dabdrv_main::instance()->vResetSourceChangingToFG();
        		trMsgSrvRspSrcState srcState;
        		srcState.enSourceState=DAB_enSourceState_FG;
        		DAB_vCallMsg(srcState);
        	}
        }
        ETG_TRACE_FATAL(("dabdrv_presets(trMeca_RRdmStationPlay) error %d currentSid 0x%08x",
                         ETG_CENUM(tenMeca_RdmStationState, poRRdmStationPlay->enStationState),
                         dabdrv_chnInfo::instance()->rGetCurrentSid()._u32Id));
            break;
    }

	tU32 u32Sid=dabdrv_chnInfo::instance()->rGetCurrentSid().u32GetSID();
#ifdef DAB_ENABLE_USE_MECA_PRESET
    // convert in according trMeca_RRdmAudioPlayAsid
    if((poRRdmStationPlay->enStationState == enMeca_RdmStationState_STATION_FREE || poRRdmStationPlay->enStationState == enMeca_RdmStationState_STATION_PLAY_ERROR) && poRRdmStationPlay->u8StationNumber == 0)
    {
        tU32 u32Sid=dabdrv_chnInfo::instance()->rGetCurrentSid().u32GetSID();
		//#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
			//_bStationStatus = TRUE; // variable set for playing the first service if present in 5A on factory reset. For IVI on calling PlayLSM ADR sends STATION_PLAY_ERROR.
		//#endif
		// PSARCC30-3589 - Send source state response when LSM not present.
		if(dabdrv_main::instance()->bGetSourceChangingToFG()){
			dabdrv_main::instance()->vSendDelayedSourceChangeRsp();
		}
        trMeca_CRdmAudioPlayAsid rRdmAudioPlayAsid;
	    rRdmAudioPlayAsid.rMecaProgrammeService._u32Id = u32Sid;
	    dabdrv_mecaIf::instance()->vSendMecaCommand(rRdmAudioPlayAsid);
    }
    else
    {
		ETG_TRACE_USR4(("dabdrv_presets(trMeca_RRdmStationPlay) trMeca_RRdmAudioPlayAsid"));
		trMeca_RRdmAudioPlayAsid rRRdmAudioPlayAsid;
			ETG_TRACE_USR4(("_u8ActiveRecallPreset %d poRRdmStationPlay->u8StationNumber %d", _u8ActiveRecallPreset, poRRdmStationPlay->u8StationNumber));
		if (_u8ActiveRecallPreset!=poRRdmStationPlay->u8StationNumber) {
			ETG_TRACE_USR4(("dabdrv_presets(trMeca_RRdmStationPlay) trMeca_RRdmAudioPlayAsid returned"));
			return;
		}

		if (poRRdmStationPlay->u8StationNumber == 0)
		{
			rRRdmAudioPlayAsid.rMecaProgrammeService._enServiceType = enMeca_ServiceType_AUDIO_SERVICE;
			rRRdmAudioPlayAsid.rMecaProgrammeService._u32Id= u32Sid;
		}
		else
		{
			rRRdmAudioPlayAsid.rMecaProgrammeService=_vPresetInfos[_u8ActiveRecallPreset].rPSID;
		}

		ETG_TRACE_USR4(("dabdrv_presets(trMeca_RRdmStationPlay)  poRRdmStationPlay->enStationState %d",poRRdmStationPlay->enStationState));
		//lint -e{788} enum constant '...' not used within defaulted switch
		switch (poRRdmStationPlay->enStationState) {
			case enMeca_RdmStationState_STATION_PLAY_OK:
				rRRdmAudioPlayAsid.enServiceState=enMeca_RdmServiceState_SERVICE_SELECTION_DONE;         
                //dabdrv_main::instance()->bSetCompMode(rRRdmAudioPlayAsid.rMecaProgrammeService._u16Scids);            
				DAB_vCallMsg(rRRdmAudioPlayAsid);
				break;
			case enMeca_RdmStationState_WAITING_FOR_STATION_PLAY:
				rRRdmAudioPlayAsid.enServiceState=enMeca_RdmServiceState_WAITING_FOR_SERVICE;
				DAB_vCallMsg(rRRdmAudioPlayAsid);
				//	// Send Source State notification after set mode response from ADR
				if(dabdrv_main::instance()->bGetSourceChangingToFG()){
					dabdrv_main::instance()->vSendDelayedSourceChangeRsp();
				}
				break;
			case enMeca_RdmStationState_STATION_SERVICE_INVALID:
			//case enMeca_RdmStationState_STATION_FREE:
			case enMeca_RdmStationState_STATION_PLAY_ERROR:
			default:
				rRRdmAudioPlayAsid.enServiceState=enMeca_RdmServiceState_SERVICE_INVALID;
				ETG_TRACE_USR4(("dabdrv_presets(trMeca_RRdmStationPlay) enMeca_RdmServiceState_SERVICE_INVALID"));
				DAB_vCallMsg(rRRdmAudioPlayAsid);
				break;
        }
    }
#endif    
}

tVoid dabdrv_presets::vProcess(trMsgDrvIndPreChnSelect* poDrvIndPreChnSelect) {
    ETG_TRACE_USR4(("dabdrv_presets(trMsgDrvIndPreChnSelect) enChnSelectSource=%d bIdChanged=%d",
                        poDrvIndPreChnSelect->enChnSelectSource,
                        poDrvIndPreChnSelect->bIdChanged));
    _enChnSelectSource=poDrvIndPreChnSelect->enChnSelectSource;
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
    if (poDrvIndPreChnSelect->bCompMode) {
        return;
    }
#endif
    if (poDrvIndPreChnSelect->enChnSelectSource==enChnSelectSource_ChnSelect &&
        poDrvIndPreChnSelect->bIdChanged) {
        // channel is changed on user-request, correct auto-compare
        // todo: check that enChnSelectSource is used correctly everywhere
        ETG_TRACE_USR4(("dabdrv_presets(trMsgDrvIndPreChnSelect) reset rActivePreset"));
        _rPersUsrData.rActivePreset=trActivePreset(); 
    }


    trMecaProgrammeService rCurrentPrgSrv(dabdrv_chnInfo::instance()->rGetCurrentSid()._u32Id,
    			enMeca_ServiceType_AUDIO_SERVICE,dabdrv_chnInfo::instance()->rGetChnInfo().u16Scids);
    ETG_TRACE_USR4(("dabdrv_presets(trMsgDrvIndPreChnSelect) inform chnInfo current sid=%d scids=%d",
    		rCurrentPrgSrv._u32Id,rCurrentPrgSrv._u16Scids));

    if (poDrvIndPreChnSelect->enChnSelectSource==enChnSelectSource_RecallPreset 
        && _rPersUsrData.rActivePreset.rPsid == rCurrentPrgSrv) {
        ETG_TRACE_USR4(("dabdrv_presets(trMsgDrvIndPreChnSelect) inform chnInfo (new PresetNr:%d)",
                        _rPersUsrData.rActivePreset.u8PresetNr));
        DAB_vCallMsgCtor(trMsgDrvRspChnListCurrentSrvChanged(_rPersUsrData.rActivePreset.rPsid));
    }

}


tVoid dabdrv_presets::vSendRecallPreset(tU8 u8PresetNumber,tU8 u8OptionVal) const {
    // tune to PSID

	trMeca_CRdmStationPlay rStationPlay;
	rStationPlay.u8StationNumber= u8PresetNumber;
	rStationPlay.u8Option = (u8OptionVal | (tU8)DAB_BIT_ZERO_VALUE);
	//NCG3D-40183 - Setting the comp mode while sending for station play instead of setting on getting the response
	if (u8OptionVal == 2)
		dabdrv_main::instance()->bSetCompMode(TRUE);
	else
		dabdrv_main::instance()->bSetCompMode(FALSE);
	//rStationPlay.u8Option = u8OptionVal;
	dabdrv_mecaIf::instance()->vSendMecaCommand(rStationPlay);
}

tBool dabdrv_presets::bStorePresettoLSM(tU8 u8PresetNr){

	 ETG_TRACE_USR4(("dabdrv_presets::bStorePresettoLSM u8PresetNr %d",u8PresetNr));
	if(dabdrv_main::instance()->enGetSourceState() == DAB_enSourceState_FG)
		return FALSE;

	trMsgSrvCmdStorePreset presetStoreLSMCmd;
	presetStoreLSMCmd.u8PresetNumber=0;//Move to LSM
	presetStoreLSMCmd.rPSID = _vPresetInfos[u8PresetNr].rPSID;
	presetStoreLSMCmd.u32EnsFrequency = _vPresetInfos[u8PresetNr].u32Frequency;
	presetStoreLSMCmd.vTrace();
	vSendSpecialPresetSave(&presetStoreLSMCmd);

	return TRUE;
}

tVoid dabdrv_presets::vSendServiceInfo(trMecaProgrammeService mecaPrgService)
{
	if(mecaPrgService._u16Scids) {			

		trMsgDrvCmdSetCompInfoScidi rDrvCmdSetCompInfoScidi(mecaPrgService, TRUE, mecaPrgService._u16Scids);
		DAB_vCallMsg(rDrvCmdSetCompInfoScidi);
	}	
}

tBool dabdrv_presets::bIsPresetRecalledFromBG(tU8 u8PresetNr){

	if(dabdrv_main::instance()->enGetSourceState() == DAB_enSourceState_FG)
		return FALSE;

	DAB_trChnStateProperty rProperty=dabdrv_properties::instance()->oChnStateProperty.oGet();
	rProperty.enChnState=enChnState_Unavail;
	dabdrv_properties::instance()->oChnStateProperty.vSet(rProperty);
	//Update the channel info property from here to avoid flickering during band change and mixed preset recall.
	trChnListKey chnlistKey(_vPresetInfos[u8PresetNr].rPSID);
	dabdrv_chnInfo::instance()->bUpdateProperty(chnlistKey, TRUE,TRUE);
	//Set old channel info to selected channel info only in case of mixed preset recall.
	trChnListChnInfo oChnListInfo = dabdrv_chnInfo::instance()->vGetPreselectChnInfo();	//Coverity
	dabdrv_main::instance()->vsetOldChnInfo(oChnListInfo);
	_u8PresetRecalledFromBG=_u8ActiveRecallPreset;
	
	return TRUE;
}

tVoid dabdrv_presets::vProcess(trMsgSrvCmdRecallPreset* poRecallPreset) {
    tU8 u8PresetNr = poRecallPreset->u8PresetNumber;
    ETG_TRACE_USR4(("dabdrv_presets(trMsgSrvCmdRecallPreset) u8PresetNumber=%d  PRESET-SID=%x",
                    u8PresetNr,
                    _vPresetInfos[u8PresetNr].rPSID.u32GetSID()));
	dabdrv_chnSelect::instance()->vResetChnSelectState();
	_u8ActiveRecallPreset=u8PresetNr;
/*    if(bStorePresettoLSM(u8PresetNr))
		return;
*/

	if(bIsPresetRecalledFromBG(u8PresetNr))
		return;

#ifdef DAB_ENABLE_USE_MECA_PRESET
    trMecaProgrammeService presetPrgService = _vPresetInfos[u8PresetNr].rPSID;
	/**Storing the preset data persistently**/
	_rPersUsrData.rActivePreset.u8PresetNr=u8PresetNr;
	_rPersUsrData.rActivePreset.rPsid = presetPrgService;
	_rPersUsrData.rActivePreset.u32Frequency=_vPresetInfos[u8PresetNr].u32Frequency;

	_enChnSelectSource = enChnSelectSource_RecallPreset;

	dabdrv_main::instance()->vSetPresetOrChannelRecallRequested(PresetRecall);

    vSendRecallPreset(u8PresetNr,presetPrgService._u16Scids !=0 ? 2 : 0);


//NCG3D-40183 - Workaround for ADR. trMeca_CRdmAudioGetScidi should be sent when there is a switch  
//from Secondary to primary service and last played service is primary service
	DAB_trChnInfoProperty rProperty=dabdrv_properties::instance()->oChnInfoProperty.oGet();

	ETG_TRACE_USR4(("dabdrv_presets(trMsgSrvCmdRecallPreset) presetPrgService.u32GetSID()=%d  rProperty.rMecaId._u32Id=%d  presetPrgService._u16Scids=%d",
		presetPrgService.u32GetSID(), rProperty.rMecaId._u32Id, presetPrgService._u16Scids));

	if((presetPrgService.u32GetSID() == rProperty.rMecaId._u32Id) && (presetPrgService._u16Scids !=0))
	{
		trMeca_CRdmAudioGetScidi rAudioGetScidi;
		dabdrv_mecaIf::instance()->vSendMecaCommand(rAudioGetScidi);
	}
	//trMsgDrvCmdSetChnInfoPsid should be called only if the preset is available in the _mapServiceInfo,
	//else wait for PLAY_ERROR from ADR and then update the channel info property via vUpdateUnavailablePresetInfo
	if(dabdrv_chnList::instance()->bIsServiceInMap(trChnListKey(presetPrgService))) {
		   // set Channel-Info for new PSID
			trMsgDrvCmdSetChnInfoPsid rSetPsid(_vPresetInfos[u8PresetNr].rPSID);
			
			//PSARCC30-1770 - serviceinfo should go before channelinfo in case secondary service preset is selected
			vSendServiceInfo(_vPresetInfos[u8PresetNr].rPSID);
			DAB_vCallMsg(rSetPsid);
	}	
#else
    trMsgDrvCmdSetChnInfoPsid rSetPsid(_vPresetInfos[u8PresetNr].rPSID);
    DAB_vCallMsg(rSetPsid);
    trMsgDrvCmdChnSelect rCmdChnSelect;
    rCmdChnSelect.enChnSelectSource=enChnSelectSource_RecallPreset;
    rCmdChnSelect.u32Value=_vPresetInfos[u8PresetNr].rPSID.u32GetSID();
    rCmdChnSelect.bNegative=0;
    rCmdChnSelect.u32Frequency=_vPresetInfos[u8PresetNr].u32Frequency;
    _rPersUsrData.rActivePreset.u8PresetNr=u8PresetNr;
    _rPersUsrData.rActivePreset.rPsid=trMecaProgrammeService(rCmdChnSelect.u32Value);
    _rPersUsrData.rActivePreset.u32Frequency=rCmdChnSelect.u32Frequency;
    DAB_vCallMsg(rCmdChnSelect);

#endif

}

tVoid dabdrv_presets::vPLayLSM(tU8 u8Options){

	//Incase of preset recall from some other source preset will be moved to LSM and play LSM will be called
	//the _u8activerecallPreset should not become 0.
	_u8ActiveRecallPreset= _enChnSelectSource != enChnSelectSource_RecallPreset?0:_u8ActiveRecallPreset;
	dabdrv_mecaIf::instance()->vSendMecaCommandCtor(trMeca_CRdmStationPlay(0,u8Options));
}

//To Handle unnecessary Chninfo updates in dabdrv_rdm::vProcess(trMeca_RRdmAudioGetAsid
//When recall preset is called one after the other immediately.
tBool dabdrv_presets::bIsPresetRecall(tU32 sid){
	(tVoid)sid;
	//return ((_enChnSelectSource != enChnSelectSource_RecallPreset) /*|| (_enChnSelectSource == enChnSelectSource_RecallPreset
		//	      && _vPresetInfos[_u8ActiveRecallPreset].rPSID._u32Id == sid)*/);
	ETG_TRACE_USR1(("_enChnSelectSource = %d", _enChnSelectSource));
   //NCG3D-39283
   return((_enChnSelectSource!=enChnSelectSource_RecallPreset)&&(_enChnSelectSource!=enChnSelectSource_ChnSelect));

}

#ifndef VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI//multi-user preset
tVoid dabdrv_presets::vProcess(DAB::trMsgSrvCmdSetUser* povSetUser) {
	povSetUser->vTrace();
	u8UserId = povSetUser->u8UserId;
	if (povSetUser->enUpdateType == DAB_enProfile_Change)
	{
		trMeca_CRdmStationSetUser rCRdmStationSetUser = vSendMecaCmdSetUser(povSetUser->u8UserId);
	}
	else if(povSetUser->enUpdateType == DAB_enProfile_Delete)
	{
		trMeca_CRdmStationTravelStore rDeletePresets = vSendMeaCommandDeleteProfile(povSetUser->u8UserId);
	}
	else if(povSetUser->enUpdateType == DAB_enProfileCopy)
	{
		trMeca_CRdmStationTravelStore rCopyPresets = vSendMeaCommandCopyProfile(povSetUser->u8UserId,povSetUser->u8DestUserId);
	}
}

tVoid dabdrv_presets::vProcess(DAB::trMsgSrvCmdDiagStatus* poDiagStatus) {

	_enDiagAction = poDiagStatus->enDiagStaus;
	ETG_TRACE_USR1(("dabdrv_presets::vProcess(trMsgSrvCmdDiagStatus) _enDiagAction %d _enPresetListToHMIStatus=%d",_enDiagAction,_enPresetListToHMIStatus));
	if(_enDiagAction == enDiagAction_FINISH &&
			_enPresetListToHMIStatus==enPresetListToHMI_NOTUPDATED)
	{
		_u8PresetDeleteCounter=0;
		_enPresetListToHMIStatus=enPresetListHMI_UPDATEDONE;
		dabdrv_properties::instance()->oPresetListDataProperty.vSet(_rProperty);
	}
}

trMeca_CRdmStationSetUser dabdrv_presets::vSendMecaCmdSetUser(tU8 _u8UserId){
ETG_TRACE_USR1(("dabdrv_presets::vSendMecaCmdSetUser _u8UserId=%d, _bStartup=%d",_u8UserId,_bStartup));
	//To synchronize preset list update when SYSSET_FINISH is called.
	_enPresetListToHMIStatus=enPresetListToHMI_INPROGRESS;
	trMeca_CRdmStationSetUser rCRdmStationSetUser;
	rCRdmStationSetUser.u8UserId = _u8UserId;
	if (_bStartup)
	{
		rCRdmStationSetUser.u8Flag = (rCRdmStationSetUser.u8Flag) | (0x02);
	}
	else
	{
	rCRdmStationSetUser.u8Flag = 0; //unused parameters
	}
	rCRdmStationSetUser.u8Rfu2 = 0;
	_bStartup = FALSE;
	rCRdmStationSetUser.tU8PresetCount = (tU8)(u8NumberofPresets+1); //1 for LSM
	dabdrv_mecaIf::instance()->vSendMecaCommand(rCRdmStationSetUser);
	return rCRdmStationSetUser;
}
trMeca_CRdmStationTravelStore dabdrv_presets::vSendMeaCommandDeleteProfile(tU8 _u8UserId){
	ETG_TRACE_USR1(("dabdrv_presets::vSendMecaCommandDeleteProfile userid %d",_u8UserId));
	trMeca_CRdmStationTravelStore rDeletePresets;
	rDeletePresets.u8Mode = (tU8) DAB_enProfile_Delete;//EMPTY_RANGE
	rDeletePresets.u8FirstStationNumber= (tU8)(_u8UserId * (u8NumberofPresets+1));//1 for LSM
	rDeletePresets.u8NumberStations= (tU8) (u8NumberofPresets+1);
	rDeletePresets.vTrace();
	dabdrv_mecaIf::instance()->vSendMecaCommand(rDeletePresets);
	return rDeletePresets;
}
trMeca_CRdmStationTravelStore dabdrv_presets::vSendMeaCommandCopyProfile(tU8 sourcdUserId, tU8 destUserId){
	ETG_TRACE_USR1(("dabdrv_presets::vSendMecaCommandCopyProfile"));
	
	u8UserId = sourcdUserId;
	trMeca_CRdmStationTravelStore rCopyPresets;
	rCopyPresets.u8Mode = (tU8)DAB_enProfileCopy;
	rCopyPresets.u8FirstStationNumber= (tU8)(sourcdUserId * (u8NumberofPresets+1));//1 for LSM
	rCopyPresets.u8NumberStations= (tU8)(u8NumberofPresets+1);//Including LSM
	rCopyPresets.u8DestinationStationNumber = (tU8)((destUserId)*(u8NumberofPresets+1));
	dabdrv_mecaIf::instance()->vSendMecaCommand(rCopyPresets);
	return rCopyPresets;
}

tVoid dabdrv_presets::vProcess(trMeca_RRdmStationTravelStore* poTravelStore){
	ETG_TRACE_USR1(("dabdrv_presets::vProcess(trMeca_RRdmStationTravelStore)_bStartup %d userId %d",_bStartup,u8UserId));
	trMsgSrvRspSetUser rSrvRspSetUser;
	rSrvRspSetUser.enRes=DAB_enResult_FAILED;
	rSrvRspSetUser.enUpdateType = (DAB_tenProfileUpdateType)poTravelStore->u8Mode;
	rSrvRspSetUser.u8UserId = u8UserId;
	switch(poTravelStore->enTravelStoreState){
	case enMeca_RdmTravelStoreState_DONE:
	case enMeca_RdmTravelStoreState_STARTED:
		if(poTravelStore->u8Mode == (tU8) DAB_enProfile_Delete){//EMPTY_RANGE
			rSrvRspSetUser.enRes = DAB_enResult_OK;			
			trMsgDrvDbQuery rDbQuery(Query_PresetInfo_All);
			DAB_vCallMsg(rDbQuery);
			
		}else if(poTravelStore->u8Mode == (tU8) DAB_enProfileCopy){
			rSrvRspSetUser.enRes = DAB_enResult_OK;
		}
		DAB_vCallMsgCtor(trMsgDrvCmdSysStore(u8UserId, TRUE));
		break;
	case enMeca_RdmTravelStoreState_COMMAND_REJECTED:
	case enMeca_RdmTravelStoreState_STOPPED:
	default:
		break;
	}
	DAB_vCallMsg(rSrvRspSetUser);
}

tVoid dabdrv_presets::vProcess(DAB::trMeca_RRdmStationSetUser* poRRdmSetUser) {

	poRRdmSetUser->vTrace();
	 ETG_TRACE_USR1(("dabdrv_presets::vProcess(trMeca_RRdmStationSetUser)"));
	//Reset the select source as the new channel changes in new user.
	_enChnSelectSource = enChnSelectSource_None;
	//query for the preset list info if user is set.
	trMsgSrvRspSetUser rSrvRspSetUser;
	rSrvRspSetUser.enRes=DAB_enResult_FAILED;
	if (u8UserId == poRRdmSetUser->u8UserId)	{
		rSrvRspSetUser.enUpdateType = DAB_enProfile_Change;
		rSrvRspSetUser.u8UserId = poRRdmSetUser->u8UserId;
		rSrvRspSetUser.enRes=DAB_enResult_OK;
	}
	DAB_vCallMsg(rSrvRspSetUser);
	trMsgDrvDbQuery rDbQuery(Query_PresetInfo_All);
	DAB_vCallMsg(rDbQuery);
}
#endif

tVoid dabdrv_presets::vProcess(DAB::trMsgSrvCmdSetPresetBank* povSetPresetBank) {
    tU8 u16FirstPreset=(tU8)((povSetPresetBank->u8PresetBank * u8NumberofPresetsPerBank) +1);
    if (!bPresetNumberValid(u16FirstPreset)) {
        povSetPresetBank->enRes = DAB_enResult_FAILED;
        return;
    }
    povSetPresetBank->enRes = DAB_enResult_OK;

	//if(_u8PresetBank != povSetPresetBank->u8PresetBank){			
		vResetSelectSource();
		_u8PresetBank=povSetPresetBank->u8PresetBank;
		DAB_trChnInfoProperty rProperty=dabdrv_properties::instance()->oChnInfoProperty.oGet();
		trChnListChnInfo rChnInfo = dabdrv_chnInfo::instance()->rGetChnInfo();
		rProperty.u8PresetNumber=dabdrv_presets::instance()->u8GetPresetNumber(rChnInfo.rMecaId,(tU8)(rChnInfo.u16Scids));
		dabdrv_properties::instance()->oChnInfoProperty.vSet(rProperty);
	//}


   ETG_TRACE_USR1(("dabdrv_presets(trMsgSrvCmdSetPresetBank) _u8PresetBank (%d)",
                    _u8PresetBank));
}


tVoid dabdrv_presets::vProcess(DAB::trMsgSrvCmdGetPresetList* poGetPresetList) {
    tU16 u16FirstId= poGetPresetList->u8FirstElementID;
    tU16 u16LastId = (tU16)(u16FirstId + poGetPresetList->u8NumberOfElements);
    if (u16FirstId==0 && u16LastId==0) {
		u16LastId=(tU16)(u16FirstId+u8NumberofPresets);
        u16FirstId=1;
    }
    if (!bPresetNumberValid(u16FirstId) || 
        !bPresetNumberValid(u16LastId) ||
        (u16FirstId==u16LastId)) {
        trMsgSrvRspGetPresetList rRsp;
        rRsp.enRes = DAB_enResult_FAILED;
        return;
    }
    trMsgSrvRspGetPresetList rRsp((tU8)u16FirstId, (tU8)(u16LastId));
    for (tU8 u8Index=(tU8)(u16FirstId);u8Index <= u16LastId;u8Index++) {
        trPresetInfo &rPresetInfo = _vPresetInfos[u8Index];
		// rPresetInfo.rLabel=  dabdrv_chnList::instance()->rGetChnLabel(rPresetInfo.rPSID);
        rRsp.vecPresetInfos.push_back(rPresetInfo);
    }
    DAB_vCallMsg(rRsp);

}

trMecaLabel dabdrv_presets::rGetPresetLabel(tU8 u8PresetNr) const {
    trMecaLabel rLabel;
    if (bPresetNumberValid(u8PresetNr)) {
        rLabel=_vPresetInfos[u8PresetNr].rLabel;
    }
    return rLabel;
}



tVoid dabdrv_presets::vGetUserData(trPresetsUsrData *prPresetsUsrData) const {
    *prPresetsUsrData=_rPersUsrData;
}

tVoid dabdrv_presets::vSetUserData(trPresetsUsrData const &rPresetsUsrData) {
    _rPersUsrData=rPresetsUsrData;
}

//Update channelinfo property when station_play_error is recieved from ADR
tVoid dabdrv_presets::vUpdateUnavailablePresetInfo(trMeca_RRdmAudioPlayAsid* poMecaRRdmPlayPsid){
	ETG_TRACE_USR4(("dabdrv_main::vUpdateUnavailablePresetInfo trPresetInfo rMecaPgmService =%d",poMecaRRdmPlayPsid->rMecaProgrammeService.u32GetSID()));	

	trMecaProgrammeService	rMecaPgmService = poMecaRRdmPlayPsid->rMecaProgrammeService;
/*
 * Fix for 22702 START
 */
	
	if(_vPresetInfos[_u8ActiveRecallPreset].rPSID.u32GetSID() == rMecaPgmService._u32Id){

/*
 * Fix for 22702 END
 */

			ETG_TRACE_USR4(("dabdrv_main::vUpdateUnavailablePresetInfo trPresetInfo rMecaPgmService =%d",rMecaPgmService.u32GetSID()));		
			dabdrv_main::instance()->vSetPresetOrChannelRecallRequested(PresetOrChannelRecallInvalid);

			 //Clear ensemble label
			DAB_trEnsembleInfoProperty rEnsembleInfoProperty=dabdrv_properties::instance()->oEnsembleInfoProperty.oGet();
			rEnsembleInfoProperty.rEnsembleLabel.bLabelValid = FALSE;
			dabdrv_properties::instance()->oEnsembleInfoProperty.vSet(rEnsembleInfoProperty);

			//Update _rPreselectChnInfo
			trChnListChnInfo rPreselectChnInfo;
			rPreselectChnInfo.rMecaId = rMecaPgmService;
			//Fix for 22702 START
			//rPreselectChnInfo.u8PresetNumber = iterPresetInfo->u8StationNumber;
			rPreselectChnInfo.u8PresetNumber = _u8ActiveRecallPreset;
			//rPreselectChnInfo.rLabel=iterPresetInfo->rLabel;
			rPreselectChnInfo.rLabel=_vPresetInfos[_u8ActiveRecallPreset].rLabel;
			//Fix for 22702 END
			rPreselectChnInfo.bLabelPresent=TRUE;
			rPreselectChnInfo.u16AvailableAnnoTypesMask=0x00;
			rPreselectChnInfo.u8PTY=0;
		    dabdrv_chnInfo::instance()->vSetPreselectChnInfo(rPreselectChnInfo);

			trMeca_CRdmStationSetPresetStation rCRdmSetPresetStation;
			rCRdmSetPresetStation.enServiceType=enMeca_ServiceType_AUDIO_SERVICE;
			trMecaProgrammeService rProgSrv=rPreselectChnInfo.rMecaId.rGetProgService();
			rCRdmSetPresetStation.u8StationNumber=0;
			rCRdmSetPresetStation.rProgrammeService=rProgSrv;
			rCRdmSetPresetStation.u32Frequency=dabdrv_chnList::instance()->u32GetFrequencyOfService(rProgSrv);
			rCRdmSetPresetStation.rLabel = rPreselectChnInfo.rLabel;
			dabdrv_mecaIf::instance()->vSendMecaCommand(rCRdmSetPresetStation);

			DAB_trChnInfoProperty rProperty=dabdrv_properties::instance()->oChnInfoProperty.oGet();
			rProperty.enChnState=enChnState_Unavail;
			rProperty.bMuted=TRUE;
			rProperty.rRadioText.bValid=FALSE;

			//NCG3D-149882: Update trChnListKey
			trChnListKey rChnListKey(rMecaPgmService,rMecaPgmService._u16Scids);
			dabdrv_chnInfo::instance()->vSetCurMecaId(rChnListKey);
			ETG_TRACE_USR4(("dabdrv_main::vUpdateUnavailablePresetInfo trChnListKey rMecaId =%d",rChnListKey._rMecaId._u32Id))

			//PSARCCB-7339
			rProperty.rMecaId = rMecaPgmService;
			rProperty.sLogoLink =  dabdrv_chnList::instance()->sGetLogoLink(rPreselectChnInfo.rMecaId.u16GetSID());
			//PSARCCB-7339

			rProperty.rLabel=_vPresetInfos[_u8ActiveRecallPreset].rLabel;

			rProperty.bLabelPresent=TRUE;
			rProperty.u16FrozenListId=0;
			
			rProperty.u8PresetNumber=_u8ActiveRecallPreset;
			
			rProperty.u16AvailableAnnoTypesMask=0x00;
			rProperty.u8PTY=0;
			// overwrite property; further information will be added when channel is tuned
			dabdrv_properties::instance()->oChnInfoProperty.vSet(rProperty);
			//break;
	}
}
tBool dabdrv_presets::vGetPresetValidity(tU8 uPresetNumber)
{
	tBool bRes = TRUE;
	if (!bPresetNumberValid(uPresetNumber))
	{
		ETG_TRACE_USR1(("dabdrv_presets(vGetPresetValidity) invalid preset-number (%d)",
				uPresetNumber));
	    bRes = FALSE;
	}
	if ((!_vPresetInfos[uPresetNumber].rPSID.bIsValid())|| !_vPresetInfos[uPresetNumber].rLabel.bIsLabelOk())
	{
		ETG_TRACE_USR1(("dabdrv_presets(vGetPresetValidity) SID=0 (%d)",uPresetNumber));
	    bRes = FALSE;
	}
	ETG_TRACE_USR1(("dabdrv_presets(vGetPresetValidity) bRes= (%d)",bRes));
	return bRes;
}
