/************************************************************************
 * FILE:     dabdrv_mecaIf.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  header of dabdrv_meca
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DABDRV_MECAIF_H
#define DABDRV_MECAIF_H


#include "fc_dabtuner_util.h"
#include "dabdrv_meca.h"
#include "dabmeca_db.hpp"
#include "dabmeca_rdm.hpp"
#include "dabmeca_ans.hpp"
#include "dabmeca_aud.hpp"
#include "dabmeca_ddm.hpp"
#include "dabmeca_sys.hpp"
#include "dabmeca_tsu.hpp"
#include "dabmeca_exp.hpp"


#include "dabdrv_adrIf.hpp"


namespace DAB {

    struct trMsgSrvCmdCriticalVoltage;

    // Message containing data from Adr received via SPI
#define DAB_ADR_INPUT_STATIC_LEN 50
    struct trMsgAdrInput:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL

        trMsgAdrInput();
        trMsgAdrInput(tU8 const *pu8Data, tU32 u32Len);
        trMsgAdrInput(const trMsgAdrInput &roFrom);
        virtual ~trMsgAdrInput();
        virtual tVoid vTrace() const;

        tBool _bValid;
        trMostHdr _rMostHdr;  
        tU8 *_pu8MecaData;

    private:
        trMsgAdrInput& operator=(const trMsgAdrInput &roFrom);
        tU8 _au8StaticData[DAB_ADR_INPUT_STATIC_LEN];
        tU8 *_pu8DynData;
    };


    struct trMsgDeBlockMeca:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL

        virtual tVoid vTrace() const;
    };

    struct trMeca_RConStartup;
    struct trMeca_CConRegistration;
    struct trMeca_RConRegistration;
    struct trMeca_CConDeRegistration;
    struct trMeca_RConDeRegistration;
    struct trMeca_CConPing;
    struct trMeca_RConPing;
    struct trMeca_RConTsuStartup;

    struct dabdrv_msgPingTimer;
 


    class dabdrv_mecaIf: 
        public DAB_Singleton <dabdrv_mecaIf>,
        public DAB_MessageHandlerCommon<dabdrv_mecaIf>
    {
        friend class DAB_Singleton<dabdrv_mecaIf>;
        friend class fc_dabtuner_tclTrace;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_MECAIF);

        typedef enum {
            enComState_Null,
            enComState_WaitStartup,
            enComState_WaitRegistration,
            enComState_WaitDeRegistration,
            enComState_AdrDead,
            enComState_Normal,
            enComState_WaitReRegistration
            
        } tenComState;


        tVoid vSendAdrMsg(tU16 u16FBlockId, tU16 u16FktId, tenOpType enOpType, tU16 u16MecaLen, tU8 const *pu8MecaData, trMecaSendSvInfo const *poSendInfo=OSAL_NULL, tU8 u8InstanceId=DAB_INSTANCE_ID);
        tVoid vSendMecaCommand( trMsgMecaOut const &roMecaOutMsg, trMecaSendSvInfo const *poSendInfo=OSAL_NULL);
        tVoid vSendMecaCommand( trMsgMecaOut const &roMecaOutMsg, trMecaSendSvInfo const &oSendInfo) {
            vSendMecaCommand(roMecaOutMsg, &oSendInfo);
        };
        tVoid vSendMecaCommand( trMsgMecaOut const &roMecaOutMsg, ten_MecaSendMode enSendMode, tU32 u32TimeOutMs=DAB_ADR_DEFAULT_ANSWER_WAIT_MS) {
            vSendMecaCommand(roMecaOutMsg, trMecaSendSvInfo(enSendMode, u32TimeOutMs));
        };
        template<class M>
        tVoid vSendMecaCommandCtor( M const oMecaOutMsg, ten_MecaSendMode enSendMode=en_MecaSendMode_Normal, tU32 u32TimeOutMs=DAB_ADR_DEFAULT_ANSWER_WAIT_MS) {
            vSendMecaCommand(oMecaOutMsg, trMecaSendSvInfo(enSendMode, u32TimeOutMs));
        }
        tVoid vSendMecaCommand(trMsgMecaRawOutput const *poRawOutput, trMecaSendSvInfo const *poSendInfo=OSAL_NULL);


        // input is complete message according to "InternalMeCa_V0_1_Connection.pdf" 
        // u32Len includes len-byte pu8Data[0]
        tVoid vSimAdrInput(tU8 const *pu8Data, tU32 u32Len) const;

        // input is the meca-command-msg according to "InternalMeCa_V0_1_Connection.pdf" 
        // u16MsgType = MsgPara
        // pu8Data    = MsgBody
        // u32Len     = MsgLength
        tVoid vSimMecaCmdInput(tU16 u16FktId, tenOpType enOpType, tU16 u16MecaLen, tU8 const *pu8MecaData);

        virtual ~dabdrv_mecaIf();
        virtual tVoid vInit(tVoid);
        virtual tVoid vDeInit(tVoid);
        virtual char const *pcGetName() const {return "dabdrv_mecaIf";};

        virtual tVoid vProcess(trMsgAdrInput* poMsgAdrInput);
        virtual tVoid vProcess(trMeca_RRdmTune *poRTune);
        virtual tVoid vProcess(trMsgAdrStatus *poAdrStatus);
        virtual tVoid vProcess(trMsgIpnError* poIpnError);
        virtual tVoid vProcess(trMsgDeBlockMeca* poDeBlockMeca);
        virtual tVoid vProcess(trMsgSrvCmdCriticalVoltage* poCriticalVoltage);

        // pseudo-private
        virtual tVoid vProcess(dabdrv_msgPingTimer* poPingTimer);
        virtual tVoid vProcess(trMeca_RConStartup* poRConStartup);
        virtual tVoid vProcess(trMeca_RConRegistration* poRConRegistration);
        virtual tVoid vProcess(trMeca_RConDeRegistration* poRConDeRegistration);
        virtual tVoid vProcess(trMeca_RConPing* poRConPing);
        virtual tVoid vProcess(trMeca_RConTsuStartup* poRConTsuStartup);

        virtual tVoid vTraceState() const;
        tenComState enGetComState() const {
            return _enComState;
        };

		/**vnd4kor: to solve prio 2 warning */
        tVoid vReset() const {
			trMsgResetAdr rMsgResetAdr;
			DAB_vPostMsg(dabdrv_adrIf::instance(), &rMsgResetAdr);
        };
        tVoid vSetPingTimerVal(tU32 u32Ms) {
            _u32PingTmrValMs = u32Ms;
        };

    private:
		tVoid vStartPingTimer();
        tVoid vEnterComState(tenComState enComState);
        tenComState _enComState;
        //lint -esym(1704, dabdrv_mecaIf::dabdrv_mecaIf) prio3 constructor has private access specification
        dabdrv_mecaIf(tVoid);

        tVoid vHandleMecaRsp(trMostHdr const &rMostHdr, tU8 const *pu8MecaData);
        tVoid vHandleBlocking(tU16 u16RcvFktId) const;
        tVoid vHandleStartup();

        DAB_tclTimer _oPingTmr;
        tU32 _u32PingTmrValMs;
        tU32 _u32LastMecaRefId;
        tBool _bMtcLunStartup;
        tBool _bDabLunStartup;
        tBool _bConRegistrationValid;
    };

} // namespace DAB
#endif
