
/************************************************************************
 * FILE:      dabdrv_learn.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_learn
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/
 
#include "dabdrv_learn.hpp"
#include "dabdrv_main.hpp"
#include "dabdrv_db.hpp"
#include "dabdrv_presets.hpp"
#include "dabdrv_mute.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_LEARN 
#include "trcGenProj/Header/dabdrv_learn.cpp.trc.h"
#endif

#define DAB_SINGLE_TUNER_MODE() bGetTunerMode()

namespace DAB {


    struct trMsgStopLearnTimeOut:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgStopLearnTimeOut"));
        };
    };
    struct trMsgStartLearnTimeOut:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgStartLearnTimeOut"));
        };
    };


}



//#ifdef USE_ONLY_CYCLIC_DABTUNER_LEARN
#define DAB_STOP_LEARN_RSP_WAIT_TIMER_MS (2000 * DAB_TIME_FACTOR)
//#endif //USE_ONLY_CYCLIC_DABTUNER_LEARN

using namespace DAB;
dabdrv_learn::dabdrv_learn() {
    _enLearnState=enLearnState_Idle;
    //    _enActiveLearnCommand = enMeca_RdmLearnCommand_INVALID;
    _enRequestedLearnType = enLearnType_OFF;
    _enAutostoreAction = enAutostoreAction_InValid;
    _bForcedLearn = FALSE;
    _bLearnInterrupted=FALSE;
	_bManualLearn=FALSE;

    _u32StopLearnTmrValMs =DAB_STOP_LEARN_TIMER_MS;
    _u32StartLearnTmrValMs =DAB_START_LEARN_TIMER_MS;

	u8CurrFreqIndex = 1;
	u8PreviousFreqIndex = 0;
	u8FreqIndexdiff = 0;
	_bUpdateComplete = FALSE; 

    vSubscribe<trMsgSrvCmdLearn>();
    vSubscribe<trMeca_RRdmLearn>();
    vSubscribe<trMeca_RRdmFrequencyInfo>();

    vSubscribe<trMsgDrvStartComponent>();
    vSubscribe<trMsgDrvStopComponent>();
    vSubscribe<trMsgDrvCmdSourceState>();

}

tVoid dabdrv_learn::vInit() {
    ETG_TRACE_USR1(("dabdrv_learn::vInit"));

#if 1 // etg-test
    char const *testSTr="hello";
    ETG_TRACE_USR4(( "ETG-test 1 line=%d.\
                    line break with backslash in format string line=%d",
                    1, 2));
    ETG_TRACE_USR4(( "ETG-test 2.\
                    line break with backslash in format string"));

                  ETG_TRACE_COMP(("ETG-test 3 testSTr.testSTr \
                     is :%s.", testSTr));

#endif

    _oStopLearnTmr.vInit(instance(),trMsgStopLearnTimeOut());    
    _oStartLearnTmr.vInit(instance(),trMsgStartLearnTimeOut());

	//if(DAB_SINGLE_TUNER_MODE())
		_oLearnActivity.vSetPrio(enActivityPrio_Low);	

#ifndef DAB_ENABLE_CHN_RESELECT_AFTER_LEARN
    _oLearnActivity.vSetChangesChannel(FALSE);
#endif

	//if(DAB_SINGLE_TUNER_MODE())
		dabdrv_main::instance()->vRegisterActivity(&_oLearnActivity);  
}

tVoid dabdrv_learn::vDeInit() {
    ETG_TRACE_USR1(("dabdrv_learn::vDeInit"));

    _oStopLearnTmr.vDeInit();    
    _oStartLearnTmr.vDeInit();    

}

tVoid dabdrv_learn::vTraceState() const {

    ETG_TRACE_USR1(("  dabdrv_learn STATE: _enLearnState=%d _bForcedLearn=%d _enRequestedLearnType=%d"
                    "bStopLearnTmrRunning=%d bStartLearnTmrRunning=%d",
                    ETG_CENUM(tenLearnState, _enLearnState),
                    _bForcedLearn,
                    ETG_CENUM(tenLearnType, _enRequestedLearnType),
                    _oStopLearnTmr.bIsRunning(),
                    _oStartLearnTmr.bIsRunning()));
}


tVoid dabdrv_learn::vOnLearnDone() {
    tenLearnState enOldLearnState=_enLearnState;
    _enLearnState = enLearnState_Idle;
    _enRequestedLearnType = enLearnType_OFF;
    _bForcedLearn=FALSE;
    _oStopLearnTmr.vStop();

    vStartLearnTimerConditional();

    if (enOldLearnState==enLearnState_Running || enOldLearnState==enLearnState_Stopping) {
        trMsgDrvCmdSetRdmNotifyMode rRdmNotifyMode(enRdmNotifyMode_Normal);
        DAB_vCallMsg(rRdmNotifyMode);
        trMsgDrvEvtLearnDone rLearnDone;
        rLearnDone.bCompleteScan= !_bLearnInterrupted;
        DAB_vCallMsg(rLearnDone);
        
    }

	
    if( (!DAB_SINGLE_TUNER_MODE()) && (dabdrv_main::instance()->bGetStartupLearn())
		){

		ETG_TRACE_USR1(("dabdrv_main:vOnLearnDone _startupLearn=%d",dabdrv_main::instance()->bGetStartupLearn()));
		dabdrv_main::instance()->vSetStartupLearn(FALSE);

		//if autostore is ON
		if(dabdrv_learn::instance()->vGetAutostoreAction()){
			trMsgDrvDbQuery rDbQuery(Query_InitialAutostore);
			DAB_vCallMsg(rDbQuery);
			dabdrv_db::instance()->vSetAutoStorePendingStatus(TRUE);
		}
		else { 
			trMsgSrvRspAutostore rResAutostore;
			rResAutostore.u8NumberOfFoundStations = 0;
			rResAutostore.enRes=DAB_enResult_FAILED;
			DAB_vCallMsg(rResAutostore);
			dabdrv_presets::instance()->vSetAutoStoreType(enAutostore_InValid);
			dabdrv_learn::instance()->vSetAutostoreAction(enAutostoreAction_InValid);
			//Play preset 0
			dabdrv_mecaIf::instance()->vSendMecaCommandCtor(trMeca_CRdmStationPlay(0));
		}
	}
	/*else if ( (!DAB_SINGLE_TUNER_MODE()) && (!(dabdrv_main::instance()->bGetStartupLearn()))
		)
	{
		trMsgDrvDbQuery rDbQuery(Query_InitialAutostore);
		DAB_vCallMsg(rDbQuery);
	}*/	
	else if((DAB_SINGLE_TUNER_MODE()) && (dabdrv_main::instance()->bGetStartupLearn()))
	{
		dabdrv_main::instance()->vSetStartupLearn(FALSE);
		trMsgDrvDbQuery rDbQuery(Query_InitialAutostore);
		DAB_vCallMsg(rDbQuery);
		dabdrv_db::instance()->vSetAutoStorePendingStatus(TRUE);
	}

	if( DAB_SINGLE_TUNER_MODE() || (_bManualLearn==TRUE) || (dabdrv_main::instance()->bGetStartupLearn()) ){
		_bManualLearn=FALSE;
		_oLearnActivity.vTerminated();
	}
}

tVoid dabdrv_learn::vProcess(trMsgStopLearnTimeOut *poStopLearnTimeOut) {
    (tVoid)poStopLearnTimeOut;
    _bLearnInterrupted=TRUE;
    vStopLearn();
    vOnLearnDone();

}

tVoid dabdrv_learn::vProcess(trMsgStartLearnTimeOut *poStartLearnTimeOut) {
    (tVoid)poStartLearnTimeOut;
/*    if ((DAB_SINGLE_TUNER_MODE()) && (dabdrv_main::instance()->enGetSourceState()==DAB_enSourceState_BG)) {
        vStartLearn();
    }
    else*/ if(!DAB_SINGLE_TUNER_MODE()){
        vStartLearnTimerConditional();
    }
}


tVoid dabdrv_learn::vProcess(trMsgDrvStartComponent *poStartComponent) {
    (tVoid)poStartComponent;
    vHandleLearn(dabdrv_main::instance()->enGetSourceState());
}

tVoid dabdrv_learn::vProcess(trMsgDrvStopComponent *poStopComponent) {
    (tVoid)poStopComponent;
    _bLearnInterrupted=TRUE;
    vOnLearnDone();
}
tVoid dabdrv_learn::vProcess(trMsgSrvCmdLearn* poSrvCmdLearn) {
    poSrvCmdLearn->enRes=DAB_enResult_OK;

	poSrvCmdLearn->vTrace();

	ETG_TRACE_USR4(("vProcess(trMsgSrvCmdLearn bIsAdrUp()=%d",dabdrv_main::instance()->bIsAdrUp() ));
	ETG_TRACE_USR4(("vProcess(trMsgSrvCmdLearn _enLearnState =%d",_enLearnState));

    if (!dabdrv_main::instance()->bIsAdrUp()) {
        poSrvCmdLearn->enRes=DAB_enResult_FAILED;
        vOnLearnDone();
    }
    if (poSrvCmdLearn->enLearnType==enLearnType_OFF) {
        // stop learn:
        vStopLearn();
        _bForcedLearn=FALSE;
        return;
    }

    tBool bStartLearn=TRUE;
    _bForcedLearn=!poSrvCmdLearn->bOffLearn;
    poSrvCmdLearn->enRes=DAB_enResult_OK;
    if (_enLearnState == enLearnState_Pending  ) {
        // overwrite requested learn-type
        _enRequestedLearnType = poSrvCmdLearn->enLearnType;

    }
    else if (_enLearnState != enLearnState_Idle) {
        // learn already running, do nothing
        bStartLearn=FALSE;
    }

    if (bStartLearn) {
        vStartLearn(poSrvCmdLearn->enLearnType, poSrvCmdLearn->bRollback);
		//only for double tuner, execute query
		/*if(!DAB_SINGLE_TUNER_MODE()&&
			(dabdrv_main::instance()->bGetStartupLearn())){
				ETG_TRACE_USR1(("vProcess(trMsgSrvCmdLearn _startupLearn=%d",dabdrv_main::instance()->bGetStartupLearn()));
				dabdrv_main::instance()->vSetStartupLearn(FALSE);
				trMsgDrvDbQuery rDbQuery(Query_InitialAutostore);
				DAB_vCallMsg(rDbQuery);
				dabdrv_db::instance()->vSetAutoStorePendingStatus(TRUE);
		}*/

    }
    else if (_bForcedLearn) {
        DAB_vCallMsgCtor(trMsgDrvEvtForcedLearnStart());
    }
}

tVoid dabdrv_learn::vStartLearnTimerConditional() {

	/*if(DAB_SINGLE_TUNER_MODE()){
		DAB_tenSourceState enSrcState=dabdrv_main::instance()->enGetSourceState();

		if (dabdrv_main::instance()->bIsAdrUp() &&
			(enSrcState==DAB_enSourceState_BG || enSrcState==DAB_enSourceState_SrvFollow)) {
			_oStartLearnTmr.vStart(_u32StartLearnTmrValMs);
		}
	}
	else*/if(!DAB_SINGLE_TUNER_MODE()){
		if (dabdrv_main::instance()->bIsAdrUp())/* &&
				(enSrcState==DAB_enSourceState_BG || enSrcState==DAB_enSourceState_SrvFollow)) */{
				_oStartLearnTmr.vStart(_u32StartLearnTmrValMs);
		}
	}
}

tVoid dabdrv_learn::vProcess(trMeca_RRdmLearn* poRRdmLearn) {
	ETG_TRACE_USR4(("poRRdmLearn->enLearnCommand = %d", poRRdmLearn->enLearnCommand));
    if (poRRdmLearn->enLearnCommand == enMeca_RdmLearnCommand_NORMAL_STOP ||
        poRRdmLearn->enLearnCommand == enMeca_RdmLearnCommand_UPDATE_STOP ||
        poRRdmLearn->enLearnCommand == enMeca_RdmLearnCommand_BG_FOREVER_LEARN_STOP ||
        poRRdmLearn->enLearnCommand == enMeca_RdmLearnCommand_REJECTED) {
			//if(u8CurrFreqIndex!=1){
				u8CurrFreqIndex =1;
				u8PreviousFreqIndex =0;
			//}

		if((DAB_SINGLE_TUNER_MODE()) || (dabdrv_main::instance()->bGetStartupLearn()) || (_bManualLearn)){
				vOnLearnDone();
				vSetMute();
		}
		else
		{
            vHandleLearn(dabdrv_main::instance()->enGetSourceState());
		}
		if(poRRdmLearn->enLearnCommand == enMeca_RdmLearnCommand_NORMAL_STOP || poRRdmLearn->enLearnCommand == enMeca_RdmLearnCommand_UPDATE_STOP)
		{
			trMsgDrvDbQuery rDbQuery(Query_EnsembleList_Evaluate);
			DAB_vCallMsg(rDbQuery);
			_bUpdateComplete = TRUE;
		}
		else
		{
			trMsgSrvRspCmdLearn oRspCmdLearn;

			if (poRRdmLearn->enLearnCommand == enMeca_RdmLearnCommand_REJECTED)
				oRspCmdLearn.enRes = DAB_enResult_FAILED;
			else
				oRspCmdLearn.enRes = DAB_enResult_OK;

			DAB_vCallMsg(oRspCmdLearn);
		}
    }
	
}

tVoid dabdrv_learn::vProcess(trMsgDrvCmdSourceState* poDrvCmdSourceState) {
    vHandleLearn(poDrvCmdSourceState->enSourceState);
}

tVoid dabdrv_learn::vProcess(trMeca_RRdmFrequencyInfo* poRdmFrequencyInfo) {
	ETG_TRACE_USR1(("dabdrv_learn::trMeca_RRdmFrequencyInfo"));
	
	poRdmFrequencyInfo->vTrace();
	if (_enLearnState == enLearnState_Running)
	{	
		ETG_TRACE_USR1(("u8CurrFreqIndex=%d u8PreviousFreqIndex =%d",u8CurrFreqIndex, u8PreviousFreqIndex));
		DAB_trLearnUpdateStatusProperty oLearnUpdateStatus = dabdrv_properties::instance()->oLearnUpdateProperty.oGet();
		oLearnUpdateStatus.u8LearnPercentage = (tU8)(((u8CurrFreqIndex - poRdmFrequencyInfo->u8FirstFreqIndex)*100)/
											(poRdmFrequencyInfo->u8LastFreqIndex - poRdmFrequencyInfo->u8FirstFreqIndex));

		if (poRdmFrequencyInfo->u8CurrFreqIndex != u8PreviousFreqIndex)
		{
				dabdrv_properties::instance()->oLearnUpdateProperty.vSet(oLearnUpdateStatus);
			if (u8CurrFreqIndex < poRdmFrequencyInfo->u8LastFreqIndex && u8PreviousFreqIndex != 0)
			{
				if (u8PreviousFreqIndex > poRdmFrequencyInfo->u8CurrFreqIndex)
				{
					u8PreviousFreqIndex = 0;
				}

					u8FreqIndexdiff = (tU8)(poRdmFrequencyInfo->u8CurrFreqIndex - u8PreviousFreqIndex);
					ETG_TRACE_USR1(("u8FreqIndexdiff=%d",u8FreqIndexdiff));
					u8CurrFreqIndex = (tU8)(u8CurrFreqIndex + u8FreqIndexdiff);

			}
			u8PreviousFreqIndex = poRdmFrequencyInfo->u8CurrFreqIndex;
		}
		

		ETG_TRACE_USR1(("dabdrv_learn::trMeca_RRdmFrequencyInfo u8FreqPerc=%d",oLearnUpdateStatus.u8LearnPercentage));
		if (oLearnUpdateStatus.u8LearnPercentage == 100)
		{
			u8CurrFreqIndex = 1;
		}
	}
		
	
}


tVoid dabdrv_learn::vStartLearn(tenLearnType enLearnType, tBool bRollback) {
    (tVoid)bRollback;
    if (_enLearnState==enLearnState_Idle) {
        _bLearnInterrupted=FALSE;
        _enRequestedLearnType = enLearnType;
        _enLearnState=enLearnState_Pending;

		ETG_TRACE_USR1(("dabdrv_learn::vStartLearn _bManualLearn=%d",_bManualLearn));
		if((DAB_SINGLE_TUNER_MODE()) || (dabdrv_main::instance()->bGetStartupLearn()) || (_bManualLearn)){
			_oLearnActivity.vRequest();
		}

    }

}

tBool dabdrv_learn::bRunActivity() {
    tBool bRes=FALSE;
    vTraceState();
	if((DAB_SINGLE_TUNER_MODE()) || (dabdrv_main::instance()->bGetStartupLearn()) || (_bManualLearn)){

		if (_enLearnState==enLearnState_Pending) {
        // reduce rdm-messages during learn
        if (_bForcedLearn) {
            DAB_vCallMsgCtor(trMsgDrvEvtForcedLearnStart());
        }
		
        trMsgDrvCmdSetRdmNotifyMode rRdmNotifyMode(enRdmNotifyMode_Learn);
        DAB_vCallMsg(rRdmNotifyMode);

        trMeca_CRdmLearn oCRdmLearn;
        // no learn active, start
        // todo: stop auto-updates of rdm to reduce message-load
		ETG_TRACE_USR4(("_enRequestedLearnType = %d", _enRequestedLearnType));
        oCRdmLearn.enLearnCommand=(_enRequestedLearnType==enLearnType_UPDATE ?
                                   enMeca_RdmLearnCommand_UPDATE_START : enMeca_RdmLearnCommand_NORMAL_START);
        _enLearnState= enLearnState_Running;
		ETG_TRACE_USR4(("oCRdmLearn.enLearnCommand = %d", oCRdmLearn.enLearnCommand));
        dabdrv_mecaIf::instance()->vSendMecaCommand(oCRdmLearn);

       
        //trMeca_CRdmFrequencyInfo oCRdmFrequencyInfo;
        //dabdrv_mecaIf::instance()->vSendMecaCommand(oCRdmFrequencyInfo);

        _oStopLearnTmr.vStart(_u32StopLearnTmrValMs);
        bRes=TRUE;
    }
    // todo assert here?
    vTraceState();
	}

    return bRes;

}

tBool dabdrv_learn::bTerminateActivity() {
    vStopLearn();
    return TRUE;
}

tVoid dabdrv_learn::vStopLearn() {

ETG_TRACE_USR4(("vStopLearn %d",_enLearnState));
    _bLearnInterrupted=TRUE;
    switch (_enLearnState) {
        case enLearnState_Pending:
        {
            // activity has not yet started
            vOnLearnDone();
        }
        break;
        case enLearnState_Running:
        {//commented as it is required in all cases when the StopLearn is called for Stopping the learn.
/*			if(DAB_SINGLE_TUNER_MODE())*/
			{
				_enLearnState=enLearnState_Stopping;
				// stop the virgin learn
				trMeca_CRdmLearn oCRdmLearn;
				oCRdmLearn.enLearnCommand=(_enRequestedLearnType==enLearnType_UPDATE ?
										   enMeca_RdmLearnCommand_UPDATE_STOP : enMeca_RdmLearnCommand_NORMAL_STOP);
				_oStopLearnTmr.vStart(DAB_STOP_LEARN_RSP_WAIT_TIMER_MS);

				dabdrv_mecaIf::instance()->vSendMecaCommand(oCRdmLearn);
			}
        }
        break;
        case enLearnState_Stopping:
        case enLearnState_Idle:
        default:
            break;
    }
}

tVoid dabdrv_learn::vHandleLearn(DAB_tenSourceState enSourceState) {
ETG_TRACE_USR1(("DAB_tenSourceState::vHandleLearn enSourceState %d _bForcedLearn %d",enSourceState,_bForcedLearn));
	/*if(DAB_SINGLE_TUNER_MODE()){
		switch(enSourceState) {
			case DAB_enSourceState_BG:
        		if(dabdrv_main::instance()->u8GetBgLearnUpdateTime()){
        			_oStartLearnTmr.vStart(dabdrv_main::instance()->u8GetBgLearnUpdateTime());
        		}
        		else{
        			vStartLearn();
        		}
				break;
	        
			case DAB_enSourceState_FG:
			case DAB_enSourceState_SrvFollow:
				if (!_bForcedLearn) {
					vStopLearn();
				}
				_oStartLearnTmr.vStop();
				break;
			case DAB_enSourceState_FG_TA:
				vStopLearn();
				break;
			default:
				break;
		}
	}
	elseif(!DAB_SINGLE_TUNER_MODE()){ */
    // make lint happy
    enSourceState= enSourceState;

    // start background tuner with learn
    trMeca_CRdmLearn oCRdmLearn;
    oCRdmLearn.enLearnCommand = enMeca_RdmLearnCommand_BG_FOREVER_LEARN_START;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCRdmLearn);

//	}
}
tVoid dabdrv_learn::vSetMute()
{
#ifdef MUTE_ACTIVE
	if(dabdrv_main::instance()->enGetMuteOperation() == enMuteOperation_LearnUpdate)
	{
		tenMuteOperation enNextMuteOp=dabdrv_main::instance()->enGetNextMuteOperation();
		if(enNextMuteOp != enMuteOperation_None){
			dabdrv_main::instance()->enSetMuteOperation(enNextMuteOp);
			dabdrv_main::instance()->enSetNextMuteOperation(enMuteOperation_None);
			trMsgDrvMuteState rMsg;
			rMsg.enDabSource = enDabSource_Dab;
			rMsg.enMuteState= enRequiredMuteState_Mute;
			DAB_vCallMsg(rMsg);
		}
		else{
			dabdrv_main::instance()->enSetMuteOperation(enMuteOperation_None);
			trMsgDrvCmdTunerOpMuteReq rMuteReq;
			rMuteReq.enRequiredMuteState=enRequiredMuteState_Demute;
			rMuteReq.enMuteOperation=enMuteOperation_ManualTune;
			DAB_vCallMsg(rMuteReq);

		}
	}
#endif
}

#if 0
tBool dabdrv_learn::bLearnActive() const {
    return (tU32)_enLearnState>(tU32)enLearnState_Pending;
};
#endif

