/************************************************************************
 * FILE:      dabdrv_db.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_db
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DABDRV_DB_HPP
#define DABDRV_DB_HPP

#include "fc_dabtuner_util.h"
#include "dabdrv_types.hpp"
#include "dabdrv_main.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_MECA
#include "trcGenProj/Header/dabdrv_db.hpp.trc.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI
#define DB_QUERY_PRESETALL "SELECT n,frequency,servecc,stype,sid,label,scids FROM dab_service_preset"
#define DB_QUERY_PRESETINFO "SELECT n,frequency,servecc,stype,sid,label,scids FROM dab_service_preset WHERE n="
#define DB_QUERY_ENSEMBLELIST "SELECT E.sihash, E.ensecc, E.eid, E.label, E.nPS, E.nDS, F.frequency, F.quality, (E.quality_word&0x40)!=0 AS not_rx FROM v1f0_dab_ensemble AS E, dab_ensemble_frequency as F ON F.e=E.o WHERE (E.quality_word&0x80)=0 GROUP BY E.r_ensemble"
#else
#define DB_QUERY_PRESETALL "SELECT rdm_sttnum(n),frequency,servecc,stype,sid,label,scids FROM dab_service_preset"
#define DB_QUERY_PRESETINFO "SELECT rdm_sttnum(n),frequency,servecc,stype,sid,label,scids FROM dab_service_preset WHERE rdm_sttnum(n)="
#define DB_QUERY_ENSEMBLELIST "SELECT E.sihash, E.ensecc, E.eid, E.label, E.nPS, E.nDS, F.frequency, F.quality, (E.quality_word&0x40)!=0 AS not_rx,rdm_freqlabel(F.frequency) FROM v1f0_dab_ensemble AS E, dab_ensemble_frequency as F ON F.e=E.o WHERE (E.quality_word&0x80)=0 GROUP BY E.r_ensemble"

#endif


namespace DAB {


    class dabdrv_db:
        public DAB_Singleton <dabdrv_db>,
        public DAB_MessageHandlerCommon<dabdrv_db>
    {
        friend class DAB_Singleton<dabdrv_db>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_MECA);
        virtual char const *pcGetName() const {return "dabdrv_db";};        
        virtual tVoid vTraceState() const;
        virtual tVoid vInit();
        virtual tVoid vDeInit();

        virtual tVoid vProcess(trMsgDrvStartComponent* poStart);
        virtual tVoid vProcess(trMsgDrvStopComponent* poStop);
        virtual tVoid vProcess(trMsgDrvCmdSetDbNotifyMode* poNotifyMode);
        virtual tVoid vProcess(trMsgDrvSetTestMode *poTestMode);
        virtual tVoid vProcess(trMeca_RDbFilterId* poRFilterId);
        virtual tVoid vProcess(trMeca_RDbSetAutoNotification* poRDbSetAutoNotification);
        virtual tVoid vProcess(trMeca_RDbGetDbEnsembleList* poEnsembleList);
        //virtual tVoid vProcess(trMeca_RDbReject* poDbReject);
		virtual tVoid vProcess(trMsgDrvDbQuery* poDrvDbQuery);
		virtual tVoid vProcess(trMeca_RDbQuery* poRDbQuery);
		virtual tVoid vProcess(trMsgDrvDbQueryTrigger* poDrvDbQueryTrigger);
		tVoid vOnInitialAutoStoreQueryResponse(trMeca_RDbQuery* poRDbQuery) ;
		tVoid vOnLinkingInfoQueryResponse(trMeca_RDbQuery* poRDbQuery) const;
		tVoid vOnAltFreqInformationResponse(trMeca_RDbQuery* poRDbQuery) const;
		tVoid vOnGlobalListQueryResponse(trMeca_RDbQuery* poRDbQuery) const;
		tVoid vSetPreset(trMecaProgrammeService const rSrv ,tU8 u8PresetNo,tU32 u32Frequency, trMecaLabel &rMecaLabel) const;	//Coverity 126841
		tVoid vManualAutostore() const;
		tVoid vSetAutoStorePendingStatus(tBool _bStatus);
		tBool bGetAutoStorePendingStatus()const{ return m_bAutostorePending;}

		
		tU8 vGetFoundStations() const{return _u8FoundStations;}

    private:
        dabdrv_db();
        tVoid vEnableNotifcations() const;
        tVoid vDisableNotifcations() const;
        tVoid vSetFilter(tenMeca_DbFilterCommand enCmd,
						 tenDabDbFilterId enFilterId, 
                         tenMeca_DbFilterElemType enFilterElemType, 
                         tU16 u16ClassMask, 
                         ten_MecaSendMode enSendMode=en_MecaSendMode_Normal, 
                         tU8 u8DataFieldLen=0, 
                         tU8 const *au8DataField=OSAL_NULL) const;

        tVoid vSetAutoNotifications();

        tVoid vRequestRdmCurNotification(tBool bEnable, tenDabDbFilterId enFilterId, tenMeca_DbNotifyClass enClass, tU16 u16MsgMask=0) const;

        tBool _bNotifyOn;
        typedef enum {
            enDabDrvDbState_Idle,
            enDabDrvDbState_WaitFilterRsp,
            enDabDrvDbState_NotifyRsp
        } tenDabDrvDbState;
        tenDabDrvDbState _enState;
		tU8 _u8FoundStations;
        set<trMecaEnsembleListElement> _setAllEnsembles;

		tBool m_bAutostorePending;
        
    };
} //namespace DAB 

#endif


