/************************************************************************
 * FILE:       dabdrv_db.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_db
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "dabdrv_main.hpp"
#include "dabdrv_mecaIf.h"
#include "dabmeca_db.hpp"
#include "dabdrv_db.hpp"
#include "dabdrv_presets.hpp"
#include "dabdrv_learn.hpp"
#include "dabdrv_chnInfo.hpp"
#include "dabdrv_chnList.hpp"
#include "fc_dabtuner_config.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_MECA 
#include "trcGenProj/Header/dabdrv_db.cpp.trc.h"
#endif


#ifndef __RFC3072_HELPER_H__
#include "rfc3072_helper.h"
#endif


#define DAB_DB_WAIT_NOTIFY_MS (2000 * DAB_TIME_FACTOR)

using namespace DAB;

dabdrv_db::dabdrv_db() {
    vSubscribe<trMsgDrvStartComponent>();
    vSubscribe<trMsgDrvStopComponent>();
    vSubscribe<trMsgDrvCmdSetDbNotifyMode>();
    vSubscribe<trMsgDrvSetTestMode>();
    vSubscribe<trMeca_RDbFilterId>();
    vSubscribe<trMeca_RDbSetAutoNotification>();
    vSubscribe<trMeca_RDbGetDbEnsembleList>();
    //vSubscribe<trMeca_RDbReject>();
	vSubscribe<trMsgDrvDbQuery>();	
	vSubscribe<trMeca_RDbQuery>();
	vSubscribe<trMsgDrvDbQueryTrigger>();

    _bNotifyOn=TRUE;
    _enState=enDabDrvDbState_Idle;
	m_bAutostorePending = FALSE;
	_u8FoundStations = 0;
}

void dabdrv_db::vInit() {

}

void dabdrv_db::vDeInit() {
}

tVoid dabdrv_db::vTraceState() const {
    ETG_TRACE_USR1(("  dabdrv_db STATE: _bNotifyOn=%d _enState=%d",
                    _bNotifyOn,
                    ETG_CENUM(tenDabDrvDbState, _enState)));
}


tVoid dabdrv_db::vProcess(trMsgDrvStartComponent*) {
    

    _enState=enDabDrvDbState_WaitFilterRsp;

    vSetFilter(enMeca_DbFilterCommand_NEW_WITH_AUTO_DESTRUCT,
				enDabDbFilterId_Default, 
               enMeca_DbFilterElemType_AUDIO_SERVICE_FILTER, 
               (tU8)enMeca_DbFilterClassMask_ENSEMBLE | (tU8)enMeca_DbFilterClassMask_SERVICE | (tU8)enMeca_DbFilterClassMask_COMPONENT);
	#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
	vSetFilter(enMeca_DbFilterCommand_ADD_ELEMENT,
				enDabDbFilterId_Default, 
               enMeca_DbFilterElemType_ID_SORTER, 
              (tU8)enMeca_DbFilterClassMask_SERVICE);
	#endif

   // vSetAutoNotifications();

    // check configuration if DMB-A enabled/disabled
    fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
    
    if (OSAL_NULL == poConfig) {
        ETG_TRACE_FATAL(("dabdrv_db::vProcess(trMsgDrvStartComponent) config not available !!!"));
        return;
    }
    
    ETG_TRACE_USR1(("  dabdrv_db DMB-A Filter %d", poConfig->bGetDmbAEnable()));

    if ( FALSE == poConfig->bGetDmbAEnable() ) {
        ETG_TRACE_USR1(("  dabdrv_db set Filter NO DMB-A"));
        vSetFilter(enMeca_DbFilterCommand_ADD_ELEMENT,
					enDabDbFilterId_Default, 
                   enMeca_DbFilterElemType_AUDIO_SERVICE_FILTER_NODMB, 
                   (tU8)enMeca_DbFilterClassMask_ENSEMBLE | (tU8)enMeca_DbFilterClassMask_SERVICE | (tU8)enMeca_DbFilterClassMask_COMPONENT,
                   en_MecaSendMode_NoDmb);
    }

#if 0 //todo: db does not want this one
    vSetFilter(enDabDbFilterId_AudioComponent, 
               enMeca_DbFilterElemType_AUDIO_SERVICE_FILTER, 
               (tU8)enMeca_DbFilterClassMask_COMPONENT);
#endif


}

tVoid dabdrv_db::vSetFilter(tenMeca_DbFilterCommand enCmd,tenDabDbFilterId enFilterId, tenMeca_DbFilterElemType enFilterElemType, tU16 u16ClassMask, ten_MecaSendMode enSendMode, tU8 u8DataFieldLen, tU8 const *au8DataField) const {
    trMeca_CDbFilterId rCSetFilter;
    rCSetFilter.u8FilterId=(tU8)enFilterId;
    rCSetFilter.u8DataFieldLen=0;
    rCSetFilter.enFilterCommand = enCmd;
    rCSetFilter.enFilterElemType = enFilterElemType;
    rCSetFilter.u16ClassMask=u16ClassMask;

    if (u8DataFieldLen && au8DataField != OSAL_NULL) {
        rCSetFilter.u8DataFieldLen = u8DataFieldLen>(tU8)DAB_MECA_DB_MAX_FILTER_DATA_FIELD_LEN ? (tU8)DAB_MECA_DB_MAX_FILTER_DATA_FIELD_LEN : u8DataFieldLen ;
    }

    if (enSendMode == en_MecaSendMode_Block) {
        trMeca_RDbFilterId rFilterId;
        rFilterId.u8FilterId = (tU8)enFilterId;
        rFilterId.enFilterResponse = enMeca_DbFilterResponse_NEW_ERROR;
        dabdrv_mecaIf::instance()->vSendMecaCommand(rCSetFilter, 
                                                    trMecaSendSvInfo(enSendMode, DAB_DB_WAIT_NOTIFY_MS, this, &rFilterId));
    } else if (enSendMode == en_MecaSendMode_NoDmb) {
        rCSetFilter.enFilterCommand = enMeca_DbFilterCommand_ADD_ELEMENT;
        dabdrv_mecaIf::instance()->vSendMecaCommand(rCSetFilter);
    } else {
        dabdrv_mecaIf::instance()->vSendMecaCommand(rCSetFilter);
    }


}

    
tVoid dabdrv_db::vSetAutoNotifications() {
    ETG_TRACE_USR1(("  dabdrv_db::vSetAutoNotifcations()"));
    if (_bNotifyOn) {
        vEnableNotifcations();
    } else {
        vDisableNotifcations();
    }
    _enState=enDabDrvDbState_NotifyRsp;
}

tVoid dabdrv_db::vEnableNotifcations() const {
    // set notification for complete info of current ensemble
    ETG_TRACE_USR1(("  dabdrv_db::vEnableNotifcations()"));
    vRequestRdmCurNotification(TRUE,
                               enDabDbFilterId_Default,
                               enMeca_DbNotifyClass_ENSEMBLE, 
                               (tU16)enMeca_DbNotifyMessageEns_INFO | 
                               (tU16)enMeca_DbNotifyMessageEns_SRV_LIST_PROG |
                               (tU16)enMeca_DbNotifyMessageEns_SRV_LIST_DATA 
                               );

    // set notification for complete info of current prog-service
    vRequestRdmCurNotification(TRUE, 
                               enDabDbFilterId_Default,
                               enMeca_DbNotifyClass_PROGRAMME_SERVICE, 
                               (tU16)enMeca_DbNotifyMessageSrv_INFO
                               | (tU16)enMeca_DbNotifyMessageSrv_COMP_LIST);

    // set notification for complete info of current prog-service-component
    vRequestRdmCurNotification(TRUE, 
                               enDabDbFilterId_Default,
                               enMeca_DbNotifyClass_PROGRAMME_SERVICE_COMPONENT, 
                               (tU16)enMeca_DbNotifyMessageSrvComp_INFO);



#if 0
    // set notification for complete info of current component
    vRequestRdmCurNotification(TRUE, 
                               enDabDbFilterId_None,
                               enMeca_DbNotifyClass_COMPONENT, 
                               (tU16)enMeca_DbNotifyMessageComponent_INFO);
#endif

    trMeca_CDbSetAutoNotification oAutoNotify;
    oAutoNotify.u8FilterId = enDabDbFilterId_Default;

#if 0
    // set notification for complete audio service list
    oAutoNotify.u8FilterId=(tU8)enDabDbFilterId_Default;
    oAutoNotify.enNotifyCommand = enMeca_DbNotifyCommand_SET;
    oAutoNotify.enNotifyClass = enMeca_DbNotifyClass_DATABASE_GET_DB_SERVICE_LIST;
    oAutoNotify.enServiceType = enMeca_ServiceType_AUDIO_SERVICE;
    oAutoNotify.rService.vInvalidate();
    oAutoNotify.u8NumBefore=0x00;
    oAutoNotify.u8NumBehind=0xFF;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oAutoNotify);
    DAB_THREAD_WAIT_MS(1000);
#endif
    // set notification for complete ensemble list
#ifdef OLD_STYLE_LIST_IMPLEMENTATION
    oAutoNotify.enNotifyCommand = enMeca_DbNotifyCommand_SET;
    oAutoNotify.enNotifyClass = enMeca_DbNotifyClass_DATABASE_GET_DB_ENSEMBLE_LIST;
    oAutoNotify.rEnsemble.vInvalidate();
    oAutoNotify.u8NumBefore=0x00;
    oAutoNotify.u8NumBehind=0xFF;
    trMeca_RDbSetAutoNotification rDbSetAutoNotification;
    rDbSetAutoNotification.enNotifyClass=enMeca_DbNotifyClass_DATABASE_GET_DB_ENSEMBLE_LIST;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oAutoNotify);
#endif


}


tVoid dabdrv_db::vDisableNotifcations() const  {

    ETG_TRACE_USR1(("  dabdrv_db::vDisableNotifcations()"));
    // set all notifications for current ensemble
    vRequestRdmCurNotification(FALSE, enDabDbFilterId_Default, enMeca_DbNotifyClass_ENSEMBLE);
    vRequestRdmCurNotification(FALSE, enDabDbFilterId_Default, enMeca_DbNotifyClass_PROGRAMME_SERVICE);
    vRequestRdmCurNotification(FALSE, enDabDbFilterId_Default, enMeca_DbNotifyClass_PROGRAMME_SERVICE_COMPONENT);
    vRequestRdmCurNotification(FALSE, enDabDbFilterId_Default, enMeca_DbNotifyClass_COMPONENT);


    trMeca_CDbSetAutoNotification oAutoNotify;

#if 0
    oAutoNotify.enNotifyCommand = enMeca_DbNotifyCommand_DELETE_ALL;
    oAutoNotify.enNotifyClass = enMeca_DbNotifyClass_DATABASE_GET_DB_SERVICE_LIST;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oAutoNotify);
    DAB_THREAD_WAIT_MS(1000);
#endif

    // last notification sent blocking. On timeout (no answer from DAB-module) will will receive the received rDbSetAutoNotification as response
    trMeca_RDbSetAutoNotification rDbSetAutoNotification;
    rDbSetAutoNotification.enNotifyClass=enMeca_DbNotifyClass_DATABASE_GET_DB_ENSEMBLE_LIST;
    oAutoNotify.enNotifyClass = enMeca_DbNotifyClass_DATABASE_GET_DB_ENSEMBLE_LIST;
    oAutoNotify.vTrace();
    dabdrv_mecaIf::instance()->vSendMecaCommand(oAutoNotify);

    DAB_THREAD_WAIT_MS(1000);


}

tVoid dabdrv_db::vProcess(trMeca_RDbSetAutoNotification* poRDbSetAutoNotification) {
    if ((poRDbSetAutoNotification->enNotifyClass==enMeca_DbNotifyClass_ENSEMBLE) &&
        (poRDbSetAutoNotification->u16NotifyMessage & (tU16)enMeca_DbNotifyMessageEns_SRV_LIST_PROG) &&
        (poRDbSetAutoNotification->u8FilterId==(tU8)enDabDbFilterId_Default)) {
        // store that notification for this ensemble is set
        _setAllEnsembles.insert(poRDbSetAutoNotification->rEnsemble);
    }

        
        if (_enState==enDabDrvDbState_NotifyRsp) {
            _enState=enDabDrvDbState_Idle;
            trMsgDrvRspSetDbNotifyMode rRsp(_bNotifyOn);
            DAB_vCallMsg(rRsp);
    }
}

tVoid dabdrv_db::vProcess(trMsgDrvStopComponent*) {
    _enState=enDabDrvDbState_Idle;
    _setAllEnsembles.clear();
}

tVoid dabdrv_db::vProcess(trMsgDrvCmdSetDbNotifyMode *poNotifyMode) {
    tBool bDiff=(_bNotifyOn!=poNotifyMode->bOn);
    _bNotifyOn=poNotifyMode->bOn;
    ETG_TRACE_USR1(("  dabdrv_db::vProcess(trMsgDrvCmdSetDbNotifyMode) enable=%d",
                            bDiff));
    if (bDiff && dabdrv_main::instance()->bIsAdrUp()) {
        vSetAutoNotifications();
    }
    else {
        trMsgDrvRspSetDbNotifyMode rRsp(_bNotifyOn);
        DAB_vCallMsg(rRsp);
    }

}

tVoid dabdrv_db::vProcess(trMsgDrvSetTestMode *poTestMode) {
    vRequestRdmCurNotification(poTestMode->bEnable, enDabDbFilterId_Default, enMeca_DbNotifyClass_SUBCHANNEL, (tU16)enMeca_DbNotifyMessageSubChannel_INFO);
}

tVoid dabdrv_db::vRequestRdmCurNotification(tBool bEnable, tenDabDbFilterId enFilterId, tenMeca_DbNotifyClass enClass, tU16 u16MsgMask) const {
    ETG_TRACE_USR1(("  dabdrv_db vRequestRdmCurNotification: bEnable=%d enFilterId=%d enClass=%d u16MsgMask=0x%04x",
                    enFilterId,
                    bEnable, 
                    ETG_CENUM(tenMeca_DbNotifyClass, enClass),
                    u16MsgMask));

    trMeca_CDbSetAutoNotification oAutoNotify;

    // set all notifications for current ensemble
    oAutoNotify.u8FilterId = (tU8)enFilterId;
    oAutoNotify.enNotifyCommand = bEnable ? enMeca_DbNotifyCommand_SET_AUTO_RDMAPI_CURR : enMeca_DbNotifyCommand_DEL_AUTO_RDMAPI_CURR;
    oAutoNotify.enNotifyClass = enClass;
    oAutoNotify.u16NotifyMessage = bEnable ? u16MsgMask : 0;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oAutoNotify);
}

tVoid dabdrv_db::vProcess(trMeca_RDbFilterId* poRFilterId) {
	(tVoid)poRFilterId;  
    // if (_enState==enDabDrvDbState_WaitFilterRsp) {
            // _enState=enDabDrvDbState_NotifyRsp;

            // vSetAutoNotifications();           
    // }

}


// maintain auto-nofication for prog-service-list of all ensembles
tVoid dabdrv_db::vProcess(trMeca_RDbGetDbEnsembleList* poEnsembleList) {
    // maintain notifcations for all rdm-ensembles
    ETG_TRACE_USR4(("  dabdrv_db::vProcess(trMeca_RDbGetDbEnsembleList)"));
        set<trMecaEnsembleListElement> vNewEnsembles;
    for (vector<trMecaEnsembleListElement>::iterator iterEnsembles = poEnsembleList->lEnsembleList.begin(); 
         iterEnsembles != poEnsembleList->lEnsembleList.end(); 
         ++iterEnsembles) {
        
        tBool bEnsembleInList = FALSE;
        for (set<trMecaEnsembleListElement>::iterator iterNewEnsembles0 = _setAllEnsembles.begin(); 
             iterNewEnsembles0 != _setAllEnsembles.end(); 
             ++iterNewEnsembles0) {
             if (iterNewEnsembles0->rEnsemble.u32GetID() == iterEnsembles->rEnsemble.u32GetID()) {
                 bEnsembleInList = TRUE;
                 break;
             }
        }
        if (!bEnsembleInList){
            vNewEnsembles.insert(iterEnsembles->rEnsemble);
            ETG_TRACE_USR4(("    iterEnsembles NEW ens=0x%08x  u8Quality=0x%x", 
                                 iterEnsembles->rEnsemble.u32GetID(),
                                 iterEnsembles->u8Quality));
        }
    }

        // initialize auto-notify command
        trMeca_CDbSetAutoNotification oAutoNotify;
        oAutoNotify.enNotifyClass=enMeca_DbNotifyClass_ENSEMBLE;
        oAutoNotify.u16NotifyMessage=(tU16)enMeca_DbNotifyMessageEns_SRV_LIST_PROG;
        oAutoNotify.u8FilterId = (tU8)enDabDbFilterId_Default;

        

        // set notifications for new ensembles
        oAutoNotify.enNotifyCommand = enMeca_DbNotifyCommand_SET;
        DAB_FOREACH(set<trMecaEnsembleListElement>, iterNewEnsembles, vNewEnsembles) {
        ETG_TRACE_USR1(("  dabdrv_db::vProcess(trMeca_RDbGetDbEnsembleList)AUTONOTIFICATION new ens=0x%08x  u8Quality=0x%x",
                        iterNewEnsembles->rEnsemble.u32GetID(),
                        iterNewEnsembles->u8Quality));
            oAutoNotify.rEnsemble=iterNewEnsembles->rEnsemble;
        dabdrv_mecaIf::instance()->vSendMecaCommand(oAutoNotify);

        _setAllEnsembles.insert(iterNewEnsembles->rEnsemble);
        }

}

/*tVoid dabdrv_db::vProcess(trMeca_RDbReject* poDbReject) {
    (tVoid)poDbReject;
    ETG_TRACE_COMP(("  dabdrv_db::vProcess(trMeca_RDbReject) enRejectClass=%d enRejectCode=%d data=%*p",
                    ETG_CENUM(tenMeca_DbRejectClass, poDbReject->enRejectClass),
                    ETG_CENUM(tenMeca_DbRejectCode, poDbReject->enRejectCode),
                    ETG_LIST_LEN(poDbReject->u8DataLen), ETG_LIST_PTR_T8(poDbReject->u8Data)));
};*/

tVoid dabdrv_db::vProcess(trMsgDrvDbQueryTrigger* poDrvDbQueryTrigger){

	trMeca_CDbQueryTrigger rCDbQueryTrigger;
	switch(poDrvDbQueryTrigger->enDbQueryTrigger)
	{
		case QueryTrigger_EnsembleList:{

			rCDbQueryTrigger.u8QueryTag = (tU8)enMeca_TagID_Ensemble_List;
			rCDbQueryTrigger.u8QueryStateId = (tU8)enMeca_StateID_Ensemble_List;
			rCDbQueryTrigger.u8Id = (tU8)enMeca_StateID_Ensemble_List;
			rCDbQueryTrigger.enMeca_DbQueryAction = enMeca_DbQueryTriggerAction_SEND_R_DB_QUERY_TRIGGER_ONLY;

			break;
		}
		/*case QueryTrigger_GlobalList:{

			rCDbQueryTrigger.u8QueryTag = (tU8)enMeca_TagID_Global_List;
			rCDbQueryTrigger.u8QueryStateId = (tU8)enMeca_StateID_Global_List;
			rCDbQueryTrigger.u8Id = (tU8)enMeca_StateID_Global_List;
			break;
		}*/
		default:
			break;
	}

	tU16 u16QueryTriggerList[THREE] = {(tU16)enMeca_DbQueryTriggerList_TR__ADDED,
								  (tU16)enMeca_DbQueryTriggerList_TR__SERVICE_DATA_COMPLETE,
								  (tU16)enMeca_DbQueryTriggerList_TR__DAB_ENSEMBLE__QUALITY_WORD};

	OSAL_pvMemoryCopy(rCDbQueryTrigger.au8TriggerList, u16QueryTriggerList, sizeof(u16QueryTriggerList));
	rCDbQueryTrigger.u16TriggerListSize = 3;

	ETG_TRACE_USR4(("dabdrv_db::vProcess(trMsgDrvDbQueryTrigger*) u8QueryTag=%d u8QueryStateId=%d u16QueryTriggerList=%d",
			 rCDbQueryTrigger.u8QueryTag,
			 rCDbQueryTrigger.u8QueryStateId,
			 (tU16)(sizeof(u16QueryTriggerList))));

	for(tU32 u32Index=0; u32Index<3; u32Index++)
		 ETG_TRACE_USR4(("dabdrv_db::vProcess(trMsgDrvDbQueryTrigger*) u16QueryTriggerList[%d]=%d",
				 u32Index, u16QueryTriggerList[u32Index]));

	dabdrv_mecaIf::instance()->vSendMecaCommand(rCDbQueryTrigger);
}
tVoid dabdrv_db::vProcess(trMsgDrvDbQuery* poDrvDbQuery){

	trMeca_CDbQuery rCDbQuery;
	tChar sQuery[QUERY_LENGTH];	
	sQuery[0]=0;
	rCDbQuery.enDbQueryCmd = enMeca_DbQueryCmd_EVALUATE;

	switch(poDrvDbQuery->enDbQuery)
	{
		case Query_InitialAutostore:
		{
			rCDbQuery.u8QueryTag = enMeca_TagID_Initial_Autostore;
			(tVoid)OSAL_szStringCopy(sQuery, "SELECT dab_filter_pidx(1,S.e,S.o) AS i,F.fst AS fst,F.frequency AS frequency,E.r_ensemble AS r_ensemble,E.label,S.r_service AS r_service,S.label FROM dab_ensemble_frequency AS F,v1f0_dab_ensemble AS E, v1f1_dab_service AS S WHERE F.e=E.o AND E.o=S.e AND (E.quality_word&0x80)=0 GROUP BY S.o ORDER BY dab_filter_pidx(1,S.e,S.o) ASC,F.fst DESC  LIMIT 6");											  
			rCDbQuery.u8QueryStateId =0 ;
			rCDbQuery.enDbQueryCmd = enMeca_DbQueryCmd_EVALUATE;
			break;
		}

		case Query_SelfLearnedLinkInfo:
		{
			tChar sid[FIELD_LENGTH];
			trMecaId rMecaId =dabdrv_chnInfo::instance()->rGetCurrentSid();
			sprintf(sid,"0x%04x",rMecaId.u16GetScidi());
			(tVoid)OSAL_szStringCopy(sQuery, "SELECT F.frequency, F.sig, E.ensecc,E.eid,S.servecc,S.sid FROM dab_ensemble_frequency AS F,dab_ensemble_f0 AS e,dab_service AS S WHERE F.e=E.o AND E.o=S.e AND S.sid=");
			OSAL_szStringConcat(sQuery,sid);
			rCDbQuery.u8QueryTag =enMeca_TagID_LinkingInfo ;
			rCDbQuery.u8QueryStateId = 0;
			rCDbQuery.enDbQueryCmd = enMeca_DbQueryCmd_EVALUATE;
			break;
		}

		case Query_AltFreqInformation:
		{
			rCDbQuery.u8QueryTag = enMeca_TagID_Alt_Freq_Info;
			(tVoid)OSAL_szStringCopy(sQuery, "SELECT EF.frequency AS frequency, EF.fst AS fst, EF.quality AS quality  FROM dab_ensemble_frequency AS EF, dab_ensemble AS E, v1f0_dab_service AS S WHERE S.e=E.o AND EF.e=E.o AND rdm_current(S.o)");
			rCDbQuery.u8QueryStateId =0 ;
			rCDbQuery.enDbQueryCmd = enMeca_DbQueryCmd_EVALUATE;
			break;
		}

		case Query_EnsembleList_Prepare:
		case Query_EnsembleList_Evaluate:
		{
			rCDbQuery.u8QueryTag = enMeca_TagID_Ensemble_List;
			(tVoid)OSAL_szStringCopy(sQuery, DB_QUERY_ENSEMBLELIST);
			rCDbQuery.u8QueryStateId = ((poDrvDbQuery->enDbQuery==Query_EnsembleList_Prepare)?enMeca_StateID_Ensemble_List:0);
			rCDbQuery.enDbQueryCmd = ((poDrvDbQuery->enDbQuery==Query_EnsembleList_Prepare)?enMeca_DbQueryCmd_PREPARE:enMeca_DbQueryCmd_EVALUATE);
			break;
		}
		case Query_PresetInfo_All:
		{
			rCDbQuery.u8QueryTag = enMeca_TagID_All_Preset_Info;
			(tVoid)OSAL_szStringCopy(sQuery, DB_QUERY_PRESETALL);
			rCDbQuery.u8QueryStateId =0 ;
			rCDbQuery.enDbQueryCmd = enMeca_DbQueryCmd_EVALUATE;
			break;
		}
		case Query_PresetInfo:
		{
			tChar presetNum[FIELD_LENGTH];
			sprintf(presetNum,"%d",poDrvDbQuery->u8Param1);
			rCDbQuery.u8QueryTag = (tU8)(enMeca_TagID_Preset_Info_Start+poDrvDbQuery->u8Param1);
			(tVoid)OSAL_szStringCopy(sQuery, DB_QUERY_PRESETINFO);
			OSAL_szStringConcat(sQuery,presetNum);
			break;
		}
		default:
			break;
	}

	tU32 u32Len=(tU32)(OSAL_u32StringLength(sQuery));
		rCDbQuery.lu8SqlStatement.reserve(u32Len+2);
		for (tU32 i=0; i < u32Len; i++) {
		rCDbQuery.lu8SqlStatement.push_back(sQuery[i]);
		}		
	ETG_TRACE_USR4(("dabdrv_db::vProcess(trMsgDrvDbQuery* length=%d Query=%s",
		u32Len,
		sQuery));
	dabdrv_mecaIf::instance()->vSendMecaCommand(rCDbQuery);
}
tVoid dabdrv_db::vProcess(trMeca_RDbQuery* poRDbQuery){
	poRDbQuery->vTrace();
	switch(poRDbQuery->u8QueryTag){
		case enMeca_TagID_Initial_Autostore:
			vOnInitialAutoStoreQueryResponse(poRDbQuery);
			break;
		case enMeca_TagID_LinkingInfo:
			vOnLinkingInfoQueryResponse(poRDbQuery);
			break;
		case enMeca_TagID_Alt_Freq_Info:
			ETG_TRACE_USR1(("dabdrv_db(trMeca_RDbQuery)vOnAltFreqInformationResponse"));
			vOnAltFreqInformationResponse(poRDbQuery);
			break;
		default:
			break;
	}
}
tVoid dabdrv_db::vOnInitialAutoStoreQueryResponse(trMeca_RDbQuery* poRDbQuery) {
	ETG_TRACE_USR4(("dabdrv_db::vOnInitialAutoStoreQueryResponse"));
	tU32 u32Sid=dabdrv_chnInfo::instance()->rGetCurrentSid().u32GetSID();
	fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();

	ETG_TRACE_USR4(("dabdrv_db::vOnInitialAutoStoreQueryResponse u32Sid =  %d", u32Sid));

	_u8FoundStations = (tU8)(poRDbQuery->u16QueryNumRows);

	if(( poRDbQuery->enQueryResponse == enMeca_DbQueryResponse_OK)&&
		(poRDbQuery->u16QueryNumRows !=0)&&
		(poRDbQuery->u16QueryNumColumns !=0)){
		tU32 u32DataLength = (tU32)(poRDbQuery->lu8UserData.size());
		tU8* pu8Data = NULL;
		pu8Data = OSAL_NEW tU8[u32DataLength];
		if (pu8Data == NULL){
			ETG_TRACE_USR4(("dabdrv_db::vOnInitialAutoStoreQueryResponse data length %d",u32DataLength));
			return;
		}
		for(tU32 u32Index=0; u32Index<u32DataLength; u32Index++)
			pu8Data[u32Index] = poRDbQuery->lu8UserData[u32Index];
		try
		{
		for (tU16 u16Row=1;u16Row<=poRDbQuery->u16QueryNumRows;u16Row++)
		{
			tU32 u32Frequency;
			APIService rAPIservice;										
			tU8 u8Servicetype;	
			APILabel SrvLabel;
			trMecaLabel rSrvLabel;

			u32Frequency=sdxf_chunk_get_numeric_uint32(sdxf_table_get_chunk(pu8Data,u32DataLength,u16Row,THREE));
			sdxf_apiserviceblob_2_apiservice(&rAPIservice, sdxf_chunk_get_blob(sdxf_table_get_chunk(pu8Data,u32DataLength,u16Row,SIX)));
			sdxf_apiserviceblob_2_apiservicetype(&u8Servicetype, sdxf_chunk_get_blob(sdxf_table_get_chunk(pu8Data,u32DataLength,u16Row,SIX)));
			sdxf_labelblob_2_apilabel(&SrvLabel, sdxf_chunk_get_blob(sdxf_table_get_chunk(pu8Data,u32DataLength,u16Row,SEVEN)));
			trMecaProgrammeService rService;
			rService._u32Id =  (rAPIservice.r_programme_service.b_programme_service_type<<24)
																| (rAPIservice.r_programme_service.b_ecc<<16)
																| (rAPIservice.r_programme_service.w_service_id);
			rService.vTrace();

			rSrvLabel.vParse(SrvLabel);

			ETG_TRACE_USR1(("dabdrv_db(trMeca_RDbQuery) index=%d sid=%08x  servicetype=%d freq=%06u)",
				u16Row,
				rService._u32Id,				
				u8Servicetype,
				u32Frequency));

			ETG_TRACE_USR1(("dabdrv_presets::instance()->u8GetAutoStoreType() = %d",
				dabdrv_presets::instance()->u8GetAutoStoreType()));
			
			if((u16Row<=poConfig->u8NumberOfPresetsPerBank())&&
				(u32Sid!=0)
				){
#ifdef VARIANT_S_FTR_ENABLE_PRESET_AST
					if(enAutostore_Initial != dabdrv_presets::instance()->u8GetAutoStoreType())
					{
						vSetPreset(rService,u16Row+(poConfig->u8NumberOfPresetsPerBank()),u32Frequency, rSrvLabel);
					}
#else					
					vSetPreset(rService,(tU8)(u16Row+(poConfig->u8NumberOfPresetsPerBank())),u32Frequency, rSrvLabel);
#endif
			}		

			if((u32Sid==0)&&(u16Row==1)){
			trMeca_CRdmAudioPlayAsid rRdmAudioPlayAsid;			
			rRdmAudioPlayAsid.rMecaProgrammeService =rService ;			
			dabdrv_mecaIf::instance()->vSendMecaCommand(rRdmAudioPlayAsid);

			}
		}			
		
		/*if(u32Sid==0){
			trMsgDrvCmdNotifyLearnComplete rStartupLearnDone;		
			DAB_vCallMsg(rStartupLearnDone);

			trMeca_CRdmAudioPlayAsid rRdmAudioPlayAsid;
			trChnListElem rNewSrv= dabdrv_chnList::instance()->rGetFirstListElement();
			rRdmAudioPlayAsid.rMecaProgrammeService._enServiceType = rNewSrv.rMecaId._enServiceType;
			rRdmAudioPlayAsid.rMecaProgrammeService._u32Id = rNewSrv.rMecaId._u32Id;
			dabdrv_mecaIf::instance()->vSendMecaCommand(rRdmAudioPlayAsid);
		}
		else if(enAutostore_Initial == dabdrv_presets::instance()->u8GetAutoStoreType())
		{
			dabdrv_presets::instance()->vSendRecallPreset(0);
		}*/
		//OSAL_DELETE[] pu8Data;
		}
		catch(std::bad_alloc)
			{
				ETG_TRACE_USR1(("Exception caught"));
			}
		OSAL_DELETE[] pu8Data;
	}
	else
	{
		ETG_TRACE_USR1(("dabdrv_db(trMeca_RDbQuery)Initial autostore query failed"));
		/*select first service in_mapserviceInfo*/
		vManualAutostore();
	}

}

tVoid dabdrv_db::vOnLinkingInfoQueryResponse(trMeca_RDbQuery* poRDbQuery) const{
	ETG_TRACE_USR4(("dabdrv_db::vOnLinkingInfoQueryResponse"));
	if( poRDbQuery->enQueryResponse == enMeca_DbQueryResponse_OK){
		tU32 u32DataLength = (tU32)(poRDbQuery->lu8UserData.size());
		tU8* pu8Data = OSAL_NEW tU8[u32DataLength]; 
		if (pu8Data == NULL){
			ETG_TRACE_USR4(("dabdrv_db::vOnLinkingInfoQueryResponse result length %d",u32DataLength));
			return;
		}
		for(tU32 u32Index=0; u32Index<u32DataLength; u32Index++){
			pu8Data[u32Index] = poRDbQuery->lu8UserData[u32Index];			
			}
		for (tU16 u16Row=1;u16Row<=poRDbQuery->u16QueryNumRows;u16Row++)
		{
			tU32 u32Frequency;
			tU8 u8Quality;
			tU32 u32ECC;
			tU32 u32Eid;
			tU32 u32Sid;
			u32Frequency=sdxf_chunk_get_numeric_uint32(sdxf_table_get_chunk(pu8Data,u32DataLength,u16Row,ONE));
			u8Quality= (tU8)(sdxf_chunk_get_numeric_uint32(sdxf_table_get_chunk(pu8Data,u32DataLength,u16Row,TWO)));
			u32ECC=sdxf_chunk_get_numeric_uint32(sdxf_table_get_chunk(pu8Data,u32DataLength,u16Row,THREE));
			u32Eid=sdxf_chunk_get_numeric_uint32(sdxf_table_get_chunk(pu8Data,u32DataLength,u16Row,FOUR));	
			u32Sid=sdxf_chunk_get_numeric_uint32(sdxf_table_get_chunk(pu8Data,u32DataLength,u16Row,SIX));	
			ETG_TRACE_USR4(("dabdrv_db(trMeca_RDbQuery) index=%d sid=%04x freq=%06u qual=%x eid=%08x",
				u16Row,
				u32Sid,
				u32Frequency,
				u8Quality,						
				u32Eid));
			trMsgDrvUpdateLink rUpdateLink;
			rUpdateLink.rLinkListElem.enLinkType = enLinkType_DAB_DBLINK;
			rUpdateLink.rLinkListElem.u32EnsembleId =(u32Eid & 0xFF00FFFF) | (u32ECC << 16);
			rUpdateLink.rLinkListElem.u8Quality = u8Quality;
			rUpdateLink.rLinkListElem.u32Id = u32Sid; 
			DAB_vCallMsg(rUpdateLink);
		}
		OSAL_DELETE[] pu8Data;
	}
	else
	{
		ETG_TRACE_USR1(("dabdrv_db(trMeca_RDbQuery)Linking info query failed"));
	}
}
tVoid dabdrv_db::vOnAltFreqInformationResponse(trMeca_RDbQuery* poRDbQuery) const{
	ETG_TRACE_USR4(("dabdrv_db::vOnAltFreqInformationResponse"));
	if( poRDbQuery->enQueryResponse == enMeca_DbQueryResponse_OK){
		tU32 u32DataLength = (tU32)(poRDbQuery->lu8UserData.size());
		tU8* pu8Data = OSAL_NEW tU8[u32DataLength];
		if (pu8Data == NULL){
			ETG_TRACE_USR4(("dabdrv_db::vOnAltFreqInformationResponse result length %d",u32DataLength));
			return;
		}
		for(tU32 u32Index=0; u32Index<u32DataLength; u32Index++){
			pu8Data[u32Index] = poRDbQuery->lu8UserData[u32Index];
			}
		for (tU16 u16Row=1;u16Row<=poRDbQuery->u16QueryNumRows;u16Row++)
		{
			tU32 u32Frequency;
			tS32 s32FieldStrength;
			tU8 u8Quality;

			u32Frequency=sdxf_chunk_get_numeric_uint32(sdxf_table_get_chunk(pu8Data,u32DataLength,u16Row,ONE));
			s32FieldStrength= sdxf_chunk_get_numeric_uint32(sdxf_table_get_chunk(pu8Data,u32DataLength,u16Row,TWO));
			u8Quality=(tU8)(sdxf_chunk_get_numeric_uint32(sdxf_table_get_chunk(pu8Data,u32DataLength,u16Row,THREE)));

			ETG_TRACE_USR4(("dabdrv_db(trMeca_RDbQuery) index=%d u32Frequency=%06u s32FieldStrength=%d u8Quality=%x",
				u16Row,
				u32Frequency,
				s32FieldStrength,
				u8Quality));
			trMsgDrvAltFreqInfo rUpdateAltFreqInfo;
			rUpdateAltFreqInfo.rAltFreqInfo.u32Freq =u32Frequency;
			rUpdateAltFreqInfo.rAltFreqInfo.s32FieldStrength =s32FieldStrength;
			rUpdateAltFreqInfo.rAltFreqInfo.u8Quality =u8Quality;
			DAB_vCallMsg(rUpdateAltFreqInfo);
		}
		OSAL_DELETE[] pu8Data;
	}
	else
	{
		ETG_TRACE_USR1(("dabdrv_db(trMeca_RDbQuery)vOnAltFreqInformationResponse query failed"));
	}
}
tVoid dabdrv_db::vManualAutostore() const{
	fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
	if(!dabdrv_chnList::instance()->bIsMapServiceInfoEmpty()){/*store presets 7-12 for normal autostore*/
	for (tU16 u16Index=1;u16Index<=poConfig->u8NumberOfPresetsPerBank();u16Index++){
		trChnListElem rChnListElem=dabdrv_chnList::instance()->rGetElemRelative(u16Index);
		trMecaProgrammeService rService(rChnListElem.rMecaId._u32Id,enMeca_ServiceType_AUDIO_SERVICE);
		tU32 u32Frequency= dabdrv_chnList::instance()->u32GetFrequencyOfService(rService);
		//Coverity
		trMecaLabel oMecaLabel = dabdrv_chnList::instance()->rGetChnLabel((trMecaId)rService);
		vSetPreset(rService,(tU8)(u16Index+(poConfig->u8NumberOfPresetsPerBank())),u32Frequency, oMecaLabel);
		}
	}
	else{//SUZUKI-24812 solve dab autostore during no reception
		dabdrv_presets::instance()->vAutoStoreResponse();
	}
}
tVoid dabdrv_db::vSetAutoStorePendingStatus(tBool _bStatus){
	m_bAutostorePending = _bStatus;
}
tVoid dabdrv_db::vSetPreset(trMecaProgrammeService const rSrv,
							tU8 u8PresetNo,
							tU32 u32Freq,
							trMecaLabel &rSrvLabel) const{	//Coverity 126841
	if(rSrv.bIsValid()){
				trMeca_CRdmStationSetPresetStation rCRdmSetPresetStation;
				rCRdmSetPresetStation.enServiceType=rSrv._enServiceType;						
				rCRdmSetPresetStation.u8StationNumber= u8PresetNo;						
				rCRdmSetPresetStation.rProgrammeService=rSrv;										
				rCRdmSetPresetStation.u32Frequency=u32Freq;
				rCRdmSetPresetStation.rLabel=  rSrvLabel;
				rCRdmSetPresetStation.vTrace();
				dabdrv_mecaIf::instance()->vSendMecaCommand(rCRdmSetPresetStation);
			}			
}