/************************************************************************
 * FILE:       dabdrv_dataSrvList.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_dataSrvList
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DABDRV_DATA_SRV_LIST_HPP
#define DABDRV_DATA_SRV_LIST_HPP

#include "fc_dabtuner_config.h"
#include "dabdrv_meca.h"
#include "dabmeca_db.hpp"
#include "dabmeca_rdm.hpp"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_DATALST 
#include "trcGenProj/Header/dabdrv_dataSrvList.hpp.trc.h"
#endif

namespace DAB {

    struct trMsgDataListUpdateTimer;

    class dabdrv_dataSrvList:
        public DAB_Singleton <dabdrv_dataSrvList>,
        public DAB_MessageHandlerCommon<dabdrv_dataSrvList>
    {
        friend class DAB_Singleton<dabdrv_dataSrvList>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_DATALST);
        virtual ~dabdrv_dataSrvList(tVoid);    
        virtual tVoid vInit();
        virtual tVoid vDeInit();

        virtual char const *pcGetName() const {return "dabdrv_dataSrvList";};
        
#if 0
// moved to dabdrv_tmclearn.cpp
        virtual tVoid vProcess(trMsgDrvSetTmcMode* poMsgDrvSetTmcMode);
#endif
        virtual tVoid vProcess(trMsgDrvStartComponent* poStart);
        virtual tVoid vProcess(trMsgDrvStopComponent* poStop);
        virtual tVoid vProcess(trMeca_RDbEnsembleGetServiceList* poServiceList);
#if 0
// moved to dabdrv_tmclearn.cpp
        virtual tVoid vProcess(trMeca_RDbServiceGetComponentList* poComponentList);
        virtual tVoid vProcess(trMeca_RDdmTmcSc* poTmcSc);
        virtual tVoid vProcess(trMeca_RDdmTmcEvent* poTmcEvent);
#endif

        virtual tVoid vProcess(trMsgDataListUpdateTimer* poMsgDataListUpdateTimer);

        virtual tVoid vProcess(trMeca_RDbGetDbEnsembleList* poEnsembleList);
#if 0
// moved to dabdrv_tmclearn.cpp
        virtual tVoid vProcess(trMeca_RDbServiceGetInfo* poSrvLabel);
        
        virtual tVoid vProcess(trMeca_RDbFilterId* poRFilterId);
#endif

        tBool bGetEnsembleInfo(trMecaEnsemble const &rRefEnsemble, set<trMecaProgrammeService>&lServiceList);
    private:

        dabdrv_dataSrvList(tVoid);
        tVoid vTraceAll() const ;
        DAB_tclTimer _oDataListUpdateTimer;
        tU32 _u32DataListUpdateTimerValMs;

        struct trDataListEnsembleInfo {
            set<trMecaProgrammeService>lServiceList;
        };
        map<trMecaEnsemble, trDataListEnsembleInfo>_mapEnsembleInfo;


        tBool _bTmcActive;
        tBool _bFilterValid;


    };

}

#endif
