/************************************************************************
 * FILE:       dabdrv_compSelect.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_compSelect
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DABDRV_COMP_SELECT_HPP
#define DABDRV_COMP_SELECT_HPP

#include "fc_dabtuner_config.h"
#include "dabdrv_meca.h"
#include "dabdrv_presets.hpp"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_COMP 
#include "trcGenProj/Header/dabdrv_compSelect.hpp.trc.h"
#endif

namespace DAB {


    //lint -esym(763, DAB::trMsgDrvRspMuteDone)  Redundant declaration for symbol
    struct trMsgDrvRspMuteDone;
    struct trMsgCompSelectSupervision;
	 struct trMsgMuteSupervision;
	 
    struct trMsgDrvCmdCompSelect:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL

        trMsgDrvCmdCompSelect(trMsgSrvCmdCompSelect const &rSrvCmdCompSelect):
            enChnSelectSource(enChnSelectSource_ChnSelect),
            enChnSelectMode(rSrvCmdCompSelect.enChnSelectMode),
            u32Value(rSrvCmdCompSelect.u32Value),
            bNegative(rSrvCmdCompSelect.bNegative),
            enRes(DAB_enResult_INPROCESS)
        {}

        trMsgDrvCmdCompSelect():
            enChnSelectSource(enChnSelectSource_ChnSelect),
            enChnSelectMode(enChnSelectMode_Invalid),
            u32Value(0),
            bNegative(FALSE),
            enRes(DAB_enResult_INPROCESS)
        {}


        /* modes:
           up/down/current
           refType:
           listId/PSID
           trMecaProgrammeService rPSID
           
        */
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgDrvCmdCompSelect: enChnSelectSource=%d enChnSelectMode=0x%x u32Value=0x%x (%u) bNegative=%d enRes=%d" , 
                                ETG_CENUM(tenChnSelectSource, enChnSelectSource),
                                ETG_CENUM(tenChnSelectMode, enChnSelectMode),
                                u32Value,
                                u32Value,
                                bNegative,
                                ETG_CENUM(DAB_tenResult, enRes)
                                ));
        }

        tenChnSelectSource enChnSelectSource;
        tenChnSelectMode enChnSelectMode;
        tU32 u32Value;
        tBool bNegative;
        DAB_tenResult enRes;
    };
 
	struct trMsgDrvCmdCompSelectFromSrvList:
		   public DAB_Message
   {
	   DAB_DISPATCH_IMPL

	   trMsgDrvCmdCompSelectFromSrvList():
	   ochnListElem(),
	   enRes(DAB_enResult_INPROCESS)
	   {}

	   trChnListElem ochnListElem;
	   DAB_tenResult enRes;
   };


    class dabdrv_compSelect:
        public DAB_Singleton <dabdrv_compSelect>,
        public DAB_MessageHandlerCommon<dabdrv_compSelect>
    {
        friend class DAB_Singleton<dabdrv_compSelect>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_COMP);
        virtual ~dabdrv_compSelect(tVoid);    
        virtual tVoid vInit();
        virtual tVoid vDeInit();

        virtual char const *pcGetName() const {return "dabdrv_compSelect";};
        virtual tVoid vTraceState() const;

        virtual tVoid vProcess(trMsgCompSelectSupervision* poCompSelectSupervision); 
#ifdef MUTE_ACTIVE
        virtual tVoid vProcess(trMsgMuteSupervision* poMuteSupervision); 
#endif
        virtual tVoid vProcess(trMsgDrvCmdCompSelect* poDrvCmdCompSelect); 
        virtual tVoid vProcess(trMsgDrvCmdCompSelectFromSrvList* poDrvCmdCompSelect);
        virtual tVoid vProcess(trMsgDrvRspMuteDone *poDrvRspMuteDone);
        virtual tVoid vProcess(trMsgDrvRspCompListScidiMonitor *poScidiMonitor);
        virtual tVoid vProcess(trMeca_RRdmAudioComponentPlay* poMecaRRdmPlayScidi); 
        virtual tVoid vProcess(trMsgDrvCmdChnSelectState *poDrvCmdChnSelectState);
		virtual tVoid vProcess(trMeca_RRdmAudioGetScidi *poRRdmAudioGetScidi);

        tBool vRequestCompMute();

        tBool bSelectionActive() const {return _enCompSelectState!=enCompSelectState_Idle;};

    private:

        trChnListElem rValidateRequest(trMsgDrvCmdCompSelect const *poDrvCmdChnSelect) const;
        tVoid vSendSelectScidi();
        tVoid vPropagateNewScidi();
#ifdef	MUTE_ACTIVE
        tVoid vSetMute();
#endif
        typedef enum {
            enCompSelectState_Idle,
            enCompSelectState_WaitGo,
            enCompSelectState_WaitMute,
            enCompSelectState_Sent
        } tenCompSelectState;
        tVoid vUpdate(tenCompSelectState enCompSelectState, tenChnState enChnState= enChnState_Invalid);
        dabdrv_compSelect(tVoid);
        trMsgDrvCmdCompSelect _activeChnSelect;
        tenCompSelectState _enCompSelectState;
        trChnListElem _rPendingChnListElem;
        tBool _bSupervisionEscalation;
        tenChnState _enChnState;
        DAB_tclTimer _oCompSelectSupervisionTimer;
#ifdef MUTE_ACTIVE
        DAB_tclTimer _oMuteSupervisionTimer;
#endif
		tU16 _u16CurrScidi;
		tBool bChnSelectFlag;
    };

}


#endif
