/************************************************************************
 * FILE:       dabdrv_compInfo.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_compInfo
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "fc_dabtuner_util.h"
#include "dabdrv_main.hpp"
#include "dabdrv_mecaIf.h"
#include "dabdrv_compList.hpp"
#include "dabdrv_compSelect.hpp"

#include "dabdrv_chnInfo.hpp"
#include "dabdrv_chnList.hpp"
#include "dabdrv_compInfo.hpp"
#include "dabdrv_rdm.hpp"
#include "dabdrv_advisory.hpp"
#include "dabdrv_presets.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_COMP 
#include "trcGenProj/Header/dabdrv_compInfo.cpp.trc.h"
#endif

// todo: remove

/* provides information about the currently selected channel.
   - PSID
   - Label
   - Song/Artist (Radio-Text)
   - FrozenListId

todo: save scids for last-mode 
- re-insert rdm-info
- check if scidi and sid are matching
- then save scids
set lsm: if scids!=0: 
- directly go to comp-mode
- select last ensemble (also in last-mode)
- select scids
- in case of failure use last-mode of chn-info (sid)
*/
using namespace DAB;

using namespace DAB;



dabdrv_compInfo::dabdrv_compInfo(tVoid) {
    _rChnInfoProgService.vInvalidate();
}

dabdrv_compInfo::~dabdrv_compInfo(tVoid) {
}    
tVoid dabdrv_compInfo::vInit(tVoid) {


    // subsribe
    vSubscribe<trMsgDrvStartComponent>();
    vSubscribe<trMsgDrvStopComponent>();
    vSubscribe<trMsgDrvCmdSetCompInfoScidi>();
    vSubscribe<trMsgDrvCmdSetChnInfoPsid>();
    vSubscribe<trMsgDrvCmdFrozenCompListStatus>();
    vSubscribe<trMsgDrvRspCompListScidiMonitor>();

    vTraceState();
}
    
tVoid dabdrv_compInfo::vDeInit() {
}


tVoid dabdrv_compInfo::vTraceState() const {
    ETG_TRACE_USR1(("  dabdrv_compInfo STATE:_rPreselectCompInfofollow"));
    _rPreselectCompInfo.vTrace();
    ETG_TRACE_USR1(("  dabdrv_compInfo STATE END"));
}

tVoid dabdrv_compInfo::vProcess(trMsgDrvStartComponent* poStart) {
    (tVoid)poStart;   
}

tVoid dabdrv_compInfo::vProcess(trMsgDrvStopComponent* poStop) {
    (tVoid)poStop;
}



void dabdrv_compInfo::vProcess(trMsgDrvCmdCompChangeFailed *poCompChangeFailed) {
    ETG_TRACE_USR1(("dabdrv_compInfo::vProcess(trMsgDrvCmdCompChangeFailed)"));
    (tVoid)poCompChangeFailed;
    // todo: pre-information becomes invalid, change to rdm-info:
    
}

tVoid dabdrv_compInfo::vProcess(trMsgDrvCmdSetCompInfoScidi *poSetScidi) {
	ETG_TRACE_USR1(("dabdrv_compInfo::vProcess(trMsgDrvCmdSetCompInfoScidi) poSetScidi->rMecaId=0x%0x poSetScidi->u16Scids=%d _rPreselectCompInfo.rMecaId==0x%0x",
		poSetScidi->rMecaId._u32Id, poSetScidi->u16Scids, _rPreselectCompInfo.rMecaId._u32Id));
    //    trChnListChnInfo rCompInfo=dabdrv_compList::instance()->rGetCompInfo(poSetScidi->rMecaId);
    // take comp-info from list if available or if scidi has changed
    if (/* rCompInfo.rMecaId.bIsValid() || */ poSetScidi->rMecaId != _rPreselectCompInfo.rMecaId) {
		if(poSetScidi->bPSFlag)
			_rPreselectCompInfo=dabdrv_compList::instance()->rGetCompInfo(poSetScidi->rMecaId);
		else{
				trChnListKey rChnListKey(poSetScidi->rMecaId,poSetScidi->u16Scids);
				dabdrv_chnInfo::instance()->vSetCurMecaId(rChnListKey);
				//_rCurMecaId=rMecaId;
				trChnListChnInfo rNewChnInfo=dabdrv_chnList::instance()->rGetChnInfo(poSetScidi->rMecaId,poSetScidi->u16Scids);
				if (rNewChnInfo.rMecaId.u32GetSID()) {
					 _rPreselectCompInfo=rNewChnInfo;
					 dabdrv_chnInfo::instance()->vSetPreselectChnInfo(_rPreselectCompInfo);

					/*trMecaProgrammeService rProgService(poSetScidi->rMecaId._u32Id,poSetScidi->rMecaId._enServiceType,poSetScidi->u16Scids);
					trMsgDrvCmdSetChnInfoPsid rDrvCmdSetChnInfoPsid(rProgService);
					DAB_vCallMsg(rDrvCmdSetChnInfoPsid);*/
				}
			}
    }
		ETG_TRACE_USR1(("dabdrv_compInfo::vProcess(trMsgDrvCmdSetCompInfoScidi) _rPreselectChnInfo.rMecaId._u32Id=0x%0x",
			_rPreselectCompInfo.rMecaId._u32Id));

	ETG_TRACE_USR1(("dabdrv_compInfo::vProcess(trMsgDrvCmdSetCompInfoScidi)dabdrv_main::instance()->bIsCompMode()=%d",
					 dabdrv_main::instance()->bIsCompMode()));

	/*In PSA , when a component is selected, primary service label is also needed */
    DAB_trServiceInfoProperty _rServiceInfo=dabdrv_properties::instance()->oServiceInfoProperty.oGet();
    trChnListChnInfo oChnInfo = dabdrv_chnList::instance()->rGetChnInfo(poSetScidi->rMecaId);
    _rServiceInfo.rProgService._u32Id = oChnInfo.rMecaId._u32Id;
	_rServiceInfo.u8PtyCode = oChnInfo.u8PTY;
	_rServiceInfo.u16ServiceIndex = dabdrv_chnList::instance()->u16GetFrozenListId(oChnInfo.rMecaId);
	_rServiceInfo.bLabelPresent = oChnInfo.bLabelPresent;
	_rServiceInfo.rLabel = oChnInfo.rLabel;
	_rServiceInfo.u16AvailableAnnoTypesMask = oChnInfo.u16AvailableAnnoTypesMask;
	_rServiceInfo.u8PresetNumber = oChnInfo.u8PresetNumber;
    _rServiceInfo.vTrace();
    dabdrv_properties::instance()->oServiceInfoProperty.vSet(_rServiceInfo);
	
    if (dabdrv_main::instance()->bIsCompMode()) {
        DAB_trChnInfoProperty rProperty =dabdrv_properties::instance()->oChnInfoProperty.oGet();
        rProperty.rMecaId =_rPreselectCompInfo.rMecaId;
        rProperty.bLabelPresent =_rPreselectCompInfo.bLabelPresent;
        rProperty.rLabel =_rPreselectCompInfo.rLabel;
        rProperty.u8Scids = (tU8)(_rPreselectCompInfo.u16Scids);
        rProperty.u16FrozenListId=_rPreselectCompInfo.u16FrozenListId;
        rProperty.bComponentMode=TRUE;
        rProperty.bFmServiceFollowActive=FALSE;
        rProperty.u8PresetNumber=dabdrv_presets::instance()->u8GetPresetNumber(_rPreselectCompInfo.rMecaId,(tU8)(_rPreselectCompInfo.u16Scids));
        rProperty.rRadioText=trRadioText();

		ETG_TRACE_USR1(("dabdrv_compInfo::vProcess(trMsgDrvCmdSetCompInfoScidi) poSetScidi->rMecaId=0x%0x _rPreselectCompInfo.rLabel is",
			poSetScidi->rMecaId._u32Id));
		_rPreselectCompInfo.rLabel.vTrace();

        dabdrv_properties::instance()->oChnInfoProperty.vSet(rProperty);
    }

    
    /*
      set pre-psid
      add info from db
      update property
    */
}

tVoid dabdrv_compInfo::vProcess(trMsgDrvCmdSetChnInfoPsid *poSetPsid) {
    ETG_TRACE_USR1(("dabdrv_compInfo::vProcess(trMsgDrvCmdSetChnInfoPsid)"));
    // there is a psid-change, we have to wait for scidi of primary service

	if (_rChnInfoProgService !=poSetPsid->rProgService) {
        _rChnInfoProgService=poSetPsid->rProgService;
        _rPreselectCompInfo=trChnListChnInfo();
    }

    
    /*
      set pre-psid
      add info from db
      update property
    */
}



tVoid dabdrv_compInfo::vProcess(trMsgDrvRspCompListScidiMonitor *poMonitor) {
    if (!dabdrv_main::instance()->bIsCompMode()) {
        return;
    }
    if (poMonitor->bNew) {
        tU16 u16Scidi= poMonitor->rMecaId.u16GetScidi();
        ETG_TRACE_USR1(("dabdrv_compSelect::trMsgDrvCmdCompListScidiMonitor u16Scidi=0x%04x",
                        u16Scidi));
        trMsgDrvCmdCompSelect oCompSelect;
        oCompSelect.enChnSelectSource=enChnSelectSource_Lsm;
        oCompSelect.enChnSelectMode= enChnSelectMode_Psid;
        oCompSelect.u32Value=u16Scidi;
        DAB_vCallMsg(oCompSelect);
    } else if (poMonitor->bLost){
        // the component is no longer available.
        DAB_vCallMsgCtor(trMsgDrvIndCompModeFailed());
    } else {
        // do nothing
       }
    
}


tVoid dabdrv_compInfo::vProcess(DAB::trMsgDrvCmdFrozenCompListStatus *poFrozenCompListStatus) {
    ETG_TRACE_USR1(("dabdrv_compInfo::vProcess(trMsgDrvCmdFrozenCompListStatus)"));
    tU16 u16OldId=_rPreselectCompInfo.u16FrozenListId;
    if (poFrozenCompListStatus->bOpen) {
        _rPreselectCompInfo.u16FrozenListId=dabdrv_compList::instance()->u16GetFrozenListId(_rPreselectCompInfo.rMecaId.rGetProgService());
    } else {
        _rPreselectCompInfo.u16FrozenListId=0;
    }

    if (dabdrv_main::instance()->bIsCompMode()) {
        if (u16OldId != _rPreselectCompInfo.u16FrozenListId) {
            DAB_trChnInfoProperty rProperty= dabdrv_properties::instance()->oChnInfoProperty.oGet();
            rProperty.u16FrozenListId=_rPreselectCompInfo.u16FrozenListId;
            dabdrv_properties::instance()->oChnInfoProperty.vSet(rProperty);
        }
    }
}




tU8 dabdrv_compInfo::u8GetSubChannelId() const {
    return _rPreselectCompInfo.rMecaId.u8GetSubChannel();
}


trChnListChnInfo const &dabdrv_compInfo::rGetCompInfo() const {
    return _rPreselectCompInfo;
};

tVoid dabdrv_compInfo::vGetUserData(trCompInfoUsrData *prCompInfoUsrData) const {
    prCompInfoUsrData->rSid=_rChnInfoProgService;
    prCompInfoUsrData->rScidi=_rPreselectCompInfo.rMecaId;
    prCompInfoUsrData->bLabelPresent=_rPreselectCompInfo.bLabelPresent;
    prCompInfoUsrData->rLabel=_rPreselectCompInfo.rLabel;
}

tVoid dabdrv_compInfo::vSetUserData(trCompInfoUsrData const &rCompInfoUsrData) {
    _rChnInfoProgService=trMecaProgrammeService(rCompInfoUsrData.rSid.rGetProgService());
    _rPreselectCompInfo= trChnListChnInfo(); 
    _rPreselectCompInfo.rMecaId=rCompInfoUsrData.rScidi;
    _rPreselectCompInfo.bLabelPresent=rCompInfoUsrData.bLabelPresent;
    _rPreselectCompInfo.rLabel=rCompInfoUsrData.rLabel;
}

