/************************************************************************
 * FILE:       dabdrv_chnInfo.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_chnInfo
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/


#ifndef DABDRV_CHN_INFO_HPP
#define DABDRV_CHN_INFO_HPP

#include "fc_dabtuner_config.h"
#include "dabdrv_meca.h"
#include "dabmeca_db.hpp"
#include "dabmeca_rdm.hpp"
#include "dabdrv_tsu.hpp"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_SRV 
#include "trcGenProj/Header/dabdrv_chnInfo.hpp.trc.h"
#endif
using namespace std;

namespace DAB {

struct stRadioLogo
{
  tU8 u8CountryCode;
  tU32 u32PI;
  string sRadioLogo;
};
struct logostr{
	logostr(tU8 ecc ,string str):
	u8ECC(ecc),
	sPath(str)
	{
	}
	tU8 u8ECC;
	string sPath;
};

typedef map<unsigned int,logostr  > MapPICode_StationLogoFileName;
#define DABLOGO_PATH "/var/opt/bosch/static/tuner/fmlogo/"

    struct trChnInfoUsrData {
        trMecaId rMecaId;
        tBool bLabelPresent;
        trMecaLabel rLabel;
		trMecaEnsemble rEnsemble;
		tU8 u8Scids;

        trChnInfoUsrData():
        bLabelPresent(FALSE),
        u8Scids(0)
        {}

        // persistant data serialization
        tVoid vSerialize(DAB_Serializer &rSerializer) const {
            rSerializer.vSerialize(rMecaId);
            rSerializer.vSerialize(bLabelPresent);
            rSerializer.vSerialize(rLabel);
			rSerializer.vSerialize(rEnsemble);
		rSerializer.vSerialize(u8Scids);
        }
            
        tVoid vParse(DAB_Parser &rParser) {
            if (rParser.u8GetVerMin()>=2) {
                rParser.vParse(rMecaId);
                rParser.vParse(bLabelPresent);
                rParser.vParse(rLabel);
				rParser.vParse(rEnsemble);
			rParser.vParse(u8Scids);
            }
        }

        tVoid vTrace() {
            ETG_TRACE_USR4(("  trChnInfoUsrData:rMecaId=0x%08x bLabelPresent=%d rEnsemble=0x%08x  slabel:%s",
                            rMecaId.u32GetSID(),
                            bLabelPresent,
							rEnsemble.u16GetEID(),
                            rLabel.pcGetCString()));
        }
    };

 
    struct trMsgDrvCmdSetChnInfoPsid:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        trMsgDrvCmdSetChnInfoPsid() {
            rProgService.vInvalidate();
        }
        trMsgDrvCmdSetChnInfoPsid(trMecaProgrammeService const &_rProgService) {
            rProgService = _rProgService;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgDrvCmdSetChnInfoPsid:sid=%x",
                                rProgService.u32GetSID()));
        }

        trMecaProgrammeService rProgService;
    };


	 struct trMsgDrvCmdSetEnsembleId:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        trMsgDrvCmdSetEnsembleId() {
            rEnsemble.vInvalidate();
        }
        trMsgDrvCmdSetEnsembleId(trMecaEnsemble const &_rEnsemble) {
            rEnsemble = _rEnsemble;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgDrvCmdSetEnsembleId:eid=%x",
                                rEnsemble.u16GetEID()));
        }

        trMecaEnsemble rEnsemble;
    };

    class dabdrv_chnInfo:
        public DAB_Singleton <dabdrv_chnInfo>,
        public DAB_MessageHandlerCommon<dabdrv_chnInfo>
    {
        friend class DAB_Singleton<dabdrv_chnInfo>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_SRV);

        virtual ~dabdrv_chnInfo(tVoid);    
        virtual tVoid vInit();
        virtual tVoid vDeInit();

        virtual char const *pcGetName() const {return "dabdrv_chnInfo";};
        virtual tVoid vTraceState() const;

        virtual tVoid vProcess(trMsgDrvStartComponent* poStart);

        virtual tVoid vProcess(trMsgDrvCmdSourceState* poSourceState);

        virtual tVoid vProcess(trMsgDrvCmdSetChnInfoPsid* poSetPsid);

		virtual tVoid vProcess(trMsgDrvCmdSetEnsembleId* poSetEid);

        virtual tVoid vProcess(trMsgDrvRspChnListCurrentSrvChanged *poCurrentSrvChanged);

        virtual tVoid vProcess(trMsgDrvIndRadioText *poDrvIndRadioText);

        virtual tVoid vProcess(trMsgDrvIndRadioTextPlus *poDrvIndRadioTextPlus);

        virtual tVoid vProcess(trMsgDrvIndNumComponentsOfSrv *poDrvIndNumComp);

        virtual tVoid vProcess(trMsgDrvCmdFrozenChnListStatus *poFrozenChnListStatus);
		
		virtual tVoid vProcess(trMsgDrvCmdFrozenEnsListStatus *poFrozenEnsListStatus);

        virtual tVoid vProcess(DAB_trChnStateProperty *poChnStateProperty);

		virtual tVoid vProcess(trMsgSrvCmdScan *poSrvCmndScan);
        tenMeca_RdmSignalQualityIndicator u8GetSignalQuality() const;

        trChnListChnInfo const &rGetChnInfo() const;
        trMecaId rGetCurrentSid() const;

		trEnsListElemInfo const &rGetCurrEnsembleInfo() const;

		trMecaEnsemble const &rGetCurrEnsemble() const;

        tVoid vGetUserData(trChnInfoUsrData *prChnInfoUsrData) const;
        tVoid vSetUserData(trChnInfoUsrData const &rChnInfoUsrData);
		tBool bUpdateProperty(trChnListKey const &rChnListKey, tBool bClear,tBool bChnStateUnavail=0);
		tVoid vSetCurMecaId(trChnListKey &rChnListKey) {_rChnListKey=rChnListKey;} ;
		tVoid vSetPreselectChnInfo(trChnListChnInfo &rPreselectChnInfo) {_rPreselectChnInfo=rPreselectChnInfo;} ;
		tVoid vUpdateActivatedElemId(tU16 u16FrozenListId) {_rPreselectChnInfo.u16FrozenListId=u16FrozenListId;} ;
        void vGetStationLogoFilePath(tU8 u8ECC, unsigned int u32PICode,string& sLogoPath,tBool bRequireSmallLogo);
		tU32 u32GetLastTunedFrequency() {return  u32LastTunedFrequency;};
		
		trChnListChnInfo vGetPreselectChnInfo()
        {return _rPreselectChnInfo;}

		tBool bGetFactoryResetStatus()
		{return _bFactoryReset;}

		tVoid vSetFactoryResetStatus(tBool bFactoryReset)
		{
			_bFactoryReset = bFactoryReset;
		}
		
		tBool bCompareIdLabel(tU32 u32Id, tChar const *label); //CRQ 431566

    private:

        dabdrv_chnInfo(tVoid);
        tenChnState enGetChnStateForProperty() const;
		
        trChnListChnInfo _rPreselectChnInfo; // todo rename by removing Preselect
        tenChnState _enChnState;
        trChnListKey _rChnListKey;

		trEnsListElemInfo _rCurrEnsembleInfo;
		MapPICode_StationLogoFileName m_oPICode_StationLogoFileName;
		tU32 u32LastTunedFrequency;
		tBool _bFactoryReset;
		tBool _bIsFirstUpdate; //CRQ 431566
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	 tBool bRadioLogosExists;
	 tBool bRadioLogo_FOTA_Exists;
	 tBool bCheckLogoPaths;
	 tU8 m_u8DefaultLogoPathAvail;
	 void vUpdateLargeLogoPath(string logopath , string& sLogoPath);
	 void vUpdateSmallLogoPath(string logopath , string& sLogoPath);
	 void vCheckRadioLogosExist(tBool bCheckFOTALogo = FALSE);
#endif

    };

}

#endif
