/************************************************************************
 * FILE:       dabdrv_chnInfo.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_chnInfo
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "fc_dabtuner_util.h"
#include "dabdrv_main.hpp"
#include "dabdrv_mecaIf.h"
#include "dabdrv_chnList.hpp"
#include "dabdrv_compList.hpp"
#include "dabdrv_chnInfo.hpp"
#include "dabdrv_rdm.hpp"
#include "dabdrv_presets.hpp"
#include "dabdrv_advisory.hpp"
#include "dirent.h"

#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_SRV
#include "trcGenProj/Header/dabdrv_chnInfo.cpp.trc.h"
#endif

#define RADIOLOGO_PATH "/var/opt/bosch/static/tuner/RadioLogo/"
#define RADIOLOGO_FOTA_PATH "/var/opt/bosch/persistent/swupdate/activations/ivi_rdl_application/"

#define RADIOLOGO_SIZE_LARGE "_L.png"
#define RADIOLOGO_SIZE_SMALL "_S.png"

#define RADIOLOGO_FOTA_PATH_LARGE 		RADIOLOGO_FOTA_PATH + logopath + RADIOLOGO_SIZE_LARGE
#define RADIOLOGO_STATIC_PATH_LARGE		RADIOLOGO_PATH + logopath + RADIOLOGO_SIZE_LARGE
#define RADIOLOGO_FOTA_PATH_SMALL 		RADIOLOGO_FOTA_PATH + logopath + RADIOLOGO_SIZE_SMALL
#define RADIOLOGO_STATIC_PATH_SMALL		RADIOLOGO_PATH + logopath + RADIOLOGO_SIZE_SMALL

#define RADIOLOGO_FOTA_DEF_PATH_LARGE		RADIOLOGO_FOTA_PATH + sLargeDefaultLogo
#define RADIOLOGO_STATIC_DEF_PATH_LARGE		RADIOLOGO_PATH + sLargeDefaultLogo
#define RADIOLOGO_FOTA_DEF_PATH_SMALL		RADIOLOGO_FOTA_PATH + sSmallDefaultLogo
#define RADIOLOGO_STATIC_DEF_PATH_SMALL		RADIOLOGO_PATH + sSmallDefaultLogo

#define RADIOLOGO_LARGE_FOTA_DEF 0X01
#define RADIOLOGO_LARGE_DEF 0X02
#define RADIOLOGO_SMALL_FOTA_DEF 0X04
#define RADIOLOGO_SMALL_DEF 0X08


// todo: remove

/* provides information about the currently selected channel.
   - PSID
   - Label
   - Song/Artist (Radio-Text)
   - FrozenListId
*/

/*
  todo: add timer-handling also to comp-info
*/
using namespace DAB;

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
static const stRadioLogo aRadioLogo[] =
{
   #define Radio_Logo(u8CountryCode, u32PI, sRadioLogo)                  { u8CountryCode, u32PI, sRadioLogo},
   #include "../fc_tmctuner/TunerApp/RadioLogo.dat"
   #undef Radio_Logo
};
#endif

dabdrv_chnInfo::dabdrv_chnInfo(tVoid) {
    _enChnState=enChnState_Invalid;
	u32LastTunedFrequency=0;
	_bFactoryReset = FALSE;
	_bIsFirstUpdate = FALSE;

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	bRadioLogosExists = FALSE;
	bRadioLogo_FOTA_Exists = FALSE;
	m_u8DefaultLogoPathAvail = 0;
	bCheckLogoPaths = TRUE;
#endif

}

dabdrv_chnInfo::~dabdrv_chnInfo(tVoid) {

}    
tVoid dabdrv_chnInfo::vInit(tVoid) {

    // subsribe
    vSubscribe<trMsgDrvStartComponent>();
    vSubscribe<trMsgDrvCmdSourceState>();
    vSubscribe<trMsgDrvCmdSetChnInfoPsid>();
	vSubscribe<trMsgDrvCmdSetEnsembleId>();
    //vSubscribe<trMsgDrvCmdFrozenChnListStatus>();
	vSubscribe<trMsgDrvCmdFrozenEnsListStatus>();
    vSubscribe<trMsgDrvRspChnListCurrentSrvChanged>();
    vSubscribe<trMsgDrvIndRadioText>();
    vSubscribe<trMsgDrvIndRadioTextPlus>();
    vSubscribe<trMsgDrvIndNumComponentsOfSrv>();
    vSubscribe<DAB_trChnStateProperty>();
	vSubscribe<trMsgSrvCmdScan>();

	#include "../fc_tmctuner/TunerApp/FMStationLogo.dat"

    vTraceState();
}

tVoid dabdrv_chnInfo::vDeInit() {
}


tVoid dabdrv_chnInfo::vTraceState() const {
    static tU32 _u32NumCalls=0;
    _u32NumCalls++;
    tU32 u32NumCalls=_u32NumCalls;

    ETG_TRACE_USR1(("  dabdrv_chnInfo STATE(u32NumCalls=%d): _rPreselectChnInfo follow",
                    u32NumCalls));
    _rPreselectChnInfo.vTrace();
    ETG_TRACE_USR1(("  dabdrv_chnInfo(u32NumCalls=%d) STATE END",
                    u32NumCalls));
}

tVoid dabdrv_chnInfo::vProcess(trMsgDrvStartComponent* poStart) {
    (tVoid)poStart;   
}



tVoid dabdrv_chnInfo::vProcess(trMsgDrvCmdSourceState *poSourceState) {
    (tVoid)poSourceState;
    ETG_TRACE_USR4(("dabdrv_chnInfo::trMsgDrvCmdSourceState"));
    //NCG3D-149882 : Update property only when DAB source is in FG
    if(dabdrv_main::instance()->enGetSourceState()!=DAB_enSourceState_BG || dabdrv_main::instance()->enGetSourceState()!=DAB_enSourceState_FG_ANNO_SURVEILLANCE|| dabdrv_main::instance()->enGetSourceState()!=DAB_enSourceState_DAB_LEARN_FOREVER)
    {
        bUpdateProperty(_rChnListKey ,FALSE);
    }
}




tVoid dabdrv_chnInfo::vProcess(DAB_trChnStateProperty *poChnStateProperty) {
    DAB_trChnInfoProperty rProperty=dabdrv_properties::instance()->oChnInfoProperty.oGet();
    rProperty.enChnState =poChnStateProperty->enChnState;
    rProperty.bMuted =poChnStateProperty->bMuted;
	/*if(poChnStateProperty->enChnState == enChnState_Unavail)
		rProperty.u16AvailableAnnoTypesMask=0x00;
	else*/
		rProperty.u16AvailableAnnoTypesMask=_rPreselectChnInfo.u16AvailableAnnoTypesMask;

    dabdrv_properties::instance()->oChnInfoProperty.vSet(rProperty);
}

//currently bChnStateUnavail will be set only incase of a preset is recalled from BG.
//we have to make channel state as unavailable till the bsync=1 is received from rdminfo.
//otherwise some flickering between channel Info and search can be seen in PSA.
tBool dabdrv_chnInfo::bUpdateProperty(trChnListKey const &rChnListKey, tBool bClear, tBool bChnStateUnavail) {
    ETG_TRACE_USR4(("dabdrv_chnInfo::vUpdateProperty sid=0x%08x _u16Scids=%d bClear=%d",
		rChnListKey._rMecaId.u32GetSID(),rChnListKey._u16Scids, bClear));
	_rPreselectChnInfo.vTrace();

	//If vUpdateProperty is called from vProcess(trMeca_RRdmAudioGetAsid *poRRdmAudioGetAsid), then check if we played a secondary component
	//If secondary component was played, then dont take any action and just return
	 ETG_TRACE_USR4(("dabdrv_chnInfo::vUpdateProperty _bServiceChanged %d dabdrv_main::instance()->bIsCompMode() %d",dabdrv_rdm::instance()->bGetServiceChangedInfo(),
		 dabdrv_main::instance()->bIsCompMode()));

#ifndef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
	if(dabdrv_rdm::instance()->bGetServiceChangedInfo() && dabdrv_main::instance()->bIsCompMode()){
		dabdrv_rdm::instance()->bSetServiceChangedInfo(FALSE);
		return FALSE;
	}
	else
#endif
	{
		dabdrv_rdm::instance()->bSetServiceChangedInfo(FALSE);
	}
	tBool bUpdateSuccess=FALSE;
    _rChnListKey=rChnListKey;

    //_rPreselectChnInfo should never becomes zero if it becomes zero, then just return
	DAB_trChnInfoProperty rProperty;
    trChnListChnInfo NewChnInfo = dabdrv_chnList::instance()->rGetChnInfo(rChnListKey._rMecaId,rChnListKey._u16Scids);
    NewChnInfo.vTrace();
    if(NewChnInfo.rMecaId.bIsValid() || (bGetFactoryResetStatus() == TRUE))
	{
		 DAB_trTunerStatusProperty rTunerStatusProperty=dabdrv_properties::instance()->oTunerStatusProperty.oGet();
		u32LastTunedFrequency  = rTunerStatusProperty.u32Frequency;
		_rPreselectChnInfo = NewChnInfo;
		_rPreselectChnInfo.vTrace();
		bUpdateSuccess=TRUE;
	}
	else if(dabdrv_main::instance()->bGetSrcFlag()) //NCG3D-82174
	{
		rProperty.bLabelPresent =_rPreselectChnInfo.bLabelPresent;
		rProperty.rLabel =_rPreselectChnInfo.rLabel;
		rProperty.u16FrozenListId=_rPreselectChnInfo.u16FrozenListId;
		dabdrv_main::instance()->vSetSrcFlag(FALSE);
	}

    //if (dabdrv_main::instance()->bIsCompMode()) {
       // return;
    //}
		DAB_trEnsembleInfoProperty rEnsembleProperty=dabdrv_properties::instance()->oEnsembleInfoProperty.oGet();
		if(!rChnListKey._rMecaId.u32GetSID()){
		//Clear ensemble label
		rEnsembleProperty.rEnsembleLabel.bLabelValid = FALSE;
		dabdrv_properties::instance()->oEnsembleInfoProperty.vSet(rEnsembleProperty);
	}
		else
		{
			trMecaLabel rCurrentEnsembleLabel = dabdrv_chnList::instance()->vGetEnsembleinfofromid(rChnListKey._rMecaId);
			rEnsembleProperty.rEnsembleLabel = rCurrentEnsembleLabel;
			dabdrv_properties::instance()->oEnsembleInfoProperty.vSet(rEnsembleProperty);
		}

    
    if (bClear) {
        DAB_trChnStateProperty rChnStateProperty=dabdrv_properties::instance()->oChnStateProperty.oGet();
        rProperty.enChnState= (bUpdateSuccess && !bChnStateUnavail) ? rChnStateProperty.enChnState : enChnState_Unavail;
        rProperty.bMuted=rChnStateProperty.bMuted;
        rProperty.rRadioText.bValid = FALSE;
		for(tU8 u8Loop = 0; u8Loop < 127; u8Loop++)
		rProperty.rRadioText.sRadioText[u8Loop] = '\0';
    } else {
        rProperty=dabdrv_properties::instance()->oChnInfoProperty.oGet();
    }

    if (!_rPreselectChnInfo.rMecaId.u32GetSID()) {
		//PSARCC30-2064
    	//_rPreselectChnInfo.rMecaId = rChnListKey._rMecaId;
    	//_rPreselectChnInfo.u16Scids = rChnListKey._u16Scids;
    	_rPreselectChnInfo.bPSFlag = (!rChnListKey._u16Scids);
    	rProperty.enChnState=enChnState_Unavail;
    }

    rProperty.rMecaId =rChnListKey._rMecaId;
    rProperty.u8Scids = (tU8)(rChnListKey._u16Scids);
    //Always update the logo from latest channel info
    //incase SID is received in RdmInfo and not updated in Servicelist
    //then there is posibilty of updating old logo.
	rProperty.sLogoLink = dabdrv_chnList::instance()->sGetLogoLink(rChnListKey._rMecaId._u32Id);
	tU16 u16AnnoTypesMask=_rPreselectChnInfo.u16AvailableAnnoTypesMask;

	 //in case SID is received in RdmInfo and not updated in Servicelist
	 //Then old channel Label may go and mean while label will be update from RDbServiceInfo
	//That value will be over written here.
		if (bUpdateSuccess){
			//CRQ 431566
			if (_bIsFirstUpdate && (bCompareIdLabel(_rPreselectChnInfo.rMecaId._u32Id, _rPreselectChnInfo.rLabel.oUtf8Label.pcGetCString()))){
				ETG_TRACE_USR4(("dabdrv_chnInfo::vUpdateProperty empty label"));
				trMecaLabel emptyLabel;
				emptyLabel.bLabelValid = TRUE;
				rProperty.rLabel = emptyLabel;
			}
			else {
				rProperty.bLabelPresent = _rPreselectChnInfo.bLabelPresent;
				rProperty.rLabel = _rPreselectChnInfo.rLabel;
				rProperty.u16FrozenListId = _rPreselectChnInfo.u16FrozenListId;
			}
	}else{
		rProperty.u16FrozenListId=0;
	}

	if(_rPreselectChnInfo.bPSFlag)
		rProperty.bComponentMode=FALSE;
	else
		rProperty.bComponentMode=TRUE;
    if (rProperty.bFmServiceFollowActive) {
        rProperty.u8NumberOfAudioComponents=0;
    } else {
        rProperty.u8NumberOfAudioComponents=dabdrv_compList::instance()->u8GetNumComponents(_rPreselectChnInfo.rMecaId);
    }

		if (_bIsFirstUpdate && (bCompareIdLabel(_rPreselectChnInfo.rMecaId._u32Id, _rPreselectChnInfo.rLabel.oUtf8Label.pcGetCString()))) {
			rProperty.u8PresetNumber = 0;
			ETG_TRACE_USR4(("dabdrv_chnInfo::vUpdateProperty  rProperty.u8PresetNumber=%d",
				rProperty.u8PresetNumber));
		}
		else {
			rProperty.u8PresetNumber = dabdrv_presets::instance()->u8GetPresetNumber(_rPreselectChnInfo.rMecaId, (tU8)(_rPreselectChnInfo.u16Scids));
			ETG_TRACE_USR4(("dabdrv_chnInfo::vUpdateProperty  rProperty.u8PresetNumber=%d",
				rProperty.u8PresetNumber));
		}
		if (rProperty.u8PresetNumber && !rProperty.rLabel.bIsLabelOk()) {
			if (!_bIsFirstUpdate) {
				rProperty.rLabel = dabdrv_presets::instance()->rGetPresetLabel(rProperty.u8PresetNumber);
				_rPreselectChnInfo.rLabel = rProperty.rLabel;
				// take label from preset instead
			}
		}
		_bIsFirstUpdate = FALSE; //CRQ 431566
	if(rProperty.enChnState == enChnState_Unavail)
			rProperty.u16AvailableAnnoTypesMask=0x00;
	else
		rProperty.u16AvailableAnnoTypesMask=_rPreselectChnInfo.u16AvailableAnnoTypesMask;

	ETG_TRACE_USR4(("dabdrv_chnInfo::vUpdateProperty rProperty.u16AvailableAnnoTypesMask=0x%08x",
                    rProperty.u16AvailableAnnoTypesMask));

	rProperty.u8PTY=_rPreselectChnInfo.u8PTY;
    // overwrite property; further information will be added when channel is tuned
    dabdrv_properties::instance()->oChnInfoProperty.vSet(rProperty);
    // todo: check if anno is also valid in comp-mode
    DAB_trAnnoStatusProperty oAnnoStatusProperty = dabdrv_properties::instance()->oAnnoStatusProperty.oGet();
    oAnnoStatusProperty.u16AvailableAnnoTypesMask=u16AnnoTypesMask;
    ETG_TRACE_USR4(("dabdrv_chnInfo::vUpdateProperty u16AnnoTypesMask=0x%08x",
                    u16AnnoTypesMask));

    dabdrv_properties::instance()->oAnnoStatusProperty.vSet(oAnnoStatusProperty);
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI
    if(_rPreselectChnInfo.u16AvailableAnnoTypesMask == 0x06){
    	DAB_trTunerStatusProperty oTunerStatusProperty = dabdrv_properties::instance()->oTunerStatusProperty.oGet();
    	oTunerStatusProperty.enTunerActivityType=DAB_enTunerActivityType_TPMONITOR;
    	dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatusProperty);
    }
#endif
    return bUpdateSuccess;
}

tVoid dabdrv_chnInfo::vProcess(trMsgDrvCmdSetChnInfoPsid *poSetPsid) {
    ETG_TRACE_USR4(("dabdrv_chnInfo::trMsgDrvCmdSetChnInfoPsid sid=0x%08x, scids=%d",
                    poSetPsid->rProgService.u32GetSID(),
					poSetPsid->rProgService._u16Scids));
//In case of default settings store empty data in _rPreselectChannelInfo
	DAB_trChnInfoProperty oChnInfoProperty = dabdrv_properties::instance()->oChnInfoProperty.oGet();
	ETG_TRACE_USR4(("dabdrv_chnInfo::oChnInfoProperty.rMecaId._u32Id=%d poSetPsid->rProgService.u32GetSID()=%d", oChnInfoProperty.rMecaId._u32Id, poSetPsid->rProgService.u32GetSID()));
	if (poSetPsid->rProgService.u32GetSID() != oChnInfoProperty.rMecaId._u32Id) {
		_bIsFirstUpdate = TRUE;
	}//CRQ 431566
	if(TRUE == bGetFactoryResetStatus())
	{
		trMecaProgrammeService rProgService;
		bUpdateProperty(rProgService, TRUE);
		//PSARCC30-3968
		dabdrv_main::instance()->vResetOldChninfo();
		//_bFactoryReset = FALSE;
	}
	else
	{
		bUpdateProperty(poSetPsid->rProgService, TRUE);
	}

	trMsgSrvCmdStorePersData rCmd;
	DAB_vCallMsg(rCmd);

    /*
      set pre-psid
      add info from db
      update property
    */
}

tVoid dabdrv_chnInfo::vProcess(trMsgDrvCmdSetEnsembleId* poSetEid) {
 ETG_TRACE_USR4(("dabdrv_chnInfo::trMsgDrvCmdSetEnsembleId eid=0x%08x",
	 poSetEid->rEnsemble.u16GetEID()));

 _rCurrEnsembleInfo.rEnsembleElem.rEnsemble =  poSetEid->rEnsemble;

}

tVoid dabdrv_chnInfo::vProcess(trMsgDrvRspChnListCurrentSrvChanged *poCurrentSrvChanged) {
	trChnListKey rchnListKey(poCurrentSrvChanged->rMecaId,poCurrentSrvChanged->u8Scids);
	bUpdateProperty(rchnListKey ,FALSE);
}


tVoid dabdrv_chnInfo::vProcess(trMsgDrvIndRadioText *poDrvIndRadioText) {
    DAB_trChnInfoProperty rProperty=dabdrv_properties::instance()->oChnInfoProperty.oGet();
    rProperty.rRadioText=poDrvIndRadioText->rRadioText;
    if(dabdrv_main::instance()->enGetSourceState() == DAB_enSourceState_FG){
    //Update the Service follow active status.
    rProperty.bFmServiceFollowActive = dabdrv_tsu::instance()->bIsSrvFollowActive();
    }else{ //Don't send if DAB is in BG.
    	 rProperty.bFmServiceFollowActive = 0;
    }
    dabdrv_properties::instance()->oChnInfoProperty.vSet(rProperty);
}

tVoid dabdrv_chnInfo::vProcess(trMsgDrvIndRadioTextPlus *poDrvIndRadioTextPlus) {
	 if (enChnState_Stable == dabdrv_properties::instance()->oChnStateProperty.oGet().enChnState) {
	        DAB_trChnInfoProperty rProperty=dabdrv_properties::instance()->oChnInfoProperty.oGet();

	        rProperty.vectorRadioTextPlus = poDrvIndRadioTextPlus->vRDTextPlus;

	        ETG_TRACE_USR4(("dabdrv_chnInfo::trMsgDrvIndRadioTextPlus NumberOfRTElements=%d",
	        		(tU16)(poDrvIndRadioTextPlus->vRDTextPlus.size())));

	        dabdrv_properties::instance()->oChnInfoProperty.vSet(rProperty);
	 }
}




tVoid dabdrv_chnInfo::vProcess(trMsgDrvIndNumComponentsOfSrv *poDrvIndNumComp) {
    if (poDrvIndNumComp->rMecaId != _rChnListKey._rMecaId) {
        return;
    }
    bUpdateProperty(_rChnListKey ,FALSE);
}



tVoid dabdrv_chnInfo::vProcess(DAB::trMsgDrvCmdFrozenChnListStatus *poFrozenChnListStatus) {
    tU16 u16OldId=_rPreselectChnInfo.u16FrozenListId;
    if (poFrozenChnListStatus->bOpen) {
        ETG_TRACE_USR4(("dabdrv_chnInfo::trMsgDrvCmdFrozenChnListStatus _rPreselectChnInfo.rMecaId.rGetProgService()._u32Id=0x%x _rPreselectChnInfo.rMecaId.rGetProgService()._u16Scids = %d",
			_rPreselectChnInfo.rMecaId.rGetProgService()._u32Id, _rPreselectChnInfo.rMecaId.rGetProgService()._u16Scids));

        _rPreselectChnInfo.u16FrozenListId=dabdrv_chnList::instance()->u16GetFrozenListId(_rPreselectChnInfo.rMecaId.rGetProgService());
    } else {
        _rPreselectChnInfo.u16FrozenListId=0;
    }

    if (!dabdrv_main::instance()->bIsCompMode()) {
        if (u16OldId != _rPreselectChnInfo.u16FrozenListId) {
            DAB_trChnInfoProperty rProperty= dabdrv_properties::instance()->oChnInfoProperty.oGet();
            rProperty.u16FrozenListId=_rPreselectChnInfo.u16FrozenListId;
            dabdrv_properties::instance()->oChnInfoProperty.vSet(rProperty);
        }
    }
}

tVoid dabdrv_chnInfo::vProcess(DAB::trMsgDrvCmdFrozenEnsListStatus *poFrozenEnsListStatus) {
    if (poFrozenEnsListStatus->bOpen) {
		_rCurrEnsembleInfo.u16FrozenListId=dabdrv_chnList::instance()->u16GetFrozenEnsembleListId(_rCurrEnsembleInfo.rEnsembleElem.rEnsemble);
    } else {
        _rCurrEnsembleInfo.u16FrozenListId=0;
    }   
}
tVoid dabdrv_chnInfo::vProcess(trMsgSrvCmdScan *poSrvCmndScan){
	trMeca_CRdmScan rRdmScan;
	rRdmScan.enCmd = poSrvCmndScan->bStartScan?enMeca_RdmScan_START:enMeca_RdmScan_ABORT;
	rRdmScan.u32StartFrequency=0;//current frequency
	//rRdmScan.u8ScanThreshold= DAB_RDM_SCAN_CONFIG_SIGNAL_QUALITY_LEVEL;
	dabdrv_mecaIf::instance()->vSendMecaCommand(rRdmScan);
}
// return the actual signal-quality of the "main" channel.
// if no data are available, enMeca_RdmSignalQualityIndicator_BEST is returned
tenMeca_RdmSignalQualityIndicator dabdrv_chnInfo::u8GetSignalQuality() const {
    // todo
    return enMeca_RdmSignalQualityIndicator_BEST;

}

trChnListChnInfo const &dabdrv_chnInfo::rGetChnInfo() const {
    return _rPreselectChnInfo;
};

trMecaId dabdrv_chnInfo::rGetCurrentSid() const {
    return _rPreselectChnInfo.rMecaId;
};

trEnsListElemInfo const &dabdrv_chnInfo::rGetCurrEnsembleInfo() const {
    return _rCurrEnsembleInfo;
}

trMecaEnsemble const &dabdrv_chnInfo::rGetCurrEnsemble() const
{
	return _rCurrEnsembleInfo.rEnsembleElem.rEnsemble;
}

tVoid dabdrv_chnInfo::vGetUserData(trChnInfoUsrData *prChnInfoUsrData) const {

	//When DAB is in background it might be tuned to some other channel and
	//if the target is shutdown the same channel information might be stored
	//in that case it is relevant to store the old channel information.
	trChnListChnInfo chninInfoFG = _rPreselectChnInfo;
	if(dabdrv_main::instance()->enGetSourceState() != DAB_enSourceState_FG){
		chninInfoFG = dabdrv_main::instance()->getOldChnInfo();
	}

    prChnInfoUsrData->rMecaId=chninInfoFG.rMecaId;
    prChnInfoUsrData->bLabelPresent=chninInfoFG. bLabelPresent;
    prChnInfoUsrData->rLabel=chninInfoFG.rLabel;
	prChnInfoUsrData->rEnsemble=rGetCurrEnsemble();
	prChnInfoUsrData->u8Scids = (tU8)chninInfoFG.u16Scids;
}

tVoid dabdrv_chnInfo::vSetUserData(trChnInfoUsrData const &rChnInfoUsrData) {
    _rPreselectChnInfo= trChnListChnInfo(); 
    _rPreselectChnInfo.rMecaId=rChnInfoUsrData.rMecaId;
    _rPreselectChnInfo.bLabelPresent=rChnInfoUsrData.bLabelPresent;
    _rPreselectChnInfo.rLabel=rChnInfoUsrData.rLabel;
	_rCurrEnsembleInfo.rEnsembleElem.rEnsemble=rChnInfoUsrData.rEnsemble;
	_rPreselectChnInfo.u16Scids = (tU16)rChnInfoUsrData.u8Scids;
	//The preselctChannel info can be assigned to old channel info when read from persistent data
	dabdrv_main::instance()->vsetOldChnInfo(_rPreselectChnInfo);
	ETG_TRACE_USR4(("dabdrv_chnInfo::vSetUserData"));
	_rPreselectChnInfo.vTrace();
}
//CRQ 431566
tBool dabdrv_chnInfo::bCompareIdLabel(tU32 u32Id, tChar const *label)
{
	tChar sId[(DAB_LABEL_MAX_NUM_CHAR*DAB_MAX_UTF8_CHAR_LEN) + 1];
	sprintf(sId, "%x", u32Id);
	tBool _blabelEqualsId = !(strcmp(sId, label));
	return _blabelEqualsId;
}

void dabdrv_chnInfo::vGetStationLogoFilePath(tU8 u8ECC,unsigned int u32PICode,string& sLogoPath,tBool bRequireSmallLogo)
 {
	 
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
	 MapPICode_StationLogoFileName::iterator it;

	 ETG_TRACE_USR2((  " dabdrv_chnInfo::vGetStationLogoFilePath() u32PICode %d size %d",u32PICode,m_oPICode_StationLogoFileName.size()));

	 it = m_oPICode_StationLogoFileName.find(u32PICode);

	 ETG_TRACE_USR2((  " dabdrv_chnInfo::vGetStationLogoFilePath() finding logo path"));

	 if(it != m_oPICode_StationLogoFileName.end())
	 {
		 ETG_TRACE_USR2((  " dabdrv_chnInfo::vGetStationLogoFilePath() logopath %x %x",it->second.u8ECC,u8ECC ));
		 if(it->second.u8ECC == u8ECC ){
		 sLogoPath = DABLOGO_PATH;
			sLogoPath += it->second.sPath;
		 }
		 ETG_TRACE_USR2((  " dabdrv_chnInfo::vGetStationLogoFilePath() logopath %s",sLogoPath.c_str()));

		/** open file and then assign to midwstring*/
		 FILE * fp = fopen(sLogoPath.c_str(), "r");
		if(!fp)
		{
			ETG_TRACE_USR2((  " dabdrv_chnInfo::vGetStationLogoFilePath() fopen fail"));

			sLogoPath.clear();
		}else{
			fclose(fp);
		}
	 }
#else
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	if(bCheckLogoPaths)
	{
		vCheckRadioLogosExist();
		vCheckRadioLogosExist(TRUE);
	}
	if((bRadioLogosExists == TRUE) || (bRadioLogo_FOTA_Exists == TRUE))
	{
		char PIcode[5];
		sprintf(PIcode,"%x",(tU16)u32PICode);
		std::string logopath = (std::string)PIcode;


		char ECCcode[3];
		sprintf(ECCcode,"%x",u8ECC);

		logopath = (std::string)ECCcode + "_" + logopath;

		for(unsigned int i=0 ; i<logopath.size() ; i++)
		{
			logopath.at(i) = (char)std::toupper(logopath.at(i));
		}

		if(bRequireSmallLogo)
		{
			vUpdateSmallLogoPath(logopath , sLogoPath);
		}
		else
		{
			vUpdateLargeLogoPath(logopath , sLogoPath);
		}
	}
#endif
#endif

	ETG_TRACE_USR2((  " dabdrv_chnInfo::vGetStationLogoFilePath() : StationLogoPathLength = %d, bRequireSmallLogo=%d u8ECC=%d u32PICode =%d StationLogoPath = %s",
					  sLogoPath.size(),bRequireSmallLogo,u8ECC,u32PICode,sLogoPath.c_str()));

 }


#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
/**************************************************************************
******************************************************************************/

void dabdrv_chnInfo::vUpdateLargeLogoPath(string logopath, string& sLogoPath)
{
	struct stat sb;
	string sLogo_Path = RADIOLOGO_FOTA_PATH_LARGE;
	if((bRadioLogo_FOTA_Exists) && (stat(sLogo_Path.c_str() , &sb) ==0))
	{
		sLogoPath = RADIOLOGO_FOTA_PATH_LARGE;
		return;
	}
	sLogo_Path = RADIOLOGO_STATIC_PATH_LARGE;
	if((bRadioLogosExists) && (stat(sLogo_Path.c_str() , &sb) ==0))
	{
		sLogoPath = RADIOLOGO_STATIC_PATH_LARGE;
		return;
	}
	if(m_u8DefaultLogoPathAvail & RADIOLOGO_LARGE_FOTA_DEF)
	{
		std::string sLargeDefaultLogo = "EE_FFFF_L.png";
		sLogoPath = RADIOLOGO_FOTA_DEF_PATH_LARGE;
	}
	else if(m_u8DefaultLogoPathAvail & RADIOLOGO_LARGE_DEF)
	{
		std::string sLargeDefaultLogo = "EE_FFFF_L.png";
		sLogoPath = RADIOLOGO_STATIC_DEF_PATH_LARGE;
	}
	else
	{
		// no logo update
	}
}


/**************************************************************************
******************************************************************************/

void dabdrv_chnInfo::vUpdateSmallLogoPath(string logopath , string& sLogoPath)
{
	struct stat sb;
	string sLogo_Path = RADIOLOGO_FOTA_PATH_SMALL;
	if((bRadioLogo_FOTA_Exists) && (stat(sLogo_Path.c_str() , &sb) ==0))
	{
		sLogoPath = RADIOLOGO_FOTA_PATH_SMALL;
		return;
	}
	sLogo_Path = RADIOLOGO_STATIC_PATH_SMALL;
	if((bRadioLogosExists) && (stat(sLogo_Path.c_str() , &sb) ==0))
	{
		sLogoPath = RADIOLOGO_STATIC_PATH_SMALL;
		return;
	}
	sLogo_Path = RADIOLOGO_FOTA_PATH_LARGE;
	if((bRadioLogo_FOTA_Exists) && (stat(sLogo_Path.c_str() , &sb) ==0))
	{
		sLogoPath = RADIOLOGO_FOTA_PATH_LARGE;
		return;
	}
	sLogo_Path = RADIOLOGO_STATIC_PATH_LARGE;
	if((bRadioLogosExists) && (stat(sLogo_Path.c_str() , &sb) ==0))
	{
		sLogoPath = RADIOLOGO_STATIC_PATH_LARGE;
		return;
	}
	if(m_u8DefaultLogoPathAvail & RADIOLOGO_SMALL_FOTA_DEF)
	{
		std::string sSmallDefaultLogo = "EE_FFFF_S.png";
		sLogoPath = RADIOLOGO_FOTA_DEF_PATH_SMALL;
	}
	else if(m_u8DefaultLogoPathAvail & RADIOLOGO_SMALL_DEF)
	{
		std::string sSmallDefaultLogo = "EE_FFFF_S.png";
		sLogoPath = RADIOLOGO_STATIC_DEF_PATH_SMALL;
	}
	else if(m_u8DefaultLogoPathAvail & RADIOLOGO_LARGE_FOTA_DEF)
	{
		std::string sLargeDefaultLogo = "EE_FFFF_L.png";
		sLogoPath = RADIOLOGO_FOTA_DEF_PATH_LARGE;
	}
	else if(m_u8DefaultLogoPathAvail & RADIOLOGO_LARGE_DEF)
	{
		std::string sLargeDefaultLogo = "EE_FFFF_L.png";
		sLogoPath = RADIOLOGO_STATIC_DEF_PATH_LARGE;
	}
	else
	{
		// no logo update
	}
}

/**************************************************************************//**
*
******************************************************************************/
 void dabdrv_chnInfo::vCheckRadioLogosExist(tBool bCheckFOTALogo)
 {
	DIR *RadioLogoDirectory;
	struct dirent *DiretoryDetails;
	tU8 u8count = 0;

	if(bCheckFOTALogo)
	{
		bCheckLogoPaths = FALSE;
		RadioLogoDirectory = opendir(RADIOLOGO_FOTA_PATH);
	}
	else
	{
		RadioLogoDirectory = opendir(RADIOLOGO_PATH);
	}

	if(!RadioLogoDirectory)
	{
		if(bCheckFOTALogo)
		{
			ETG_TRACE_USR2(("vCheckRadioLogosExist(), Radio Logos FOTA directory doesn't exist"));
		}
		else
		{
			ETG_TRACE_USR2(("vCheckRadioLogosExist(), Radio Logos static directory doesn't exist"));
		}
		tInt errsv = errno;
		ETG_TRACE_ERR(("vCheckRadioLogosExist failed with error:%d", errsv));
		ETG_TRACE_ERR(("vCheckRadioLogosExist failed and error msg : %s\n", strerror(errsv)));
		return;
	}
	while( (DiretoryDetails = readdir(RadioLogoDirectory)) != NULL)
	{
		if(++u8count > 2)
		{
			break;
		}
	}

	closedir(RadioLogoDirectory);

	if(u8count <= 2)
	{
		return;
	}
	else
	{
		if(bCheckFOTALogo)
			bRadioLogo_FOTA_Exists = TRUE;
		else
			bRadioLogosExists = TRUE;
	}
	
	ETG_TRACE_USR2(("vCheckRadioLogosExist(), bRadioLogosExists = %d, bRadioLogo_FOTA_Exists = %d",bRadioLogosExists,bRadioLogo_FOTA_Exists));

	struct stat sb;
	string sLargeDefaultLogo = "EE_FFFF_L.png";
	string sSmallDefaultLogo = "EE_FFFF_S.png";

	if(bRadioLogo_FOTA_Exists)
	{
		string sDefaultLogo = RADIOLOGO_FOTA_DEF_PATH_LARGE;
		if(stat(sDefaultLogo.c_str() , &sb) ==0)
		{
			m_u8DefaultLogoPathAvail |= RADIOLOGO_LARGE_FOTA_DEF;
		}
		sDefaultLogo = RADIOLOGO_FOTA_DEF_PATH_SMALL;
		if(stat(sDefaultLogo.c_str() , &sb) ==0)
		{
			m_u8DefaultLogoPathAvail |= RADIOLOGO_SMALL_FOTA_DEF;
		}
	}
	if(bRadioLogosExists)
	{
		string sDefaultLogo = RADIOLOGO_STATIC_DEF_PATH_LARGE;
		if(stat(sDefaultLogo.c_str() , &sb) ==0)
		{
			m_u8DefaultLogoPathAvail |= RADIOLOGO_LARGE_DEF;
		}
		sDefaultLogo = RADIOLOGO_STATIC_DEF_PATH_SMALL;
		if(stat(sDefaultLogo.c_str() , &sb) ==0)
		{
			m_u8DefaultLogoPathAvail |= RADIOLOGO_SMALL_DEF;
		}
	}

	ETG_TRACE_USR2(( " vCheckRadioLogosExist(), m_u8DefaultLogoPathAvail = %d",m_u8DefaultLogoPathAvail));

}
#endif


