/************************************************************************
 * FILE:       dabdrv_anno.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_anno
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DABDRV_ANNO_HPP
#define DABDRV_ANNO_HPP
/*
mirror preset-list of adr3
provide auto-compare by psid

todo: can preset be changed in frozenChnList: no!

*/
#include "fc_dabtuner_util.h"
#include "dabdrv_types.hpp"
#include "dabdrv_main.hpp"
#include "dabdrv_activity.hpp"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_ANNO
#include "trcGenProj/Header/dabdrv_anno.hpp.trc.h"
#endif

namespace DAB {
    struct trMsgAnnoStopSupervisionTimer;
    struct trMsgAnnoFlagTimer;
    struct trMsgDrvRspMuteDone;

class dabdrv_anno:
    public DAB_Singleton<dabdrv_anno>,
    public DAB_MessageHandlerCommon<dabdrv_anno>
{
    friend class DAB_Singleton<dabdrv_anno>;

public:
    DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_ANNO);
    virtual tVoid vInit();
    virtual tVoid vDeInit();
    virtual char const *pcGetName() const {return "dabdrv_anno";};
    virtual tVoid vTraceState() const;

    virtual tVoid vProcess(trMsgDrvStartComponent* poStart);
    virtual tVoid vProcess(trMsgDrvStopComponent* poStart);

    virtual tVoid vProcess(trMsgDrvCmdSourceState *poSourceState);
    virtual tVoid vProcess(trMsgDrvCmdSelectAnno *poSelectAnno);

    virtual tVoid  vProcess(trMsgDrvRspMuteDone *poDrvRspMuteDone);
    virtual tVoid  vProcess(trMsgDrvIndPostChnSelect *poIndPostChnSelect);

    virtual tVoid  vProcess(DAB_trChnInfoProperty const *poChnInfoProperty);



    // commands from server
    virtual tVoid vProcess(trMsgSrvCmdAnnoConfig* poAnnoConfig);
    virtual tVoid vProcess(trMsgSrvCmdStopAnno *poStopAnno);


    // timer
    virtual tVoid vProcess(trMsgAnnoStopSupervisionTimer *poStopSupervisionTimer);
    virtual tVoid vProcess(trMsgAnnoFlagTimer *poFlagTimer);

    // responses from adr3
    virtual tVoid vProcess(trMeca_RAnsAnnoActiveStatus* poRAnsAnnoActiveStatus);
    virtual tVoid vProcess(trMeca_RAnsSelectAnno* poRAnsSelectAnno);
    virtual tVoid vProcess(trMeca_RAnsSetAnnoMode* poRAnsSetAnnoMode);
    //virtual tVoid vProcess(trMeca_RAnsGetAnnoInfo* poRAnsGetAnnoInfo);
	virtual tVoid vProcess(DAB_trChnStateProperty *poChnStateProperty);

    virtual tVoid vProcess(trMeca_RAnsConfigAnno* poRAnsConfigAnno);
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	virtual tVoid vProcess(trMeca_RRdmStationSetUser* povSetUser);

	virtual tVoid vProcess(trMeca_RRdmStationTravelStore* poTravelStore);
	//virtual tVoid vProcess(trMeca_RAnsEnableAnno* poRAnsEnableAnno);
#endif
    tBool bRunActivity();

#ifdef DABTUNER_UTEST
protected:
	dabdrv_anno();
#else 
private:
	dabdrv_anno();
#endif

private:

    tVoid vUpdateAnnoStatusProperty(trMeca_RAnsAnnoActiveStatus const &rAnnoActiveStatus, tBool bChnChanged=FALSE);
	tVoid vUpdateAnnostatusList(trMeca_RAnsAnnoActiveStatus const &rAnnoActiveStatus);
	tVoid vUpdateAnnoStatusPropertyVector(DAB::trAnnoElement const &rAnnoElem, DAB_trAnnoStatusProperty &oAnnoStatusProperty) const;
	tVoid vTraceAnnoStatusList();
    tVoid vSelectAnno(tBool bSelect,tU16 u16AnnoMask =0);
    virtual tVoid vSendConfigAnno();
    tVoid vSendSelectAnno();
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	virtual tVoid vSetAnnoConfigFromDP();
#endif
    trMeca_RAnsAnnoActiveStatus _lastAnnoActiveStatus;
    trMeca_RAnsAnnoActiveStatus _selectedAnnoActiveStatus;
    tenAnnoSelectState _enAnnoSelectState;
    tU16 _u16CfgAnnoTypesMask;
    tenAnnoSource _enCfgValidAnnoSources;
    dabdrv_activity<dabdrv_anno, (int)DAB_enDrvActivity_Anno> _oAnnoActivity;
    DAB_tclTimer _oAnnoStopSuperVisionTimer;
    DAB_tclTimer _oAnnoFlagTimer;

    tenAnnoSource _enActAnnoSource;

    typedef enum {
        enAnnoChnState_New,
        enAnnoChnState_Stable,
        enAnnoChnState_Bad
    } tenAnnoChnState;
    tenAnnoChnState _enAnnoChnState;
    
	map<tU16,trMeca_RAnsAnnoActiveStatus>_mapRAnsAnnoList;

};

}
#endif
