/************************************************************************
 * FILE:       dabdrv_advisory.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_advisory
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DABDRV_ADVISORY_HPP
#define DABDRV_ADVISORY_HPP

#include "fc_dabtuner_config.h"
#include "dabdrv_meca.h"
#include "dabmeca_db.hpp"
#include "dabmeca_rdm.hpp"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_SRV 
#include "trcGenProj/Header/dabdrv_advisory.hpp.trc.h"
#endif

namespace DAB {


    struct dabdrv_msgAdvisoryTimer;
 
    class dabdrv_advisory:
        public DAB_Singleton <dabdrv_advisory>,
        public DAB_MessageHandlerCommon<dabdrv_advisory>
    {
        friend class DAB_Singleton<dabdrv_advisory>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_SRV);

        virtual ~dabdrv_advisory(tVoid);    
        virtual tVoid vInit();
        virtual tVoid vDeInit();

        virtual char const *pcGetName() const {return "dabdrv_advisory";};
        virtual tVoid vTraceState() const;

        virtual tVoid vProcess(trMsgDrvStartComponent* poStart);

        virtual tVoid vProcess(trMsgDrvStopComponent* poStart);

        virtual tVoid vProcess(trMsgDrvCmdSourceState *poSourceState);

        virtual tVoid vProcess(dabdrv_msgAdvisoryTimer *poTimeOutMsg);

        virtual tVoid vProcess(trMsgDrvCmdChnSelectState *poChnSelectState);

        virtual tVoid vProcess(trMsgDrvIndPreChnSelect *poChnSelectIndPre);

        virtual tVoid vProcess(trMeca_RRdmGetRdmInfo const *poRdmInfo);
        virtual tVoid vProcess(trMsgDrvFmServiceFollow* poFmServiceFollow);
        virtual tVoid vProcess(trMeca_RRdmAudioPlayAsid* poMecaRRdmPlayPsid);

		virtual tVoid vProcess(trMeca_RRdmAudioComponentPlay* poMecaRRdmPlayScidi);

        tenMeca_RdmSignalQualityIndicator u8GetSignalQuality() const;

        trMecaId rGetCurrentPsid() const;
        trMecaId rGetCurrentScidi() const;
        trMecaId rGetCurrentMecaId() const;

    private:

        dabdrv_advisory(tVoid);
        tVoid vUpdate() const;

        DAB_tclTimer _oAdvisoryTimer;

        tenChnState _enChnState;
        tenChnState _enLastSentChnState;
        tBool _bChnSelectActive;
        tBool _bCompSelectActive;
        DAB_tenSourceState _enSourceState;
        tBool _bSrvFollow;


        tVoid vStopSv() {
            _oAdvisoryTimer.vStop();
        };

        tBool bIsRdmOk() const;

        tBool bIsSelectActive() const {
            return _bChnSelectActive || _bCompSelectActive;
        };
    
        tVoid vClearAdvisory() {
            _oAdvisoryTimer.vStop();
            _enChnState= enChnState_Stable;
            _bChnSelectActive=FALSE;
            _bCompSelectActive=FALSE;
        };

    };

}

#endif
