/************************************************************************
 * FILE:        dabdrv_activityList.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  header of dabdrv_activityList
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DABDRV_ACTIVITY_LIST_HPP
#define DABDRV_ACTIVITY_LIST_HPP
#include "dabdrv_types.hpp"

/*
  List to store all activities.

*/
namespace DAB {
    //lint -esym(763, DAB::dabdrv_activityBase)  Redundant declaration for symbol
    class dabdrv_activityBase;
    class dabdrv_activityList {

    public:
        // add an activity to our list
        tVoid vAddActivity(dabdrv_activityBase *poActivity);
        // get access to a specific activity
        dabdrv_activityBase *poGetActivity(DAB_tenDrvActivity enActivity);

        /* get state of the activity-list.
           the state is interruptible, if the running activity is interruptible and
           the pending activity has higher priority
        */
        DAB_tenDrvActivityListState enGetState();
        // interrupt the running activity. may only be called if enGetState() returned interruptible
        tBool bInterrupt();
        dabdrv_activityBase *poGetPendingActivity();
    private:
        list<dabdrv_activityBase *>oActivityList;
    };

}
#endif
