/************************************************************************
 * FILE:        dabdrv_activityList.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_activityList
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "dabdrv_types.hpp"
#include "dabdrv_activity.hpp"
#include "dabdrv_activityList.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_MAIN 
#include "trcGenProj/Header/dabdrv_activityList.cpp.trc.h"
#endif

namespace DAB {
    tVoid dabdrv_activityList::vAddActivity(dabdrv_activityBase *poActivity) {
        if (OSAL_NULL == poActivity) {
            return;
        }
        DAB_tenDrvActivity enActivity = poActivity->enGetActivity();
        ETG_TRACE_USR4(("dabdrv_activityList::vAddActivity(%d)",
                        ETG_CENUM(DAB_tenDrvActivity, enActivity)));
        if (OSAL_NULL == poGetActivity(enActivity)) {
            oActivityList.push_back(poActivity);
        }
    }

    dabdrv_activityBase * dabdrv_activityList::poGetActivity(DAB_tenDrvActivity enActivity) {
        DAB_FOREACH(list<dabdrv_activityBase *>, iter, oActivityList) {
            if ((*iter)->enGetActivity()==enActivity) {
                return *iter;
            }
        }
        return OSAL_NULL;
    }

    DAB_tenDrvActivityListState dabdrv_activityList::enGetState() {
        DAB_tenDrvActivityListState enResState = DAB_enDrvActivityListState_Idle;
        DAB_tenDrvActivity enResActivity=DAB_enDrvActivity_Idle;
        tenActivityPrio enPendingPrio=enActivityPrio_Invalid;
        tenActivityPrio enInterruptiblePrio=enActivityPrio_Invalid;
        DAB_FOREACH(list<dabdrv_activityBase *>, iter, oActivityList) {
            DAB_tenDrvActivityListState enState=DAB_enDrvActivityListState_Idle;
            DAB_tenDrvActivity enActivity=(*iter)->enGetActivity();
            tenActivityPrio enPrio=(*iter)->enGetPrio();
            switch ((*iter)->enGetState()) {
                case DAB_enDrvActivityState_Idle:
                    enState= DAB_enDrvActivityListState_Idle;
                    break;
                case DAB_enDrvActivityState_Pending:
                    enState= DAB_enDrvActivityListState_Pending;
                    if (enPendingPrio < enPrio) {
                        enPendingPrio = enPrio;
                    }
                    break;
                case DAB_enDrvActivityState_Terminating:
                    enState= DAB_enDrvActivityListState_Terminating;
                    break;
                case DAB_enDrvActivityState_Running:
                    // only one activity can be in state running
                    if ((*iter)->bIsInterruptible()) {
                        enState=DAB_enDrvActivityListState_Interruptible;
                        if (enInterruptiblePrio < enPrio) {
                            enInterruptiblePrio = enPrio;
                        }
                    }
                    else {
                        enState=DAB_enDrvActivityListState_NonInterruptible;
                    }
					//Coverity 18136 and 18137
                    /*enState= (*iter)->bIsInterruptible() ? 
                        DAB_enDrvActivityListState_Interruptible : 
                    DAB_enDrvActivityListState_NonInterruptible;*/
                    break;
                default:
                    break;
            }
            if (enResState<enState) {
                enResActivity = enActivity;
                enResState=enState;
            }
        }

        if (enResState==DAB_enDrvActivityListState_Interruptible && enPendingPrio<=enInterruptiblePrio) {
            // the pending activity has not the priority before the interruptible activity.
            enResState=DAB_enDrvActivityListState_NonInterruptible;
        }
        ETG_TRACE_USR4(("dabdrv_activityList::enGetState(%d):%d",
                        ETG_CENUM(DAB_tenDrvActivity, enResActivity),
                        ETG_CENUM(DAB_tenDrvActivityListState, enResState)));
        return enResState;
    }

    tBool dabdrv_activityList::bInterrupt() {

        DAB_FOREACH(list<dabdrv_activityBase *>, iter, oActivityList) {
            if ((*iter)->enGetState()==DAB_enDrvActivityState_Running) {
                if ((*iter)->bIsInterruptible()) {
                    (*iter)->bTerminate();
                    ETG_TRACE_USR4(("dabdrv_activityList::bInterrupt(%d)",
                                    ETG_CENUM(DAB_tenDrvActivity, (*iter)->enGetActivity())));
                    return TRUE;
                }
                else {
                    ETG_TRACE_USR4(("dabdrv_activityList::bInterrupt():%d not Interruptible",
                                    ETG_CENUM(DAB_tenDrvActivity, (*iter)->enGetActivity())));
                    return FALSE;
                }
            }
        }
        ETG_TRACE_USR4(("dabdrv_activityList::bInterrupt():no running activities"));
        return TRUE;
    }

    dabdrv_activityBase *dabdrv_activityList::poGetPendingActivity() {
        dabdrv_activityBase *poRes=OSAL_NULL;
        tenActivityPrio enPendingPrio=enActivityPrio_Invalid;
        DAB_FOREACH(list<dabdrv_activityBase *>, iter, oActivityList) {
            if ((*iter)->enGetState()==DAB_enDrvActivityState_Pending) {
                if ((*iter)->enGetPrio()>enPendingPrio) {
                    poRes=*iter;
                    enPendingPrio=(*iter)->enGetPrio();
                    ETG_TRACE_USR4(("dabdrv_activityList::poGetPendingActivity():%d (Prio=%d)",
                                    ETG_CENUM(DAB_tenDrvActivity, (*iter)->enGetActivity()),
                                    ETG_CENUM(tenActivityPrio, enPendingPrio)));
                }
            }
        }
        if (poRes==OSAL_NULL) {
            ETG_TRACE_USR4(("dabdrv_activityList::poGetPendingActivity():No Activity pending"));
        }
        return poRes;
    }

}
