/************************************************************************
 * FILE:        DBAPITypes.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  header contents of DBAPITypes
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      	| Author                       | Modification
  25-01-99		   Maik Scholz		  
				
 *************************************************************************/


#ifndef _DB_API_TYPES_H_
#define _DB_API_TYPES_H_
/*** INCLUDES ******************************************************************
*/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

/*** DEFINES *******************************************************************
*/
#define uint8  tU8
#define uint16 tU16
#define uint32 tU32
#define sint8  tS8
#define sint16 tS16
#define sint32 tS32
#define int32 int
#define boolean tBool


#define API_USER_APPLICATION_TYPE__NO_APP  0x00
#define API_USER_APPLICATION_TYPE__DLS     0x01
#define API_USER_APPLICATION_TYPE__SLS     0x02
#define API_USER_APPLICATION_TYPE__BWS     0x03
#define API_USER_APPLICATION_TYPE__TPEC    0x04
#define API_USER_APPLICATION_TYPE__GPS     0x05
#define API_USER_APPLICATION_TYPE__TOPNEWS 0x400
#define API_USER_APPLICATION_TYPE__EGNOS   0x500


/*** TYPE DEFS. ****************************************************************
*/

#define API_SERVICE_TYPE__INVALID          0x00
#define API_SERVICE_TYPE__DAB_PROG_SERVICE 0x01
#define API_SERVICE_TYPE__DAB_DATA_SERVICE 0x02

typedef enum {
  SERVICE_TYPE_INVALID = API_SERVICE_TYPE__INVALID,
  DAB_PROG_SERVICE     = API_SERVICE_TYPE__DAB_PROG_SERVICE,
  DAB_DATA_SERVICE     = API_SERVICE_TYPE__DAB_DATA_SERVICE
} APIServiceType;


#define API_PROG_SERVICE__ECC_INVALID      0x00
#define API_PROG_SERVICE__SID_INVALID      0x0000


#define API_PROG_SERVICE_TYPE__INVALID     0x00
#define API_PROG_SERVICE_TYPE__DAB         0x01
#define API_PROG_SERVICE_TYPE__FM_RDS      0x02
#define API_PROG_SERVICE_TYPE__FM_NO_RDS   0x03
#define API_PROG_SERVICE_TYPE__AM          0x04
#define API_PROG_SERVICE_TYPE__DRM_AMSS    0x05

typedef enum {
  PROG_SERVICE_INVALID    = API_PROG_SERVICE_TYPE__INVALID,
  PROG_SERVICE_DAB        = API_PROG_SERVICE_TYPE__DAB,
  PROG_SERVICE_FM_RDS     = API_PROG_SERVICE_TYPE__FM_RDS,
  PROG_SERVICE_FM_NO_RDS  = API_PROG_SERVICE_TYPE__FM_NO_RDS,
  PROG_SERVICE_AM         = API_PROG_SERVICE_TYPE__AM
} APIProgServiceType;

/*
 * marco for initilize a APIProgrammeService
 */

/* DeactivateLintMessage_ID0012 */
/*lint -esym(666, APIPROGSERVICE_INIT) */
#define APIPROGSERVICE_INIT(__ptr__)		\
{						\
  (__ptr__)->b_programme_service_type = (uint8) API_PROG_SERVICE_TYPE__INVALID;	\
  (__ptr__)->b_ecc                    = (uint8) API_PROG_SERVICE__ECC_INVALID;	\
  (__ptr__)->w_service_id             = (uint16)API_PROG_SERVICE__SID_INVALID;	\
}																				\

typedef struct
{
  uint8  b_programme_service_type;
  uint8  b_ecc;
  uint16 w_service_id;
} APIProgrammeService;

#define API_ENSEMBLE__ECC_INVALID      0x00
#define API_ENSEMBLE__TAG              0

typedef struct
{
  uint8  b_ensemble_tag;
  uint8  b_ecc;
  uint16 w_ensemble_id;
} APIEnsemble;

#define APIENSEMBLE_IS_EQUAL(a,b)		\
/* DeactivateLintMessage_ID0012 */              \
/*lint -esym( 666, RETVAL ) */                  \
(((a).b_ensemble_tag == (b).b_ensemble_tag)&&	\
 ((a).b_ecc == (b).b_ecc)&&			\
 ((a).w_ensemble_id == (b).w_ensemble_id))      \
/*lint -restore */

#define APIENSEMBLE_IS_EQUAL_WITHOUT_ECC(a,b)	\
(((a).b_ensemble_tag == (b).b_ensemble_tag)&&	\
 ((a).w_ensemble_id == (b).w_ensemble_id))

#define APIENSEMBLE_IS_NULL(a)	       	\
(((a).b_ensemble_tag == 0)&&		\
 ((a).b_ecc == 0)&&			\
 ((a).w_ensemble_id == 0))

typedef union
{
  APIProgrammeService    r_programme_service;
  uint32                 l_data_service_id;
} APIService;

/* DeactivateLintMessage_ID0012 */
/*lint -esym( 666, APIPROGSERVICE_IS_EQUAL ) */
#define APIPROGSERVICE_IS_EQUAL(a,b)		\
  (((a).b_programme_service_type == (b).b_programme_service_type)&&	\
   ((a).b_ecc == (b).b_ecc)&&					\
   ((a).w_service_id == (b).w_service_id))

#define APISERVICE_IS_EQUAL(a,b,t)		\
(((t == API_SERVICE_TYPE__DAB_PROG_SERVICE)&&							\
  (((a).r_programme_service.b_programme_service_type == (b).r_programme_service.b_programme_service_type)&&	\
   ((a).r_programme_service.b_ecc == (b).r_programme_service.b_ecc)&&					\
   ((a).r_programme_service.w_service_id == (b).r_programme_service.w_service_id)))||			\
 ((t == API_SERVICE_TYPE__DAB_DATA_SERVICE)&&							\
  ((a).l_data_service_id == (b).l_data_service_id)))

#define APISERVICE_IS_EQUAL_WITHOUT_ECC(a,b,t)		\
(((t == API_SERVICE_TYPE__DAB_PROG_SERVICE)&&							\
  (((a).r_programme_service.b_programme_service_type == (b).r_programme_service.b_programme_service_type)&&	\
   ((a).r_programme_service.w_service_id == (b).r_programme_service.w_service_id)))||			\
 ((t == API_SERVICE_TYPE__DAB_DATA_SERVICE)&&							\
  ((a).l_data_service_id == (b).l_data_service_id)))

#define APISERVICE_IS_NULL(a,t)		\
(((((a).r_programme_service.b_ecc == 0)&&			\
   ((a).r_programme_service.w_service_id == 0)))||		\
 ((t == API_SERVICE_TYPE__DAB_DATA_SERVICE)&&			\
  ((a).l_data_service_id == 0)))

#define APIPROGSERVICE_IS_NULL(a) \
(((a).b_ecc == 0)&&					\
   ((a).w_service_id == 0))

#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_COMMAND__SET                  0x01
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_COMMAND__DELETE               0x02
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_COMMAND__DELETE_ALL           0x03
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_COMMAND__SET_ALL              0x04
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_COMMAND__GET_SELECTED         0x05
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_COMMAND__SET_AUTO_RDMAPI_CURR 0x06
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_COMMAND__DEL_AUTO_RDMAPI_CURR 0x07
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_COMMAND__GET_DATA             0x08

#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_CLASS__DATABASE                  0x01
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_CLASS__DATABASE_DB_ENSEMBLE_LIST 0x02
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_CLASS__DATABASE_DB_SERVICE_LIST  0x03
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_CLASS__ENSEMBLE                  0x11
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_CLASS__PROG_SERVICE              0x21
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_CLASS__DATA_SERVICE              0x22
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_CLASS__PROG_SERVICE_COMPONENT    0x31
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_CLASS__DATA_SERVICE_COMPONENT    0x32
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_CLASS__COMPONENT                 0x33
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_CLASS__SUBCHANNEL                0x41
typedef union
{
  struct
  {
    uint16                 w_notify_message;
  } database;

  struct
  {
    APIEnsemble            r_ref_ensemble;
    uint8                  b_num_ens_before;
    uint8                  b_num_ens_behind;
  } database_get_db_ensemble_list;

  struct
  {
    uint8                  b_ref_service_type;
    uint8                  b_rfu2;
    uint8                  b_num_serv_before;
    uint8                  b_num_serv_behind;
    APIService             r_ref_service;
  } database_get_db_service_list;

  struct
  {
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_ENSEMBLE_GET_INFO               0x0001
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_ENSEMBLE_GET_LABEL              0x0002
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_ENSEMBLE_GET_SHORT_LABEL        0x0004
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_ENSEMBLE_GET_TIME               0x0008
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_ENSEMBLE_GET_SERVICE_LIST_PROG  0x0010
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_ENSEMBLE_GET_SERVICE_LIST_DATA  0x0020
    uint16                 w_notify_message;
    APIEnsemble            r_ensemble;
  } ensemble;

#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_SERVICE_GET_LABEL                (0x0001 << 0)
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_PROG_SERVICE_GET_SHORT_LABEL     (0x0001 << 1)
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_SERVICE_GET_TIME                 (0x0001 << 2)
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_SERVICE_GET_ANNOUNCEMENT_SUPPORT (0x0001 << 3)
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_SERVICE_GET_COMPONENT_LIST       (0x0001 << 4)
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_SERVICE_GET_PTY                  (0x0001 << 5)
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_SERVICE_GET_AF                   (0x0001 << 6)
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_SERVICE_GET_INFO                 (0x0001 << 7)
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_SERVICE_GET_LINK_INFO            (0x0001 << 8)

  struct
  {
    uint16                 w_notify_message;
    APIProgrammeService    r_programme_service;
  } prog_service;

  struct
  {
    uint16               w_notify_message;
    uint32               l_data_service_id;
  } data_service;

/* #define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_SERVICE_COMPONENT_GET_SCIDI                  0x0001 */
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_SERVICE_COMPONENT_GET_LABEL                  0x0002
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_SERVICE_COMPONENT_GET_USER_APPLICATION_LIST  0x0004
/* #define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_SERVICE_COMPONENT_GET_USER_APPLICATION_DATA  0x0008 */
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_SERVICE_COMPONENT_GET_INFO                   0x0008
#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_SERVICE_COMPONENT_GET_PS_STATUS              0x0010

  struct
  {
    uint16                 w_notify_message;
    APIProgrammeService    r_programme_service;
    uint16                 w_scidi;
  } prog_service_component;

  struct
  {
    uint16               w_notify_message;
    uint32               l_data_service_id;
    uint16               w_scidi;
  } data_service_component;

#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_COMPONENT_GET_INFO                           0x0001

  struct
  {
    uint16               w_notify_message;
    uint16               w_scidi;
  } component;

#define DBAPI_DB_SET_AUTO_NOTIFICATION__NOTIFY_MESSAGE__R_DB_SUBCHANNEL_GET_INFO                          0x0001

  struct
  {
    uint16               w_notify_message;
    uint8                b_subch_id;
  } subchannel;

} APIAutoNotificationObject;

/*
 * db_preset_station_play
 */

/*** The Command Interface *****************************************************
*/

#define API_LABEL_INVALID 0
#define API_LABEL_VALID   1
typedef struct
{
  uint8  b_label_status;
  uint8  b_charset;
  uint8  b_text_control_field;       /* as defined in TS103176: bit3=bidiflag, bit2=basedirection, bit1=contextualflag, bit0=combiningflag */
  uint16 w_8_char_abbreviation;
  uint8  b_label[65];
} APILabel;

#define APILABEL_INIT(__ptr__)				\
{							\
  (__ptr__)->b_label_status = API_LABEL_INVALID;	\
  (__ptr__)->b_charset = 0;				\
  (__ptr__)->w_8_char_abbreviation = 0;			\
  (__ptr__)->b_label[0] = 0;				\
  (__ptr__)->b_label[1] = 0;				\
  (__ptr__)->b_label[2] = 0;				\
  (__ptr__)->b_label[3] = 0;				\
  (__ptr__)->b_label[4] = 0;				\
  (__ptr__)->b_label[5] = 0;				\
  (__ptr__)->b_label[6] = 0;				\
  (__ptr__)->b_label[7] = 0;				\
  (__ptr__)->b_label[8] = 0;				\
  (__ptr__)->b_label[9] = 0;				\
  (__ptr__)->b_label[10] = 0;				\
  (__ptr__)->b_label[11] = 0;				\
  (__ptr__)->b_label[12] = 0;				\
  (__ptr__)->b_label[13] = 0;				\
  (__ptr__)->b_label[14] = 0;				\
  (__ptr__)->b_label[15] = 0;				\
}

#define APILABEL_IS_EQUAL(a,b)					\
  (((a).b_label_status == (b).b_label_status)&&			\
   ((a).b_charset == (b).b_charset)&&				\
   ((a).w_8_char_abbreviation == (b).w_8_char_abbreviation)&&	\
   ((a).b_label[0] == (b).b_label[0])&&				\
   ((a).b_label[1] == (b).b_label[1])&&				\
   ((a).b_label[2] == (b).b_label[2])&&				\
   ((a).b_label[3] == (b).b_label[3])&&				\
   ((a).b_label[4] == (b).b_label[4])&&				\
   ((a).b_label[5] == (b).b_label[5])&&				\
   ((a).b_label[6] == (b).b_label[6])&&				\
   ((a).b_label[7] == (b).b_label[7])&&				\
   ((a).b_label[8] == (b).b_label[8])&&				\
   ((a).b_label[9] == (b).b_label[9])&&				\
   ((a).b_label[10] == (b).b_label[10])&&			\
   ((a).b_label[11] == (b).b_label[11])&&			\
   ((a).b_label[12] == (b).b_label[12])&&			\
   ((a).b_label[13] == (b).b_label[13])&&			\
   ((a).b_label[14] == (b).b_label[14])&&			\
   ((a).b_label[15] == (b).b_label[15]))

typedef struct
{
  uint8  b_label_status;
  uint8  b_charset;
  uint8  b_short_label[8];
} APIShortLabel;


/*** END ***********************************************************************
*/
#endif
/* ChangeLog:
 * $Log: DBAPITypes.h,v $
 * Revision 1.9  2011/09/23 07:47:23  shz2hi
 * branch "Root_tmp_branch_20110819_sqlite_tryout=>tmp_branch_20110819_sqlite_tryout" merged to HEAD.
 * * first implementation of using global database
 *
 * Revision 1.8.12.1  2011/09/19 13:06:53  shz2hi
 * API_ENSEMBLE__ECC_INVALID added
 *
 * Revision 1.8  2011/04/13 10:21:22  gol2hi
 * - correct LINT suppression
 *
 * Revision 1.7  2011/04/01 06:52:10  shz2hi
 * some more Lint Exceptions added
 *
 * Revision 1.6  2011/03/25 15:12:29  bmg2hi
 *  lint warning PRIO 1 exceptions activated
 *
 * Revision 1.5  2007/09/19 09:08:58  shz2hi
 * dbapi & list filtering enhanced
 *
 * Revision 1.4  2007/06/11 15:03:25  shz2hi
 * service_component_get_ps_status implemented
 *
 * Revision 1.3  2006/10/25 17:08:30  shz2hi
 * macro added
 *
 * Revision 1.2  2006/07/13 13:56:02  sbv2hi
 * ServiceType - define for DRM_AMSS added.
 *
 * Revision 1.1  2004/04/06 13:39:09  pn82hi
 * --- First 'dabsw' check-in ---
 *
 * Revision 1.40  2003/01/29 12:30:00  pn82hi
 * API_PROG_SERVICE__???_INVALID added.
 *
 * Revision 1.39  2003/01/27 14:56:27  lse2hi
 * correction made
 *
 * Revision 1.38  2003/01/27 14:43:58  lse2hi
 * new define for app type EGNOS
 *
 * Revision 1.37  2002/12/11 10:36:00  pn82hi
 * Clean-up API_PROG_SERVICE_TYPES, some new added.
 *
 * Revision 1.36  2002/11/22 09:04:21  lse2hi
 * CarouselId casting problem resolved
 * New command *change_mode
 *
 * Revision 1.35  2002/08/14 14:49:05  sbv2hi
 * added new type in APIProgServiceType: PROG_SERVICE_AM
 *
 * Revision 1.34  2002/08/05 09:35:34  shz2hi
 * INVALID defines for API SERVICE added
 *
 * Revision 1.33  2002/06/13 09:59:51  scholz
 * AudioService globaly changed into ProgrammeService
 *
 * Revision 1.32  2002/06/11 07:53:24  scholz
 * SET_RDMAPI_CURR added for auto-notifications
 *
 * Revision 1.31  2002/04/12 09:36:26  sbv2hi
 * R_DB_SERVICE_GET_LINK_INFO added.
 *
 * Revision 1.30  2001/12/17 12:51:48  lse2hi
 * user app types added
 *
 * Revision 1.29  2001/08/22 10:13:34  pn82hi
 * APIProgrammeService added
 *
 * Revision 1.28  2001/07/26 15:37:11  scholz
 * auto ntf added for dbapi SERV_COMP_GET_INFO
 *
 * Revision 1.27  2001/02/14 08:38:55  scholz
 * NULL_OBJ_IDX removed, changed into NULL_OBJ
 *
 * Revision 1.26  2000/12/21 16:01:33  scholz
 * dekoding of sub channel size in cu fixed
 *
 * Revision 1.25  2000/11/14 13:53:37  scholz
 * test for invalid dbapi responses is running without errors now
 *
 * Revision 1.24  2000/11/14 07:47:10  scholz
 * some warnings fixed
 *
 * Revision 1.23  2000/11/08 19:06:10  scholz
 * some changes for user application id
 *
 * Revision 1.22  2000/10/26 10:39:18  scholz
 * dbapi command set-auto-notif... db-list support added
 *
 * Revision 1.21  2000/09/14 17:33:47  bertram
 * define added
 *
 * Revision 1.20  2000/09/12 12:02:20  scholz
 * some changes
 *
 * Revision 1.18  2000/09/06 12:53:45  scholz
 * -
 *
 * Revision 1.17  2000/08/28 16:46:50  scholz
 * -
 *
 * Revision 1.16  2000/08/14 08:37:59  scholz
 * ensemble quality added
 *
 * Revision 1.15  2000/05/10 15:05:22  scholz
 * -
 *
 * Revision 1.14  2000/05/10 13:34:39  scholz
 * some changes
 *
 * Revision 1.13  2000/05/02 16:20:04  scholz
 * some more functions added
 *
 * Revision 1.12  2000/03/22 10:20:38  scholz
 * some changes
 *
 * Revision 1.11  2000/03/15 17:53:41  scholz
 * a lot of changes for new dbapi design (first version of dbapi)
 *
 * Revision 1.10  2000/01/25 14:44:35  wendland
 * add defines for DBAPI_LABEL
 *
 * Revision 1.9  2000/01/18 15:04:44  wendland
 * add Types for preset stations
 *
 * Revision 1.8  2000/01/07 10:19:26  scholz
 * naka switch to version 1.0 !!!
 *
 * Revision 1.7  1999/12/23 17:38:48  scholz
 * a lot of changes in gtkDAB & palmDAB
 *
 * Revision 1.6  1999/12/22 22:24:46  schepers
 * added service_component_get_scidi calls
 *
 * Revision 1.5  1999/11/09 10:07:03  schepers
 * preliminary added get_component_scidi
 *
 * Revision 1.4  1999/08/13 14:17:56  schepers
 * added ensemble_get_time functions
 *
 * Revision 1.3  1999/08/09 12:36:53  shr2hi
 * *** empty log message ***
 *
 * Revision 1.2  1999/03/02 18:10:16  scholz
 * some bugs fixed
 *
 * Revision 1.1  1999/03/02 15:33:48  scholz
 * dbapi added
 *
 * ChangeLogEnd
 */
