/* ******************************************************FileHeaderBegin** *//**
 *
 * @file        DataPoolKERNEL.h
 *
 * generated header for the structure of KERNEL access. 
 *
 * @date        2013-011-20
 *
 * @note 
 *
 *  &copy; Copyright BoschSoftec GmbH Hildesheim. All Rights reserved!
 *
 *//* ***************************************************FileHeaderEnd******* */
#ifndef _DATA_POOL_KERNEL
#define _DATA_POOL_KERNEL

/************************************************************************
|defines and macros (scope: global)
|-----------------------------------------------------------------------*/

/************************************************************************
|typedefs and struct defs (scope: global)
|-----------------------------------------------------------------------*/
/* the maximum size that can be written once a time
(chunk size of the chip;it can only be written once in that area)*/
#define PDD_KERNEL_CHIP_ALIGNMENT   32

typedef int tPddKernelValid  __attribute__ ((aligned (PDD_KERNEL_CHIP_ALIGNMENT)));

/*struct for both validation flag*/
typedef struct
{
  tPddKernelValid     Valid;       /*valid flag*/
  tPddKernelValid     Invalid;     /*invalid flag*/
}TPddHeaderValid;

/*struct for the header information*/
typedef struct
{
  unsigned int       Size;                  /* size of the complete data stream (TPddKernel_PoolKernel) */
  unsigned int       Version;               /* version of the struct; change if an element added*/
  unsigned int       Magic;                 /* magic value */
  unsigned int       ChunkSize;             /* chip aligment*/
  unsigned int       EraseSectorCount;      /* erase sector count (for debug)*/
  unsigned int       Checksum;              /* checksum for indicates bit flips*/
  unsigned int       ChecksumXor;           /* checksum Xor for indicates bit flips*/
}TPddHeaderStream;

/*structure header infomation for PDD*/
typedef struct {
   TPddHeaderValid           HeaderValid;
   TPddHeaderStream          HeaderStream;
}TPddKernel_Header;

/*-----------------------------------------------------------------------
 ---- structure TPddKernel_DpPddKernel for pool DpPddKernel
 -----------------------------------------------------------------------*/
#define DATAPOOL_KERNEL_VERSION_POOL_DPPDDKERNEL     0x0001 
/*array numer of elements*/
#define DATAPOOL_KERNEL_DISPLAYTIMING_NUMBER  16

typedef struct {
   tU32   SynergyDriver;
}TDataPoolKernel_SynergyDriver;

typedef struct {
   tU8   DisplayTiming[DATAPOOL_KERNEL_DISPLAYTIMING_NUMBER];
}TDataPoolKernel_DisplayTiming;

typedef struct {
    TDataPoolKernel_SynergyDriver   SynergyDriver;
    TDataPoolKernel_DisplayTiming   DisplayTiming;
}TDataPoolKernel_DpPddKernel;

typedef struct {
  TPddKernel_Header    PddKernelHeader;
  TDataPoolKernel_DpPddKernel   DpPddKernel;
}TPddKernel_DpPddKernel;



#endif
