/**
* @copyright (c) 2015-2020 Robert Bosch Car Multimedia GmbH
* @addtogroup NavMiddleware
* @{
*/

#ifndef PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_SETTINGS_TRAFFICSETTINGS_H_
#define PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_SETTINGS_TRAFFICSETTINGS_H_

#include <vector>
#include <string>
#include "InfoTypes.h"

namespace navmiddleware
{
namespace settings
{

enum TrafficIconSelectionCriteria
{
   TRAFFIC_ICON_SELECTION_CRITERIA__ALL_TRAFFIC_INFORMATION = 0,
   TRAFFIC_ICON_SELECTION_CRITERIA__TRAFFIC_JAM,
   TRAFFIC_ICON_SELECTION_CRITERIA__SLOW_TRAFFIC,
   TRAFFIC_ICON_SELECTION_CRITERIA__TRAFFIC_FLOWING_FREELY,
   TRAFFIC_ICON_SELECTION_CRITERIA__ROAD_CLOSED,
   TRAFFIC_ICON_SELECTION_CRITERIA__ACCIDENT,
   TRAFFIC_ICON_SELECTION_CRITERIA__ROADWORKS,
   TRAFFIC_ICON_SELECTION_CRITERIA__NARROW_LANES,
   TRAFFIC_ICON_SELECTION_CRITERIA__ALL_OTHER_EVENTS,
   TRAFFIC_ICON_SELECTION_CRITERIA__NUMBER_OF_SELECTION_CRITERIA
};

inline ::std::string toString(TrafficIconSelectionCriteria selectionCriteria)
{
   switch (selectionCriteria)
   {
   case TRAFFIC_ICON_SELECTION_CRITERIA__ALL_TRAFFIC_INFORMATION:
      return "TRAFFIC_ICON_SELECTION_CRITERIA__ALL_TRAFFIC_INFORMATION";
   case TRAFFIC_ICON_SELECTION_CRITERIA__TRAFFIC_JAM:
      return "TRAFFIC_ICON_SELECTION_CRITERIA__TRAFFIC_JAM";
   case TRAFFIC_ICON_SELECTION_CRITERIA__SLOW_TRAFFIC:
      return "TRAFFIC_ICON_SELECTION_CRITERIA__SLOW_TRAFFIC";
   case TRAFFIC_ICON_SELECTION_CRITERIA__TRAFFIC_FLOWING_FREELY:
      return "TRAFFIC_ICON_SELECTION_CRITERIA__TRAFFIC_FLOWING_FREELY";
   case TRAFFIC_ICON_SELECTION_CRITERIA__ROAD_CLOSED:
      return "TRAFFIC_ICON_SELECTION_CRITERIA__ROAD_CLOSED";
   case TRAFFIC_ICON_SELECTION_CRITERIA__ACCIDENT:
      return "TRAFFIC_ICON_SELECTION_CRITERIA__ACCIDENT";
   case TRAFFIC_ICON_SELECTION_CRITERIA__ROADWORKS:
      return "TRAFFIC_ICON_SELECTION_CRITERIA__ROADWORKS";
   case TRAFFIC_ICON_SELECTION_CRITERIA__NARROW_LANES:
      return "TRAFFIC_ICON_SELECTION_CRITERIA__NARROW_LANES";
   case TRAFFIC_ICON_SELECTION_CRITERIA__ALL_OTHER_EVENTS:
      return "TRAFFIC_ICON_SELECTION_CRITERIA__ALL_OTHER_EVENTS";
   default:
      return "<unknown>";
   }
}

enum TestServerType
{
   TESTSERVERTYPE__STANDARD = 0,
   TESTSERVERTYPE__CUSTOMER,
   TESTSERVERTYPE__BOSCH_BMT,
   TESTSERVERTYPE__BOSCH_HIWAY,
   TESTSERVERTYPE__BOSCH_AUX,
   TESTSERVERTYPE__CUSTOMER_AUX,
   TESTSERVERTYPE__AUX,
   TESTSERVERTYPE__WU6CH_DE
};

inline ::std::string toString(TestServerType testServerType)
{
   switch(testServerType)
   {
   case TESTSERVERTYPE__STANDARD:
      return "TESTSERVERTYPE__STANDARD";
   case TESTSERVERTYPE__CUSTOMER:
      return "TESTSERVERTYPE__CUSTOMER";
   case TESTSERVERTYPE__BOSCH_BMT:
      return "TESTSERVERTYPE__BOSCH_BMT";
   case TESTSERVERTYPE__BOSCH_HIWAY:
      return "TESTSERVERTYPE__BOSCH_HIWAY";
   case TESTSERVERTYPE__BOSCH_AUX:
      return "TESTSERVERTYPE__BOSCH_AUX";
   case TESTSERVERTYPE__CUSTOMER_AUX:
      return "TESTSERVERTYPE__CUSTOMER_AUX";
   case TESTSERVERTYPE__AUX:
      return "TESTSERVERTYPE__AUX";
   case TESTSERVERTYPE__WU6CH_DE:
      return "TESTSERVERTYPE__WU6CH_DE";
   default:
      return "<unknown>";
   }
}

class TrafficSettings
{
public:
   TrafficSettings()
      : m_trafficIncidents(true)
      , m_trafficFlow(true)
      , m_usePremiumTraffic(false)
      , m_useNonPremiumTraffic(false)
      , m_downloadWheneverDestinationIsSet(false)
      , m_trafficRequestFrequencyInSecond(0)
      , m_testServerType(TESTSERVERTYPE__STANDARD)
      , m_testServerPort()
   {
   }

   bool operator == (const TrafficSettings& rhs) const
   {
      return (m_trafficIncidents == rhs.m_trafficIncidents &&
              m_trafficFlow == rhs.m_trafficFlow &&
              m_usePremiumTraffic == rhs.m_usePremiumTraffic &&
              m_useNonPremiumTraffic == rhs.m_useNonPremiumTraffic &&
              m_downloadWheneverDestinationIsSet == rhs.m_downloadWheneverDestinationIsSet &&
              m_trafficRequestFrequencyInSecond == rhs.m_trafficRequestFrequencyInSecond &&
              m_trafficIconFilterCriteriaList == rhs.m_trafficIconFilterCriteriaList &&
              m_testServerType == rhs.m_testServerType &&
              m_testServerPort == rhs.m_testServerPort);
   }

   bool operator != (const TrafficSettings& rhs) const
   {
      return !(*this == rhs);
   }


   bool isShowTrafficIncidentsEnabled() const
   {
      return m_trafficIncidents;
   }

   void setShowTrafficIncidents(bool trafficIncidents)
   {
      m_trafficIncidents = trafficIncidents;
   }

   bool isShowTrafficFlowEnabled() const
   {
      return m_trafficFlow;
   }

   void setShowTrafficFlow(bool trafficFlow)
   {
      m_trafficFlow = trafficFlow;
   }

   bool isUsePremiumTrafficEnabled() const
   {
      return m_usePremiumTraffic;
   }

   void setUsePremiumTraffic(bool premiumTraffic)
   {
      m_usePremiumTraffic = premiumTraffic;
   }

   bool isNonPremiumTrafficEnabled() const
   {
      return m_useNonPremiumTraffic;
   }

   void setNonPremiumTraffic(bool nonPremiumTraffic)
   {
      m_useNonPremiumTraffic = nonPremiumTraffic;
   }

   ::navmiddleware::ValidValue<int32_t> getTrafficRequestFrequencyInSecond() const
   {
      return m_trafficRequestFrequencyInSecond;
   }

   void setTrafficRequestFrequencyInSecond(::navmiddleware::ValidValue<int32_t> trafficRequestInSecond)
   {
      m_trafficRequestFrequencyInSecond = trafficRequestInSecond;
   }

   bool isDownloadWheneverDestinationIsSetEnabled() const
   {
      return m_downloadWheneverDestinationIsSet;
   }

   void setDownloadWheneverDestinationIsSet(bool downloadWheneverDestinationIsSet)
   {
      m_downloadWheneverDestinationIsSet = downloadWheneverDestinationIsSet;
   }

   const ::std::vector< TrafficIconSelectionCriteria>& getTrafficIconFilterCriteriaList() const
   {
      return m_trafficIconFilterCriteriaList;
   }

   void setTrafficIconFilterCriteriaList(::std::vector< TrafficIconSelectionCriteria> trafficIconSelectionCriteria)
   {
      m_trafficIconFilterCriteriaList = trafficIconSelectionCriteria;
   }

   TestServerType getTestServer() const
   {
      return m_testServerType;
   }

   void setTestServer(TestServerType testServerType)
   {
      m_testServerType = testServerType;
   }

   const ::navmiddleware::ValidValue<uint16_t>& getTestServerPort() const
   {
      return m_testServerPort;
   }

   void setTestServerPort(const ::navmiddleware::ValidValue<uint16_t>& testServerPort)
   {
      m_testServerPort = testServerPort;
   }

   ::std::string toString() const
   {
      ::std::stringstream stream("TrafficSettings payload:\n");
      stream << ::std::endl;

      stream << "\tm_trafficIncidents: " << m_trafficIncidents << ::std::endl
             << "\tm_trafficFlow: " << m_trafficFlow << ::std::endl
             << "\tm_usePremiumTraffic: "<< m_usePremiumTraffic << ::std::endl
             << "\tm_useNonPremiumTraffic: " << m_useNonPremiumTraffic << ::std::endl
             << "\tm_downloadWheneverDestinationIsSet: " << m_downloadWheneverDestinationIsSet << ::std::endl
             << "\tm_trafficRequestFrequencyInSecond: " << m_trafficRequestFrequencyInSecond.getValue() << ::std::endl
             << "\tm_testServerType: " << ::navmiddleware::settings::toString(m_testServerType) << ::std::endl
             << "\tm_testServerPort: " << m_testServerPort.toString() << ::std::endl;

      return stream.str();
   }

private:
   bool m_trafficIncidents;
   bool m_trafficFlow;
   bool m_usePremiumTraffic;
   bool m_useNonPremiumTraffic;
   bool m_downloadWheneverDestinationIsSet;
   ::navmiddleware::ValidValue<int32_t> m_trafficRequestFrequencyInSecond;
   ::std::vector< TrafficIconSelectionCriteria> m_trafficIconFilterCriteriaList;
   TestServerType m_testServerType;
   ::navmiddleware::ValidValue<uint16_t> m_testServerPort;
};

}
}
#endif  // PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_SETTINGS_TRAFFICSETTINGS_H_
