/**
* @copyright (c) 2016-2020 Robert Bosch Car Multimedia GmbH
* @addtogroup NavMiddleware
* @{
*/
#ifndef PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_SETTINGS_SETTINGTYPES_H_
#define PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_SETTINGS_SETTINGTYPES_H_

namespace navmiddleware
{
namespace settings
{

enum RestoreType
{
   /**
    * addressbook, settings
    */
   RESTORE_TYPE__USER_DATA,
   /**
    * same as USER_DATA + position calibration
    */
   RESTORE_TYPE__ALL
};

enum UserProfileGroup
{
   /**
    * Considers only current user
    */
   USER_PROFILE_GROUP__CURRENT_USER,
   /**
    * Considers all users
    */
   USER_PROFILE_GROUP__ALL_USERS
};

enum RestoreStatus
{
   RESTORE_STATUS__SAVED_VALUES_LOADED,
   RESTORE_STATUS__DEFAULT_VALUES_ASSIGNED
};

enum SettingsGroup
{
   SETTINGS_GROUP__ALL,
   SETTINGS_GROUP__RNAIVI_ROUTE,
   SETTINGS_GROUP__RNAIVI_MAP,
   SETTINGS_GROUP__RNAIVI_SOUND_AND_WARNING,
   SETTINGS_GROUP__RNAIVI_DRIVING_ASSISTANCE,
   SETTINGS_GROUP__RNAIVI_ELECTRIC_VEHICLE,
   SETTINGS_GROUP__RNAIVI_ELECTRIC_VEHICLE_CONNECTOR_TYPE,
   SETTINGS_GROUP__RNAIVI_ELECTRIC_VEHICLE_CHARGE_TYPE
};

} // settings
} // navmiddleware

#endif // PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_SETTINGS_SETTINGTYPES_H_
