/**
* @copyright (c) 2017-2020 Robert Bosch Car Multimedia GmbH
* @addtogroup NavMiddleware
* @{
*/

#ifndef PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_SETTINGS_DESTINATIONMEMORYSETTINGS_H_
#define PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_SETTINGS_DESTINATIONMEMORYSETTINGS_H_

#include <string>

namespace navmiddleware
{
namespace settings
{

enum AutoSaveQuickChargingStation
{
   AUTO_SAVE_QUICK_CHARGING_STATION__OFF=0,
   AUTO_SAVE_QUICK_CHARGING_STATION__ON
};

inline ::std::string toString(const AutoSaveQuickChargingStation& autoSaveQuickChargingStation)
{
   switch (autoSaveQuickChargingStation)
   {
   case AUTO_SAVE_QUICK_CHARGING_STATION__OFF:
      return "AUTO_SAVE_QUICK_CHARGING_STATION__OFF";
   case AUTO_SAVE_QUICK_CHARGING_STATION__ON:
      return "AUTO_SAVE_QUICK_CHARGING_STATION__ON";
   default:
      ::std::stringstream stream;
      stream << "AUTO_SAVE_QUICK_CHARGING_STATION__<" << static_cast<unsigned int>(autoSaveQuickChargingStation) << ">";
      return stream.str();
   }
};

enum AutoSaveStandardChargingStation
{
   AUTO_SAVE_STANDARD_CHARGING_STATION__OFF=0,
   AUTO_SAVE_STANDARD_CHARGING_STATION__ON
};

inline ::std::string toString(const AutoSaveStandardChargingStation& autoSaveStandardChargingStation)
{
   switch (autoSaveStandardChargingStation)
   {
   case AUTO_SAVE_STANDARD_CHARGING_STATION__OFF:
      return "AUTO_SAVE_STANDARD_CHARGING_STATION__OFF";
   case AUTO_SAVE_STANDARD_CHARGING_STATION__ON:
      return "AUTO_SAVE_STANDARD_CHARGING_STATION__ON";
   default:
      ::std::stringstream stream;
      stream << "AUTO_SAVE_STANDARD_CHARGING_STATION__<" << static_cast<unsigned int>(autoSaveStandardChargingStation) << ">";
      return stream.str();
   }
};

enum AutoSaveTrickleChargingStation
{
   AUTO_SAVE_TRICKLE_CHARGING_STATION__OFF=0,
   AUTO_SAVE_TRICKLE_CHARGING_STATION__ON
};

inline ::std::string toString(const AutoSaveTrickleChargingStation& autoSaveTrickleChargingStation)
{
   switch (autoSaveTrickleChargingStation)
   {
   case AUTO_SAVE_TRICKLE_CHARGING_STATION__OFF:
      return "AUTO_SAVE_TRICKLE_CHARGING_STATION__OFF";
   case AUTO_SAVE_TRICKLE_CHARGING_STATION__ON:
      return "AUTO_SAVE_TRICKLE_CHARGING_STATION__ON";
   default:
      ::std::stringstream stream;
      stream << "AUTO_SAVE_TRICKLE_CHARGING_STATION__<" << static_cast<unsigned int>(autoSaveTrickleChargingStation) << ">";
      return stream.str();
   }
};

class EvAutoSaveChargingStationSettings
{
public:
   EvAutoSaveChargingStationSettings():
      m_optionAutoSaveQuickChargingStation(AUTO_SAVE_QUICK_CHARGING_STATION__OFF),
      m_optionAutoSaveStandardChargingStation(AUTO_SAVE_STANDARD_CHARGING_STATION__OFF),
      m_optionAutoSaveStandardChargingStation_100v(AUTO_SAVE_STANDARD_CHARGING_STATION__OFF),
      m_optionAutoSaveStandardChargingStation_200v(AUTO_SAVE_STANDARD_CHARGING_STATION__OFF),
      m_optionAutoSaveTrickleChargingStation(AUTO_SAVE_TRICKLE_CHARGING_STATION__OFF)
   {}

   EvAutoSaveChargingStationSettings(
      const AutoSaveQuickChargingStation& optionAutoSaveQuickChargingStation,
      const AutoSaveStandardChargingStation& optionAutoSaveStandardChargingStation,
      const AutoSaveStandardChargingStation& optionAutoSaveStandardChargingStation_100v,
      const AutoSaveStandardChargingStation& optionAutoSaveStandardChargingStation_200v,
      const AutoSaveTrickleChargingStation& optionAutoSaveTrickleChargingStation)

      : m_optionAutoSaveQuickChargingStation(optionAutoSaveQuickChargingStation)
      , m_optionAutoSaveStandardChargingStation(optionAutoSaveStandardChargingStation)
      , m_optionAutoSaveStandardChargingStation_100v(optionAutoSaveStandardChargingStation_100v)
      , m_optionAutoSaveStandardChargingStation_200v(optionAutoSaveStandardChargingStation_200v)
      , m_optionAutoSaveTrickleChargingStation(optionAutoSaveTrickleChargingStation)
   {}

   bool operator == (const EvAutoSaveChargingStationSettings& rhs) const
   {
      return ( m_optionAutoSaveQuickChargingStation == rhs.m_optionAutoSaveQuickChargingStation &&
               m_optionAutoSaveStandardChargingStation == rhs.m_optionAutoSaveStandardChargingStation &&
               m_optionAutoSaveStandardChargingStation_100v == rhs.m_optionAutoSaveStandardChargingStation_100v &&
               m_optionAutoSaveStandardChargingStation_200v == rhs.m_optionAutoSaveStandardChargingStation_200v &&
               m_optionAutoSaveTrickleChargingStation == rhs.m_optionAutoSaveTrickleChargingStation );
   }

   bool operator != (const EvAutoSaveChargingStationSettings& rhs) const
   {
      return !(*this == rhs);
   }

   void setEvAutoSaveQuickChargingStation(const AutoSaveQuickChargingStation optionEvAutoSaveQuickChargingStationValue)
   {
      m_optionAutoSaveQuickChargingStation = optionEvAutoSaveQuickChargingStationValue;
   }

   AutoSaveQuickChargingStation getEvAutoSaveQuickChargingStation() const
   {
      return m_optionAutoSaveQuickChargingStation;
   }

   void setEvAutoSaveStandardChargingStation(const AutoSaveStandardChargingStation optionEvAutoSaveStandardChargingStationValue)
   {
      m_optionAutoSaveStandardChargingStation = optionEvAutoSaveStandardChargingStationValue;
   }

   AutoSaveStandardChargingStation getEvAutoSaveStandardChargingStation() const
   {
      return m_optionAutoSaveStandardChargingStation;
   }

   AutoSaveStandardChargingStation getEvAutoSaveStandardChargingStation_100v() const
   {
      return m_optionAutoSaveStandardChargingStation_100v;
   }

   void setEvAutoSaveStandardChargingStation_100v(const AutoSaveStandardChargingStation optionEvAutoSaveStandardChargingStationValue_100v)
   {
      m_optionAutoSaveStandardChargingStation_100v = optionEvAutoSaveStandardChargingStationValue_100v;
   }

   AutoSaveStandardChargingStation getEvAutoSaveStandardChargingStation_200v() const
   {
      return m_optionAutoSaveStandardChargingStation_200v;
   }

   void setEvAutoSaveStandardChargingStation_200v(const AutoSaveStandardChargingStation optionEvAutoSaveStandardChargingStationValue_200v)
   {
      m_optionAutoSaveStandardChargingStation_200v = optionEvAutoSaveStandardChargingStationValue_200v;
   }

   void setEvAutoSaveTrickleChargingStation(const AutoSaveTrickleChargingStation optionEvAutoSaveTrickleChargingStationValue)
   {
      m_optionAutoSaveTrickleChargingStation = optionEvAutoSaveTrickleChargingStationValue;
   }

   AutoSaveTrickleChargingStation getEvAutoSaveTrickleChargingStation() const
   {
      return m_optionAutoSaveTrickleChargingStation;
   }

   ::std::string toString() const
   {
      ::std::stringstream stream;
      stream << "EvAutoSaveChargingStationSettings:" << std::endl
             << "optionAutoSaveQuickChargingStation = " << settings::toString(m_optionAutoSaveQuickChargingStation) << ::std::endl
             << "optionAutoSaveStandardChargingStation = " << settings::toString(m_optionAutoSaveStandardChargingStation) << ::std::endl
             << "optionAutoSaveStandardChargingStation_100v = " << settings::toString(m_optionAutoSaveStandardChargingStation_100v) << ::std::endl
             << "optionAutoSaveStandardChargingStation_200v = " << settings::toString(m_optionAutoSaveStandardChargingStation_200v) << ::std::endl
             << "optionAutoSaveTrickleChargingStation = " << settings::toString(m_optionAutoSaveTrickleChargingStation) << ::std::endl;
      return stream.str();
   }

private:
   AutoSaveQuickChargingStation     m_optionAutoSaveQuickChargingStation;
   AutoSaveStandardChargingStation  m_optionAutoSaveStandardChargingStation;
   AutoSaveStandardChargingStation  m_optionAutoSaveStandardChargingStation_100v;//Japan Specific
   AutoSaveStandardChargingStation  m_optionAutoSaveStandardChargingStation_200v;//Japan Specific
   AutoSaveTrickleChargingStation   m_optionAutoSaveTrickleChargingStation;
};

}
}
#endif  // PRES_CTRL_AIVI_PRES_CTRL_SRC_NAVMIDDLEWARE_SETTINGS_DESTINATIONMEMORYSETTINGS_H_
