/* ***************************************************************************************
* FILE:          Bosch_CGI_Config.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Bosch_CGI_Config.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef BOSCH_CGI_CONFIG_H
#define BOSCH_CGI_CONFIG_H

#include "View/CGI/CgiExtensions/BoschCustomDiagnostic.h"

// enable system and video memory statistics
#ifdef VARIANT_S_FTR_ENABLE_CGI_MEMORY_STATISTICS
#define FEATSTD_SYSTEM_MEMORY_STATISTIC_ENABLED
#define FEATSTD_SYSTEM_MEMORY_STATISTIC_FILE_AND_LINE_TRACKING_ENABLED
// CGI 2.x
#define FEATSTD_VIDEO_MEMORY_STATISTIC_ENABLED
// CGI 3.x
#define CANDERA_VIDEO_MEMORY_STATISTIC_ENABLED
#endif

// enable Candera layout monitor
// to be included in VARIANT_S_FTR_ENABLE_CGI_MONITOR section when LayoutMonitor is included in CGI Analyzer
#ifdef VARIANT_S_FTR_ENABLE_CGI_CANDERA_LAYOUT_MONITOR
#define CANDERA_LAYOUT_MONITOR_ENABLED
#endif

// enable monitoring capabilities
#ifdef VARIANT_S_FTR_ENABLE_CGI_MONITOR
#define FEATSTD_MONITOR_ENABLED
#define COURIER_MESSAGING_MONITOR_ENABLED
#define COURIER_RENDERING_MONITOR_ENABLED
#define MONITOR_CANDERA_PERFORMANCE_RECORDER_ENABLED
#define MONITOR_RECORDING_2D_CALLS_ENABLED
// frame interval for single-step mode
#define MONITOR_SINGLE_STEP_INTERVAL 20

#ifdef WIN32
#define MONITOR_TCPIP_ADDRESS "127.0.0.1"
#else
#define MONITOR_TCPIP_ADDRESS "172.17.0.5"
#endif
#define MONITOR_TCPIP_PORT  13047
#define MONITOR_TCPIP_STACK_ENABLED
#define MONITOR_CONNECTION_TYPE_TCPIP
#endif

// COURIER settings ( todo: remove settings from prod.xml )
#ifndef COURIER_ITEM_DESCRIPTOR_MAX
#define COURIER_ITEM_DESCRIPTOR_MAX          0xffff
#endif
#ifndef COURIER_BINDING_SOURCE_MAX
#define COURIER_BINDING_SOURCE_MAX           0xffff
#endif
#ifndef COURIER_DEFAULT_TOUCHSOURCE_COUNT
#define COURIER_DEFAULT_TOUCHSOURCE_COUNT    1000
#endif
#ifndef COURIER_USE_DYNAMIC_MESSAGE_FACTORY
#define COURIER_USE_DYNAMIC_MESSAGE_FACTORY
#endif
#ifndef CANDERA_LAYOUT_CLIPPING_ENABLED
#define CANDERA_LAYOUT_CLIPPING_ENABLED
#endif

#ifndef COURIER_DEFAULT_RENDER_COUNT
#define COURIER_DEFAULT_RENDER_COUNT 3
#endif

#endif
