/* ***************************************************************************************
* FILE:          UniqueUID.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  UniqueUID.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef HMIBASE_UTIL_UUID_H
#define HMIBASE_UTIL_UUID_H

#include <string>

extern "C"
{
#ifdef _MSC_VER
#include <Rpc.h>
#else
#include <uuid/uuid.h>
#endif
}


namespace hmibase {
namespace util {

class UniqueUID
{
   public:

      UniqueUID();
      UniqueUID(const uuid_t& uuid);
      UniqueUID(const UniqueUID& a);
      ~UniqueUID();

      bool operator == (const UniqueUID& rhs);
      bool operator != (const UniqueUID& rhs);
      UniqueUID& operator = (const UniqueUID& rhs);

      bool isNull();
      void clear();
      void getUUID(uuid_t& uuid);

      static std::string toString(const hmibase::util::UniqueUID&);
      static std::string toString(const uuid_t&);

   private:
      uuid_t _uuid;

      void copy(uuid_t& dst, const uuid_t& src);
      int compare(const uuid_t& a, const uuid_t& b);
};


}
}


#endif
