#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_CM_ASF_LANG_CMS_CONNECTORS_H
#define COM_BOSCH_CM_ASF_LANG_CMS_CONNECTORS_H

#include "asf/core/Internal.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "com/bosch/cm/asf/lang/cms/ConnectorsConst.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "Connectors" isn't clear, then there should be a description here.
 */

namespace com {
namespace bosch {
namespace cm {
namespace asf {
namespace lang {
namespace cms {
namespace Connectors {

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 0;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 0;

// forward declarations
class CmsSocketServerConnector;

class CmsSocketClientConnector;

class CmsWebSocketServerConnector;


/**
 * A CMS connector which listens on a TCP/IP port
 */
class CmsSocketServerConnector {
public:

    /**
     * Default constructor
     */
    inline  CmsSocketServerConnector ();

    /**
     * Copy constructor
     */
    inline  CmsSocketServerConnector (const CmsSocketServerConnector &rhs);

    /**
     * All fields constructor
     */
    inline  CmsSocketServerConnector (uint16 portNumber_, Encoding encoding_, const ::std::string& bindToAddress_, const ::std::string& address_);

    /**
     * Destructor
     */
    inline  ~CmsSocketServerConnector();

    /**
     * Assignment operator
     */
    inline CmsSocketServerConnector& operator = (const CmsSocketServerConnector& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CmsSocketServerConnector& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CmsSocketServerConnector& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CmsSocketServerConnector& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CmsSocketServerConnector& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "portNumber"

    static const int kPortNumber = 0;

    /**
     * Clears the field "portNumber".
     *
     * The field will be set to its default value. The hasPortNumber()
     * method will return false.
     */
    inline void clearPortNumber();

    /**
     * Checks whether the field "portNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPortNumber()). Otherwise it will return false.
     */
    inline bool hasPortNumber () const;

    /**
     * Returns the value of the member "portNumber".
     *
     * The port on which the connector listens and accepts client connections,
     * see http://en.wikipedia.org/wiki/Port_(computer_networking).
     *
     * Please use a port outside the local port range [32768, 61000].
     *
     * @return The value of the field "portNumber"
     */
    inline uint16 getPortNumber () const;

    /**
     * Sets the value of the member "portNumber".
     *
     * The port on which the connector listens and accepts client connections,
     * see http://en.wikipedia.org/wiki/Port_(computer_networking).
     *
     * Please use a port outside the local port range [32768, 61000].
     *
     * @param portNumber The value which will be set
     */
    inline void setPortNumber (uint16 portNumber_);

    // API of field "encoding"

    static const int kEncoding = 1;

    /**
     * Clears the field "encoding".
     *
     * The field will be set to its default value. The hasEncoding()
     * method will return false.
     */
    inline void clearEncoding();

    /**
     * Checks whether the field "encoding" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEncoding()). Otherwise it will return false.
     */
    inline bool hasEncoding () const;

    /**
     * Returns the value of the member "encoding".
     *
     * The encoding controls the encoding format of the messages, either Json (default)
     * or FastBin
     *
     * @return The value of the field "encoding"
     */
    inline Encoding getEncoding () const;

    /**
     * Sets the value of the member "encoding".
     *
     * The encoding controls the encoding format of the messages, either Json (default)
     * or FastBin
     *
     * @param encoding The value which will be set
     */
    inline void setEncoding (Encoding encoding_);

    // API of field "bindToAddress"

    static const int kBindToAddress = 2;

    /**
     * Clears the field "bindToAddress".
     *
     * The field will be set to its default value. The hasBindToAddress()
     * method will return false.
     */
    inline void clearBindToAddress();

    /**
     * Checks whether the field "bindToAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBindToAddress()). Otherwise it will return false.
     */
    inline bool hasBindToAddress () const;

    /**
     * Returns the value of the member "bindToAddress".
     *
     * If the meaning of "bindToAddress" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bindToAddress"
     */
    inline const ::std::string& getBindToAddress () const;

    /**
     * Retrieves the value of the field "bindToAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "bindToAddress".
     */
    inline ::std::string& getBindToAddressMutable ();

    /**
     * Sets the value of the member "bindToAddress".
     *
     * If the meaning of "bindToAddress" isn't clear, then there should be a description here.
     *
     * @param bindToAddress The value which will be set
     */
    inline void setBindToAddress (const ::std::string& bindToAddress_);

    /**
     * Sets the value of the member "bindToAddress".
     *
     * If the meaning of "bindToAddress" isn't clear, then there should be a description here.
     *
     * @param bindToAddress The value which will be set
     */
    inline void setBindToAddress (const char* bindToAddress_);

    /**
     * Sets the value of the member "bindToAddress".
     *
     * If the meaning of "bindToAddress" isn't clear, then there should be a description here.
     *
     * @param bindToAddress The value which will be set
     */
    inline void setBindToAddress (const char* value, size_t size);

    /**
     * Release the object stored in the field "bindToAddress".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "bindToAddress"
     */
    inline ::std::string* releaseBindToAddress();

    /**
     * Replace the field "bindToAddress".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceBindToAddress (::std::string* bindToAddress_);

    // API of field "address"

    static const int kAddress = 3;

    /**
     * Clears the field "address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "address".
     *
     * The 'address' field is optional.
     * If the 'address' field is set it must match the hierarchical URI pattern like:
     *
     * scheme://host:port
     * The allowed values for scheme are: cms-bin or cms-json
     * e.g. cms-bin://localhost:12345
     *      cms-json://localhost:12346
     *
     * If the 'address' field is set, the values - portNumber, encoding and bindToAddress - are
     * ignored.
     *
     * @return The value of the field "address"
     */
    inline const ::std::string& getAddress () const;

    /**
     * Retrieves the value of the field "address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "address".
     */
    inline ::std::string& getAddressMutable ();

    /**
     * Sets the value of the member "address".
     *
     * The 'address' field is optional.
     * If the 'address' field is set it must match the hierarchical URI pattern like:
     *
     * scheme://host:port
     * The allowed values for scheme are: cms-bin or cms-json
     * e.g. cms-bin://localhost:12345
     *      cms-json://localhost:12346
     *
     * If the 'address' field is set, the values - portNumber, encoding and bindToAddress - are
     * ignored.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const ::std::string& address_);

    /**
     * Sets the value of the member "address".
     *
     * The 'address' field is optional.
     * If the 'address' field is set it must match the hierarchical URI pattern like:
     *
     * scheme://host:port
     * The allowed values for scheme are: cms-bin or cms-json
     * e.g. cms-bin://localhost:12345
     *      cms-json://localhost:12346
     *
     * If the 'address' field is set, the values - portNumber, encoding and bindToAddress - are
     * ignored.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* address_);

    /**
     * Sets the value of the member "address".
     *
     * The 'address' field is optional.
     * If the 'address' field is set it must match the hierarchical URI pattern like:
     *
     * scheme://host:port
     * The allowed values for scheme are: cms-bin or cms-json
     * e.g. cms-bin://localhost:12345
     *      cms-json://localhost:12346
     *
     * If the 'address' field is set, the values - portNumber, encoding and bindToAddress - are
     * ignored.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* value, size_t size);

    /**
     * Release the object stored in the field "address".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "address"
     */
    inline ::std::string* releaseAddress();

    /**
     * Replace the field "address".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceAddress (::std::string* address_);

    static const CmsSocketServerConnector &getDefaultInstance();

private:

    inline void set_has_portNumber ();

    inline void clear_has_portNumber ();

    inline void set_has_encoding ();

    inline void clear_has_encoding ();

    inline void set_has_bindToAddress ();

    inline void clear_has_bindToAddress ();

    inline void set_has_address ();

    inline void clear_has_address ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint16 _portNumber;

    Encoding _encoding;

    ::std::string* _bindToAddress;

    ::std::string* _address;

};

/**
 * A CMS connector which connects to a TCP/IP port
 */
class CmsSocketClientConnector {
public:

    /**
     * Default constructor
     */
    inline  CmsSocketClientConnector ();

    /**
     * Copy constructor
     */
    inline  CmsSocketClientConnector (const CmsSocketClientConnector &rhs);

    /**
     * All fields constructor
     */
    inline  CmsSocketClientConnector (Encoding encoding_, uint32 connectionReattemptInterval_, uint32 connectionAttemptWarningThreshold_);

    /**
     * Destructor
     */
    inline  ~CmsSocketClientConnector();

    /**
     * Assignment operator
     */
    inline CmsSocketClientConnector& operator = (const CmsSocketClientConnector& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CmsSocketClientConnector& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CmsSocketClientConnector& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CmsSocketClientConnector& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CmsSocketClientConnector& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "encoding"

    static const int kEncoding = 0;

    /**
     * Clears the field "encoding".
     *
     * The field will be set to its default value. The hasEncoding()
     * method will return false.
     */
    inline void clearEncoding();

    /**
     * Checks whether the field "encoding" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEncoding()). Otherwise it will return false.
     */
    inline bool hasEncoding () const;

    /**
     * Returns the value of the member "encoding".
     *
     * The encoding controls the encoding format of the messages, either Json (default)
     * or FastBin
     *
     * @return The value of the field "encoding"
     */
    inline Encoding getEncoding () const;

    /**
     * Sets the value of the member "encoding".
     *
     * The encoding controls the encoding format of the messages, either Json (default)
     * or FastBin
     *
     * @param encoding The value which will be set
     */
    inline void setEncoding (Encoding encoding_);

    // API of field "connectionReattemptInterval"

    static const int kConnectionReattemptInterval = 1;

    /**
     * Clears the field "connectionReattemptInterval".
     *
     * The field will be set to its default value. The hasConnectionReattemptInterval()
     * method will return false.
     */
    inline void clearConnectionReattemptInterval();

    /**
     * Checks whether the field "connectionReattemptInterval" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectionReattemptInterval()). Otherwise it will return false.
     */
    inline bool hasConnectionReattemptInterval () const;

    /**
     * Returns the value of the member "connectionReattemptInterval".
     *
     * Specifies the interval in milli-seconds between connection attempts.
     *
     * When a connection can not be established the connector waits for the
     * given interval and runs a new connection attempt.
     *
     * Whenever a connection is lost a reconnect attempt is initiated immediately
     * (unless the connectionReattemptInterval is set to 0). This is performed
     * to trigger the restart of server via the socket activation feature of systemd.
     *
     * If the value is 0 then no connection reattempt will be performed.
     *
     * @return The value of the field "connectionReattemptInterval"
     */
    inline uint32 getConnectionReattemptInterval () const;

    /**
     * Sets the value of the member "connectionReattemptInterval".
     *
     * Specifies the interval in milli-seconds between connection attempts.
     *
     * When a connection can not be established the connector waits for the
     * given interval and runs a new connection attempt.
     *
     * Whenever a connection is lost a reconnect attempt is initiated immediately
     * (unless the connectionReattemptInterval is set to 0). This is performed
     * to trigger the restart of server via the socket activation feature of systemd.
     *
     * If the value is 0 then no connection reattempt will be performed.
     *
     * @param connectionReattemptInterval The value which will be set
     */
    inline void setConnectionReattemptInterval (uint32 connectionReattemptInterval_);

    // API of field "connectionAttemptWarningThreshold"

    static const int kConnectionAttemptWarningThreshold = 2;

    /**
     * Clears the field "connectionAttemptWarningThreshold".
     *
     * The field will be set to its default value. The hasConnectionAttemptWarningThreshold()
     * method will return false.
     */
    inline void clearConnectionAttemptWarningThreshold();

    /**
     * Checks whether the field "connectionAttemptWarningThreshold" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectionAttemptWarningThreshold()). Otherwise it will return false.
     */
    inline bool hasConnectionAttemptWarningThreshold () const;

    /**
     * Returns the value of the member "connectionAttemptWarningThreshold".
     *
     * Specifies the number of failed connection attempts after which a warning
     * will be logged.
     *
     * The connector counts down the remaining connection attempts, starting at
     * "connectionAttemptWarningThreshold" (default value is 20).
     * If the connection is not established within the threshold, then a warning message
     * will be logged. The warning informs about the fact that a connection to the given
     * server could not be established. Then the counting starts again.
     *
     * If the value is 0 then no warning is logged.
     *
     * @return The value of the field "connectionAttemptWarningThreshold"
     */
    inline uint32 getConnectionAttemptWarningThreshold () const;

    /**
     * Sets the value of the member "connectionAttemptWarningThreshold".
     *
     * Specifies the number of failed connection attempts after which a warning
     * will be logged.
     *
     * The connector counts down the remaining connection attempts, starting at
     * "connectionAttemptWarningThreshold" (default value is 20).
     * If the connection is not established within the threshold, then a warning message
     * will be logged. The warning informs about the fact that a connection to the given
     * server could not be established. Then the counting starts again.
     *
     * If the value is 0 then no warning is logged.
     *
     * @param connectionAttemptWarningThreshold The value which will be set
     */
    inline void setConnectionAttemptWarningThreshold (uint32 connectionAttemptWarningThreshold_);

    static const CmsSocketClientConnector &getDefaultInstance();

private:

    inline void set_has_encoding ();

    inline void clear_has_encoding ();

    inline void set_has_connectionReattemptInterval ();

    inline void clear_has_connectionReattemptInterval ();

    inline void set_has_connectionAttemptWarningThreshold ();

    inline void clear_has_connectionAttemptWarningThreshold ();

    uint32 _has_bits_[ (3 + 31) / 32];

    Encoding _encoding;

    uint32 _connectionReattemptInterval;

    uint32 _connectionAttemptWarningThreshold;

};

/**
 * A CMS Websocket connector which listens on a TCP/IP port
 */
class CmsWebSocketServerConnector {
public:

    /**
     * Default constructor
     */
    inline  CmsWebSocketServerConnector ();

    /**
     * Copy constructor
     */
    inline  CmsWebSocketServerConnector (const CmsWebSocketServerConnector &rhs);

    /**
     * All fields constructor
     */
    inline  CmsWebSocketServerConnector (uint16 portNumber_, Encoding encoding_);

    /**
     * Destructor
     */
    inline  ~CmsWebSocketServerConnector();

    /**
     * Assignment operator
     */
    inline CmsWebSocketServerConnector& operator = (const CmsWebSocketServerConnector& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CmsWebSocketServerConnector& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CmsWebSocketServerConnector& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CmsWebSocketServerConnector& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CmsWebSocketServerConnector& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "portNumber"

    static const int kPortNumber = 0;

    /**
     * Clears the field "portNumber".
     *
     * The field will be set to its default value. The hasPortNumber()
     * method will return false.
     */
    inline void clearPortNumber();

    /**
     * Checks whether the field "portNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPortNumber()). Otherwise it will return false.
     */
    inline bool hasPortNumber () const;

    /**
     * Returns the value of the member "portNumber".
     *
     * The port on which the connector listens and accepts client connections.
     *
     * Please use a port outside the local port range [32768, 61000].
     *
     * @return The value of the field "portNumber"
     */
    inline uint16 getPortNumber () const;

    /**
     * Sets the value of the member "portNumber".
     *
     * The port on which the connector listens and accepts client connections.
     *
     * Please use a port outside the local port range [32768, 61000].
     *
     * @param portNumber The value which will be set
     */
    inline void setPortNumber (uint16 portNumber_);

    // API of field "encoding"

    static const int kEncoding = 1;

    /**
     * Clears the field "encoding".
     *
     * The field will be set to its default value. The hasEncoding()
     * method will return false.
     */
    inline void clearEncoding();

    /**
     * Checks whether the field "encoding" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEncoding()). Otherwise it will return false.
     */
    inline bool hasEncoding () const;

    /**
     * Returns the value of the member "encoding".
     *
     * The encoding controls the encoding format of the messages, either Json (default)
     * or FastBin
     *
     * @return The value of the field "encoding"
     */
    inline Encoding getEncoding () const;

    /**
     * Sets the value of the member "encoding".
     *
     * The encoding controls the encoding format of the messages, either Json (default)
     * or FastBin
     *
     * @param encoding The value which will be set
     */
    inline void setEncoding (Encoding encoding_);

    static const CmsWebSocketServerConnector &getDefaultInstance();

private:

    inline void set_has_portNumber ();

    inline void clear_has_portNumber ();

    inline void set_has_encoding ();

    inline void clear_has_encoding ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _portNumber;

    Encoding _encoding;

};

inline  CmsSocketServerConnector::CmsSocketServerConnector ()  :
    _portNumber (0u),
    _encoding (::com::bosch::cm::asf::lang::cms::Connectors::Encoding__Json),
    _bindToAddress (NULL),
    _address (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CmsSocketServerConnector::CmsSocketServerConnector (const CmsSocketServerConnector &rhs)  :
    _portNumber (0u),
    _encoding (::com::bosch::cm::asf::lang::cms::Connectors::Encoding__Json),
    _bindToAddress (NULL),
    _address (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CmsSocketServerConnector::CmsSocketServerConnector (uint16 portNumber_, Encoding encoding_, const ::std::string& bindToAddress_, const ::std::string& address_)  :
    _portNumber (portNumber_),
    _encoding (encoding_),
    _bindToAddress (new ::std::string(bindToAddress_)),
    _address (new ::std::string(address_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(Encoding_IsValid(encoding_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", encoding_, "Encoding", "encoding", "CmsSocketServerConnector");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (bindToAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CmsSocketServerConnector::~CmsSocketServerConnector() {
    delete _bindToAddress;
    delete _address;
}

inline CmsSocketServerConnector& CmsSocketServerConnector::operator = (const CmsSocketServerConnector& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPortNumber()) {
            setPortNumber(rhs.getPortNumber());
        } else {
            clearPortNumber();
        }
        if (rhs.hasEncoding()) {
            setEncoding(rhs.getEncoding());
        } else {
            clearEncoding();
        }
        if (rhs.hasBindToAddress()) {
            setBindToAddress(rhs.getBindToAddress());
        } else {
            clearBindToAddress();
        }
        if (rhs.hasAddress()) {
            setAddress(rhs.getAddress());
        } else {
            clearAddress();
        }
    }
    return *this;
}

inline bool CmsSocketServerConnector::operator == (const CmsSocketServerConnector& rhs) const {
    return (((!hasPortNumber() && !rhs.hasPortNumber()) || getPortNumber() == rhs.getPortNumber()) &&
        ((!hasEncoding() && !rhs.hasEncoding()) || getEncoding() == rhs.getEncoding()) &&
        ((!hasBindToAddress() && !rhs.hasBindToAddress()) || getBindToAddress() == rhs.getBindToAddress()) &&
        ((!hasAddress() && !rhs.hasAddress()) || getAddress() == rhs.getAddress()));
}

inline bool CmsSocketServerConnector::operator != (const CmsSocketServerConnector& rhs) const {
    return ! (*this == rhs);
}

inline bool CmsSocketServerConnector::operator < (const CmsSocketServerConnector& rhs) const {
    if (hasPortNumber() || rhs.hasPortNumber()) {
        if (getPortNumber() < rhs.getPortNumber()) return true;
        if (getPortNumber() > rhs.getPortNumber()) return false;
    }
    if (hasEncoding() || rhs.hasEncoding()) {
        if ((uint32)getEncoding() < (uint32)rhs.getEncoding()) return true;
        if ((uint32)getEncoding() > (uint32)rhs.getEncoding()) return false;
    }
    if (hasBindToAddress() || rhs.hasBindToAddress()) {
        if (getBindToAddress() < rhs.getBindToAddress()) return true;
        if (getBindToAddress() > rhs.getBindToAddress()) return false;
    }
    if (hasAddress() || rhs.hasAddress()) {
        if (getAddress() < rhs.getAddress()) return true;
        if (getAddress() > rhs.getAddress()) return false;
    }
    return false;
}

inline bool CmsSocketServerConnector::operator > (const CmsSocketServerConnector& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CmsSocketServerConnector::clear() {
    clearPortNumber();
    clearEncoding();
    clearBindToAddress();
    clearAddress();
}

inline void CmsSocketServerConnector::clearPortNumber() {
    if (hasPortNumber()) {
         clear_has_portNumber();
        _portNumber = 0u;
     }
}

inline bool CmsSocketServerConnector::hasPortNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 CmsSocketServerConnector::getPortNumber () const {
    return _portNumber;
}

inline void CmsSocketServerConnector::setPortNumber (uint16 portNumber_) {
    set_has_portNumber();
    this->_portNumber = portNumber_;
}

inline void CmsSocketServerConnector::clearEncoding() {
    if (hasEncoding()) {
         clear_has_encoding();
        _encoding = ::com::bosch::cm::asf::lang::cms::Connectors::Encoding__Json;
     }
}

inline bool CmsSocketServerConnector::hasEncoding () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline Encoding CmsSocketServerConnector::getEncoding () const {
    return _encoding;
}

inline void CmsSocketServerConnector::setEncoding (Encoding encoding_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(Encoding_IsValid(encoding_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", encoding_, "Encoding", "encoding", "CmsSocketServerConnector");
    }
    set_has_encoding();
    this->_encoding = encoding_;
}

inline void CmsSocketServerConnector::clearBindToAddress() {
    if (hasBindToAddress()) {
         clear_has_bindToAddress();
        if (_bindToAddress != NULL) {
            _bindToAddress->clear();
        }
     }
}

inline bool CmsSocketServerConnector::hasBindToAddress () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& CmsSocketServerConnector::getBindToAddress () const {
    if (_bindToAddress == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_bindToAddress;
}

inline ::std::string& CmsSocketServerConnector::getBindToAddressMutable () {
    set_has_bindToAddress();
    if (_bindToAddress == NULL) {
        _bindToAddress = new ::std::string ();
        CHECK_ALLOCATION( _bindToAddress );
    }
    return *_bindToAddress;
}

inline void CmsSocketServerConnector::setBindToAddress (const ::std::string& bindToAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (bindToAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_bindToAddress();
    if (this->_bindToAddress == NULL) {
        this->_bindToAddress = new ::std::string (bindToAddress_);
        CHECK_ALLOCATION( this->_bindToAddress );
    } else {
        *this->_bindToAddress = bindToAddress_;
    }
}

inline void CmsSocketServerConnector::setBindToAddress (const char* bindToAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (bindToAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_bindToAddress();
    if (this->_bindToAddress == NULL) {
        this->_bindToAddress = new ::std::string (bindToAddress_);
        CHECK_ALLOCATION( this->_bindToAddress );
    } else {
        this->_bindToAddress->assign(bindToAddress_);
    }
}

inline void CmsSocketServerConnector::setBindToAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_bindToAddress();
    if (this->_bindToAddress == NULL) {
        this->_bindToAddress = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_bindToAddress );
    } else {
        this->_bindToAddress->assign(value, size);
    }
}

inline ::std::string* CmsSocketServerConnector::releaseBindToAddress() {
    clear_has_bindToAddress();
    ::std::string* temp = _bindToAddress;
    this->_bindToAddress = NULL;
    return temp;
}

inline void CmsSocketServerConnector::replaceBindToAddress (::std::string* bindToAddress_) {
    set_has_bindToAddress();
    if (this->_bindToAddress != bindToAddress_) {
        if (this->_bindToAddress != NULL) {
            delete this->_bindToAddress;
        }
        this->_bindToAddress = bindToAddress_;
    }
}

inline void CmsSocketServerConnector::clearAddress() {
    if (hasAddress()) {
         clear_has_address();
        if (_address != NULL) {
            _address->clear();
        }
     }
}

inline bool CmsSocketServerConnector::hasAddress () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& CmsSocketServerConnector::getAddress () const {
    if (_address == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_address;
}

inline ::std::string& CmsSocketServerConnector::getAddressMutable () {
    set_has_address();
    if (_address == NULL) {
        _address = new ::std::string ();
        CHECK_ALLOCATION( _address );
    }
    return *_address;
}

inline void CmsSocketServerConnector::setAddress (const ::std::string& address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    if (this->_address == NULL) {
        this->_address = new ::std::string (address_);
        CHECK_ALLOCATION( this->_address );
    } else {
        *this->_address = address_;
    }
}

inline void CmsSocketServerConnector::setAddress (const char* address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    if (this->_address == NULL) {
        this->_address = new ::std::string (address_);
        CHECK_ALLOCATION( this->_address );
    } else {
        this->_address->assign(address_);
    }
}

inline void CmsSocketServerConnector::setAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    if (this->_address == NULL) {
        this->_address = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_address );
    } else {
        this->_address->assign(value, size);
    }
}

inline ::std::string* CmsSocketServerConnector::releaseAddress() {
    clear_has_address();
    ::std::string* temp = _address;
    this->_address = NULL;
    return temp;
}

inline void CmsSocketServerConnector::replaceAddress (::std::string* address_) {
    set_has_address();
    if (this->_address != address_) {
        if (this->_address != NULL) {
            delete this->_address;
        }
        this->_address = address_;
    }
}

inline void CmsSocketServerConnector::set_has_portNumber () {
    _has_bits_[0] |= 1u << 0;
}

inline void CmsSocketServerConnector::clear_has_portNumber () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CmsSocketServerConnector::set_has_encoding () {
    _has_bits_[0] |= 1u << 1;
}

inline void CmsSocketServerConnector::clear_has_encoding () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void CmsSocketServerConnector::set_has_bindToAddress () {
    _has_bits_[0] |= 1u << 2;
}

inline void CmsSocketServerConnector::clear_has_bindToAddress () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void CmsSocketServerConnector::set_has_address () {
    _has_bits_[0] |= 1u << 3;
}

inline void CmsSocketServerConnector::clear_has_address () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  CmsSocketClientConnector::CmsSocketClientConnector ()  :
    _encoding (::com::bosch::cm::asf::lang::cms::Connectors::Encoding__Json),
    _connectionReattemptInterval (500u),
    _connectionAttemptWarningThreshold (20u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CmsSocketClientConnector::CmsSocketClientConnector (const CmsSocketClientConnector &rhs)  :
    _encoding (::com::bosch::cm::asf::lang::cms::Connectors::Encoding__Json),
    _connectionReattemptInterval (500u),
    _connectionAttemptWarningThreshold (20u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CmsSocketClientConnector::CmsSocketClientConnector (Encoding encoding_, uint32 connectionReattemptInterval_, uint32 connectionAttemptWarningThreshold_)  :
    _encoding (encoding_),
    _connectionReattemptInterval (connectionReattemptInterval_),
    _connectionAttemptWarningThreshold (connectionAttemptWarningThreshold_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(Encoding_IsValid(encoding_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", encoding_, "Encoding", "encoding", "CmsSocketClientConnector");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CmsSocketClientConnector::~CmsSocketClientConnector() {
}

inline CmsSocketClientConnector& CmsSocketClientConnector::operator = (const CmsSocketClientConnector& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEncoding()) {
            setEncoding(rhs.getEncoding());
        } else {
            clearEncoding();
        }
        if (rhs.hasConnectionReattemptInterval()) {
            setConnectionReattemptInterval(rhs.getConnectionReattemptInterval());
        } else {
            clearConnectionReattemptInterval();
        }
        if (rhs.hasConnectionAttemptWarningThreshold()) {
            setConnectionAttemptWarningThreshold(rhs.getConnectionAttemptWarningThreshold());
        } else {
            clearConnectionAttemptWarningThreshold();
        }
    }
    return *this;
}

inline bool CmsSocketClientConnector::operator == (const CmsSocketClientConnector& rhs) const {
    return (((!hasEncoding() && !rhs.hasEncoding()) || getEncoding() == rhs.getEncoding()) &&
        ((!hasConnectionReattemptInterval() && !rhs.hasConnectionReattemptInterval()) || getConnectionReattemptInterval() == rhs.getConnectionReattemptInterval()) &&
        ((!hasConnectionAttemptWarningThreshold() && !rhs.hasConnectionAttemptWarningThreshold()) || getConnectionAttemptWarningThreshold() == rhs.getConnectionAttemptWarningThreshold()));
}

inline bool CmsSocketClientConnector::operator != (const CmsSocketClientConnector& rhs) const {
    return ! (*this == rhs);
}

inline bool CmsSocketClientConnector::operator < (const CmsSocketClientConnector& rhs) const {
    if (hasEncoding() || rhs.hasEncoding()) {
        if ((uint32)getEncoding() < (uint32)rhs.getEncoding()) return true;
        if ((uint32)getEncoding() > (uint32)rhs.getEncoding()) return false;
    }
    if (hasConnectionReattemptInterval() || rhs.hasConnectionReattemptInterval()) {
        if (getConnectionReattemptInterval() < rhs.getConnectionReattemptInterval()) return true;
        if (getConnectionReattemptInterval() > rhs.getConnectionReattemptInterval()) return false;
    }
    if (hasConnectionAttemptWarningThreshold() || rhs.hasConnectionAttemptWarningThreshold()) {
        if (getConnectionAttemptWarningThreshold() < rhs.getConnectionAttemptWarningThreshold()) return true;
        if (getConnectionAttemptWarningThreshold() > rhs.getConnectionAttemptWarningThreshold()) return false;
    }
    return false;
}

inline bool CmsSocketClientConnector::operator > (const CmsSocketClientConnector& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CmsSocketClientConnector::clear() {
    clearEncoding();
    clearConnectionReattemptInterval();
    clearConnectionAttemptWarningThreshold();
}

inline void CmsSocketClientConnector::clearEncoding() {
    if (hasEncoding()) {
         clear_has_encoding();
        _encoding = ::com::bosch::cm::asf::lang::cms::Connectors::Encoding__Json;
     }
}

inline bool CmsSocketClientConnector::hasEncoding () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline Encoding CmsSocketClientConnector::getEncoding () const {
    return _encoding;
}

inline void CmsSocketClientConnector::setEncoding (Encoding encoding_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(Encoding_IsValid(encoding_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", encoding_, "Encoding", "encoding", "CmsSocketClientConnector");
    }
    set_has_encoding();
    this->_encoding = encoding_;
}

inline void CmsSocketClientConnector::clearConnectionReattemptInterval() {
    if (hasConnectionReattemptInterval()) {
         clear_has_connectionReattemptInterval();
        _connectionReattemptInterval = 500u;
     }
}

inline bool CmsSocketClientConnector::hasConnectionReattemptInterval () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 CmsSocketClientConnector::getConnectionReattemptInterval () const {
    return _connectionReattemptInterval;
}

inline void CmsSocketClientConnector::setConnectionReattemptInterval (uint32 connectionReattemptInterval_) {
    set_has_connectionReattemptInterval();
    this->_connectionReattemptInterval = connectionReattemptInterval_;
}

inline void CmsSocketClientConnector::clearConnectionAttemptWarningThreshold() {
    if (hasConnectionAttemptWarningThreshold()) {
         clear_has_connectionAttemptWarningThreshold();
        _connectionAttemptWarningThreshold = 20u;
     }
}

inline bool CmsSocketClientConnector::hasConnectionAttemptWarningThreshold () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 CmsSocketClientConnector::getConnectionAttemptWarningThreshold () const {
    return _connectionAttemptWarningThreshold;
}

inline void CmsSocketClientConnector::setConnectionAttemptWarningThreshold (uint32 connectionAttemptWarningThreshold_) {
    set_has_connectionAttemptWarningThreshold();
    this->_connectionAttemptWarningThreshold = connectionAttemptWarningThreshold_;
}

inline void CmsSocketClientConnector::set_has_encoding () {
    _has_bits_[0] |= 1u << 0;
}

inline void CmsSocketClientConnector::clear_has_encoding () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CmsSocketClientConnector::set_has_connectionReattemptInterval () {
    _has_bits_[0] |= 1u << 1;
}

inline void CmsSocketClientConnector::clear_has_connectionReattemptInterval () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void CmsSocketClientConnector::set_has_connectionAttemptWarningThreshold () {
    _has_bits_[0] |= 1u << 2;
}

inline void CmsSocketClientConnector::clear_has_connectionAttemptWarningThreshold () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  CmsWebSocketServerConnector::CmsWebSocketServerConnector ()  :
    _portNumber (0u),
    _encoding (::com::bosch::cm::asf::lang::cms::Connectors::Encoding__Json)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CmsWebSocketServerConnector::CmsWebSocketServerConnector (const CmsWebSocketServerConnector &rhs)  :
    _portNumber (0u),
    _encoding (::com::bosch::cm::asf::lang::cms::Connectors::Encoding__Json)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CmsWebSocketServerConnector::CmsWebSocketServerConnector (uint16 portNumber_, Encoding encoding_)  :
    _portNumber (portNumber_),
    _encoding (encoding_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(Encoding_IsValid(encoding_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", encoding_, "Encoding", "encoding", "CmsWebSocketServerConnector");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CmsWebSocketServerConnector::~CmsWebSocketServerConnector() {
}

inline CmsWebSocketServerConnector& CmsWebSocketServerConnector::operator = (const CmsWebSocketServerConnector& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPortNumber()) {
            setPortNumber(rhs.getPortNumber());
        } else {
            clearPortNumber();
        }
        if (rhs.hasEncoding()) {
            setEncoding(rhs.getEncoding());
        } else {
            clearEncoding();
        }
    }
    return *this;
}

inline bool CmsWebSocketServerConnector::operator == (const CmsWebSocketServerConnector& rhs) const {
    return (((!hasPortNumber() && !rhs.hasPortNumber()) || getPortNumber() == rhs.getPortNumber()) &&
        ((!hasEncoding() && !rhs.hasEncoding()) || getEncoding() == rhs.getEncoding()));
}

inline bool CmsWebSocketServerConnector::operator != (const CmsWebSocketServerConnector& rhs) const {
    return ! (*this == rhs);
}

inline bool CmsWebSocketServerConnector::operator < (const CmsWebSocketServerConnector& rhs) const {
    if (hasPortNumber() || rhs.hasPortNumber()) {
        if (getPortNumber() < rhs.getPortNumber()) return true;
        if (getPortNumber() > rhs.getPortNumber()) return false;
    }
    if (hasEncoding() || rhs.hasEncoding()) {
        if ((uint32)getEncoding() < (uint32)rhs.getEncoding()) return true;
        if ((uint32)getEncoding() > (uint32)rhs.getEncoding()) return false;
    }
    return false;
}

inline bool CmsWebSocketServerConnector::operator > (const CmsWebSocketServerConnector& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CmsWebSocketServerConnector::clear() {
    clearPortNumber();
    clearEncoding();
}

inline void CmsWebSocketServerConnector::clearPortNumber() {
    if (hasPortNumber()) {
         clear_has_portNumber();
        _portNumber = 0u;
     }
}

inline bool CmsWebSocketServerConnector::hasPortNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 CmsWebSocketServerConnector::getPortNumber () const {
    return _portNumber;
}

inline void CmsWebSocketServerConnector::setPortNumber (uint16 portNumber_) {
    set_has_portNumber();
    this->_portNumber = portNumber_;
}

inline void CmsWebSocketServerConnector::clearEncoding() {
    if (hasEncoding()) {
         clear_has_encoding();
        _encoding = ::com::bosch::cm::asf::lang::cms::Connectors::Encoding__Json;
     }
}

inline bool CmsWebSocketServerConnector::hasEncoding () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline Encoding CmsWebSocketServerConnector::getEncoding () const {
    return _encoding;
}

inline void CmsWebSocketServerConnector::setEncoding (Encoding encoding_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(Encoding_IsValid(encoding_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", encoding_, "Encoding", "encoding", "CmsWebSocketServerConnector");
    }
    set_has_encoding();
    this->_encoding = encoding_;
}

inline void CmsWebSocketServerConnector::set_has_portNumber () {
    _has_bits_[0] |= 1u << 0;
}

inline void CmsWebSocketServerConnector::clear_has_portNumber () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CmsWebSocketServerConnector::set_has_encoding () {
    _has_bits_[0] |= 1u << 1;
}

inline void CmsWebSocketServerConnector::clear_has_encoding () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace Connectors
} // namespace cms
} // namespace lang
} // namespace asf
} // namespace cm
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_CM_ASF_LANG_CMS_CONNECTORS_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
